module Main (main) where

import           Codec.Compression.BZip
import qualified Data.ByteString.Lazy   as BSL
import           System.FilePath        ((-<.>))
import           Test.Tasty
import           Test.Tasty.Golden
import           Test.Tasty.HUnit

testDecompress :: FilePath -> TestTree
testDecompress fp =
    goldenVsString ("Decompress " ++ fp) (fp -<.> ".ref") (decompress <$> BSL.readFile fp)

testCompress :: FilePath -> TestTree
testCompress fp = testCase ("Roundtrip " ++ fp) $ do
    contents <- BSL.readFile fp
    let actual = decompress (compress contents)
    actual @?= contents

main :: IO ()
main = defaultMain (testGroup "bz2" [testDecompression, testCompression])
    where
        testDecompression = testGroup "Decompress"
            [ testDecompress "test/data/sample1.bz2"
            , testDecompress "test/data/sample2.bz2"
            , testDecompress "test/data/sample3.bz2"
            ]
        testCompression = testGroup "Compress"
            [ testCompress "test/data/sample1.ref"
            , testCompress "test/data/sample2.ref"
            , testCompress "test/data/sample3.ref"
            ]
