/*
 * Hardware Information, version 0.3
 * Copyright (C) 2003 Leandro Pereira <leandro@linuxmag.com.br>
 *
 * May be modified and/or distributed under the terms of GNU GPL version 2.
 *
 */

#include "hardinfo.h"
#include "v4l.h"

#include <stdlib.h>
#include <dirent.h>

#define get_str_val(var) { \
	        walk_until_inclusive(':'); buf++; \
	        var = g_strdup(buf); \
        	continue; \
 	}

V4LDevice *hi_scan_v4l(void)
{
	FILE *proc_video;
	DIR *proc_dir;
	struct dirent *sd;
	V4LDevice *v4l_dev, *v4l;
	struct stat st;
	
	v4l = NULL;

	if (stat("/proc/video/dev", &st))
		return NULL;
	
	proc_dir = opendir("/proc/video/dev");
	if(!proc_dir)
		return NULL;

	while ((sd = readdir(proc_dir))) {
		gchar *dev, buffer[128];
		
		dev = g_strdup_printf("/proc/video/dev/%s", sd->d_name);
		proc_video = fopen(dev, "r");
		g_free(dev);
		
		if(!proc_video)
			continue;
			
		v4l_dev = g_new0(V4LDevice, 1);
		v4l_dev->next = v4l;
		v4l = v4l_dev;
		
		while (fgets(buffer, 128, proc_video)) {
			char *buf = g_strstrip(buffer);
			
			if(!strncmp(buf, "name", 4))
				get_str_val(v4l_dev->name)
			else if(!strncmp(buf, "type", 4))
				get_str_val(v4l_dev->type)
		}		

		fclose(proc_video);		
	}

	return v4l;
}

void hi_show_v4l_info(MainWindow *mainwindow, V4LDevice *device)
{
	gchar *buf;

	if(!device) return;

	buf = g_strdup_printf("%sv4l.png", IMG_PREFIX);
	detail_window_set_icon(mainwindow->det_window, buf);	
	g_free(buf);

	gtk_window_set_title(GTK_WINDOW(mainwindow->det_window->window), _("Device Information"));
	

	detail_window_set_dev_name(mainwindow->det_window, device->name);

	if (device->type) {
		gchar *b = g_strdup(device->type);
		gpointer b_start = b;
	
		do {
			if (*b == '|') *b = '\n';
			b++;
		} while(*b);
		b = b_start;
	
		detail_window_append_info(mainwindow->det_window, _("Type"),
					  b);
		g_free(b);
	}
}
