/*
 * happydigger - program for cataloging archaeological finds
 * Copyright (C) 2004, 2005, 2007 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "utils.h"
#include "callbacks.h"

extern GtkWidget *window;
gint brightness1, brightness2;

gboolean
on_imagewindow_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive (window, 1);
	return FALSE;
}


static void
colorbright_picture (GdkPixbuf *pb, gint offset)
{
	gint i, j, h, w, bpp, rowstride;
	guchar *p;

	bpp = gdk_pixbuf_get_has_alpha (pb) ? 4 : 3;
	p = gdk_pixbuf_get_pixels (pb);
	w = gdk_pixbuf_get_width (pb);
	h = gdk_pixbuf_get_height (pb);
	rowstride = gdk_pixbuf_get_rowstride (pb);

	for (i = 0; i < h; i++)
	{
		guchar *q = p;
		for (j = 0; j < w; j++)
		{
			q[0] += offset;
			q[1] += offset;
			q[2] += offset;
			q += bpp;
		}
		p += rowstride;
	}
}

/* up/down key changes brightness of the image */
gboolean
on_imagewindow_keypress (GtkWidget *widget, GdkEventKey *event, gpointer data)
{
	gchar *name, *imagestr;
	GtkWidget *imageentry, *image;
	GdkPixbuf *pix;

	switch (event->keyval)
	{
		case GDK_Up:
			gtk_container_foreach (GTK_CONTAINER(widget),
				(GtkCallback)gtk_widget_destroy, NULL);
			name = g_strdup_printf ("image%dentry", GPOINTER_TO_INT(data));
			imageentry = lookup_widget (window, name);
			g_free (name);
			imagestr = gtk_editable_get_chars (GTK_EDITABLE(imageentry), 0, -1);
			pix = gdk_pixbuf_new_from_file (imagestr, NULL);
			if (pix)
			{
				if (GPOINTER_TO_INT(data) == 1)
				{
					brightness1 += 5;
					colorbright_picture (pix, brightness1);
				}
				else
				{
					brightness2 += 5;
					colorbright_picture (pix, brightness2);
				}
				image = gtk_image_new_from_pixbuf (pix);
				gtk_container_add (GTK_CONTAINER(widget), image);
				gtk_widget_show (image);
				g_object_unref (pix);
			}
		break;
		case GDK_Down:
			gtk_container_foreach (GTK_CONTAINER(widget),
				(GtkCallback)gtk_widget_destroy, NULL);
			name = g_strdup_printf ("image%dentry", GPOINTER_TO_INT(data));
			imageentry = lookup_widget (window, name);
			g_free (name);
			imagestr = gtk_editable_get_chars (GTK_EDITABLE(imageentry), 0, -1);
			pix = gdk_pixbuf_new_from_file (imagestr, NULL);
			if (pix)
			{
				if (GPOINTER_TO_INT(data) == 1)
				{
					brightness1 -= 5;
					colorbright_picture (pix, brightness1);
				}
				else
				{
					brightness2 -= 5;
					colorbright_picture (pix, brightness2);
				}
				image = gtk_image_new_from_pixbuf (pix);
				gtk_container_add (GTK_CONTAINER(widget), image);
				gtk_widget_show (image);
				g_object_unref (pix);
			}
		break;
		default:
		return FALSE;
		break;
	}
	return TRUE;
}
