module HAppS.Util.Daemonize where 

import System.Directory
import System.Environment
import System.Exit
import System.Time
import Control.Concurrent
import Control.Exception
import Control.Monad.Error
import HAppS.Protocols.SHA1

-- Will placing the lock-file in the current directory work if we run the application from cron?
daemonize main = do
  uniqueId <- getDaemonizedId
  let name = ".haskell_daemon." ++ uniqueId
  t <- try $ getModificationTime name
  now <- getClockTime
  case t of
    Right modTime | diffClockTimes now modTime < tenSeconds
        -> exitWith ExitSuccess
    _otherwie
        -> do tid <- periodic (repeat 5) $ writeFile name "daemon"
              main `finally` killThread tid
    where tenSeconds = noTimeDiff { tdSec = 10 }

getDaemonizedId
    = do prog <- getProgName
         args <- getArgs
         return (sha1 (prog ++ unwords args))

periodic ts x = forkIO $ periodic' ts x
periodic' [] x = x
periodic' (t:ts) x = x >> threadDelay (10^6*t) >> periodic' ts x
