{-# OPTIONS -fglasgow-exts -fallow-overlapping-instances -fth #-}
--Copyright (C) 2006 HAppS.org. All Rights Reserved.

import Control.Monad.State
import HAppS
import HAppS.Protocols.MessageWrap.W
import HAppS.Protocols.SimpleHTTP

type UEv a = Ev MyState Request a

data MyState = My { foo :: String } deriving(Read,Show)


$(inferStartState ''MyState)

instance Serialize MyState where
    typeString _  = "MyState"
    encodeStringM = defaultEncodeStringM
    decodeStringM = defaultDecodeStringM


a :: Method -> Host -> [String] -> UEv (IO Result)
a _ _ ["io"]    = w (\() -> return (text $ sresult 200 =<< readFile "/etc/fstab"))
a _ _ ["pure"]  = w (\() -> text $ sresult 200 "foobar")
a _ _ ["err"]   = w (\() -> fail "some error" >> sresult 200 "")
a _ _ p         = return $ text $ sresult 403 ("Unknown path: "++show p)

text :: Functor f => f Result -> f Result
text = fmap $ setHeader "Content-Type" "text/plain"

main = stdMain $ simpleHTTPIO "" [] a :*: End
