/* 
 * File: gmlplaylist.h
 *
 * Medialib search and playlist editor
 * Copyright (c) 2005 Johannes Heimansberg
 *
 * requires GTK+ 2.6 or better and XMMS2 DR2 or better
 *
 * Released under the GNU General Public License v2
 */

#ifndef __GMLPLAYLIST_H__
#define __GMLPLAYLIST_H__

#include <glib.h>
#include <gtk/gtk.h>

struct _GMLPlaylist
{
	GtkWidget         *frame, *table;
	GtkWidget         *list, *scroll_widget;
	GtkWidget         *button_reload_pl,  *image_reload;
	GtkWidget         *button_new_pl,     *image_new;
	GtkWidget         *button_up,   *button_down,   *image_up,     *image_down;
	GtkWidget         *button_play, *button_delete, *image_play,   *image_delete;
	GtkWidget         *button_info, *image_info,    *button_track, *image_track;
	GtkWidget         *button_shuffle_pl, *image_shuffle_pl;
	GtkWidget         *button_add_rnd,    *image_add_rnd;
	GtkWidget         *button_sort_pl,    *image_sort_pl;
	GtkWidget         *button_save_pl,    *image_save;
	GtkListStore      *ls;
	GtkTreeSelection  *sel;
	guint              length, current_pos;
	gboolean           move_finished, refresh;
	gint               refresh_counter;
	GdkPixbuf         *icon_rating[5];

	GtkTreeViewColumn *column_pos,    *column_id;
	GtkTreeViewColumn *column_artist, *column_track;
	GtkTreeViewColumn *column_album,  *column_rating;
	gboolean           column_pos_visible,    column_id_visible;
	gboolean           column_artist_visible, column_track_visible;
	gboolean           column_album_visible,  column_rating_visible;
};

#endif
