/*
 * Copyright 2013 Canonical Ltd.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * telephony-app is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


import QtQuick 2.0
import Ubuntu.Components 0.1
import Ubuntu.Components.ListItems 0.1
import Friends 0.1

Rectangle {
    property string stream: ""
    property int unseen: 0
    property string search
    color: "#f8f8f8"

    /* Jump to the bottom of the view and set the currentIndex */
    function jumpToBottom () {
        listView.currentIndex = listView.count - 1;
        listView.positionViewAtIndex(listView.currentIndex, ListView.End);
    }

    /* Jump to the top of the view and set the currentIndex */
    function jumpToTop () {
        listView.positionViewAtIndex(0, ListView.Contain);
        listView.currentIndex = 0;
    }

    onUnseenChanged: {
        updatesText.text = unseen == 1 ? (unseen + i18n.tr(" new update")) : (unseen + i18n.tr(" new updates"));
    }

    Component.onCompleted: {
        listView.focus = true;
    }

    Component {
        id: statusDelegate
        StatusUpdateTile {
            id: content
            width: ListView.view.width  - units.gu(1)
            height: childrenRect.height
            ListView.onAdd: SequentialAnimation {
                ScriptAction { script: {unseen++; console.log(column_0[0][0] + " " + column_0[0][1] + " " + column_0[0][2]) }}
            }
        }
    }

    StreamModel {
        id: streamModel
        objectName: "streamModel"
    }

    onStreamChanged: {
        console.log("stream changed to " + stream);
        streamModel.stream = stream;
    }

    onSearchChanged: {
        console.log ("onSearchChanged");
    }

    RefreshBar {
        id: refreshBar
        y: -listView.contentY - height
        anchors.top: listView.top
        opacity: 0
        visible: opacity > 0 ? true : false
        Behavior on opacity {
            NumberAnimation { duration: 200; }
        }
    }

    ListView {
        id: listView
        objectName: "listView"
        height: parent.height - toolbar.height - units.gu(2)
        width: parent.width
        anchors {
            top: updatesBanner.bottom
            topMargin: units.gu(1)
        }
        opacity: 1
        spacing: units.gu(1)
        model: streamModel
        snapMode: ListView.SnapToItem
        cacheBuffer: parent.height
        boundsBehavior: Flickable.DragOverBounds
        currentIndex: 0
        delegate: statusDelegate

        preferredHighlightBegin: 0
        preferredHighlightEnd: preferredHighlightBegin
        highlightRangeMode: ListView.StrictlyEnforceRange
        //highlight: Rectangle { color: "black"; opacity: 0.1 }

        onCurrentIndexChanged: {
            if (currentIndex == 0) {
                unseen = 0;
            }
        }

        /* Ensure we collapse details when scrolling */
        onFlickStarted: {
            if (listView.currentItem.state != "List")
                listView.currentItem.state = "List";
        }

        /* Expand details on enter */
        Keys.onReturnPressed: {
            if (listView.currentItem.state != "Details")
            listView.currentItem.state = "Details";
        }

        /* Collapse details on escape */
        Keys.onEscapePressed: {
            if (listView.currentItem.state != "List")
                listView.currentItem.state = "List";
        }

        /* Handle home and end nav */
        Keys.onPressed: {
            if (event.key == Qt.Key_Home) {
                jumpToTop();
            }
            else if (event.key == Qt.Key_End) {
                jumpToBottom();
            }
        }

        onDragStarted: {
            if (listView.atYBeginning)
                refreshBar.opacity = 1.0;
        }
        onDragEnded: {
            refreshBar.opacity = 0
            if (refreshBar.refreshed) {
                console.log ("Refreshed");
                friends.refresh ();
            }
        }
    }

    Item {
        id: updatesBanner
        anchors {
            top: parent.top
            left: parent.left
            right: parent.right
        }
        visible: unseen > 0
        height: visible ? units.gu(3) : 0
        Text {
            id: updatesText
            anchors {
                centerIn: parent
                bottom: parent.bottom
            }
            text: ""
            font.family: "Ubuntu"
            font.bold: true
            font.pointSize: 12
            color: "gray"
        }
        MouseArea {
            anchors.fill: parent
            onClicked: {
                unseen = 0;
                updatesText.text = "";
                updatesBanner.visible = false;
                jumpToTop();
            }
        }
    }

    Scrollbar {
        flickableItem: listView
        align: Qt.AlignTrailing
    }
}
