import QtQuick 2.0
import Ubuntu.Components 0.1
import Friends 0.1

Item {
    height: threadListView.height + pictureImage.height
    width: parent.width
    anchors {
        bottomMargin: units.gu(2)
    }

    StreamModel {
        id: streamModel
        stream: "reply_to/"+messageId
    }


    FriendsUtils {
        id: friendsUtils
    }

    Column {
        id: threadListView
        width: parent.width
        Repeater {
            width: parent.width
            model: streamModel
            delegate: Item {
                id: threadItem
                width: parent.width - units.gu(8)
                anchors {
                    right: parent.right
                    leftMargin: units.gu(8)
                    rightMargin: units.gu(2)
                    bottomMargin: units.gu(2)
                }
                height: status_update_content.height

                UbuntuShape {
                    id: avatarImage
                    radius: "small"
                    height: units.dp(32)
                    width: units.dp(32)
                    anchors {
                        left: parent.left
                        top: parent.top
                        leftMargin: units.gu(1)
                        topMargin: units.gu(1)
                    }
                    image: Image {
                        source: Qt.resolvedUrl(column_10)
                        asynchronous: true
                        fillMode: Image.PreserveAspectFit
                    }
                }

                Item {
                    id: status_update_content
                    anchors {
                        left: avatarImage.right
                        right: parent.right
                        top: parent.top
                        topMargin: units.gu(1)
                        leftMargin: units.gu(1)
                        bottomMargin: units.gu(1)
                        rightMargin: units.gu(1)
                    }
                    width: parent.width - avatarImage.width
                    height: childrenRect.height + units.gu(1)

                    Column {
                        width: parent.width
                        spacing: 0
                        anchors {
                            left: parent.left;
                            right: parent.right
                            bottomMargin: units.gu(2)
                        }
                        Label {
                            text: column_4
                            fontSize: "small"
                            font.bold: true
                            width: parent.width
                        }
                        Label {
                            id: messageText
                            text: column_9
                            wrapMode: Text.WrapAtWordBoundaryOrAnywhere
                            width: parent.width - units.gu(3)
                            fontSize: "small"
                            onLinkActivated: {
                                console.log(link + " link activated");
                                Qt.openUrlExternally(link);
                            }
                        }
                    }
                    Row {
                        anchors.right: parent.right
                        anchors.rightMargin: units.gu(1)
                        anchors.top: parent.top
                        spacing: units.gu(1)

                        Text {
                            id: time
                            text: friendsUtils.createTimeString(column_8)
                            font.family: "Ubuntu"
                            font.pointSize: 8
                            color: "gray"
                        }
                    }
                }
            }
        }
    }
}
