
import gobject, dbus.glib, os, sys
import dbus, dbus.service
from microblog import support

######################################################################
# DBus integration

DBUS_PATH = '/com/GwibberClient'
DBUS_NAME = 'com.GwibberClient'

class DBusManager(dbus.service.Object):
  def __init__(self, client):
    self.client = client
    self.bus = dbus.SessionBus()
    bus_name = dbus.service.BusName(DBUS_NAME, bus=self.bus)
    dbus.service.Object.__init__(self, bus_name, DBUS_PATH)

  @dbus.service.method(DBUS_NAME)
  def indicator_activated(self, msgid):
    def on_idle(*a):
      self.client.account_tree.get_selection().select_path((2,))
      self.client.external_invoke()

    gobject.idle_add(on_idle)

  @dbus.service.method(DBUS_NAME)
  def external_invoke(self):
    self.client.external_invoke()

  @dbus.service.method(DBUS_NAME)
  def send_message(self, msg):
    self.client.client.send(msg)

try:
  import pynotify
  pynotify.init("Gwibber")

  def notify(title, text, icon = None, timeout = None):
    caps = pynotify.get_server_caps()    
    notification = pynotify.Notification(title, text, icon)
    if timeout:
      notification.set_timeout(timeout)
    if "x-canonical-append" in caps:
      notification.set_hint('x-canonical-append', 'allowed')
    return notification.show()

  can_notify = True
except:
  can_notify = False


######################################################################

try:
  import sexy
  SPELLCHECK_ENABLED = True
except:
  SPELLCHECK_ENABLED = False

try:
  import gnome
  def load_url(url): gnome.url_show(url)
except:
  def load_url(url): os.system("xdg-open %s" % url)

def service_is_running(name):
  return name in dbus.Interface(dbus.SessionBus().get_object(
    "org.freedesktop.DBus", "/org/freedesktop/DBus"),
      "org.freedesktop.DBus").ListNames()

def create_tomboy_note(text):
  obj = dbus.SessionBus().get_object("org.gnome.Tomboy", "/org/gnome/Tomboy/RemoteControl")
  tomboy = dbus.Interface(obj, "org.gnome.Tomboy.RemoteControl")
  
  n = tomboy.CreateNote()
  tomboy.DisplayNote(n)
  tomboy.SetNoteContents(n, text)

def set_pidgin_status_text(message):
  bus = dbus.SessionBus()
  obj = bus.get_object("im.pidgin.purple.PurpleService", "/im/pidgin/purple/PurpleObject")
  purple = dbus.Interface(obj, "im.pidgin.purple.PurpleInterface")
  
  current = purple.PurpleSavedstatusGetType(purple.PurpleSavedstatusGetCurrent())
  status = purple.PurpleSavedstatusNew("", current)
  purple.PurpleSavedstatusSetMessage(status, message)
  purple.PurpleSavedstatusActivate(status)
