/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "gwsupport.h"
#include "gwpluginsmanager.h"

#include <gmodule.h>
#include <dirent.h> /* opendir readir closedir*/
#include <string.h> /* strstr */

#include "gwapplicationmanager.h"


GWPluginsManager my_plugins_manager;


gint gw_plugins_manager_init ( )
{
	gint result = -1;
	GModule *module = NULL;
	gchar *module_path = NULL;
	func_get_author_t func_get_author = NULL;
	func_get_info_t func_get_info = NULL;
	func_get_help_t func_get_help = NULL;
	func_get_allowed_ext_t func_get_allowed_ext = NULL;
	func_get_allowed_name_t func_get_allowed_name = NULL;
	func_get_file_descr_t func_get_file_descr = NULL;
	func_get_files_descr_t func_get_files_descr = NULL;
	func_get_parent_descr_t func_get_parent_descr = NULL;
	DIR *plugins_descr_dir = NULL;
	struct dirent *dentry = NULL;
	char *so = NULL;
	gchar **allowed_ext = NULL;
	gchar **allowed_name = NULL;
	int i = 0;
	gchar *plugins_dir = NULL;


#if GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	if ( g_module_supported ( ) )
	{
		my_plugins_manager.descr_plugins = g_hash_table_new ( g_str_hash, g_str_equal/*(GCompareFunc)strcasecmp*/);
		my_plugins_manager.file_descr_funcs = g_hash_table_new ( g_str_hash, g_str_equal/*(GCompareFunc)strcasecmp*/);
		my_plugins_manager.files_descr_funcs = g_hash_table_new ( g_str_hash, g_str_equal/*(GCompareFunc)strcasecmp*/);
		my_plugins_manager.parent_descr_funcs = g_hash_table_new ( g_str_hash, g_str_equal/*(GCompareFunc)strcasecmp*/);

#if GW_DEBUG_MODE
		gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Starting the scan of %s...", PACKAGE_PLUGINS_DESCRIPTION_DIR);
#endif
		if ( (plugins_dir = gw_package_get_plugins_dir ( )) != NULL )
		{
			if ( (plugins_descr_dir = opendir ( plugins_dir)) != NULL )
			{
				while ( (dentry = readdir ( plugins_descr_dir)) != NULL )
				{
#if GW_DEBUG_MODE
					gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Current file is %s", dentry->d_name);
#endif

					if ( dentry->d_name != NULL )
					{
#if GW_DEBUG_MODE
						gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Checking the file %s", dentry->d_name);
#endif

						if ( (so = strrchr ( dentry->d_name, '.')) != NULL )
						{
#if GW_DEBUG_MODE
							gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "File extension is founded : %s", so);
#endif

							if ( strcasecmp ( ++so, G_MODULE_SUFFIX) == 0 )
							{
								/* The file extension is a valid extension for module file. */
#if GW_DEBUG_MODE
								gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "The file extension founded is supported : %s.", so);
#endif
								module_path = g_strconcat ( PACKAGE_PLUGINS_DESCRIPTION_DIR, G_DIR_SEPARATOR_S, dentry->d_name, NULL);

#if GW_DEBUG_MODE
								gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Trying to load %s...", module_path);
#endif

								module = g_module_open ( module_path, 0);

								if ( module != NULL )
								{
									g_module_symbol ( module, "plugin_get_author", (gpointer *)(&func_get_author));
									g_module_symbol ( module, "plugin_get_info", (gpointer *)(&func_get_info));
									g_module_symbol ( module, "plugin_get_help", (gpointer *)(&func_get_help));
									g_module_symbol ( module, "plugin_get_allowed_ext", (gpointer *)(&func_get_allowed_ext));
									g_module_symbol ( module, "plugin_get_allowed_name", (gpointer *)(&func_get_allowed_name));
									g_module_symbol ( module, "plugin_get_file_descr", (gpointer *)(&func_get_file_descr));
									g_module_symbol ( module, "plugin_get_files_descr", (gpointer *)(&func_get_files_descr));
									g_module_symbol ( module, "plugin_get_parent_descr", (gpointer *)(&func_get_parent_descr));

									if ( (func_get_author != NULL) && (func_get_info != NULL) && (func_get_help != NULL) )
									{
#if GW_DEBUG_MODE
										gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Module name is %s", g_module_name ( module));
										gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Module author is %s", func_get_author ( ));
										gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Module info is %s", func_get_info ( ));
										gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Module help is %s", func_get_help ( ));
#endif

										if ( (func_get_allowed_ext != NULL) && (func_get_file_descr != NULL) )
										{
#if GW_DEBUG_MODE
											gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Module allowed_ext is %s", func_get_allowed_ext ( ));
#endif

											if ( (func_get_allowed_ext ( ) != NULL) && (strlen ( func_get_allowed_ext ( )) > 0) )
											{
												allowed_ext = g_strsplit ( func_get_allowed_ext ( ), "|", -1);

												if ( allowed_ext != NULL )
												{
													for ( i = 0; allowed_ext[i] != NULL; i++)
													{
														g_hash_table_insert ( my_plugins_manager.descr_plugins, g_strdup ( func_get_allowed_ext ( )), module);
#if GW_DEBUG_MODE
														gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "plugin %s added", allowed_ext[i]);
#endif

														g_strdown ( allowed_ext[i]);
														g_hash_table_insert ( my_plugins_manager.file_descr_funcs, g_strdup ( allowed_ext[i]), func_get_file_descr);
													}

													g_strfreev ( allowed_ext);
													allowed_ext = NULL;
												}
											}
										}

										if ( (func_get_allowed_name != NULL) && (func_get_allowed_name ( ) != NULL) && ((func_get_files_descr != NULL) || (func_get_parent_descr != NULL)) )
										{
#if GW_DEBUG_MODE
											gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Module allowed_name is %s", func_get_allowed_name ( ));
#endif

											if ( (func_get_allowed_name ( ) != NULL) && (strlen ( func_get_allowed_name ( )) > 0) )
											{
												allowed_name = g_strsplit ( func_get_allowed_name ( ), "|", -1);

												if ( allowed_name != NULL )
												{
													for ( i = 0; allowed_name[i] != NULL; i++)
													{
														g_hash_table_insert ( my_plugins_manager.descr_plugins, g_strdup ( func_get_allowed_name ( )), module);

														g_strdown ( allowed_name[i]);

														if ( func_get_files_descr != NULL )
														{
															g_hash_table_insert ( my_plugins_manager.files_descr_funcs, g_strdup ( allowed_name[i]), func_get_files_descr);
#if GW_DEBUG_MODE
															gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "plugin %s added", allowed_name[i]);
#endif
														}

														if ( func_get_parent_descr != NULL )
														{
															g_hash_table_insert ( my_plugins_manager.parent_descr_funcs, g_strdup ( allowed_name[i]), func_get_parent_descr);

#if GW_DEBUG_MODE
															gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "plugin %s added", allowed_name[i]);
#endif
														}
													}

													g_strfreev ( allowed_name);
													allowed_name = NULL;
												}
											}
										}
									}
								} else {
#if GW_DEBUG_MODE
									gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "unabble to load plugin %s, error :%s", dentry->d_name, g_module_error ( ));
#endif
								}

								g_free ( module_path);
								module_path = NULL;
							}
							else
							{
								/* The file extension is not supported as module file extension. */
#if GW_DEBUG_MODE
								gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "The file extension founded is not supported : %s.", so);
#endif
							}
						}
						else
						{
							/* Unable to find the file extension. */
#if GW_DEBUG_MODE
							gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "No file extension has been founded.", NULL);
#endif
						}

						so = NULL;
					}
					else
					{
						/* Unable to get the file name. */
#if GW_DEBUG_MODE
						gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "File name is null (inode=%d).", dentry->d_ino);
#endif
					}

				}

				closedir ( plugins_descr_dir);
			}
			else
			{
#if GW_DEBUG_MODE
				gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "%s not found.", PACKAGE_PLUGINS_DESCRIPTION_DIR);
#endif
			}

			g_free ( plugins_dir);
		}

#if GW_DEBUG_MODE
		gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Scan of %s is stopped.", PACKAGE_PLUGINS_DESCRIPTION_DIR);
#endif
	}
	else
	{
#if GW_DEBUG_MODE
		gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, "Dynamic modules are not supported!!");
#endif
	}

	return result;
}


gboolean gw_plugins_manager_module_close ( gchar * key, GModule *value, gpointer data)
{
	gboolean result = FALSE;


#if GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	if ( key != NULL )
	{
		g_free ( key);
	}

	if ( value != NULL )
	{
		g_module_close ( value);
	}

	return result;
}


gint gw_plugins_manager_get_file_descr_func ( const gchar *ext, func_get_file_descr_t *f)
{
	gint result = -1;
	gchar *ext_lower = NULL;


#if GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	if ( (my_plugins_manager.file_descr_funcs != NULL) && (ext != NULL) )
	{
		g_strdown ( ext_lower = g_strdup ( ext));
		*f = g_hash_table_lookup ( my_plugins_manager.file_descr_funcs, ext_lower);
		g_free ( ext_lower);
	}

	return result;
}


gint gw_plugins_manager_get_files_descr_func ( const gchar *name, func_get_files_descr_t *f)
{
	gint result = -1;
	gchar *name_lower = NULL;


#if GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	if ( (my_plugins_manager.files_descr_funcs != NULL) && ( name != NULL) )
	{
		g_strdown ( name_lower = g_strdup ( name));
		*f = g_hash_table_lookup ( my_plugins_manager.files_descr_funcs, name_lower);
		g_free ( name_lower);
	}

	return result;
}


gint gw_plugins_manager_get_parent_descr_func ( const gchar *name, func_get_parent_descr_t *f)
{
	gint result = -1;
	gchar *name_lower = NULL;


#if GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	if ( (my_plugins_manager.parent_descr_funcs != NULL) && (name != NULL) )
	{
		g_strdown ( name_lower = g_strdup ( name));
		*f = g_hash_table_lookup ( my_plugins_manager.parent_descr_funcs, name_lower);
		g_free ( name_lower);
	}

	return result;
}


gint gw_plugins_manager_exit ( )
{
	gint result = -1;


#if GW_DEBUG_MODE
	gw_application_manager_log_msg ( 0, __FILE__, __LINE__, __PRETTY_FUNCTION__, NULL);
#endif

	if ( my_plugins_manager.catalog_plugins != NULL )
	{
		g_hash_table_foreach_remove ( my_plugins_manager.catalog_plugins, (GHRFunc)gw_plugins_manager_module_close, NULL);
		g_hash_table_destroy ( my_plugins_manager.catalog_plugins);
		my_plugins_manager.catalog_plugins = NULL;
	}

	if ( my_plugins_manager.file_descr_funcs != NULL )
	{
		g_hash_table_destroy ( my_plugins_manager.file_descr_funcs);
		my_plugins_manager.file_descr_funcs = NULL;
	}

	if ( my_plugins_manager.files_descr_funcs != NULL )
	{
		g_hash_table_destroy ( my_plugins_manager.files_descr_funcs);
		my_plugins_manager.files_descr_funcs = NULL;
	}

	if ( my_plugins_manager.parent_descr_funcs != NULL )
	{
		g_hash_table_destroy ( my_plugins_manager.parent_descr_funcs);
		my_plugins_manager.parent_descr_funcs = NULL;
	}

	if ( my_plugins_manager.descr_plugins != NULL )
	{
		g_hash_table_foreach_remove ( my_plugins_manager.descr_plugins, (GHRFunc)gw_plugins_manager_module_close, NULL);
		g_hash_table_destroy ( my_plugins_manager.descr_plugins);
		my_plugins_manager.descr_plugins = NULL;
	}

	return result;
}
