/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "../gwsupport.h"
#include "gwmenupopupcallback.h"

#include <string.h> /* strlen strcmp */

#include "data/gwdata.h"

#include "gwnotebookcatalog.h"
#include "gwcategorieseditbox.h"
#include "gwpropertiesbox.h"
#include "gwcapturebox.h"
#include "gwtextbox.h"
#include "gwmsgbox.h"

#include "../gwguimanager.h"
#include "../gwcatalogstats.h"


/* I don't like globals variables. But it's in order to memorize last selected node and files list. */
GtkCTreeNode *node_gw_menu_popup_callback = NULL;
GList *files_gw_menu_popup_callback = NULL;


gboolean gw_menu_popup_catalog_rename ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		window = gw_gui_manager_main_interface_get_main_window ( );
		node_gw_menu_popup_callback = node;

		gw_capture_box_create ( window, _( "Rename catalog"), _( "Enter new catalog name"), catalog_file_info_get_title ( gtk_ctree_node_get_row_data ( tree, node)), GTK_SIGNAL_FUNC ( gw_menu_popup_catalog_rename_ok));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_catalog_rename_ok ( GtkWidget *w, GtkWidget *data)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkCTreeNode *selection = NULL;
	struct catalog_file_info *catalog_info = NULL;
	guint8 spc;
	GdkBitmap *btmp;
	GdkPixmap *pxmp;
	gchar *tmp_name, *name;
	GtkWindow *window = NULL;
gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( data != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);
		window = gw_gui_manager_main_interface_get_main_window ( );

		tmp_name = gw_capture_box_get_text ( GTK_WINDOW ( data));
		catalog_info = gtk_ctree_node_get_row_data ( tree, node_gw_menu_popup_callback);
/*
Notes : this code change the catalog file name, not the catalog name.
		if ( strcmp ( catalog_file_info_get_title ( catalog_info), text_utf8) != 0 )
		{
*/			/* If the filled name isn't equal to the catalog name. */
/*			if ( (strlen ( text_utf8) > 0 ) && (strcmp ( text_utf8, "") != 0) )
			{
*/				/* If a name is filled. */
/*				buf = catalog_file_info_get_full_name ( catalog_info);
				file = g_strsplit ( buf, G_SEARCHPATH_SEPARATOR_S, 0);

				while ( file[++i + 1] != NULL )
				{
*/					/* Goes to the last item of table in order to change it. */
/*				}

				g_free ( file[i]);
				file [i] = g_strdup ( text_utf8);

				catalog_file_info_set_full_name ( catalog_info, g_strjoinv ( G_SEARCHPATH_SEPARATOR_S, file));
				catalog_file_info_set_title ( catalog_info, g_strdup ( text_utf8));
				catalog_file_info_set_ismodified ( catalog_info, TRUE);

				gtk_ctree_node_get_pixtext ( tree, node_gw_menu_popup_callback, 0, &name, &spc, &pxmp, &btmp);
				gtk_ctree_node_set_pixtext ( tree, node_gw_menu_popup_callback, 0, tmp_name, spc, pxmp, btmp);
				gtk_window_set_title ( window, g_strconcat ( PROJECT_NAME, " - ", catalog_file_info_get_full_name ( catalog_info), NULL));

				g_strfreev ( file);

				result = TRUE;
			}
		}
		else
		{
			g_free ( tmp_name);
		}

		g_free ( text_utf8);
*/

//TODO It will be great to check if the catalog name changed in order to set or not the is_modified status
		catalog_file_info_set_title ( catalog_info, tmp_name);
		catalog_file_info_set_ismodified ( catalog_info, TRUE);
if ( tmp_name!= NULL && strlen(tmp_name)>0) {
	g_strdup_to_gtk_text ( tmp_name, text_utf8);
} else {
	g_strdup_to_gtk_text ( catalog_file_info_get_name ( catalog_info), text_utf8);
}

		gtk_ctree_node_get_pixtext ( tree, node_gw_menu_popup_callback, 0, &name, &spc, &pxmp, &btmp);
		gtk_ctree_node_set_pixtext ( tree, node_gw_menu_popup_callback, 0, text_utf8, spc, pxmp, btmp);
g_free ( text_utf8);
		gtk_widget_destroy ( data);
		node_gw_menu_popup_callback = NULL;

		/* Selects the selected item in the exploration tree to refresh the list of files. */
		gtk_ctree_select ( tree, selection);
	}

	return result;
}


gboolean gw_menu_popup_catalog_add_new_disk ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		/* FIX BUG : Must implement this function!! */
	}

	return result;
}


gboolean gw_menu_popup_catalog_edit_description ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		window = gw_gui_manager_main_interface_get_main_window ( );

		node_gw_menu_popup_callback = node;
		gw_text_box_create ( window, _( "Edit description"), _( "Catalog description"), catalog_file_info_get_description ( gtk_ctree_node_get_row_data ( tree, node)), GTK_SIGNAL_FUNC ( gw_menu_popup_catalog_edit_description_ok));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_catalog_edit_description_ok ( GtkWidget *b, GtkWidget *w )
{
	gboolean result = FALSE;
	struct catalog_file_info *catalog_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *selection = NULL;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		catalog_info = gtk_ctree_node_get_row_data ( tree, node_gw_menu_popup_callback);

		text_utf8 = gw_text_box_get_text ( w);

		if ( (catalog_file_info_get_description ( catalog_info) == NULL) || (strcmp ( text_utf8, catalog_file_info_get_description ( catalog_info)) != 0) ) {
			/* If the filled description isn't equals to the catalog description. */
			if ( strlen ( text_utf8) > 0 ) {
				catalog_file_info_set_description ( catalog_info, g_strdup ( text_utf8));
			} else {
				catalog_file_info_set_description ( catalog_info, NULL);
			}

			/* Indicates that catalog have been modified. */
			catalog_file_info_set_ismodified ( catalog_info, TRUE);
		}

		g_free ( text_utf8);

		gtk_widget_destroy ( w);

		/* Selects the selected item in the exploration tree to refresh the list of files. */
		gtk_ctree_select ( tree, selection);

		node_gw_menu_popup_callback = NULL;

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_catalog_edit_categories ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	struct catalog_file_info *catalog_info = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		catalog_info = gtk_ctree_node_get_row_data ( tree, node);
		window = gw_gui_manager_main_interface_get_main_window ( );

		gw_categories_edit_box_create ( window, catalog_info);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_catalog_properties ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkWindow *window = NULL;
	GtkCTree *tree = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		window = gw_gui_manager_main_interface_get_main_window ( );
		tree = gw_gui_manager_main_interface_get_tree ( );

		gw_properties_box_create_catalog ( m, window, tree, node);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_disk_move_to ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );

		if ( !GTK_CTREE_ROW ( node)->expanded )
		{
			if ( node != NULL )
			{
				gtk_ctree_expand ( tree, node);
			}
		}

		gtk_ctree_select ( GTK_CTREE ( tree), node);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_disk_rename ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		window = gw_gui_manager_main_interface_get_main_window ( );

		node_gw_menu_popup_callback = node;
		gw_capture_box_create ( window, _( "Rename disk"), _( "Enter new disk name"), disk_info_get_name ( disk_data_get_info ( gtk_ctree_node_get_row_data ( tree, node))), GTK_SIGNAL_FUNC ( gw_menu_popup_disk_rename_ok));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_disk_rename_ok ( GtkWidget *w, GtkWidget *data)
{
	gboolean result = FALSE;
	struct disk_info *disk_info = NULL;
	guint8 spc;
	GdkBitmap *btmp;
	GdkPixmap *pxmp;
	gchar *tmp_name, *disk_name, *name;
	GtkCTree *tree = NULL;
	GtkCTreeNode *selection = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( data != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		tmp_name = gw_capture_box_get_text ( GTK_WINDOW ( data));
		disk_info = disk_data_get_info ( gtk_ctree_node_get_row_data ( tree, node_gw_menu_popup_callback));

		if ( strcmp ( disk_info_get_name ( disk_info), tmp_name) != 0 )
		{
			/* Checks if the filled name isn't equals to the disk name. */
			disk_name = gw_disk_get_name ( tmp_name);

			if ( strcmp ( disk_name, "") != 0 )
			{
				/* If a name has been filled. */
				gtk_ctree_node_get_pixtext ( tree, node_gw_menu_popup_callback, 0, &name, &spc, &pxmp, &btmp);
				gtk_ctree_node_set_pixtext ( tree, node_gw_menu_popup_callback, 0, disk_name, spc, pxmp, btmp);
				disk_info_set_name ( disk_info, g_strdup ( disk_name));

				/* Indicates that catalog has been modified. */
				catalog_file_info_set_ismodified ( gtk_ctree_node_get_row_data ( tree, GTK_CTREE_ROW ( node_gw_menu_popup_callback)->parent), TRUE);

				/* Selects the selected item in the exploration tree to refresh the list of files. */
				gtk_ctree_select ( tree, selection);
			}
			else
			{
				window = gw_gui_manager_main_interface_get_main_window ( );
				gw_msg_box_create ( window, _("Rename disk"), _("Invalid filled disk name"));
			}


			g_free ( disk_name);
		}

		g_free ( tmp_name);
		gtk_widget_destroy ( data);
		node_gw_menu_popup_callback = NULL;

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_disk_delete ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkWindow *w = NULL;
	GtkCList *clist_info = NULL;
	GtkCList *clist = NULL;
	struct catalog_file_info *file_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *parent = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		parent = GTK_CTREE_ROW ( node)->parent;
		w = gw_gui_manager_main_interface_get_main_window ( );
		clist_info = gw_notebook_catalog_get_clist_explorer ( w);
		tree = gw_gui_manager_main_interface_get_tree ( );

		clist = GTK_CLIST ( tree);
		gtk_clist_freeze ( clist);
		gtk_clist_freeze ( clist_info);
		gtk_clist_clear ( clist_info);
		gtk_ctree_remove_node ( tree, node);
		gtk_clist_thaw ( clist);
		gtk_clist_thaw ( clist_info);
		gtk_ctree_select ( GTK_CTREE ( tree), parent);


		file_info = gtk_ctree_node_get_row_data ( tree, parent);
		catalog_file_info_set_ismodified ( file_info, TRUE);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_disk_change_volume_label ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		window = gw_gui_manager_main_interface_get_main_window ( );

		node_gw_menu_popup_callback = node;
		gw_capture_box_create ( window, _( "Change volume label"), _( "Enter new disk volume label"), disk_info_get_volume ( disk_data_get_info ( gtk_ctree_node_get_row_data ( tree, node))), GTK_SIGNAL_FUNC ( gw_menu_popup_disk_change_volume_label_ok));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_disk_change_volume_label_ok ( GtkWidget *w, GtkWidget *data)
{
	gboolean result = FALSE;
	struct disk_info *disk_info = NULL;
	gchar *tmp_name;
	GtkCTree *tree = NULL;
	GtkCTreeNode *selection = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( data != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		tmp_name = gw_capture_box_get_text ( GTK_WINDOW ( data));
		disk_info = disk_data_get_info ( gtk_ctree_node_get_row_data ( tree, node_gw_menu_popup_callback));

		if ( strcmp ( disk_info_get_volume ( disk_info), tmp_name) != 0 )
		{
			/* Checks if the filled volume name isn't equals to the disk volume name. */
			if ( strcmp ( tmp_name, "") != 0 )
			{
				/* If a volume name has been filled. */
				disk_info_set_volume ( disk_info, g_strdup ( tmp_name));

				/* Indicates that catalog has been modified. */
				catalog_file_info_set_ismodified ( gtk_ctree_node_get_row_data ( tree, GTK_CTREE_ROW ( node_gw_menu_popup_callback)->parent), TRUE);

				/* Selects the selected item in the exploration tree to refresh the list of files. */
				gtk_ctree_select ( tree, selection);
			}
		}

		g_free ( tmp_name);
		gtk_widget_destroy ( data);
		node_gw_menu_popup_callback = NULL;

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_disk_edit_description ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		window = gw_gui_manager_main_interface_get_main_window ( );

		node_gw_menu_popup_callback = node;
		gw_text_box_create ( window, _( "Edit description"), _( "Disk description"), disk_info_get_description ( disk_data_get_info ( gtk_ctree_node_get_row_data ( tree, node))), GTK_SIGNAL_FUNC ( gw_menu_popup_disk_edit_description_ok));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_disk_edit_description_ok ( GtkWidget *b, GtkWidget *w )
{
	gboolean result = FALSE;
	struct disk_info *disk_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *selection = NULL;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		selection = GTK_CTREE_NODE ( GTK_CLIST( tree)->selection->data);

		disk_info = disk_data_get_info ( gtk_ctree_node_get_row_data ( tree, node_gw_menu_popup_callback));

		text_utf8 = gw_text_box_get_text ( w);

		if ( (disk_info_get_description ( disk_info) == NULL) || (strcmp ( text_utf8, disk_info_get_description ( disk_info)) != 0) ) {
			/* If the filled description isn't equals to the catalog description. */
			if ( strlen ( text_utf8) > 0 ) {
				disk_info_set_description ( disk_info, g_strdup ( text_utf8));
			} else {
				disk_info_set_description ( disk_info, NULL);
			}

			/* Indicates that catalog have been modified. */
			catalog_file_info_set_ismodified ( gtk_ctree_node_get_row_data ( tree, GTK_CTREE_ROW ( node_gw_menu_popup_callback)->parent), TRUE);
		}

		g_free ( text_utf8);

		gtk_widget_destroy ( w);

		/* Selects the selected item in the exploration tree to refresh the list of files. */
		gtk_ctree_select ( tree, selection);

		node_gw_menu_popup_callback = NULL;

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_disk_properties ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkWindow *window = NULL;
	GtkCTree *tree = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		window = gw_gui_manager_main_interface_get_main_window ( );
		tree = gw_gui_manager_main_interface_get_tree ( );

		gw_properties_box_create_disk ( m, window, tree, node);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_folder_move_to ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );

		if ( !GTK_CTREE_ROW ( node)->expanded )
		{
			if ( node != NULL )
			{
				gtk_ctree_expand ( tree, node);
			}
		}

		gtk_ctree_select ( GTK_CTREE ( tree), node);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_folder_rename ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		window = gw_gui_manager_main_interface_get_main_window ( );

		node_gw_menu_popup_callback = node;
		gw_capture_box_create ( window, _( "Rename folder"), _( "Enter new folder name"), file_info_get_name ( dir_data_get_info ( gtk_ctree_node_get_row_data ( tree, node))), GTK_SIGNAL_FUNC ( gw_menu_popup_folder_rename_ok));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_folder_rename_ok ( GtkWidget *w, GtkWidget *data)
{
	gboolean result = FALSE;
	struct file_info *file_info = NULL;
	guint8 spc;
	GdkBitmap *btmp;
	GdkPixmap *pxmp;
	gchar *folder_name = NULL, *name = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *selection = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( data != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		folder_name = gw_capture_box_get_text ( GTK_WINDOW ( data));
		file_info = dir_data_get_info ( gtk_ctree_node_get_row_data ( tree, node_gw_menu_popup_callback));

		if ( (strcmp ( folder_name, "") != 0 ) && (strcmp ( file_info_get_name ( file_info), folder_name) != 0) )
		{
			/* Checks if the filled name isn't equals to the folder name. */
			if ( !gw_folder_name_is_exist ( node_gw_menu_popup_callback, folder_name))
			{
				/* If a name has been filled. */
				gtk_ctree_node_get_pixtext ( tree, node_gw_menu_popup_callback, 0, &name, &spc, &pxmp, &btmp);
				gtk_ctree_node_set_pixtext ( tree, node_gw_menu_popup_callback, 0, folder_name, spc, pxmp, btmp);
				file_info_set_name ( file_info, g_strdup ( folder_name));

				/* Indicates that catalog has been modified. */
				catalog_file_info_set_ismodified ( gtk_ctree_node_get_row_data ( tree, gw_gui_manager_main_interface_get_tree_root ( )), TRUE);

				/* Selects the selected item in the exploration tree to refresh the list of files. */
				gtk_ctree_select ( tree, selection);
			}
			else
			{
				window = gw_gui_manager_main_interface_get_main_window ( );
				gw_msg_box_create ( window, _("Rename folder"), _("The filled folder name already exist in the current folder"));
			}
		}
		else
		{
			window = gw_gui_manager_main_interface_get_main_window ( );
			gw_msg_box_create ( window, _("Rename folder"), _("No new folder name was filled"));
		}

		g_free ( folder_name);
		gtk_widget_destroy ( data);
		node_gw_menu_popup_callback = NULL;

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_folder_edit_description ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkWindow *window = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		window = gw_gui_manager_main_interface_get_main_window ( );

		node_gw_menu_popup_callback = node;
		gw_text_box_create ( window, _( "Edit description"), _( "Folder description"), file_info_get_description ( dir_data_get_info ( gtk_ctree_node_get_row_data ( tree, node))), GTK_SIGNAL_FUNC ( gw_menu_popup_folder_edit_description_ok));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_folder_edit_description_ok ( GtkWidget *b, GtkWidget *w )
{
	gboolean result = FALSE;
	struct file_info *dir_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *selection = NULL;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		dir_info = dir_data_get_info ( gtk_ctree_node_get_row_data ( tree, node_gw_menu_popup_callback));

		text_utf8 = gw_text_box_get_text ( w);

		if ( (file_info_get_description ( dir_info) == NULL) || (strcmp ( text_utf8, file_info_get_description ( dir_info)) != 0) ) {
			/* If the filled description isn't equals to the catalog description. */
			if ( strlen ( text_utf8) > 0 ) {
				file_info_set_description ( dir_info, g_strdup ( text_utf8));
			} else {
				file_info_set_description ( dir_info, NULL);
			}

			/* Indicates that catalog have been modified. */
			catalog_file_info_set_ismodified ( gtk_ctree_node_get_row_data ( tree, gw_folder_get_catalog ( tree, node_gw_menu_popup_callback)), TRUE);
		}

		g_free ( text_utf8);

		gtk_widget_destroy ( w);

		/* Selects the selected item in the exploration tree to refresh the list of files. */
		gtk_ctree_select ( tree, selection);

		node_gw_menu_popup_callback = NULL;

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_folder_remove ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkWindow *w = NULL;
	GtkCList *clist_info = NULL;
	GtkCList *clist;
	struct catalog_file_info *file_info = NULL;
	GtkCTreeNode *tmp, *parent = NULL;
	GtkCTree *tree = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		parent = GTK_CTREE_ROW ( node)->parent;
		w = gw_gui_manager_main_interface_get_main_window ( );
		clist_info = gw_notebook_catalog_get_clist_explorer ( w);
		tree = gw_gui_manager_main_interface_get_tree ( );

		/* Updates the folders size which contains the folder to delete. */
		tmp = parent;

		while ( GTK_CTREE_ROW ( GTK_CTREE_ROW ( tmp)->parent)->parent != NULL )
		{
			file_info_set_size ( dir_data_get_info ( gtk_ctree_node_get_row_data ( tree, tmp)), file_info_get_size ( dir_data_get_info ( gtk_ctree_node_get_row_data ( tree, tmp))) - file_info_get_size ( dir_data_get_info ( gtk_ctree_node_get_row_data ( tree, node))));
			tmp = GTK_CTREE_ROW ( tmp)->parent;
		}

		/* Updates the disk size which contains the folder to delete. */
		disk_info_set_full ( disk_data_get_info ( gtk_ctree_node_get_row_data ( tree, tmp)), disk_info_get_full ( disk_data_get_info ( gtk_ctree_node_get_row_data ( tree, tmp))) - file_info_get_size ( dir_data_get_info ( gtk_ctree_node_get_row_data ( tree, node))));

		clist = GTK_CLIST ( tree);
		gtk_clist_freeze ( clist);
		gtk_clist_freeze ( clist_info);
		gtk_clist_clear ( clist_info);
		gtk_ctree_remove_node ( tree, node);
		gtk_clist_thaw ( clist);
		gtk_clist_thaw ( clist_info);
		gtk_ctree_select ( GTK_CTREE ( tree), parent);

		file_info = gtk_ctree_node_get_row_data ( tree, GTK_CTREE_ROW ( tmp)->parent);

		/* Indicates that catalog has been modified. */
		catalog_file_info_set_ismodified ( file_info, TRUE);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_folder_properties ( GtkMenuItem *m, GtkCTreeNode *node)
{
	gboolean result = FALSE;
	GtkWindow *window = NULL;
	GtkCTree *tree = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( node != NULL )
	{
		window = gw_gui_manager_main_interface_get_main_window ( );
		tree = gw_gui_manager_main_interface_get_tree ( );

		gw_properties_box_create_folder ( m, window, tree, node);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_file_rename ( GtkMenuItem *m, gpointer row)
{
	gboolean result = FALSE;
	GtkCTree *tree = NULL;
	GtkWindow *window = NULL;
	GtkCTreeNode *selection = NULL;
	GtkCList *clist_info = NULL;
	gchar *name = NULL;
	guint8 spc;
	GdkBitmap *btmp;
	GdkPixmap *pxmp;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( GPOINTER_TO_INT ( row ) >= 0 )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		window = gw_gui_manager_main_interface_get_main_window ( );
		clist_info = gw_notebook_catalog_get_clist_explorer ( window);

		/* Gets the file name. */
		gtk_clist_get_pixtext ( GTK_CLIST ( clist_info), GPOINTER_TO_INT ( row), 0, &name, &spc, &btmp, &pxmp);
		g_strdup_from_gtk_text ( name, text_utf8);
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
		g_print ( "*** GW - %s (%d) :: %s() : selected file is %s\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, name);
#endif

		/* Gets the parent folder. */
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		/* Gets file informations. */
		files_gw_menu_popup_callback = dir_data_get_child_named ( gtk_ctree_node_get_row_data ( tree, selection), text_utf8);

		gw_capture_box_create ( window, _( "Rename file"), _( "Enter new file name"), text_utf8, GTK_SIGNAL_FUNC ( gw_menu_popup_file_rename_ok));

		g_free ( text_utf8);
		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_file_rename_ok ( GtkWidget *w, GtkWidget *data)
{
	GtkWindow *window = NULL;
	gboolean result = FALSE;
	struct file_info *file_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *selection = NULL;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		file_info = files_gw_menu_popup_callback->data;

		text_utf8 = gw_capture_box_get_text ( GTK_WINDOW ( data));

		/* Checks of the filled file name isn't equals to the current file name. */
		if ( strcmp ( text_utf8, "")!=0 && strcmp ( text_utf8, file_info_get_name ( file_info))!=0 )
		{
			if ( !gw_folder_name_is_exist ( GTK_CTREE_ROW ( selection)->children, text_utf8))
			{
				if ( GTK_CTREE_ROW ( selection)->children==NULL )
				{
					if ( dir_data_get_child_named ( gtk_ctree_node_get_row_data ( tree, selection), text_utf8) == NULL )
					{
						file_info_set_name ( file_info, g_strdup ( text_utf8));

						/* Indicates that catalog has been modified. */
						catalog_file_info_set_ismodified ( gtk_ctree_node_get_row_data ( tree, gw_folder_get_catalog ( tree, selection)), TRUE);
					}
					else
					{
						window = gw_gui_manager_main_interface_get_main_window ( );
						gw_msg_box_create ( window, _("Rename folder"), _("The filled file name already exist in the current folder"));
					}
				}
				else
				{
					file_info_set_name ( file_info, g_strdup ( text_utf8));

					/* Indicates that catalog has been modified. */
					catalog_file_info_set_ismodified ( gtk_ctree_node_get_row_data ( tree, gw_folder_get_catalog ( tree, selection)), TRUE);
				}
			}
			else
			{
				window = gw_gui_manager_main_interface_get_main_window ( );
				gw_msg_box_create ( window, _("Rename folder"), _("The filled file name already exist in the current folder"));
			}
		}
		else
		{
			window = gw_gui_manager_main_interface_get_main_window ( );
			gw_msg_box_create ( window, _("Rename file"), _("No new file name was filled"));
		}

		g_free ( text_utf8);

		gtk_widget_destroy ( data);

		/* Selects the selected item in the exploration tree to refresh the list of files. */
		gtk_ctree_select ( tree, selection);

		node_gw_menu_popup_callback = NULL;
		files_gw_menu_popup_callback = NULL;

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_file_edit_description ( GtkMenuItem *m, gpointer row)
{
	gboolean result = FALSE;
	GtkWindow *w = NULL;
	GtkCList *clist_info = NULL;
	GList *child = NULL;
	GtkCTreeNode *selection;
	gchar *name;
	guint8 spc;
	GdkBitmap *btmp;
	GdkPixmap *pxmp;
	GtkCTree *tree = NULL;
	GtkWindow *window = NULL;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( GPOINTER_TO_INT ( row ) >= 0 )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		window = gw_gui_manager_main_interface_get_main_window ( );

		w = gw_gui_manager_main_interface_get_main_window ( );
		clist_info = gw_notebook_catalog_get_clist_explorer ( w);

		/* Gets the file name. */
		gtk_clist_get_pixtext ( GTK_CLIST ( clist_info), GPOINTER_TO_INT ( row), 0, &name, &spc, &btmp, &pxmp);
		g_strdup_from_gtk_text ( name, text_utf8);
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
		g_print ( "*** GW - %s (%d) :: %s() : selected file is %s\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, name);
#endif

		/* Gets the parent folder. */
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		/* Gets file informations. */
		files_gw_menu_popup_callback = child = dir_data_get_child_named ( gtk_ctree_node_get_row_data ( tree, selection), text_utf8);
		g_free ( text_utf8);

		node_gw_menu_popup_callback = selection;
		gw_text_box_create ( window, _( "Edit description"), _( "File description"), file_info_get_description ( child->data), GTK_SIGNAL_FUNC ( gw_menu_popup_file_edit_description_ok));

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_file_edit_description_ok ( GtkWidget *b, GtkWidget *w )
{
	gboolean result = FALSE;
	struct file_info *file_info = NULL;
	GtkCTree *tree = NULL;
	GtkCTreeNode *selection = NULL;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( w != NULL )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		file_info = files_gw_menu_popup_callback->data;

		text_utf8 = gw_text_box_get_text ( w);

		if ( (file_info_get_description ( file_info) == NULL) || (strcmp ( text_utf8, file_info_get_description ( file_info)) != 0) ) {
			/* If the filled description isn't equals to the catalog description. */
			if ( strlen ( text_utf8) > 0 ) {
				file_info_set_description ( file_info, g_strdup ( text_utf8));
			} else {
				file_info_set_description ( file_info, NULL);
			}

			/* Indicates that catalog have been modified. */
			catalog_file_info_set_ismodified ( gtk_ctree_node_get_row_data ( tree, gw_folder_get_catalog ( tree, node_gw_menu_popup_callback)), TRUE);
		}

		g_free ( text_utf8);

		gtk_widget_destroy ( w);

		/* Selects the selected item in the exploration tree to refresh the list of files. */
		gtk_ctree_select ( tree, selection);

		node_gw_menu_popup_callback = NULL;
		files_gw_menu_popup_callback = NULL;

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_file_remove ( GtkMenuItem *m, gpointer row)
{
	gboolean result = FALSE;
	GtkWindow *w = NULL;
	GtkCList *clist_info = NULL;
	GList *child = NULL;
	struct catalog_file_info *file_info = NULL;
	GtkCTreeNode *selection, *parent, *tmp;
	gchar *name = NULL;
	guint8 spc;
	GdkBitmap *btmp;
	GdkPixmap *pxmp;
	GtkCTree *tree = NULL;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( GPOINTER_TO_INT ( row ) >= 0 )
	{
		tree = gw_gui_manager_main_interface_get_tree ( );
		w = gw_gui_manager_main_interface_get_main_window ( );
		clist_info = gw_notebook_catalog_get_clist_explorer ( w);

		/* Gets the file name to delete. */
		gtk_clist_get_pixtext ( GTK_CLIST ( clist_info), GPOINTER_TO_INT ( row), 0, &name, &spc, &btmp, &pxmp);
		g_strdup_from_gtk_text ( name, text_utf8);
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
		g_print ( "*** GW - %s (%d) :: %s() : selected file is %s\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, name);
#endif

		/* Gets the parent folder. */
		parent = selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		/* Gets the file informations */
		child = dir_data_get_child_named ( gtk_ctree_node_get_row_data ( tree, selection), text_utf8);
		g_free ( text_utf8);

		/* Updates the folders size which containsthe file to delete. */
		tmp = parent;

		while ( GTK_CTREE_ROW ( GTK_CTREE_ROW ( tmp)->parent)->parent != NULL )
		{
			file_info_set_size ( dir_data_get_info ( gtk_ctree_node_get_row_data ( tree, tmp)), file_info_get_size ( dir_data_get_info ( gtk_ctree_node_get_row_data ( tree, tmp))) - file_info_get_size ( child->data));
			tmp = GTK_CTREE_ROW ( tmp)->parent;
		}

		/* Updates the disk size which contains the file to delete. */
		disk_info_set_full ( disk_data_get_info ( gtk_ctree_node_get_row_data ( tree, tmp)), disk_info_get_full ( disk_data_get_info ( gtk_ctree_node_get_row_data ( tree, tmp))) - file_info_get_size ( child->data));

		/* Removes the file from catalog. */
		dir_data_remove_child ( gtk_ctree_node_get_row_data ( tree, selection), child->data);

		/* Selects the selected item in the exploration tree to refresh the list of files. */
		gtk_ctree_select ( GTK_CTREE ( tree), selection);


		/*file_info = gtk_object_get_data ( GTK_OBJECT ( window), "window");*/
		file_info = gtk_ctree_node_get_row_data ( tree, GTK_CTREE_ROW ( tmp)->parent);
		catalog_file_info_set_ismodified ( file_info, TRUE);

		result = TRUE;
	}

	return result;
}


gboolean gw_menu_popup_file_properties ( GtkMenuItem *m, gpointer row)
{
	gboolean result = FALSE;
	GtkWindow *w = NULL;
	GtkCList *clist_info = NULL;
	GList *child = NULL;
	GtkCTreeNode *selection;
	gchar *name = NULL;
	guint8 spc;
	GdkBitmap *btmp;
	GdkPixmap *pxmp;
	GtkWindow *window = NULL;
	GtkCTree *tree = NULL;
	gchar *text_utf8 = NULL;


#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( GPOINTER_TO_INT ( row ) >= 0 )
	{
		window = gw_gui_manager_main_interface_get_main_window ( );
		tree = gw_gui_manager_main_interface_get_tree ( );

		w = gw_gui_manager_main_interface_get_main_window ( );
		clist_info = gw_notebook_catalog_get_clist_explorer ( w);

		/* Gets the file name to delete. */
		gtk_clist_get_pixtext ( GTK_CLIST ( clist_info), GPOINTER_TO_INT ( row), 0, &name, &spc, &btmp, &pxmp);
		g_strdup_from_gtk_text ( name, text_utf8);
#ifdef GW_DEBUG_GUI_CALLBACK_COMPONENT
		g_print ( "*** GW - %s (%d) :: %s() : selected file (%d) is %s\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, GPOINTER_TO_INT ( row), name);
#endif

		/* Gets the parent folder. */
		selection = GTK_CTREE_NODE ( GTK_CLIST ( tree)->selection->data);

		/* Gets file informations. */
		child = dir_data_get_child_named ( gtk_ctree_node_get_row_data ( tree, selection), text_utf8);
		g_free ( text_utf8);

		gw_properties_box_create_file ( m, window, tree, selection, child);

		result = TRUE;
	}

	return result;
}
