/*  GWhere.
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "../gwsupport.h"
#include "gwdiskinfo.h"

#include <time.h> /* localtime */
#include <string.h> /* strncmp */
#include "tools/gwtools.h"


extern GdkPixmap *PixCDRomDisk;
extern GdkBitmap *MskCDRomDisk;
extern GdkPixmap *PixFloppyDisk;
extern GdkBitmap *MskFloppyDisk;
extern GdkPixmap *PixHardDriveDisk;
extern GdkBitmap *MskHardDriveDisk;
extern GdkPixmap *PixZipDisk;
extern GdkBitmap *MskZipDisk;



typedef struct disk_info
{
	gchar *name;			/* Disk name					*/
	gchar *fsname;			/* Device file system name			*/
	gchar *dir;			/* Disk access path				*/
	gint num;			/* Number archive in catalog			*/
	gchar *type;			/* Device type					*/
	gchar *volume;			/* Disk label					*/
	guint64 full;			/* Disk full capacity				*/
	guint64 free;			/* Disk free space				*/
	gulong date;			/* Disk adding date				*/
	gchar *serial;			/* Disk serial number				*/
	struct category *category;	/* Disk category				*/
	gchar *description;		/* Disk description				*/
} DiskInfo;


DiskInfo * disk_info_new ( void)
{
	DiskInfo *p = NULL;


#ifdef GW_DEBUG_DATA_COMPONENT
	static gint i = 0;


	i++;

	g_print ( "*** GW - %s (%d) :: %s() : %d calls\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, i);
#endif

	if ( (p = (DiskInfo*)g_malloc0 ( sizeof ( DiskInfo))) != NULL)
	{
		p->name = NULL;
		p->fsname = NULL;
		p->dir = NULL;
		p->num = 0;
		p->type = NULL;
		p->volume = NULL;
		p->full = 0;
		p->free = 0;
		p->date = 0;
		p->serial = NULL;
		p->category = NULL;
		p->description = NULL;
	}

	return p;
}


gint disk_info_set_name ( DiskInfo *p, gchar *name)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->name != NULL )
		{
			g_free ( p->name);
		}

		p->name = name;

		return 0;
	}

	return -1;
}


gint disk_info_set_fsname ( DiskInfo *p, gchar *fsname)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->fsname != NULL )
		{
			g_free ( p->fsname);
		}

		p->fsname = fsname;

		return 0;
	}

	return -1;
}


gint disk_info_set_dir ( DiskInfo *p, gchar *dir)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->dir != NULL )
		{
			g_free ( p->dir);
		}

		p->dir = dir;

		return 0;
	}

	return -1;
}


gint disk_info_set_num ( DiskInfo *p, gint num)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num = num;

		return 0;
	}

	return -1;
}


gint disk_info_set_type ( DiskInfo *p, gchar *type)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->type != NULL )
		{
			g_free ( p->type);
		}

		p->type = type;

		return 0;
	}

	return -1;
}


gint disk_info_set_volume ( DiskInfo *p, gchar *volume)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->volume != NULL )
		{
			g_free ( p->volume);
		}

		p->volume = volume;

		return 0;
	}

	return -1;
}


gint disk_info_set_full ( DiskInfo *p, guint64 full)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->full = full;

		return 0;
	}

	return -1;
}


gint disk_info_set_free ( DiskInfo *p, guint64 free)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->free = free;

		return 0;
	}

	return -1;
}


gint disk_info_set_date ( DiskInfo *p, gulong date)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->date = date;

		return 0;
	}

	return -1;
}


gint disk_info_set_serial ( DiskInfo *p, gchar *serial)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->serial != NULL )
		{
			g_free ( p->serial);
		}

		p->serial = serial;

		return 0;
	}

	return -1;
}


gint disk_info_set_category ( struct disk_info *p, struct category *category)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->category != NULL )
		{
			/* Must to decrese the category count */
		}

		p->category = category;

		return 0;
	}

	return -1;
}


gint disk_info_set_description ( DiskInfo *p, gchar *description)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->description != NULL )
		{
			g_free ( p->description);
		}

		p->description = description;

		return 0;
	}

	return -1;
}


gchar * disk_info_get_name ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->name != NULL )
		{
			return p->name;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gchar * disk_info_get_fsname ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->fsname != NULL )
		{
			return p->fsname;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gchar * disk_info_get_dir ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->dir != NULL )
		{
			return p->dir;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gint disk_info_get_num ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->num;
	}

	return 0;
}


gchar * disk_info_get_type ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->type != NULL )
		{
			return p->type;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gchar * disk_info_get_volume ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->volume != NULL )
		{
			return p->volume;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


guint64 disk_info_get_capacity ( DiskInfo *p)
{
	guint64 size = G_GINT64_CONSTANT ( 0);


#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		size = disk_info_get_full ( p) + disk_info_get_free ( p);
	}

	return size;
}


guint64 disk_info_get_full ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->full;
	}

	return 0;
}


guint64 disk_info_get_free ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->free;
	}

	return 0;
}


gulong disk_info_get_date ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->date;
	}

	return 0;
}


gchar * disk_info_get_date_to_gchar ( DiskInfo *p)
{
	struct tm *time = NULL;
	


#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( (time = localtime ( &(p->date))) != NULL )
		{
			return gw_tm_to_str_format ( time);
		}
	}

	return NULL;
}


gchar * disk_info_get_serial ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->serial != NULL )
		{
			return p->serial;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


struct category * disk_info_get_category ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->category != NULL )
		{
			return p->category;
		}
	}

	return NULL;
}


gchar * disk_info_get_category_name ( struct disk_info *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( disk_info_get_category ( p) == NULL )
		{
			return "";
		}

		return category_get_name ( disk_info_get_category ( p));
	}

	return NULL;
}


gint disk_info_get_category_index ( struct disk_info *p)
{
	gint index = 0;


#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( disk_info_get_category ( p) == NULL )
		{
			return 0;
		}

		if ( (index = category_get_index ( disk_info_get_category ( p))) == -1)
		{
			return 0;
		}
	}

	return index;
}


gchar * disk_info_get_description ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->description != NULL )
		{
			return p->description;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


GdkPixmap * disk_info_get_pixmap ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
/*		if ( strncmp ( "CD-ROM", p->type, 5) == 0 )
		{
			return PixCDRomDisk;
		}
		else { if ( strncmp ( "HD", p->type, 9) == 0 )
		{
			return PixHardDriveDisk;
		}
		else { if ( strncmp ( "Floppy", p->type, 6) == 0 )
		{
			return PixFloppyDisk;
		}
		else { if ( strncmp ( "Zip", p->type, 3) == 0 )
		{
			return PixZipDisk;
		}*/

		if ( p->type == NULL )
		{
			return PixHardDriveDisk;
		}

		if ( p->fsname == NULL )
		{
			return PixHardDriveDisk;
		}

		if ( strncmp ( p->type, "iso9660", 7) == 0 )
		{
			return PixCDRomDisk;
		}
		else {	if ( strncmp ( p->type, "cdfs", 4) == 0 )
		{
			return PixCDRomDisk;
		}
		else {	if ( strncmp ( p->fsname, "/dev/hd", 7) == 0 )
		{
			return PixHardDriveDisk;
		}
		else { if ( strncmp ( p->fsname, "/dev/fd", 7) == 0 )
		{
			return PixFloppyDisk;
		}
		else { if ( strncmp ( p->fsname, "/dev/zip", 8) == 0 )
		{
			return PixZipDisk;
		}
		else { if ( strncmp ( p->fsname, "\\\\.\\A:\\", 7) == 0 )
		{
			return PixFloppyDisk;
		}
		else { if ( strncmp ( p->fsname, "\\\\.\\B:\\", 7) == 0 )
		{
			return PixFloppyDisk;
		}
		else
		{
			return PixHardDriveDisk;
		}}}}}}}
	}

	return NULL;
}


GdkBitmap * disk_info_get_bitmap ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
/*		if ( strncmp ( "CD-ROM", p->type, 5) == 0 )
		{
			return MskCDRomDisk;
		}
		else { if ( strncmp ( "HD", p->type, 9) == 0 )
		{
			return MskHardDriveDisk;
		}
		else { if ( strncmp ( "Floppy", p->type, 6) == 0 )
		{
			return MskFloppyDisk;
		}
		else { if ( strncmp ( "Zip", p->type, 3) == 0 )
		{
			return MskZipDisk;
		}*/

		if ( p->type == NULL )
		{
			return MskHardDriveDisk;
		}

		if ( p->fsname == NULL )
		{
			return MskHardDriveDisk;
		}

		if ( strncmp ( p->type, "iso9660", 7) == 0 )
		{
			return MskCDRomDisk;
		}
		else {	if ( strncmp ( p->fsname, "/dev/hd", 7) == 0 )
		{
			return MskHardDriveDisk;
		}
		else { if ( strncmp ( p->fsname, "/dev/fd", 7) == 0 )
		{
			return MskFloppyDisk;
		}
		else { if ( strncmp ( p->fsname, "/dev/zip", 8) == 0 )
		{
			return MskZipDisk;
		}
		else
		{
			return MskHardDriveDisk;
		}}}}
	}

	return NULL;
}


gint disk_info_free ( DiskInfo *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	static gint i = 0;


	i++;

	g_print ( "*** GW - %s (%d) :: %s() : %d calls\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, i);
#endif

	if ( p != NULL )
	{
		disk_info_set_name ( p, NULL);
		disk_info_set_fsname ( p, NULL);
		disk_info_set_dir ( p, NULL);
		disk_info_set_type ( p, NULL);
		disk_info_set_volume ( p, NULL);
		disk_info_set_serial ( p, NULL);
		disk_info_set_description ( p, NULL);

		g_free ( p);

		return 0;
	}

	return -1;
}
