/*  GWhere
 *  Copyright (C) 2000  Sbastien LECACHEUR
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "../gwsupport.h"
#include "gwcategory.h"


typedef struct category
{
	gint index;				/* Category's index				*/
	gchar *name;				/* Category's name				*/
	gchar *description;			/* Category's description				*/
	gint num_catalog;				/* Number of catalogs which are in this category	*/
	gint num_disk;				/* Number of disks which are in this category		*/
	gint num_folder;				/* Number of folders which are in this category		*/
	gint num_file;				/* Number of files which are in this category		*/
} Category;


struct category * category_new ( void)
{
	struct category *p = NULL;


#ifdef GW_DEBUG_DATA_COMPONENT
	static gint i = 0;


	i++;

	g_print ( "*** GW - %s (%d) :: %s() : %d calls\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, i);
#endif

	if ( (p = (struct category*)g_malloc0 ( sizeof ( struct category))) != NULL )
	{
		p->name = NULL;
		p->description = NULL;
		p->num_catalog = 1;
		p->num_disk = 0;
		p->num_folder = 0;
		p->num_file = 0;

	}

	return p;
}


gint category_set_index ( struct category *p, gint index)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->index = index;

		return 0;
	}

	return -1;
}


gint category_set_name ( struct category *p, gchar *name)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->name != NULL )
		{
			g_free ( p->name);
		}

		p->name = name;

		return 0;
	}

	return -1;
}


gint category_set_description ( struct category *p, gchar *description)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->description != NULL )
		{
			g_free ( p->description);
		}

		p->description = description;

		return 0;
	}

	return -1;
}


gint category_set_number_catalog ( struct category *p, gint num)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num_catalog = num;

		return 0;
	}

	return -1;
}


gint category_set_number_disk ( struct category *p, gint num)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num_disk = num;

		return 0;
	}

	return -1;
}


gint category_set_number_folder ( struct category *p, gint num)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num_folder = num;

		return 0;
	}

	return -1;
}


gint category_set_number_file ( struct category *p, gint num)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num_file = num;

		return 0;
	}

	return -1;
}


gint category_get_index ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->index;
	}

	return -1;
}


gchar * category_get_name ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->name != NULL )
		{
			return p->name;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gchar * category_get_description ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( p->description != NULL )
		{
			return p->description;
		}
		else
		{
			return "";
		}
	}

	return NULL;
}


gint category_get_number_catalog ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->num_catalog;
	}

	return -1;
}


gint category_get_number_disk ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->num_disk;
	}

	return -1;
}


gint category_get_number_folder ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->num_folder;
	}

	return -1;
}


gint category_get_number_file ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		return p->num_file;
	}

	return -1;
}


gint category_add_catalog ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num_catalog++;

		return p->num_catalog;
	}

	return -1;
}


gint category_add_disk ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num_disk++;

		return p->num_disk;
	}

	return -1;
}


gint category_add_folder ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num_folder++;

		return p->num_folder;
	}

	return -1;
}


gint category_add_file ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num_file++;

		return p->num_file;
	}

	return -1;
}


gint category_remove_catalog ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p == NULL )
	{
		p->num_catalog--;

		return p->num_catalog;
	}

	return -1;
}


gint category_remove_disk ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p == NULL )
	{
		p->num_disk--;

		return p->num_disk;
	}

	return -1;
}


gint category_remove_folder ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num_folder--;

		return p->num_folder;
	}

	return -1;
}


gint category_remove_file ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		p->num_file--;

		return p->num_file;
	}

	return -1;
}


gboolean category_can_removed ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	g_print ( "*** GW - %s (%d) :: %s()\n", __FILE__, __LINE__, __PRETTY_FUNCTION__);
#endif

	if ( p != NULL )
	{
		if ( (category_get_number_catalog ( p) == 0) && (category_get_number_disk ( p) == 0) && (category_get_number_folder ( p) == 0) && (category_get_number_file ( p) == 0) )
		{
			return TRUE;
		}
	}

	return FALSE;
}


gint category_free ( struct category *p)
{
#ifdef GW_DEBUG_DATA_COMPONENT
	static gint i = 0;


	i++;

	g_print ( "*** GW - %s (%d) :: %s() : %d calls\n", __FILE__, __LINE__, __PRETTY_FUNCTION__, i);
#endif

	if ( p != NULL )
	{
		category_set_name ( p, NULL);
		category_set_description ( p, NULL);

		g_free ( p);

		return 0;
	}

	return -1;
}
