/*     ____
      /____\ 
      \    /    Gweled
       \  /
        \/

(C) 2003-2004 Sebastien Delestaing <sebdelestaing@free.fr>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>

#include "sge_core.h"
#include "board_engine.h"
#include "graphic_engine.h"

// GLOBALS
GnomeProgram *g_program;
GladeXML *gweled_xml;
GtkWidget *g_main_window;
GtkWidget *g_pref_window;
GtkWidget *g_score_window;

GtkWidget *g_drawing_area;
GtkWidget *g_progress_bar;
GtkWidget *g_score_label;
GtkWidget *g_bonus_label;
GdkPixmap *g_buffer_pixmap = NULL;
GRand *g_random_generator;

void init_pref_window(void)
{
	GtkWidget *radio_button = NULL;

	if (gweled_in_timer_mode == FALSE)
		radio_button = glade_xml_get_widget(gweled_xml, "easyRadiobutton");
	else
		radio_button = glade_xml_get_widget(gweled_xml, "hardRadiobutton");
	if (radio_button)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radio_button), TRUE);

	radio_button = NULL;
	switch (gi_tile_width) {
	case 32:
		radio_button = glade_xml_get_widget(gweled_xml, "smallRadiobutton");
		break;
	case 48:
		radio_button = glade_xml_get_widget(gweled_xml, "mediumRadiobutton");
		break;
	case 64:
		radio_button = glade_xml_get_widget(gweled_xml, "largeRadiobutton");
		break;
	}
	if (radio_button)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radio_button), TRUE);
}

int main (int argc, char **argv)
{
	guint board_engine_id;

	gnome_score_init ("gweled");

	g_program =
	    gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc,
				argv, GNOME_PARAM_APP_DATADIR,
				PACKAGE_DATA_DIR, NULL);

	sge_init ();

	g_random_generator = g_rand_new_with_seed (time (NULL));

// let's do that before calling init_pref_window
	gi_tile_width = 48;
	gi_tile_height = 48;
	gweled_in_timer_mode = FALSE;

	gweled_xml = glade_xml_new(PACKAGE_DATA_DIR "/gweled/gweled.glade", NULL, NULL);
	g_pref_window = glade_xml_get_widget(gweled_xml, "preferencesDialog");
	g_main_window = glade_xml_get_widget(gweled_xml, "gweledApp");
	g_score_window = glade_xml_get_widget(gweled_xml, "highscoresDialog");
	g_progress_bar = glade_xml_get_widget(gweled_xml, "bonusProgressbar");
	g_score_label = glade_xml_get_widget(gweled_xml, "scoreLabel");
	g_bonus_label = glade_xml_get_widget(gweled_xml, "bonusLabel");
	g_drawing_area = glade_xml_get_widget(gweled_xml, "boardDrawingarea");

	init_pref_window();

	glade_xml_signal_autoconnect(gweled_xml);

	gtk_widget_add_events (GTK_WIDGET (g_drawing_area),
			       GDK_BUTTON_RELEASE_MASK | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_MOTION_MASK);

	gtk_window_set_resizable (GTK_WINDOW (g_main_window), FALSE);
	gtk_widget_show (g_main_window);

	gtk_widget_set_size_request (GTK_WIDGET (g_drawing_area),
				     BOARD_WIDTH * gi_tile_width,
				     BOARD_HEIGHT * gi_tile_height);

	g_buffer_pixmap =
	    gdk_pixmap_new (g_drawing_area->window,
			    BOARD_WIDTH * gi_tile_width,
			    BOARD_HEIGHT * gi_tile_height, -1);

	gweled_init_glyphs ();
	gweled_load_pixmaps ();
	gweled_load_font ();

	gi_game_running = 0;

	board_engine_id = gtk_timeout_add (100, board_engine_loop, NULL);
	sge_set_drawing_area (g_drawing_area, g_buffer_pixmap,
			      BOARD_WIDTH * gi_tile_width,
			      BOARD_HEIGHT * gi_tile_height);

	gweled_draw_board ();
	gweled_draw_message ("gweled");

	gtk_main ();

	sge_destroy ();
	gtk_timeout_remove (board_engine_id);
	g_rand_free (g_random_generator);
	g_object_unref(G_OBJECT(gweled_xml));	

	return 0;
}

