#!/usr/bin/env python

from os import listdir, path
from distutils.core import setup
from DistUtilsExtra.command import *
import sys
import subprocess

dist = setup(name='gvb',
      version='1.2',
      description='Good ViBrations',
      license='GPL',
      author='Pietro Battiston',
      author_email='toobaz@email.it',
      url='http://www.pietrobattiston.it/gvb',
      scripts=['gvb'],
      packages=['gvbmod'],
      data_files=[('share/gvb/stuff', ['stuff/logo.svg', 'stuff/wlogo.svg', 'stuff/gvb.glade']),
#				  ('share/doc/gvb', ['README']),
				  ('share/pixmaps', ['stuff/gvb.svg']),
				  ('share/applications', ['stuff/gvb.desktop'])]+
				  [('share/locale/'+lang+'/LC_MESSAGES/', ['locale/'+lang+'/LC_MESSAGES/gvb.mo'] ) for lang in listdir('locale')],
      cmdclass = { "build" :  build_extra.build_extra,
                   "build_help" :  build_help.build_help},
      classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: X11 Applications :: GTK',
        'Intended Audience :: Education',
        'Intended Audience :: End Users/Desktop',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python',
        'Topic :: Education :: Testing',
        'Topic :: Scientific/Engineering :: Physics',
        'Topic :: Scientific/Engineering :: Visualization',
        ]    
     )

if 'prefix' in dist.command_options['install']:
    prefix = dist.command_options['install']['prefix'][1]
elif 'root' in dist.command_options['install']:
    prefix = dist.command_options['install']['root'][1] + sys.prefix
else:
    prefix = sys.prefix

omf_path, omf_files = dist.data_files[-1]
help_C_path, help_C_files = dist.data_files[-2]

for omf in omf_files:
	folder, lang, filename = omf.split('/')
	omf_full_path = path.join(prefix, omf_path, filename)
	help_full_path = path.join(prefix, help_C_path.split('/C/')[0], lang, 'gvb.xml')
	subprocess.call(['scrollkeeper-preinstall', help_full_path, omf_full_path, omf_full_path])

