/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2004 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef GF_COMPAT_H
#define GF_COMPAT_H

/* we need the GAIM_VERSION_CHECK macro to make these macros below work */
#include <version.h>

#if GAIM_VERSION_CHECK(2,0,0)
# define gf_find_conversation(type, name, account) \
	gaim_find_conversation_with_account((type), (name), (account))

# define gf_conv_switch(win, conv) \
	gaim_conv_window_switch_conversation((win), (conv))

# define gf_blist_node_action_new(string, cb)\
	gaim_blist_node_action_new((string), (cb), NULL, NULL)

# define gf_prefs_connect_callback(plugin, pref, cb, data) \
	gaim_prefs_connect_callback((plugin), (pref), (cb), (data))

# define gf_chat_get_name(chat) gaim_chat_get_name((chat))

# define gf_get_warning_level(buddy) \
	gaim_presence_get_warning_level((buddy)->presence)

# define gf_mkstemp(path) gaim_mkstemp((path), FALSE)

# define gf_create_prpl_icon(account) gaim_gtk_create_prpl_icon((account))

# define gf_presence_is_valid(account) \
	gaim_presence_is_available((account)->presence)

#else /* GAIM_VERSION_CHECK(2,0,0) */
# define gf_find_conversation(type, name, account) \
	gaim_find_conversation_with_account((name), (account))

# define GAIM_CONV_ANY	(4)

# define gf_conv_switch(win, conv) \
	gaim_conv_window_switch_conversation(win, gaim_conversation_get_index((conv)))

# define gf_blist_node_action_new(string, cb) \
	gaim_blist_node_action_new((string), (cb), NULL)

# define gf_prefs_connect_callback(plugin, pref, cb, data) \
	gaim_prefs_connect_callback((pref), (cb), (data))

# define gf_chat_get_name(chat) gaim_chat_get_display_name((chat))

# define gf_get_warning_level(buddy) (buddy)->evil

# define gf_mkstemp(path) gaim_mkstemp((path))

# define gf_create_prpl_icon(account) create_prpl_icon((account))

# define gf_presence_is_valid(account) (!(account)->gc->away_state)

#endif /* GAIM_VERSION_CHECK(2,0,0) */

#endif /* GF_COMPAT_H */
