## How to contribute to Guider

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/iipeace/guider/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/iipeace/guider/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

#### **Did you fix whitespace, format code, or make a purely cosmetic patch?**

Changes that are cosmetic in nature and do not add anything substantial to the stability, functionality, or testability of Guider will generally not be accepted.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change in the [Guider chart](https://gitter.im/guiderchat/Lobby?source=orgpage) or [Guider issues](https://github.com/iipeace/guider/issues) and start writing code.

* Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.

#### **Do you have questions about the source code?**

* Ask any question about how to use Guider in the [Guider chart](https://gitter.im/guiderchat/Lobby?source=orgpage).

#### **Do you want to contribute to the Guider documentation?**

* Please read and update [Guider Document](https://github.com/iipeace/guider/blob/master/README.md).

Thanks!

Peace Lee
