# -*- coding: utf-8 -*-
#
# Copyright © 2009-2010 CEA
# Pierre Raybaut
# Licensed under the terms of the CECILL License
# (see guidata/__init__.py for details)

"""
JSON I/O demo

DataSet objects may be saved in JSON files.
This script shows how to save in and then reload data from a JSON file.
"""

SHOW = True  # Show test in GUI-based test launcher

import os

from guidata.dataset.dataitems import StringItem
from guidata.jsonio import JSONReader, JSONWriter
from guidata.tests.all_items import TestParameters


class TestParameters_Light(TestParameters):
    date = StringItem("D1", default="Replacement for unsupported DateItem")
    dtime = StringItem("D2", default="Replacement for unsupported DateTimeItem")


if __name__ == "__main__":
    # Create QApplication
    import guidata

    _app = guidata.qapplication()

    if os.path.exists("test.json"):
        os.unlink("test.json")

    e = TestParameters()
    if e.edit():
        writer = JSONWriter("test.json")
        e.serialize(writer)
        writer.save()

        e = TestParameters()
        reader = JSONReader("test.json")
        e.deserialize(reader)
        e.edit()
