# -*- coding: utf-8 -*-
# Gufw 13.10.0 - http://gufw.org
# Copyright (C) 2008-2013 Marcos Alvarez Costales https://launchpad.net/~costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.

from gi.repository import GObject, Gtk
import os

from constants import *


class ListeningReport():
    def __init__(self, fw_frontend, model):
        
        self.fw = fw_frontend
        self.model = model
        
        self.previous_report = []
        self.running_listening = False
    
    def _show_report(self):
        if not self.running_listening:
            return False
        
        report = self.fw.get_listening_report()
        self._view_report(self.model, report, self.previous_report)
        self.previous_report = report
        
        while Gtk.events_pending(): # Not freeze main win
            Gtk.main_iteration()
        
        return True        
    
    def starting(self):
        if self.running_listening:
            return
        
        self.running_listening = True
        GObject.timeout_add(100, self._show_report)
    
    def stopping(self):
        self.running_listening = False
    
    def _view_report(self, model, report, previous_report):
        self.model.clear() 
        row = 0
        
        for line in report:
            line_split = line.split('%')
            row += 1
            iter = self.model.insert(row)
            self.model.set_value(iter, 0, line_split[0].strip()) # Protocol
            self.model.set_value(iter, 1, line_split[1].strip()) # Port
            self.model.set_value(iter, 2, line_split[2].strip()) # Address
            self.model.set_value(iter, 3, line_split[3].strip()) # App
            
            if self.fw.get_status():
                if line_split[4] == 'allow':
                    self.model.set_value(iter, 4, RED)
                elif line_split[4] == 'deny':
                    self.model.set_value(iter, 4, GREEN)
                elif line_split[4] == 'reject':
                    self.model.set_value(iter, 4, BLUE)
                elif line_split[4] == 'limit':
                    self.model.set_value(iter, 4, ORANGE)
