# Gufw 13.10.0 - http://gufw.org
# Copyright (C) 2008-2013 Marcos Alvarez Costales https://launchpad.net/~costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.

import os
from netifaces import interfaces, ifaddresses, AF_INET


class UtilsGUI():
    """Set or get the Log properties"""   
    def __init__(self, backend):
        self.backend = backend
    
    def get_config_value(self, attrib):
        return self.backend.get_config_value(attrib)
    
    def set_config_value(self, attrib, value):
        self.backend.set_config_value(attrib, value)
    
    def get_internal_ip(self):
        for ifaceName in interfaces():
            try:
                addresses = ifaddresses(ifaceName)[AF_INET][0]['addr']
                if addresses != '127.0.0.1' and addresses != '1.1.1.1':
                    return addresses
            except:
                continue
        return ''
    
    def get_net_interfaces(self):
        return interfaces()



class InstanceApp:
    """Manages application instances"""
    def __init__(self):
        self.pid_file = '/tmp/gufw.pid'
        self._check_is_root()
        self._check_instance()
        self._start_application()
    
    def _check_instance(self):
        if not os.path.isfile(self.pid_file):
            return
        
        # Read the pid from file
        pid = 0
        try:
            file = open(self.pid_file, 'rt')
            data = file.read()
            file.close()
            pid = int(data)
        except:
            pass
        
        # Check whether the process specified exists
        if pid == 0:
            return
        try:
            os.kill(pid, 0) # exception if the pid is invalid
        except:
            return
        
        exit(0)
    
    def _start_application(self):
        file = open(self.pid_file, 'wt')
        file.write(str(os.getpid()))
        file.close()
    
    def exit_application(self):
        try:
            os.remove(self.pid_file)
        except:
            pass

    def _check_is_root(self):
        if os.geteuid() != 0:
            from gi.repository import Gtk
            dialog = Gtk.MessageDialog(None, 0, Gtk.MessageType.INFO, Gtk.ButtonsType.OK, "Run as superuser")
            dialog.format_secondary_text("Just run this command in the shell: gufw  or  sudo gufw")
            dialog.run()
            dialog.destroy()
            exit(0)
