# Gufw 13.10.0 - http://gufw.org
# Copyright (C) 2008-2013 Marcos Alvarez Costales https://launchpad.net/~costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.


class Logging():
    """Set or get the Log properties"""   
    def __init__(self, backend):
        self.backend = backend
        
        self.ufw_logging = self.backend.get_ufw_logging()
        
        self.gufw_logging = True # By default
        if self.backend.get_config_value('GufwLogging') == 'no':
            self.gufw_logging = False
    
    # ufw
    def get_ufw_logging(self):
        return self.ufw_logging

    def set_ufw_logging(self, level):
        self.ufw_logging = level
        self.backend.set_ufw_logging(level)
    
    # Gufw
    def get_logging(self):
        return self.gufw_logging
    
    def set_logging(self, status):
        self.gufw_logging = status
        if status:
            self.backend.set_config_value('GufwLogging', 'yes')
        else:
            self.backend.set_config_value('GufwLogging', 'no')
    
    def get_log(self):
        return self.backend.get_log()
        
    def add_to_log(self, msg):
        if self.gufw_logging:
            return self.backend.add_to_log(msg)
        return ''
    
    def refresh_log(self):
        self.backend.refresh_log()

