#!/usr/bin/env python
# Gufw 13.10.0 - http://gufw.org
# Copyright (C) 2008-2013 Marcos Alvarez Costales https://launchpad.net/~costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.

from controller  import Controller 
from model.utils import InstanceApp
from view.gufw   import Gufw

if __name__ == '__main__':
    # Check config file & is running previously
    appInstance = InstanceApp()
    
    # Controller & Unlock root GUI
    controler = Controller()
    
    # Firewall
    fw_frontend = controler.get_fw_frontend()
    
    # GUI
    app = Gufw(fw_frontend)
    
    # Remove current instance
    appInstance.exit_application()
    
