# Gufw 13.10.0 - http://gufw.org
# Copyright (C) 2008-2013 Marcos Alvarez Costales https://launchpad.net/~costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.

from model.basic     import Basic
from model.logging   import Logging
from model.listening import Listening
from model.utils     import UtilsGUI


class Frontend():
    """One ring to rule them all..."""
    def __init__(self, backend):
        self.basic     = Basic(backend)
        self.log       = Logging(backend)
        self.listening = Listening(backend)
        self.utils     = UtilsGUI(backend)
    
    
    # BASIC
    # PROFILE
    def get_profile(self):
        return self.basic.get_profile()
    
    def set_profile(self, profile):
        return self.basic.set_profile(profile)
    
    def get_all_profiles(self):
        return self.basic.get_all_profiles()
    
    def add_profile(self, profile):
        self.basic.add_profile(profile)
    
    def delete_profile(self, profile):
        self.basic.delete_profile(profile)
    
    def rename_profile(self, old_name, new_name):
        self.basic.rename_profile(old_name, new_name)
    
    def import_profile(self, file):
        self.basic.import_profile(file)
    
    def export_profile(self, file):
        self.basic.export_profile(file)
    
    # FIREWALL > For current profile!
    def get_status(self):
        return self.basic.get_status()
    
    def set_status(self, status):
        self.basic.set_status(status)
    
    def get_policy(self, policy):
        return self.basic.get_policy(policy)
    
    def set_policy(self, policy, value):
        self.basic.set_policy(policy, value)
    
    def reset(self):
        self.basic.reset()
    
    # RULES > For current profile!
    def get_rules(self):
        return self.basic.get_rules()
    
    def add_rule(self, description, insert='', policy='', direction='', iface='', logging='', proto='', from_ip='', from_port='', to_ip='', to_port=''):
        return self.basic.add_rule(description, insert, policy, direction, iface, logging, proto, from_ip, from_port, to_ip, to_port)
    
    def delete_rule(self, num):
        return self.basic.delete_rule(num)
    
    
    
    # LOGGING
    # ufw LOGGING
    def get_ufw_logging(self):
        return self.log.get_ufw_logging()
    
    def set_ufw_logging(self, level):
        self.log.set_ufw_logging(level)
    
    # Gufw LOGGING
    def get_logging(self):
        return self.log.get_logging()
    
    def set_logging(self, status):
        self.log.set_logging(status)
    
    def get_log(self):
        return self.log.get_log()
    
    def add_to_log(self, msg):
        return self.log.add_to_log(msg)
    
    def refresh_log(self):
        self.log.refresh_log()
    
    
    
    # LISTENING REPORT
    def get_listening_report(self):
        return self.listening.get_listening_report()
    
    
    
    # GUI needs
    def get_config_value(self, attrib):
        return self.utils.get_config_value(attrib)
    
    def set_config_value(self, attrib, value):
        self.utils.set_config_value(attrib, value)
    
    def get_internal_ip(self):
        return self.utils.get_internal_ip()
    
    def get_net_interfaces(self):
        return self.utils.get_net_interfaces()
