#!/usr/bin/env python

# Gufw 11.04.1 - http://gufw.tuxfamily.org
# Copyright (C) 2008-2011 Marcos Alvarez Costales https://launchpad.net/~costales
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.

import sys, os
assert sys.version >= '2', "Install Python 2.0 or greater"
from distutils.core import setup, Extension
import glob


# Create data files
data = [ ('/usr/share/applications',             ['gufw.desktop']),
         ('/usr/share/gufw/data/ui',             glob.glob("data/ui/*.ui")),                
         ('/usr/bin',                            ['bin/gufw']),      
         ('/usr/share/icons/hicolor/48x48/apps', glob.glob("data/media/gufw.png")),         
         ('/usr/share/man/man8',                 ['man/gufw.8.gz']),             
         ('/usr/share/gufw/model',               glob.glob("gufw/model/*.*")),                
         ('/usr/share/gufw/view',                glob.glob("gufw/view/*.*")),                 
         ('/usr/share/gufw/data/media',          glob.glob("data/media/deny*.png")),
         ('/usr/share/gufw/data/media',          glob.glob("data/media/disable*.png")),              
         ('/usr/share/gufw/data/media',          glob.glob("data/media/allow*.png")),            
         ('/usr/share/gufw/data/media',          glob.glob("data/media/reject*.png")),            
         ('/usr/share/gufw',                     glob.glob("gufw/*.py")),
         ('/usr/share/polkit-1/actions',         ['gufw/daemon/gufw.daemon.policy']),
         ('/etc/dbus-1/system.d',                ['gufw/daemon/gufw.Daemon.conf']),
         ('/usr/share/dbus-1/system-services',   ['gufw/daemon/gufw.Daemon.service']),
         ('/usr/share/gufw/daemon',              ['gufw/daemon/gufw_daemon.py']) ]



# Create locale list
locales = []
for i in os.listdir("./mo/"):
    locales.append(i)
# Adding locales to data files:
for i in locales:
    locale = ("/usr/share/locale-langpack/%s/LC_MESSAGES/"%i,["mo/%s/LC_MESSAGES/gufw.mo"%i])
    data.append(locale)



# Setup stage
setup(
    name         = "Gufw",
    version      = "11.04.1",
    description  = "An easy, intuitive, way to manage your Linux firewall. It supports common tasks such as allowing or blocking pre-configured, common p2p, or individual ports port(s), and many others!",
    author       = "Marcos Alvarez Costales https://launchpad.net/~costales",
    author_email = "https://launchpad.net/~costales",
    url          = "http://gufw.tuxfamily.org",
    license      = "GPL3",
    packages     = ["doc"],
    data_files   = data
    )

