#!/usr/bin/env python

# Gufw 10.04.5 - http://gufw.tuxfamily.org
# Copyright (C) 2008-2010 Marcos Alvarez Costales <marcos@ubuntu-ast.org>
#
# Gufw is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
# 
# Gufw is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with Gufw; if not, see http://www.gnu.org/licenses for more
# information.

import sys, os
assert sys.version >= '2', "Install Python 2.0 or greater"
from distutils.core import setup, Extension
import glob


# Create data files
data = [ ('/usr/share/applications',             ['Alacarte_menu/gufw.desktop']),
         ('/usr/share/gufw/glade',               glob.glob("src/glade/*.*")),                
         ('/usr/bin',                            ['global_command/gufw']),      
         ('/usr/share/icons/hicolor/48x48/apps', glob.glob("icon/*.*")),         
         ('/usr/share/man/man8',                 ['man_page/gufw.8.gz']),             
         ('/usr/share/gufw/model',               glob.glob("src/model/*.*")),                
         ('/usr/share/pixmaps/gufw',             glob.glob("pixmaps/*.png")),            
         ('/usr/share/gufw/view',                glob.glob("src/view/*.*")),                 
         ('/usr/share/gufw',                     glob.glob("src/*.py")) ]



# Create locale list
locales = []
for i in os.listdir("./locale-langpack/"):
    locales.append(i)
# Adding locales to data files:
for i in locales:
    locale = ("/usr/share/locale-langpack/%s/LC_MESSAGES/"%i,["locale-langpack/%s/LC_MESSAGES/gufw.mo"%i])
    data.append(locale)



# Setup stage
setup(
    name         = "Gufw",
    version      = "10.04.5",
    description  = "An easy, intuitive, way to manage your Linux firewall. It supports common tasks such as allowing or blocking pre-configured, common p2p, or individual ports port(s), and many others!",
    author       = "Marcos Alvarez Costales <marcos@ubuntu-ast.org>",
    author_email = "<marcos@ubuntu-ast.org>",
    url          = "http://gufw.tuxfamily.org",
    license      = "GPL3",
    packages     = ["doc"],
    data_files   = data
    )

