#ifndef PEER_SCANNER_H
#define PEER_SCANNER_H

/*
 * Scan for the existance of a specific peer using fake ARP requests
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 * Originally based on laptop-netconf.c by Matt Kern <matt@debian.org>
 * Which in turn was nased on divine.c by Felix von Leitner <felix@fefe.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "Mutex.h"
#include "Scanner.h"
#include "NetWatcher.h"
#include "NetSender.h"
#include "nettypes.h"

#include <list>

class NetWatcher;

class PeerScanner : public Scanner, public PacketListener
{
protected:
	Mutex candMutex;

	NetSender sender;

	std::list<const PeerScan*> candidates;

public: 
	PeerScanner(NetSender sender, ScannerListener* listener) throw ()
		: Scanner(listener), sender(sender) {}
	virtual ~PeerScanner() throw () {}

	virtual void handleEthernet(const NetBuffer& arp) throw ();
	virtual void handleARP(const NetBuffer& arp) throw ();
	
	void addCandidate(const PeerScan* scan) throw ();

	void registerWith(NetWatcher& watcher) throw ();
};

// vim:set ts=4 sw=4:
#endif
