using System;
using System.IO;
using System.Diagnostics;
using Gtk;
using GConf;
using Gnome;
using Mono.Unix;

namespace gtwitter
{
	
	public partial class PreferencesWindow : Gtk.Dialog
	{
		public PreferencesWindow()
		{
			this.Build();
			
			//read from gconf
			UpdateFromGConf();
			MainWindow.client.AddNotify (MainWindow.GCONF_APP_PATH, new NotifyEventHandler (GConf_Changed));
			
			//notifications | sensitivity
			//notifications toggled event
			EnableNotifyCheckButton.Toggled += new EventHandler(this.EnableNotifyCheckButtonToggled);
			
			if (EnableNotifyCheckButton.Active == true)
			{
				NotifyOnDirect.Sensitive = true;
				NotifyOnPublicFriends.Sensitive = true;
				NotifyOnBoth.Sensitive = true;
			}
			
		}
		
		//gconf update
		void UpdateFromGConf () {
			
			try {
				
				SourceCombobox.Active = (int) MainWindow.client.Get (MainWindow.SOURCE_KEY);
				
				UsernameEntry.Text = (string) MainWindow.client.Get (MainWindow.USERNAME_KEY);
				PasswordEntry.Text = (string) MainWindow.client.Get (MainWindow.PASSWORD_KEY);
				
				RefreshCombobox.Active = (int) MainWindow.client.Get (MainWindow.REFRESH_KEY);
				
				HiddenCheckbutton.Active = (bool) MainWindow.client.Get (MainWindow.HIDDEN_KEY);
				
				//Notification options
				EnableNotifyCheckButton.Active = (bool) MainWindow.client.Get (MainWindow.NOTIFY_KEY);
				NotifyOnDirect.Active = (bool) MainWindow.client.Get (MainWindow.NOTIFY_DIRECT_KEY);
				NotifyOnPublicFriends.Active = (bool) MainWindow.client.Get (MainWindow.NOTIFY_PUBFRIE_KEY);
				NotifyOnBoth.Active = (bool) MainWindow.client.Get (MainWindow.NOTIFY_ALL_KEY);
			}
			catch (Exception ex)
			{
				if (MainClass.debug) {
					Console.WriteLine("Preferences Window GConf exception: PreferencesWindow.cs - UpdateFromGConf()");
					Console.WriteLine(ex.StackTrace);
				}
			}
			
		}
		public void GConf_Changed (object sender, NotifyEventArgs args) {
			
			UpdateFromGConf();
		}
		
		//ok button
		protected virtual void OnOkButtonClicked(object sender, System.EventArgs e)
		{
			MainWindow.client.Set (MainWindow.SOURCE_KEY, SourceCombobox.Active);
			
			MainWindow.client.Set (MainWindow.USERNAME_KEY, UsernameEntry.Text);
			MainWindow.client.Set (MainWindow.PASSWORD_KEY, PasswordEntry.Text);
			
			MainWindow.client.Set (MainWindow.REFRESH_KEY, RefreshCombobox.Active);
			
			MainWindow.client.Set (MainWindow.HIDDEN_KEY, HiddenCheckbutton.Active);
			
			//notifications
			MainWindow.client.Set (MainWindow.NOTIFY_KEY, EnableNotifyCheckButton.Active);
			MainWindow.client.Set (MainWindow.NOTIFY_DIRECT_KEY, NotifyOnDirect.Active);
			MainWindow.client.Set (MainWindow.NOTIFY_PUBFRIE_KEY, NotifyOnPublicFriends.Active);
			MainWindow.client.Set (MainWindow.NOTIFY_ALL_KEY, NotifyOnBoth.Active);
			
			ClearCacheLabel.Text = "";

			this.Hide();
		}
		
		protected virtual void OnDeleteEvent(object o, Gtk.DeleteEventArgs args)
		{
			ClearCacheLabel.Text = "";
			
			this.Hide();
			args.RetVal = true;
		}

		protected virtual void OnClearCacheButtonClicked(object sender, System.EventArgs e)
		{
			Directory.Delete(gtwitter.MainWindow.configDir + "images/", true);
			
			Directory.CreateDirectory(gtwitter.MainWindow.configDir + "images");
			
			ClearCacheLabel.Text = Catalog.GetString("Done!");
		}

		// call the GNOME Default browser to open the Twitter.com signup url
		protected virtual void OnSignUpClicked(object sender, System.EventArgs e)
		{
			Gnome.Url.Show ("http://twitter.com/signup");
		}
		
		//Toggle notifications event
		protected virtual void EnableNotifyCheckButtonToggled(object sender, System.EventArgs e)
		{
			if(EnableNotifyCheckButton.Active == true)
			{
				MainWindow.client.Set (MainWindow.NOTIFY_KEY, EnableNotifyCheckButton.Active);
				
				NotifyOnDirect.Sensitive = true;
				NotifyOnPublicFriends.Sensitive = true;
				NotifyOnBoth.Sensitive = true;
			}
			else
			{
				MainWindow.client.Set (MainWindow.NOTIFY_KEY, EnableNotifyCheckButton.Active);
				
				NotifyOnDirect.Sensitive = false;
				NotifyOnPublicFriends.Sensitive = false;
				NotifyOnBoth.Sensitive = false;
			}
		}

	}
}

//ghaefb