#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include "main.h"
#include "tray-icon.h"
void about_window();
void stock_icons();
void gconf_set_hide_due();
void gconf_set_hide_nodate();
void gconf_set_hide_done();
void sorting_order_callback(GtkWidget *widget, int data, GtkWidget *wid2);
gulong shand;
GdkEventMotion *ovent;
void sorting_callback(GtkWidget *widget, int data, GtkWidget *wid2);
void windows_moved(GtkWidget *window);

	static char *
item_factory_translate_func (const char *path, gpointer func_data)
{
	return _(path);
}

static GtkItemFactoryEntry menu_items[] =
{
	{ N_("/_ToDo"),					NULL,			0,		0,		"<Branch>" },
	{ N_("/ToDo/_New Task List"),			"<control>n",	create_playlist,		0,		"<StockItem>",GTK_STOCK_NEW},
	{ N_("/ToDo/_Open Task List"),			"<control>o",	open_playlist,		0,		"<StockItem>",GTK_STOCK_OPEN},
	{ N_("/ToDo/_Export to"), 			NULL,		0,		0,		"<Branch>"},
	{ N_("/ToDo/Export to/html"),			"",	export_gui,		0,		"<StockItem>",GTK_STOCK_SAVE},
	{ N_("/ToDo/Export to/task list"),			"",	export_backup_xml,		0,		"<StockItem>",GTK_STOCK_SAVE},
	{ "/ToDo/Sep0",					0,			0,		0,"<Separator>",	0},
	{ N_("/ToDo/_Hide or Show Window"), 		"<control>h",		tray_hide_show_window,		0,		"<StockItem>", GTK_STOCK_CONVERT },
	{ "/ToDo/Sep1",					0,			0,		0,"<Separator>",	0},
	{ N_("/ToDo/_Preferences"),			"<control>p",	gui_preferences,		0,		"<StockItem>",GTK_STOCK_PREFERENCES},
	{ N_("/ToDo/_Edit Categories"),		"<control>e",	category_manager,		0,"<StockItem>", "gtodo-edit"},
	{ "/ToDo/Sep1",					0,			0,		0,"<Separator>",	0},
	{ N_("/ToDo/_Quit"),				"<control>q",	quit_program,			0,"<StockItem>",	GTK_STOCK_QUIT},
	{ N_("/_Item"),					NULL,			0,		0,"<Branch>"},
	{ N_("/Item/_Add"),			"<alt>a",		gui_add_todo_item, (int)GINT_TO_POINTER(0), 	"<StockItem>", GTK_STOCK_ADD},
	{ N_("/Item/_Edit"),				"<alt>e",	gui_add_todo_item, (int)GINT_TO_POINTER(1), 	"<StockItem>", "gtodo-edit"},  
	{ N_("/Item/_Remove"),			"<alt>r",	remove_todo_item,		FALSE,		"<StockItem>",	GTK_STOCK_REMOVE},  
	{ N_("/Item/Remove _Completed Items"),		NULL,	purge_category,		0,	0},
	{ N_("/_View"),					NULL,	0,			0,	"<Branch>"},
	{ N_("/_View/_Sorting"),				NULL,	0,			0,	"<Branch>"},
	{ N_("/View/Sorting/Done, Date, Priority"),		NULL,	sorting_callback,	0, 	"<RadioItem>", 0},
	{ N_("/View/Sorting/Done, Priority, Date"),		NULL,	sorting_callback,	1, 	N_("/View/Sorting/Done, Date, Priority"),0},
	{ N_("/View/Sorting/Priority, Date, Done"),		NULL,	sorting_callback,	2, 	N_("/View/Sorting/Done, Date, Priority"),0},
	{ N_("/View/Sorting/Priority, Done, Date"),		NULL,	sorting_callback,	3, 	N_("/View/Sorting/Done, Date, Priority"),0},
	{ N_("/View/Sorting/Date, Priority, Done"),		NULL,	sorting_callback,	4, 	N_("/View/Sorting/Done, Date, Priority"),0},
	{ N_("/View/Sorting/Date, Done, Priority"),		NULL,	sorting_callback,	5, 	N_("/View/Sorting/Done, Date, Priority"),0},
	{ "/View/Sorting/Sepsort",				0,			0,	0,	"<Separator>",	0},
	{ N_("/View/Sorting/Sort Ascending"),			NULL,	sorting_order_callback,	0,	"<RadioItem>",0},  
	{ N_("/View/Sorting/Sort Descending"),		NULL,	NULL,		 	0,	N_("/View/Sorting/Sort Ascending"),0},    
	{ N_("/View/Hide Completed Items"),			NULL,	gconf_set_hide_done,	0, 	"<ToggleItem>", 0},
	{ N_("/View/Hide Items that Are Past Due Date"),		NULL,	gconf_set_hide_due,	0, 	"<ToggleItem>", 0},
	{ N_("/View/Hide Items Without an End Date"),	NULL,	gconf_set_hide_nodate,		0, 	"<ToggleItem>", 0},
	{ N_("/_Help"),					NULL,			0,	0,	"<Branch>"},
	{ N_("/Help/_About"),				NULL,			about_window,		0, "<StockItem>", "gnome-stock-about"},
};

static int nmenu_items = sizeof (menu_items) / sizeof (menu_items[0]);

/* the main window struct */
mwindow mw;    

void gui_create_main_window(){
	GtkTreeViewColumn  *column;
	GtkCellRenderer *renderer;
	GtkWidget *lb, *hbox;
	static GtkWidget  *sw;
	/* used for the buttons @ the bottom */
	GtkSizeGroup *sgroup;
	GtkIconSet *set;
	GdkPixbuf *pixbuf;
	/* TODO: make this compile time  (path is now)*/
	stock_icons();

	set = gtk_icon_factory_lookup_default("gtodo");

	mw.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(mw.window), _("Todo List"));
	gtk_window_set_default_size(GTK_WINDOW(mw.window), 200, 400);

	pixbuf = gtk_icon_set_render_icon(set, mw.window->style, GTK_TEXT_DIR_NONE, GTK_STATE_NORMAL, GTK_ICON_SIZE_LARGE_TOOLBAR, mw.window, NULL);
	gtk_window_set_icon(GTK_WINDOW(mw.window), pixbuf);
	g_object_unref(pixbuf);

	/* add an verticall box */
	mw.vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(mw.window), mw.vbox);

	/* drop down menu's */
	mw.accel_group = gtk_accel_group_new();
	mw.item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", mw.accel_group);
	g_object_set_data_full (G_OBJECT (mw.window), "<main>", mw.item_factory, (GDestroyNotify) g_object_unref);
	gtk_item_factory_set_translate_func(mw.item_factory, item_factory_translate_func,
			NULL, NULL);
	gtk_item_factory_create_items (mw.item_factory, nmenu_items, menu_items, NULL);


	gtk_box_pack_start(GTK_BOX(mw.vbox), gtk_item_factory_get_widget(mw.item_factory, "<main>"), FALSE, TRUE, 0);    

	/* add a Hbuttonbox (droby) with a category selector and a new/delete button */

	mw.toolbar = gtk_hbox_new(FALSE, 6);    
	gtk_box_pack_end(GTK_BOX(mw.vbox), mw.toolbar, FALSE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(mw.toolbar), 6);



	/* add drop down menu's */
	mw.option = gtk_option_menu_new();
	mw.menu = gtk_menu_new();
	gtk_widget_set_usize(mw.option, 120 , -1);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(mw.option), mw.menu);
	gtk_box_pack_start(GTK_BOX(mw.toolbar), mw.option, TRUE, TRUE, 0); 

	gtk_menu_shell_insert (GTK_MENU_SHELL (mw.menu), gtk_menu_item_new_with_label (_("All")), 0);
	gtk_menu_shell_insert (GTK_MENU_SHELL (mw.menu), gtk_separator_menu_item_new(), 1);
	mw.mitems = g_malloc(1*sizeof(GtkWidget *));
	mw.mitems[0] = NULL;
	/* shand can be removed?? */
	shand = g_signal_connect(G_OBJECT(mw.option), "changed", G_CALLBACK(category_changed), NULL);

	/* the buttonbox buttons */
	/* set the button's same size */ 
	sgroup = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
	/*buttons */
	mw.tbaddbut = gtk_button_new_from_stock(GTK_STOCK_ADD);
	mw.tbdelbut = gtk_button_new_from_stock(GTK_STOCK_REMOVE);
	mw.tbeditbut = gtk_button_new();
	hbox = gtk_hbox_new(FALSE, 6);
	lb = gtk_alignment_new(0.5,0.5,0,0);
	gtk_container_add(GTK_CONTAINER(lb), hbox);
	gtk_container_add(GTK_CONTAINER(mw.tbeditbut), lb);


	lb = gtk_image_new_from_stock("gtodo-edit", GTK_ICON_SIZE_BUTTON);
	gtk_box_pack_start(GTK_BOX(hbox), lb, FALSE, TRUE, 0);
	mw.tbeditlb = gtk_label_new_with_mnemonic(_("_Edit"));
	gtk_box_pack_start(GTK_BOX(hbox), mw.tbeditlb, FALSE, TRUE,0);


	/* add them */
	gtk_box_pack_end(GTK_BOX(mw.toolbar), mw.tbaddbut, FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(mw.toolbar), mw.tbdelbut, FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(mw.toolbar), mw.tbeditbut, FALSE, FALSE, 0);
	gtk_size_group_add_widget(sgroup, mw.tbaddbut);
	gtk_size_group_add_widget(sgroup, mw.tbeditbut);
	gtk_size_group_add_widget(sgroup, mw.tbdelbut);

	/* signals */
	g_signal_connect(G_OBJECT(mw.tbaddbut), "clicked", G_CALLBACK(gui_add_todo_item), GINT_TO_POINTER(0));
	g_signal_connect(G_OBJECT(mw.tbeditbut), "clicked", G_CALLBACK(gui_add_todo_item), GINT_TO_POINTER(1));
	g_signal_connect(G_OBJECT(mw.tbdelbut), "clicked", G_CALLBACK(remove_todo_item), FALSE);


	/* add the todo list */
	mw.list = gtk_list_store_new(N_COL, G_TYPE_UINT64, G_TYPE_INT,G_TYPE_STRING, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT64, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT64, G_TYPE_UINT64, G_TYPE_BOOLEAN);
	mw.sortmodel = gtk_tree_model_sort_new_with_model(GTK_TREE_MODEL(mw.list));
	mw.treeview = gtk_tree_view_new_with_model(GTK_TREE_MODEL(mw.sortmodel));

	sw = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(sw), GTK_SHADOW_ETCHED_IN);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
	gtk_container_add(GTK_CONTAINER(sw), mw.treeview);

	gtk_box_pack_start(GTK_BOX(mw.vbox), sw, TRUE, TRUE, 0);
	gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(mw.treeview), TRUE);

	/* add the columns to the list */
	renderer =  gtk_cell_renderer_toggle_new();
	column = gtk_tree_view_column_new_with_attributes("", renderer, "active",DONE,"activatable", EDITABLE, NULL);
	g_signal_connect(renderer, "toggled", G_CALLBACK(list_toggled_done), NULL);    
	gtk_tree_view_append_column(GTK_TREE_VIEW(mw.treeview), column);    

	renderer =  gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(_("Priority"), renderer, "text" , PRIOSTR,"strikethrough", DONE, "foreground-set", DUE,"foreground", COLOR,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(mw.treeview), column);    
	if(!gconf_client_get_bool(client, "/apps/gtodo/view/show-priority-column",NULL)) gtk_tree_view_column_set_visible(column, FALSE);



	
	renderer =  gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(_("Due date"), renderer, "text" , F_DATE,"strikethrough", DONE, "foreground-set", DUE,"foreground", COLOR,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(mw.treeview), column);    
	if(!gconf_client_get_bool(client, "/apps/gtodo/prefs/show-due-column",NULL)) gtk_tree_view_column_set_visible(column, FALSE);

	renderer =  gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(_("Category"), renderer, "text" , CATEGORY,"strikethrough", DONE, "foreground-set", DUE,"foreground", COLOR,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(mw.treeview), column);    
	if(!gconf_client_get_bool(client, "/apps/gtodo/view/show-category-column",NULL)) gtk_tree_view_column_set_visible(column, FALSE);

	renderer =  gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes(_("Summary"), renderer, "markup",SUMMARY,"strikethrough", DONE, "foreground-set", DUE,"foreground", COLOR,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(mw.treeview), column);    

	gtk_tree_sortable_set_sort_func((GtkTreeSortable *)mw.sortmodel,0, (GtkTreeIterCompareFunc)sort_function_test, NULL, NULL);
	gtk_tree_sortable_set_sort_column_id((GtkTreeSortable *)mw.sortmodel,0, settings.sortorder);	    

	gtk_tree_view_column_set_fixed_width(column, 10);
	gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_FIXED);	

	/* handlers */
	g_signal_connect(G_OBJECT(mw.treeview), "motion-notify-event", G_CALLBACK(mw_motion_cb), NULL);
	g_signal_connect(G_OBJECT(mw.treeview), "leave-notify-event", G_CALLBACK(mw_leave_cb), NULL);


	g_signal_connect(G_OBJECT (mw.treeview), "row-activated", G_CALLBACK (gui_add_todo_item), GINT_TO_POINTER(1));
	g_signal_connect(mw.window, "delete-event", G_CALLBACK(quit_program), NULL);
	g_signal_connect(mw.window, "destroy-event", G_CALLBACK(quit_program), NULL);
	gtk_window_add_accel_group(GTK_WINDOW(mw.window), mw.accel_group);

	gtk_check_menu_item_set_active((GtkCheckMenuItem *)gtk_item_factory_get_widget(mw.item_factory, N_("/View/Hide Completed Items")),settings.hide_done);
	gtk_check_menu_item_set_active((GtkCheckMenuItem *)gtk_item_factory_get_widget(mw.item_factory, N_("/View/Hide Items that Are Past Due Date")),settings.hide_due);
	gtk_check_menu_item_set_active((GtkCheckMenuItem *)gtk_item_factory_get_widget(mw.item_factory, N_("/View/Hide Items Without an End Date")), settings.hide_nodate);

	if(settings.sortorder == 0)gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(mw.item_factory, N_("/View/Sorting/Sort Ascending"))), TRUE);		
	else gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(mw.item_factory, N_("/View/Sorting/Sort Descending"))), TRUE);		

	set_sorting_menu_item();
}

void about_window()
{
	GtkWidget *dialog, *label, *image, *vbox;
	gchar *buf;
	dialog = gtk_dialog_new_with_buttons(_("About gToDo"), GTK_WINDOW(mw.window), 
			GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, NULL);
	gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_CLOSE, GTK_RESPONSE_CANCEL);    

	vbox = gtk_vbox_new(FALSE, 0);
	image = gtk_image_new_from_stock("gtodo", GTK_ICON_SIZE_DIALOG);
	gtk_box_pack_start(GTK_BOX(vbox), image,FALSE, FALSE, 6);

	buf = g_strdup_printf(_("gToDo %s"),VERSION);
	label = gtk_label_new(buf);
	g_free(buf);

	buf =  g_strdup_printf(_("<span size=\"xx-large\"><b>gToDo %s</b></span>"),VERSION);
	gtk_label_set_markup(GTK_LABEL(label),buf);
	g_free(buf);
	gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 6);


	label = gtk_label_new(_("gToDo is a small and simple todo list written in gtk+-2.0"));
	gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 6);


	label = gtk_label_new(_("Copyright © 2003-2004 Qball Cow (Qball@qball.homelinux.org)"));
	gtk_label_set_markup(GTK_LABEL(label), _("<span size=\"small\">""Copyright © 2003-2004 Qball Cow (Qball@qball.homelinux.org)""</span>"));
	gtk_box_pack_start(GTK_BOX(vbox), label,FALSE, FALSE, 6);




	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 6);
	gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(dialog)), 6);


	gtk_dialog_set_has_separator(GTK_DIALOG(dialog), FALSE);
	gtk_widget_show_all(dialog);
	gtk_dialog_run(GTK_DIALOG(dialog));    
	gtk_widget_destroy(dialog);
}









void stock_icons()
{
	GtkIconFactory *factory;
	GtkIconSet *icons;
	GtkIconSource *icon_source;

	/* testing icon factory.. hope it works a little */
	factory = gtk_icon_factory_new();
	/* random icon */
	icons = gtk_icon_set_new();
	icon_source = gtk_icon_source_new();
	gtk_icon_source_set_filename(icon_source, PIXMAP_PATH"/gtodo-edit.png");
	gtk_icon_set_add_source(icons, icon_source);
	gtk_icon_factory_add(factory, "gtodo-edit", icons);

	icons = gtk_icon_set_new();
	icon_source = gtk_icon_source_new();
	gtk_icon_source_set_filename(icon_source, PIXMAP_PATH"/gtodo.png");
	gtk_icon_set_add_source(icons, icon_source);
	gtk_icon_factory_add(factory, "gtodo", icons);

	icons = gtk_icon_set_new();
	icon_source = gtk_icon_source_new();
	gtk_icon_source_set_filename(icon_source, PIXMAP_PATH"/gtodo_tray.png");
	gtk_icon_set_add_source(icons, icon_source);
	gtk_icon_factory_add(factory, "gtodo-tray", icons);

	/* added this because there isn no about availible in the default stock set. */
	/* I call it gnome about so it still uses the one out off the current icon theme */
	icons = gtk_icon_set_new();
	icon_source = gtk_icon_source_new();
	gtk_icon_source_set_filename(icon_source, PIXMAP_PATH"/gtodo-about.png");
	gtk_icon_set_add_source(icons, icon_source);
	gtk_icon_factory_add(factory, "gnome-stock-about", icons);
	gtk_icon_factory_add_default (factory);

}

void gconf_set_hide_done()
{
	/*    settings.hide_done = gtk_check_menu_item_get_active((GtkCheckMenuItem *)gtk_item_factory_get_widget(mw.item_factory, N_("/View/Todo List/Hide Completed Items")));*/
	settings.hide_done = gtk_check_menu_item_get_active((GtkCheckMenuItem *)gtk_item_factory_get_widget(mw.item_factory, N_("/View/Hide Completed Items")));
	gconf_client_set_bool(client, "/apps/gtodo/prefs/hide-done",settings.hide_done,NULL);
}
void gconf_set_hide_nodate()
{
	settings.hide_nodate =    gtk_check_menu_item_get_active((GtkCheckMenuItem *)gtk_item_factory_get_widget(mw.item_factory, N_("/View/Hide Items Without an End Date")));
	gconf_client_set_bool(client, "/apps/gtodo/prefs/hide-nodate",settings.hide_nodate,NULL);
}
void gconf_set_hide_due()
{
	settings.hide_due =  gtk_check_menu_item_get_active((GtkCheckMenuItem *)gtk_item_factory_get_widget(mw.item_factory, N_("/View/Hide Items that Are Past Due Date")));
	gconf_client_set_bool(client, "/apps/gtodo/prefs/hide-due",settings.hide_due,NULL);
}

void set_sorting_menu_item()
{
	int i = gconf_client_get_int(client, "/apps/gtodo/prefs/sort-type",NULL);
	if(i == 0)
	{
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(mw.item_factory, N_("/View/Sorting/Done, Date, Priority"))), TRUE);
	}
	else if (i==1)
	{
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(mw.item_factory, N_("/View/Sorting/Done, Priority, Date"))), TRUE);	
	}
	else if(i==2)
	{
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(mw.item_factory, N_("/View/Sorting/Priority, Date, Done"))), TRUE);		
	}
	else if(i==3)
	{
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(mw.item_factory, N_("/View/Sorting/Priority, Done, Date"))), TRUE);		
	}    
	else if(i==4)
	{
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(mw.item_factory, N_("/View/Sorting/Date, Priority, Done"))), TRUE);		
	}
	else if(i==5)
	{
		gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(mw.item_factory, N_("/View/Sorting/Date, Done, Priority"))), TRUE);		
	}    
}

void sorting_order_callback(GtkWidget *widget, int data, GtkWidget *wid2)
{
	settings.sortorder = !gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(wid2));
	gconf_client_set_int(client, "/apps/gtodo/prefs/sort-order",settings.sortorder,NULL);
	gtk_tree_sortable_set_sort_column_id((GtkTreeSortable *)mw.sortmodel,0, settings.sortorder);	    
}

void sorting_callback(GtkWidget *widget, int data, GtkWidget *wid2)
{
	if(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(wid2)))
	{
		settings.sorttype = data;
		gconf_client_set_int(client, "/apps/gtodo/prefs/sort-type",data,NULL);
		gtk_tree_sortable_set_sort_column_id((GtkTreeSortable *)gtk_tree_view_get_model(GTK_TREE_VIEW(mw.treeview)),0, settings.sortorder);
		category_changed();
	}
}

void windows_moved(GtkWidget *window)
{
	gint width, height;
	gint x, y;
	gtk_window_get_size(GTK_WINDOW(window), &width, &height);
	gtk_window_get_position(GTK_WINDOW(window), &x, &y);
	gconf_client_set_int(client, "/apps/gtodo/prefs/pos-x",x,NULL);
	gconf_client_set_int(client, "/apps/gtodo/prefs/pos-y",y,NULL);
	gconf_client_set_int(client, "/apps/gtodo/prefs/size-x",width,NULL);
	gconf_client_set_int(client, "/apps/gtodo/prefs/size-y",height,NULL);
}
