/* Track definition for Track editor and writing services */

#ifndef TRACKS_H
# define TRACKS_H

# include <glib.h>

extern char *tracks_tracktypedefinitions[];
extern int   tracks_tracktypesectorsizes[];

/* find out about a tracktype with those functions */
# define tracks_sectorsize(tt) tracks_tracktypesectorsizes[tracks_tracktypeid(tt)]
/* get tracktype id,used mainly by defines above */
int tracks_tracktypeid(char *tt);

typedef char *tracks_tracktype;

typedef enum
{
   none,atwrite,atadd
}
tracks_precache;

typedef struct
{
   char  name[256]; /* a name describing the track, for display in the GUI */
   
   char  title[256];
   char  performer[256];

   void  *data;
   tracks_tracktype tracktype;
   tracks_precache  precacherequired; /* specifies what kind of precaching is required */
   int   users; /* how many parts of Gnome toaster (e.g. tracklists etc.) do currently use this track ? */
   GList *updatehandlers; /* functions wanting to stay
			   * informed about tracksize changes
			   * The callback list is handled by
			   * updatehandlers.c and does not have
			   * any support within tracks.c except that
			   * updatehandlers is initialized with NULL
			   * in tracks_create(). */
   int  (*openpipe) (void*);
   void (*closepipe) (void*);
   int  (*tracksize) (void*);
   int  (*dataavail) (void*);
   int  (*valid) (void*);
   void (*destroy) (void*);
}
tracks_trackinfo;

/* tracks_create creates a track with the following parameters,
 * this is a lowlevel function,usually tracks are created by referencing
 * their respective constructors.
 * users is set to one,so the creating function should call unclaim()
 * if the track is no more used by the caller */
tracks_trackinfo  *tracks_create(char *name,
				 
				 const char *title,
				 const char *performer,
				 
				 tracks_tracktype,
				 tracks_precache,
				 int  (*openpipe)(void*),
				 void (*closepipe)(void*),
				 int  (*tracksize)(void*),
				 int  (*dataavail)(void*),
				 int  (*valid)(void*),
				 void (*destroy)(void*),
				 void *data);
int   tracks_openpipe(tracks_trackinfo*);
void  tracks_closepipe(tracks_trackinfo*);
int   tracks_tracksize(tracks_trackinfo*);
/* as all possible tracks on a cdrom are a really just audiotracks
 * with an additional highlevel protocol,
 * all tracksizes can be represented as audiotrack sizes,
 * it all depends on how many bytes of a sector can actually be used
 * for data storage */
int   tracks_audiotracksize(tracks_trackinfo*);
int   tracks_dataavail(tracks_trackinfo*);
int   tracks_valid(tracks_trackinfo*);
/* return by how many "users" a track is currently used */
int   tracks_users(tracks_trackinfo*);
void  tracks_claim(tracks_trackinfo*);
void  tracks_unclaim(tracks_trackinfo*);

#endif // TRACKS_H
