/*
 *  Copyright (C) 1999-2002 Bruno Pires Marinho
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _FILE_LIST_H
#define _FILE_LIST_H

#include "gtm.h"

void file_list_menu_popup_set_state (GtkCList *file_list);

GtkWidget *file_list_create (void);

void file_list_set_row_state (GtkCList *file_list, gint row, DlState state);

void file_list_set_row_statistics (GtkCList *file_list, gint row,
                                   FileData *file_data);

gint file_list_find_url (GtkCList *file_list, gchar *url);

gint file_list_single_add (GtkCList *file_list, FileData *file_data);

gboolean file_list_bulk_add (GtkCList *file_list, FileData **file_data,
                             gint total_files, gboolean list_load);

void file_list_remove_selection (GtkCList *file_list, gboolean completed,
                                 gboolean incomplete);

void file_list_drop_selection (GtkCList *file_list, gboolean completed,
		               gboolean incomplete);

void file_list_remove_file (GtkCList *file_list, FileData *file_data);

void file_list_drop_file (GtkCList *file_list, FileData *file_data);

void file_list_load_data (GtkCList *file_list);

void file_list_func_on_selection (GtkCList *file_list,
                                  void (*func) (FileData *file_data));

void file_list_start_auto_downloads (GtkCList *file_list);

void file_list_stop_auto_downloads (GtkCList *file_list);

gboolean file_list_has_pending_work (GtkCList *file_list);

void file_list_select_all (GtkCList *file_list);

void file_list_unselect_all (GtkCList *file_list);

void file_list_update_statistics (GtkCList *file_list);

FileData *file_list_get_unique_selection (GtkCList *file_list);

/* structure to pass list stats */
typedef struct
{
    guint32 num_unstarted;
    guint32 num_stopped;
    guint32 num_running;
    guint32 num_completed;
    
    guint32 size_stopped;
    guint32 size_running;
    guint32 size_completed;
    
    guint32 retrieved_stopped;
    guint32 retrieved_running;
} FileListStats;

/* result of attempting to add a file to the list */
typedef enum {
    ADD_OK,
    ADD_FAIL_DUPLICATE,
    ADD_FAIL_FILE_EXISTS
} AddResult;

#endif /* _FILE_LIST_H */
