#   File:       antlr68K.make
#   Target:     antlr68K
#   Sources:    ::support:set:set.c
#               antlr.c
#               bits.c
#               build.c
#               egman.c
#               err.c
#               fcache.c
#               fset2.c
#               fset.c
#               gen.c
#               globals.c
#               hash.c
#               lex.c
#               main.c
#               misc.c
#               mrhoist.c
#               pred.c
#               scan.c
#   Created:    Sunday, May 17, 1998 10:12:02 PM
#	Author:		Kenji Tanaka


MAKEFILE     = antlr68K.make
MondoBuild = {MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified
Includes     = 
		-i "::h:" 
		-i "::support:set:"
Sym68K      = 
ObjDir68K   = :Obj:

COptions     = {Includes} {Sym68K} -model far -w off  -d MPW -d __STDC__=1 -d USER_ZZSYN

Objects68K  = 
		"{ObjDir68K}set.c.o" 
		"{ObjDir68K}antlr.c.o" 
		"{ObjDir68K}bits.c.o" 
		"{ObjDir68K}build.c.o" 
		"{ObjDir68K}egman.c.o" 
		"{ObjDir68K}err.c.o" 
		"{ObjDir68K}fcache.c.o" 
		"{ObjDir68K}fset2.c.o" 
		"{ObjDir68K}fset.c.o" 
		"{ObjDir68K}gen.c.o" 
		"{ObjDir68K}globals.c.o" 
		"{ObjDir68K}hash.c.o" 
		"{ObjDir68K}lex.c.o" 
		"{ObjDir68K}main.c.o" 
		"{ObjDir68K}misc.c.o" 
		"{ObjDir68K}mrhoist.c.o" 
		"{ObjDir68K}pred.c.o" 
		"{ObjDir68K}scan.c.o"


antlr68K  {MondoBuild} {Objects68K}
	Link 
		-o {Targ} -d {Sym68K} 
		{Objects68K} 
		-t 'MPST' 
		-c 'MPS ' 
		-mf 
		-model far 
		-br ON 
		-srtsg ALL 
		"{Libraries}Stubs.o" 
		#"{Libraries}MathLib.o" 
		#"{CLibraries}Complex.o" 
		"{CLibraries}StdCLib.o" 
		"{Libraries}MacRuntime.o" 
		"{Libraries}IntEnv.o" 
		"{Libraries}ToolLibs.o" 
		"{Libraries}Interface.o"


"{ObjDir68K}set.c.o"  {MondoBuild} "::support:set:set.c"
	{C} "::support:set:set.c" -o {Targ} {COptions}

"{ObjDir68K}antlr.c.o"  {MondoBuild} antlr.c
	{C} antlr.c -o {Targ} {COptions}

"{ObjDir68K}bits.c.o"  {MondoBuild} bits.c
	{C} bits.c -o {Targ} {COptions}

"{ObjDir68K}build.c.o"  {MondoBuild} build.c
	{C} build.c -o {Targ} {COptions}

"{ObjDir68K}egman.c.o"  {MondoBuild} egman.c
	{C} egman.c -o {Targ} {COptions}

"{ObjDir68K}err.c.o"  {MondoBuild} err.c
	{C} err.c -o {Targ} {COptions}

"{ObjDir68K}fcache.c.o"  {MondoBuild} fcache.c
	{C} fcache.c -o {Targ} {COptions}

"{ObjDir68K}fset2.c.o"  {MondoBuild} fset2.c
	{C} fset2.c -o {Targ} {COptions}

"{ObjDir68K}fset.c.o"  {MondoBuild} fset.c
	{C} fset.c -o {Targ} {COptions}

"{ObjDir68K}gen.c.o"  {MondoBuild} gen.c
	{C} gen.c -o {Targ} {COptions}

"{ObjDir68K}globals.c.o"  {MondoBuild} globals.c
	{C} globals.c -o {Targ} {COptions}

"{ObjDir68K}hash.c.o"  {MondoBuild} hash.c
	{C} hash.c -o {Targ} {COptions}

"{ObjDir68K}lex.c.o"  {MondoBuild} lex.c
	{C} lex.c -o {Targ} {COptions}

"{ObjDir68K}main.c.o"  {MondoBuild} main.c
	{C} main.c -o {Targ} {COptions}

"{ObjDir68K}misc.c.o"  {MondoBuild} misc.c
	{C} misc.c -o {Targ} {COptions}

"{ObjDir68K}mrhoist.c.o"  {MondoBuild} mrhoist.c
	{C} mrhoist.c -o {Targ} {COptions}

"{ObjDir68K}pred.c.o"  {MondoBuild} pred.c
	{C} pred.c -o {Targ} {COptions}

"{ObjDir68K}scan.c.o"  {MondoBuild} scan.c
	{C} scan.c -o {Targ} {COptions}


antlr68K  antlr.r
	Rez antlr.r -o antlr68K -a

Install   antlr68K
	Duplicate -y antlr68K "{MPW}"Tools:antlr
