/*
 *   Copyright (C) 2007-2008 Tristan Heaven <tristanheaven@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License along
 *   with this program; if not, write to the Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _HASH_H_
#define _HASH_H_

#include <stdbool.h>
#include <gtk/gtk.h>
#include <mhash.h>

#define HASH_N 27

// Supported hash functions
enum {
	MD2, MD4, MD5,
	SHA1, SHA224, SHA256, SHA384, SHA512,
	RIPEMD128, RIPEMD160, RIPEMD256, RIPEMD320,
	HAVAL128, HAVAL160, HAVAL192, HAVAL224, HAVAL256,
	TIGER128, TIGER160, TIGER192,
	GOST,
	WHIRLPOOL,
	SNEFRU128, SNEFRU256,
	CRC32, CRC32B,
	ADLER32,
};

struct hash_s {
	const hashid type; // mhash id
	const char *name;
	MHASH thread;
	GtkToggleButton *button;
	GtkLabel *label;
	GtkEntry *entry;
} hash[HASH_N];

bool hash_abort;

char *hash_string(const char *string, const int id);
bool hash_file(const char *filename);

#endif // _HASH_H_
