/* 
** gtklauncher.c: This program make it possible to write action driven 
** shell scripts. See the info pages for more information.
**
** copyright: (c) 2003 by László Pere
** email: pipas@linux.pte.hu
**
** This program is free software; you can redistribute it and/or 
** modify  it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of
** the License, or (at your option) any later version.
**
** $Id: gtklauncher.c,v 1.2 2004/11/16 20:52:15 root Exp root $ 
** $Log: gtklauncher.c,v $
** Revision 1.2  2004/11/16 20:52:15  root
** The copyright note inserted.
**
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char *argv[])
{
	char *commandline;
	if (argc == 1) {
		fprintf(stderr, "%s: Missing parameter.\n", argv[0]);
		exit(EXIT_FAILURE);
	}

	commandline = malloc(strlen(argv[1]) + 256);
	if (commandline == NULL) {
		fprintf(stderr, "%s: Insufficient memory.\n", argv[0]);
		exit(EXIT_FAILURE);
	}

	sprintf(commandline,
		"source %s; gtkdialog -i %s --program=MAIN_DIALOG",
		argv[1], argv[1]);

	return (system(commandline));
}
