/* 
** automaton.c: 
** copyright: (c) 2003 by Lszl Pere
** email: pipas@linux.pte.hu
** This program is free software; you can redistribute it and/or 
** modify  it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of
** the License, or (at your option) any later version.
*/
#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <regex.h>
#include "actions.h"
#include "gtkdialog.h"
#include "variables.h"

/* 
** This action will close a window. The program remain running.
** If we get a window's name, we close that if the name is null
** we close the widget's parent window.
FIXME: close by name
*/
int action_closewindow(GtkWidget * widget, char *string)
{
	GtkWidget *PWindow;
	variable *var;

	g_assert(string != NULL);
#ifdef DEBUG
	fprintf(stderr, "%s(): Closing: '%s'\n", __func__, string);
	fflush(stderr);
#endif

	if (strlen(string) != 0) {
		var = variables_get_by_name(string);
		if (var == NULL) {
			fprintf(stderr, "%s() Window '%s' not found.\n",
				__func__, string);
			fflush(stderr);
			return (-1);
		}
		//PWindow = var->Widget;
		variables_drop_by_parent(NULL, var->ParentWindow);
		gtk_widget_destroy(GTK_WIDGET(var->ParentWindow));
		return 0;
	}

	//  PWindow=gtk_widget_get_parent_window(widget);
//  variables_drop_by_parent( NULL, PWindow );
//  gdk_window_destroy( PWindow ); 
}

/*
** This action will launch a dialog box, a new window. It's a little
** bit tricky, because we have to exit the gtk main loop and call the
** parser to interpret new code.
*/
int action_launchwindow(GtkWidget * widget, char *string)
{
	variable *existing;
#ifdef DEBUG
	fprintf(stderr, "%s(): Window: %s.\n", __func__, string);
	fflush(stderr);
#endif
	/*
	 ** If the window is already opened, we give the focus to it and
	 ** will not open another instance.
	 */
	existing = variables_get_by_name(string);
	if (existing != NULL && existing->Widget != NULL) {
		gtk_window_present(GTK_WINDOW(existing->Widget));
		return (0);
	}

	/*
	 ** We read the window description from the environment variable.
	 */
	program_src = getenv(string);
	/*
	 ** If we could not find the window we give a message to the user and
	 ** exit.
	 */
	if (program_src == NULL) {
		fprintf(stderr, "%s(): Could not find window.\n",
			__func__);
		return (-1);
	}
	/*
	 ** We exit the gtk main loop to call the parser to interpret the
	 ** new code.
	 */
	variables_export_all();
	program_name = string;
	source = PRG_MEMORY;
	charsreaded = 0;
	gtk_main_quit();
	return (0);
}

int action_exitprogram(GtkWidget * widget, char *string)
{
	print_variables(NULL);
	printf("EXIT%s", string);
	gtk_main_quit();
	exit(EXIT_SUCCESS);
}

int action_refreshwidget(GtkWidget * widget, char *string)
{
	variables_refresh(string);
	return (0);
}

int action_savewidget(GtkWidget * widget, char *string)
{
	variables_save(string);
	return (0);
}

/*
** This function will create and open a fileselection dialog and
** connect it to the action_fileselection_made function to take
** the selected file name.
*/
int action_fileselect(GtkWidget * widget, char *string)
{
	actioncommand *ac;
	/*
	 ** We create a new actioncommand.
	 */
	ac = pip_malloc(sizeof(actioncommand), __func__);
	ac->source_widget = gtk_file_selection_new("gtkwindow");
	ac->destination_name = string;
	gtk_widget_show(ac->source_widget);

	/*
	 ** We connect the OK button in fileselection dialog
	 */
	g_signal_connect(G_OBJECT
			 (GTK_FILE_SELECTION(ac->source_widget)->
			  ok_button), "clicked",
			 G_CALLBACK(action_fileselection_made),
			 (gpointer) ac);
	/*
	 ** We connect the Cancel button in fileselection dialog
	 */
	g_signal_connect(G_OBJECT
			 (GTK_FILE_SELECTION(ac->source_widget)->
			  cancel_button), "clicked",
			 G_CALLBACK(action_fileselection_destroy),
			 (gpointer) ac);
	return;
}

/*
** This function is called, when the user pressed the OK button in
** a fileselection dialog.
*/
void action_fileselection_made(GtkWidget * w, actioncommand * ac)
{
	/*
	 ** Let's copy the selected file name to the destination widget.
	 */
	variables_set_value((const char *)ac->destination_name,
		gtk_file_selection_get_filename(GTK_FILE_SELECTION(ac->source_widget))
	    );
	/*
	 ** We destroy the fileselection dialog and free the actioncommand
	 ** memory.
	 */
	gtk_widget_destroy(ac->source_widget);
	free(ac);
}

/*
** This function is called, when the user pressed the Cancel button in
** a fileselection dialog.
*/
void action_fileselection_destroy(GtkWidget * w, actioncommand * ac)
{
	/*
	 ** We destroy the fileselection dialog and free the actioncommand
	 ** memory.
	 */
	gtk_widget_destroy(ac->source_widget);
	free(ac);
}


/*
** The action is about to remove all elements from the widget.
*/
int action_clearwidget(GtkWidget * widget, char *string)
{
	variables_clear(string);
	return (0);
}

/*
** This action is about to remove the selected element from a
** widget.
*/
int action_removeselected(GtkWidget * widget, char *string)
{
	remove_selected_variable(string);
	return 0;
}

int action_append(GtkWidget *widget, char * string){
	regex_t twoparams;
	regmatch_t matched[3];
	char *regular = "[ ]*([A-Za-z_]+),[ ]*([A-Za-z_]+)";
	char *from, *to;
	int length_from, length_to;
	
	g_assert(string != NULL);
	
	if (regcomp(&twoparams, regular, REG_EXTENDED) != 0){
		fprintf(stderr, "%s(): Internal error: %m\n",
				__func__);
		exit(EXIT_FAILURE);
	}

	if (regexec(&twoparams, string, 3, matched, 0) != 0) {
		yywarning("Insert action needs two parameters.");
		return FALSE;
	}
	
	length_from = matched[1].rm_eo - matched[1].rm_so;
	from = pip_malloc(length_from + 1, __func__);

	length_to = matched[2].rm_eo - matched[2].rm_so;
	to = pip_malloc(length_to + 1, __func__);

	strncpy(from, string, length_from);
	from[length_from] = '\0';

	strncpy(to, string + matched[2].rm_so, length_to);
	to[length_to] = '\0';

	return append_fromto_variable(from, to);

	// FIXME: I have a serious problem with memory allocation!
	//pip_free(from, __func__);
	//pip_free(to, __func__);
}

/*
*/
int action_enable(GtkWidget * widget, char *string)
{
	variables_enable(string);
	return (0);
}

/*
*/
int action_disable(GtkWidget * widget, char *string)
{
	variables_disable(string);
	return (0);
}


/*
** This fuction will export variables and run a shell command.
*/
int action_shellcommand(GtkWidget * widget, char *string)
{
	char *command;
	variables_export_all();

	if (includefile == NULL) {
		system(string);
		return (0);
	}

	command =
	    pip_malloc(strlen(string) + strlen(includefile) + 16,
		       __func__);
	sprintf(command, "source %s; %s", includefile, string);
	system(command);
	free(command);
	return;
}
