/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2010 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "config.h"

#include "global.h"
#include "interface.h"
#include "callback.h"
#include "game.h"
#include "main.h"
#include "client.h"
#include "display.h"

#include "engine.h"

#include "icon.xpm"


void interface_create_mainwindow()  {

	global->MainWin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(global->MainWin), "GtkAtlantic");
	gtk_window_set_policy(GTK_WINDOW(global->MainWin), FALSE, TRUE, TRUE);
	gtk_widget_set_usize(global->MainWin, 700, 500);

	gtk_signal_connect(GTK_OBJECT(global->MainWin), "delete-event", (GtkSignalFunc)Callback_Exit, NULL);
	gtk_signal_connect(GTK_OBJECT(global->MainWin), "destroy", (GtkSignalFunc)gtk_exit, NULL);

	global->MainBox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(global->MainWin), global->MainBox);

	/* icon */
	gtk_widget_realize(global->MainWin);
	global->icon_pixmap = gdk_pixmap_create_from_xpm_d(global->MainWin->window, &global->icon_mask, NULL, icon_xpm);
	gdk_window_set_icon(global->MainWin->window, NULL, global->icon_pixmap, global->icon_mask);

	/* used for reparent some widgets shouldn't be displayed */
	global->Trick = gtk_vbox_new(FALSE, 0);

	gtk_widget_show_all(global->MainWin);
}


void interface_create_menubar()  {

//	GtkWidget *HandleBar;
		GtkWidget *MenuBar;
			GtkWidget *Button;
				GtkWidget *Menu;
					GtkWidget *MenuItem;

//	HandleBar = gtk_handle_box_new();
//	gtk_box_pack_start(GTK_BOX(global->MainBox), HandleBar, FALSE, FALSE, 0);

	MenuBar = gtk_menu_bar_new();
//	gtk_container_add(GTK_CONTAINER(HandleBar), MenuBar);
	gtk_box_pack_start(GTK_BOX(global->MainBox), MenuBar, FALSE, FALSE, 0);

	/* GAME MENU */
	Button = gtk_menu_item_new_with_label("Game");

	gtk_menu_bar_append(GTK_MENU_BAR(MenuBar), Button);
//	gtk_signal_connect(GTK_OBJECT(Button), "activate", (GtkSignalFunc)CallBack, (gpointer)"Menu Game");

	Menu = gtk_menu_new();
	gtk_menu_set_title(GTK_MENU(Menu), "Game Menu");
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(Button), Menu);

	MenuItem = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("Change nickname");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_menu_change_nickname, NULL);

	MenuItem = gtk_menu_item_new_with_label("Show estates tree");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_estates_tree, NULL);

	MenuItem = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("(Un)dock Server messages");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_toggle_float_message, NULL);

	MenuItem = gtk_menu_item_new_with_label("(Un)dock Chat");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_toggle_float_chat, NULL);

	MenuItem = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("Declare bankrupcy");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_menu_DeclareBankrupcy, NULL);

	MenuItem = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("Reconnect (after client crash)");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_menu_reconnect, NULL);

	MenuItem = gtk_menu_item_new_with_label("Leave game (disconnect)");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_menu_LeaveGame, NULL);

	MenuItem = gtk_menu_item_new_with_label("Close all connections (except game)");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_menu_CloseAllConnections, NULL);

	MenuItem = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("Exit");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)Callback_Exit, NULL);

	/* CONFIG MENU */
	Button = gtk_menu_item_new_with_label("Settings");
	gtk_menu_bar_append(GTK_MENU_BAR(MenuBar), Button);

	Menu = gtk_menu_new();
	gtk_menu_set_title(GTK_MENU(Menu), "Settings Menu");
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(Button), Menu);

	MenuItem = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("Preferences");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)Callback_ShowConfiguration, NULL);

//	MenuItem = gtk_menu_item_new_with_label("Themes (unavailable yet)");
//	gtk_menu_append(GTK_MENU(Menu), MenuItem);
//	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)Callback_menu_Themes, NULL);

	/* HELP MENU */
	Button = gtk_menu_item_new_with_label("Help");
	gtk_menu_item_right_justify(GTK_MENU_ITEM(Button));

	gtk_menu_bar_append(GTK_MENU_BAR(MenuBar), Button);
//	gtk_signal_connect(GTK_OBJECT(Button), "activate", (GtkSignalFunc)CallBack, (gpointer)"Menu Help");

	Menu = gtk_menu_new();
	gtk_menu_set_title(GTK_MENU(Menu), "Help Menu");
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(Button), Menu);

	MenuItem = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(Menu), MenuItem);

	MenuItem = gtk_menu_item_new_with_label("Index");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)interface_create_helpwin, NULL);

	MenuItem = gtk_menu_item_new_with_label("About");
	gtk_menu_append(GTK_MENU(Menu), MenuItem);
	gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)interface_create_aboutwin, NULL);

//	gtk_widget_show_all(HandleBar);
	gtk_widget_show_all(MenuBar);
}


void interface_create_logo()  {

//global->MainBox
	//global->MainVerticalBox
		GtkWidget *FrameLogo;
			GtkWidget *AlignementLogo;
				//global->gdkrgb_logo
				//global->pixmap_logo
				//global->mask_logo
		GtkWidget *AlignementEnterButton;
			GtkWidget *EnterButton;

	guint32 frame, pic;

	GtkStyle *style;
	GdkColor gdk_color;
	guint32  bg_color;

	interface_unparent_message();
	interface_unparent_chat();

	global->phase = PHASE_LOGO;

	global->MainVerticalBox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(global->MainBox), global->MainVerticalBox, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(global->MainVerticalBox), "destroy", (GtkSignalFunc)CallBack_logo_page_destroyed, NULL);

	/* logo */
	AlignementLogo = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), AlignementLogo, TRUE, TRUE, 0);

	FrameLogo = gtk_frame_new(NULL);
	gtk_container_add(GTK_CONTAINER(AlignementLogo), FrameLogo);

	global->gdkrgb_logo = gtk_drawing_area_new();
	gtk_drawing_area_size( GTK_DRAWING_AREA (global->gdkrgb_logo), data->logo_width +20, data->logo_height +20);
	gtk_container_add(GTK_CONTAINER(FrameLogo), global->gdkrgb_logo);
	gtk_signal_connect (GTK_OBJECT ( global->gdkrgb_logo), "expose_event", GTK_SIGNAL_FUNC (on_logo_expose), NULL);

	/* enter button */
	AlignementEnterButton = gtk_alignment_new(0.9, 0.5, 0.0, 0.0);
	gtk_widget_set_usize(AlignementEnterButton, 0, 100);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), AlignementEnterButton, FALSE, FALSE, 0);

	EnterButton = gtk_button_new_with_label("Enter");
	gtk_widget_set_usize(EnterButton, 150, 30);
	gtk_container_add(GTK_CONTAINER(AlignementEnterButton), EnterButton);
	gtk_signal_connect(GTK_OBJECT(EnterButton), "clicked", (GtkSignalFunc)Callback_EnterButton, NULL);

	/* get background color */
	style = gtk_widget_get_style(FrameLogo);
	gdk_color = style->bg[0];
	bg_color = (gdk_color.red >> 8) << 16 | (gdk_color.green >> 8) << 8 | (gdk_color.blue >> 8);

	/* frame */
	frame = global->logo_frame = frame_create();
	frame_set_width(frame, data->logo_width + 20);
	frame_set_height(frame, data->logo_height + 20);
	frame_set_bgcolor(frame, bg_color);

	/* logo alpha */
	pic = global->logo_alpha = pic_create(frame);
	pic_is_alphamask(frame, pic);
	pic_set_width(frame, pic, data->logo_width);
	pic_set_height(frame, pic, data->logo_height);
	pic_buff(frame, pic, data->pngfile_logo_alpha);

	/* logo */
	pic = global->logo_pic = pic_create(frame);
	pic_set_x(frame, pic, 0);
	pic_set_y(frame, pic, 0);
	pic_set_z(frame, pic, 0);	pic_set_width(frame, pic, data->logo_width);
	pic_set_height(frame, pic, data->logo_height);
	pic_set_alphamask(frame, pic, global->logo_alpha);
	pic_buff(frame, pic, data->pngfile_logo_image);

	gtk_widget_show_all(global->MainVerticalBox);
}


void interface_create_getgamespage()  {

//global->MainBox
	//global->MainVerticalBox
		GtkWidget *GameFrame;
			GtkWidget *GameScrollwin;
				//GameList
		GtkWidget *ButtonAndEntryHorizontalBox;
			GtkWidget *MetaServerFrame;
				GtkWidget *MetaServerHorizontalBox;
					GtkWidget *RefreshGameButton;
					GtkWidget *ShowServerButton;
			GtkWidget *AnotherServerFrame;
				GtkWidget *AnotherServerHorizontalBox;
					GtkWidget *HostLabel;
					GtkWidget *HostEntry;
					GtkWidget *PortEntry;
					GtkWidget *GetgameButton;
			GtkWidget *ConnectButton;
		GtkWidget *MessageFrame;

	gchar *text;

	global->phase = PHASE_GETGAMES;

	interface_unparent_message();
	interface_unparent_chat();

	gtk_widget_destroy(global->MainVerticalBox);
	global->MainVerticalBox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(global->MainBox), global->MainVerticalBox, TRUE, TRUE, 0);

	/* list of open game & gametype */
	GameFrame = gtk_frame_new("Start or Select a monopd game");
	gtk_container_set_border_width(GTK_CONTAINER(GameFrame), 15);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), GameFrame, TRUE, TRUE, 0);

	GameScrollwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(GameScrollwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_set_border_width(GTK_CONTAINER(GameScrollwin), 10);
	gtk_container_add(GTK_CONTAINER(GameFrame), GameScrollwin);

	global->GameCList = gtk_clist_new(8);
	gtk_clist_set_reorderable(GTK_CLIST(global->GameCList), TRUE);
	gtk_clist_set_selection_mode(GTK_CLIST(global->GameCList), GTK_SELECTION_SINGLE);
	gtk_container_add(GTK_CONTAINER(GameScrollwin), global->GameCList);
	gtk_clist_column_titles_show(GTK_CLIST(global->GameCList) );
	gtk_clist_set_column_visibility(GTK_CLIST(global->GameCList), 5, FALSE);
	gtk_clist_set_column_visibility(GTK_CLIST(global->GameCList), 6, FALSE);
	gtk_clist_set_column_visibility(GTK_CLIST(global->GameCList), 7, FALSE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(global->GameCList), 0, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(global->GameCList), 1, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(global->GameCList), 2, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(global->GameCList), 3, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(global->GameCList), 4, TRUE);
	global->mode_gameclist = 0;
	gameclist_title_showgames();

	gtk_signal_connect(GTK_OBJECT(global->GameCList), "unselect_row", (GtkSignalFunc)Callback_GetGame_Unselect, NULL);
	gtk_signal_connect_after(GTK_OBJECT(global->GameCList), "select_row", (GtkSignalFunc)Callback_GetGame_Select, NULL);


	/* horizontal box for button / entry */
	ButtonAndEntryHorizontalBox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), ButtonAndEntryHorizontalBox, FALSE, FALSE, 0);

	/* meta server frame */
	MetaServerFrame = gtk_frame_new("Meta server");
	gtk_box_pack_start(GTK_BOX(ButtonAndEntryHorizontalBox), MetaServerFrame, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(MetaServerFrame), BORDER);

	/* meta server horizontal box */
	MetaServerHorizontalBox = gtk_hbox_new(FALSE, BORDER);
	gtk_container_set_border_width(GTK_CONTAINER(MetaServerHorizontalBox), BORDER);
	gtk_container_add(GTK_CONTAINER(MetaServerFrame), MetaServerHorizontalBox);

	/* refresh button */
	ShowServerButton = gtk_button_new_with_label("Servers list");
//	gtk_widget_set_usize(ShowServerButton, 120, 0);
	gtk_box_pack_start(GTK_BOX(MetaServerHorizontalBox), ShowServerButton, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(ShowServerButton), "clicked", (GtkSignalFunc)Callback_ShowMetaServer, NULL);

	/* refresh button */
	RefreshGameButton = gtk_button_new_with_label("Refresh games");
//	gtk_widget_set_usize(RefreshGameButton, 120, 0);
	gtk_box_pack_start(GTK_BOX(MetaServerHorizontalBox), RefreshGameButton, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(RefreshGameButton), "clicked", (GtkSignalFunc)Callback_RefreshGameMetaServer, NULL);

	/* another server frame */
	AnotherServerFrame = gtk_frame_new("Another server");
	gtk_box_pack_start(GTK_BOX(ButtonAndEntryHorizontalBox), AnotherServerFrame, TRUE, TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(AnotherServerFrame), BORDER);

	/* Another server horizontal box */
	AnotherServerHorizontalBox = gtk_hbox_new(FALSE, BORDER);
	gtk_container_set_border_width(GTK_CONTAINER(AnotherServerHorizontalBox), BORDER);
	gtk_container_add(GTK_CONTAINER(AnotherServerFrame), AnotherServerHorizontalBox);

	/* label/entry host, label/entry port, get games button */
	HostLabel = gtk_label_new("host/port");
	gtk_box_pack_start(GTK_BOX(AnotherServerHorizontalBox), HostLabel, FALSE, FALSE, 0);

	HostEntry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(AnotherServerHorizontalBox), HostEntry, TRUE, TRUE, 0);
	gtk_entry_set_text(GTK_ENTRY(HostEntry), config->getgames_host);

	PortEntry = gtk_entry_new();
	gtk_widget_set_usize(PortEntry, 45, 0);
	gtk_box_pack_start(GTK_BOX(AnotherServerHorizontalBox), PortEntry, FALSE, FALSE, 0);
	text = g_strdup_printf("%d", config->getgames_port);
	gtk_entry_set_text(GTK_ENTRY(PortEntry), text);
	g_free(text);

	GetgameButton = gtk_button_new_with_label("Get games");
//	gtk_widget_set_usize(GetgameButton, 100, 0);
	gtk_box_pack_start(GTK_BOX(AnotherServerHorizontalBox), GetgameButton, FALSE, FALSE, 0);
	gtk_object_set_data(GTK_OBJECT(GetgameButton), "host", HostEntry);
	gtk_object_set_data(GTK_OBJECT(GetgameButton), "port", PortEntry);
	gtk_signal_connect(GTK_OBJECT(GetgameButton), "clicked", (GtkSignalFunc)Callback_GetgamesButton, NULL);

	/* big connect button */
	ConnectButton = gtk_button_new_with_label("CREATE/JOIN GAME");
	gtk_widget_set_usize(ConnectButton, 150, 0);
	gtk_container_set_border_width(GTK_CONTAINER(ConnectButton), BORDER);
	gtk_box_pack_start(GTK_BOX(ButtonAndEntryHorizontalBox), ConnectButton, FALSE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(ConnectButton), "clicked", (GtkSignalFunc)Callback_ConnectButton, NULL);

	/* message text */
	MessageFrame = gtk_frame_new("Messages");
	gtk_container_set_border_width(GTK_CONTAINER(MessageFrame), BORDER);
	gtk_widget_set_usize(MessageFrame, 0, 125);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), MessageFrame, FALSE, FALSE, 0);

	interface_create_message(MessageFrame);

	gtk_widget_show_all(global->MainVerticalBox);

	/* autoconnect to server (getgamelist / getserverlist) */
	if(config->metaserver_autogetlist)  {

		create_connection_metaserver(CONNECT_TYPE_META_GETLIST);
		return;
	}

	if(config->metaserver_autogetgames)
		create_connection_metaserver(CONNECT_TYPE_META_GETGAME);

	if(config->getgames_autogetgames)
		create_connection_get_games(config->getgames_host, config->getgames_port);
}


void interface_create_gameconfigpage()  {

//global->MainBox
	//global->MainVerticalBox
		GtkWidget *HorizontalBox;
			GtkWidget *VerticalBoxLeft;
				GtkWidget *MessageFrame;
					//global->MessageBox;
				GtkWidget *ChatFrame;
					//game->ChatBox
			GtkWidget *VerticalBoxRight;
				GtkWidget *AlignementListFrame;
					GtkWidget *PlayerScrollwin;
						GtkWidget *PlayerListFrame;
				GtkWidget *ConfigurationFrame;
					GtkWidget *ConfigurationScrolledWin;
						//game->GameConfigBox
				GtkWidget *HorizontalBoxButton;
					GtkWidget *StartButton;
					GtkWidget *LeaveButton;


	gchar *titles[2];

	global->phase = PHASE_GAMECREATE;

	interface_unparent_message();
	interface_unparent_chat();

	gtk_widget_destroy(global->MainVerticalBox);
	global->MainVerticalBox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(global->MainBox), global->MainVerticalBox, TRUE, TRUE, 0);

	/* main horizontal box */
	HorizontalBox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), HorizontalBox, TRUE, TRUE, 0);

	/* vertical box for messages */
	VerticalBoxLeft = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(HorizontalBox), VerticalBoxLeft, TRUE, TRUE, 0);

	/* message frame */
	MessageFrame = gtk_frame_new("Server Messages");
	gtk_container_set_border_width(GTK_CONTAINER(MessageFrame), 10);
	gtk_widget_set_usize(MessageFrame , 0, 130);
	gtk_box_pack_start(GTK_BOX(VerticalBoxLeft), MessageFrame, FALSE, TRUE, 0);

//	gtk_text_set_point(GTK_TEXT(global->Message), 0);
//	gtk_text_forward_delete(GTK_TEXT(global->Message), gtk_text_get_length(GTK_TEXT(global->Message)) );
	global->message_nb_lines = 0;
	interface_create_message(MessageFrame);

	/* chat frame */
	ChatFrame = gtk_frame_new("Chat");
	gtk_container_set_border_width(GTK_CONTAINER(ChatFrame), 10);
	gtk_box_pack_start(GTK_BOX(VerticalBoxLeft), ChatFrame, TRUE, TRUE, 0);
	interface_create_chat(ChatFrame);


	/* vertical box right */
	VerticalBoxRight = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(HorizontalBox), VerticalBoxRight, FALSE, TRUE, 0);

	/* player list frame */
	PlayerListFrame = gtk_frame_new("Players");
	gtk_container_set_border_width(GTK_CONTAINER(PlayerListFrame), 10);
	gtk_widget_set_usize(PlayerListFrame, 380, 240);
	gtk_box_pack_start(GTK_BOX(VerticalBoxRight), PlayerListFrame, FALSE, TRUE, 0);

	AlignementListFrame = gtk_alignment_new(0.0, 0.0, 1.0, 1.0);
	gtk_container_set_border_width(GTK_CONTAINER(AlignementListFrame), 10);
	gtk_container_add(GTK_CONTAINER(PlayerListFrame), AlignementListFrame);

	PlayerScrollwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(PlayerScrollwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(AlignementListFrame), PlayerScrollwin);

	titles[0] = g_strdup("Name");
	titles[1] = g_strdup("Host");
	game->PlayerCList = gtk_clist_new_with_titles(2, titles);
	g_free(titles[0]);
	g_free(titles[1]);
	gtk_clist_set_column_auto_resize(GTK_CLIST(game->PlayerCList), 0, TRUE);
	gtk_clist_column_titles_passive(GTK_CLIST(game->PlayerCList));
	gtk_clist_set_reorderable(GTK_CLIST(game->PlayerCList), FALSE);
	gtk_clist_set_selection_mode(GTK_CLIST(game->PlayerCList), GTK_SELECTION_SINGLE);
	gtk_container_add(GTK_CONTAINER(PlayerScrollwin), game->PlayerCList);

	/* game configuration frame */
	ConfigurationFrame = gtk_frame_new("Game Configuration");
	gtk_container_set_border_width(GTK_CONTAINER(ConfigurationFrame), 10);
	gtk_box_pack_start(GTK_BOX(VerticalBoxRight), ConfigurationFrame, TRUE, TRUE, 0);

	ConfigurationScrolledWin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ConfigurationScrolledWin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(ConfigurationFrame), ConfigurationScrolledWin);

	game->GameConfigBox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(game->GameConfigBox), 10);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ConfigurationScrolledWin), game->GameConfigBox);

	/* horizontal box button */
	HorizontalBoxButton = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(HorizontalBoxButton), 30);
	gtk_box_set_spacing(GTK_BOX(HorizontalBoxButton), 30);
	gtk_box_pack_start(GTK_BOX(VerticalBoxRight), HorizontalBoxButton, FALSE, TRUE, 0);

	/* leave button */
	LeaveButton = gtk_button_new_with_label("LEAVE GAME");
	gtk_widget_set_usize(LeaveButton, 0, 30);
	gtk_box_pack_start(GTK_BOX(HorizontalBoxButton), LeaveButton, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(LeaveButton), "clicked", (GtkSignalFunc)CallBack_menu_LeaveGame, NULL);

	/* start button */
	StartButton = gtk_button_new_with_label("START GAME");
	gtk_widget_set_usize(StartButton, 0, 30);
	gtk_box_pack_start(GTK_BOX(HorizontalBoxButton), StartButton, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(StartButton), "clicked", (GtkSignalFunc)Callback_StartButton, NULL);
	gtk_object_set_data(GTK_OBJECT(global->MainVerticalBox), "start_button", StartButton);

	gtk_widget_show_all(global->MainVerticalBox);
}


void interface_create_gameinitpage()  {

//global->MainBox
	//global->MainVerticalBox
		GtkWidget *Alignment;
			GtkWidget *Label;

	global->phase = PHASE_GAMEINIT;

	interface_unparent_message();
	interface_unparent_chat();

	gtk_widget_destroy(global->MainVerticalBox);
	global->MainVerticalBox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(global->MainBox), global->MainVerticalBox, TRUE, TRUE, 0);

	/* text */
	Alignment = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), Alignment, TRUE, TRUE, 0);

	Label = gtk_label_new("Please wait while loading...");
	gtk_container_add(GTK_CONTAINER(Alignment), Label);


	gtk_widget_show_all(global->MainVerticalBox);
	while(gtk_events_pending()) gtk_main_iteration();
}


void interface_create_gameboardpage()  {

//global->MainBox
	//global->MainVerticalBox
		GtkWidget *MainHorizontalBox;
			GtkWidget *VerticalBoxPlayerlistMessageChat;
				GtkWidget *PlayerVerticalBox;
					GtkWidget *PlayerHorizontalBox;
						GtkWidget *AlignementTokenPlayer;
							//global->player[].playerlist_token_gdkrgb
						GtkWidget *PlayerTable;
							//global->player[i].playerlist_AlignementNamePlayer;
								//global->player[].playerlist_LabelNamePlayer
							//global->player[i].playerlist_AlignementMoneyPlayer;
								//global->player[].playerlist_LabelMoneyPlayer
							//global->player[].playerlist_cards_gdkrgb
						GtkWidget *PlayerPopupMenu;
					GtkWidget *PlayerSeparator;
				//game->BoxMessageAndChat
					//call interface_message_and_chat_float_unfloat
			GtkWidget *VerticalBoxBoard;
				GtkWidget *hbox_board;
				GtkWidget *vbox_board;
				GtkWidget *EventBox;
					GtkTooltips *ToolTips;
					//game->BoardCenter;
					//game->estate[].gdkrgb
				GtkWidget *CmdButton;

	GtkWidget *Alignment;

	gint32 frame, pic, i, j, t, token, star, houses;
	gchar *text, *tmp1, *tmp2;

	GtkStyle *style;
	GdkColor gdk_color;
	guint32  bg_color;

	GtkWidget *MenuItem;
	gint32 nb_players;

	global->phase = PHASE_GAMEPLAY;
	game_sort_playerlist_by_playerid();

	interface_unparent_message();
	interface_unparent_chat();

	gtk_widget_destroy(global->MainVerticalBox);
	global->MainVerticalBox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(global->MainBox), global->MainVerticalBox, TRUE, TRUE, 0);

	/* horizontal box for board / player status */
	MainHorizontalBox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(global->MainVerticalBox), MainHorizontalBox, TRUE, TRUE, 0);

	/* vertical box for player / messages / chat */
	VerticalBoxPlayerlistMessageChat = gtk_vbox_new(FALSE, 0);
	if(config->game_playerlist_position == GAME_PLAYERLIST_POS_RIGHT)
		gtk_box_pack_end(GTK_BOX(MainHorizontalBox), VerticalBoxPlayerlistMessageChat, TRUE, TRUE, 0);
	else /* left (default) */
		gtk_box_pack_start(GTK_BOX(MainHorizontalBox), VerticalBoxPlayerlistMessageChat, TRUE, TRUE, 0);

	/* player status */
	PlayerVerticalBox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(PlayerVerticalBox), BORDER);
	gtk_box_pack_start(GTK_BOX(VerticalBoxPlayerlistMessageChat), PlayerVerticalBox, FALSE, FALSE, 0);

	/* set buffer_token & buffer_star */
	for(i = 0, j = 0 ; i < MAX_PLAYERS ; i++)  {

		if(! global->player[i].playerid) continue;
		if(global->player[i].game != game->gameid) continue;

		global->player[i].buffer_token = j;
		global->player[i].buffer_star = j;
		j++;
	}

	/* get background color */
	style = gtk_widget_get_style(PlayerVerticalBox);
	gdk_color = style->bg[0];
	bg_color = (gdk_color.red >> 8) << 16 | (gdk_color.green >> 8) << 8 | (gdk_color.blue >> 8);

	/* player list game */
	for(i = 0 ; i < MAX_PLAYERS ; i++)  {

		if(! global->player[i].playerid) continue;
		if(global->player[i].game != game->gameid) continue;

		token = global->player[i].buffer_token;

		/* separator */
		PlayerSeparator = gtk_hseparator_new();
		gtk_box_pack_start(GTK_BOX(PlayerVerticalBox), PlayerSeparator, FALSE, FALSE, 0);

		/* alignment */
		Alignment = gtk_alignment_new(0.0, 0.5, 0.0, 1.0);
		gtk_box_pack_start(GTK_BOX(PlayerVerticalBox), Alignment, FALSE, TRUE, 0);

		/* event box */
		EventBox = gtk_event_box_new();
		gtk_signal_connect(GTK_OBJECT(EventBox), "button_press_event", GTK_SIGNAL_FUNC (Callback_ClicOnPlayer), NULL);
		gtk_container_add(GTK_CONTAINER(Alignment), EventBox);

		/* box which contain all widgets for a player */
		PlayerHorizontalBox = gtk_hbox_new(FALSE, 0);
		gtk_style_copy(PlayerHorizontalBox->style);
		gtk_widget_set_style(PlayerHorizontalBox,  global->style_normal);
		gtk_container_add(GTK_CONTAINER(EventBox), PlayerHorizontalBox);

		/* building popup player menu */
		PlayerPopupMenu = gtk_menu_new();
		text = g_strdup_printf("%d", global->player[i].playerid);
		gtk_object_set_data_full(GTK_OBJECT(PlayerPopupMenu), "playerid", text, g_free);
		gtk_object_set_data(GTK_OBJECT(EventBox), "menu", PlayerPopupMenu);

		MenuItem = gtk_menu_item_new_with_label("Initiate a trade");
		gtk_menu_append(GTK_MENU(PlayerPopupMenu), MenuItem);
		gtk_object_set_data(GTK_OBJECT(MenuItem), "action", "trade");
		gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_PopupMenuPlayer, NULL);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new();
		gtk_menu_append(GTK_MENU(PlayerPopupMenu), MenuItem);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new_with_label("Request version");
		gtk_menu_append(GTK_MENU(PlayerPopupMenu), MenuItem);
		gtk_object_set_data(GTK_OBJECT(MenuItem), "action", "version");
		gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_PopupMenuPlayer, NULL);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new_with_label("Request date");
		gtk_menu_append(GTK_MENU(PlayerPopupMenu), MenuItem);
		gtk_object_set_data(GTK_OBJECT(MenuItem), "action", "date");
		gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_PopupMenuPlayer, NULL);
		gtk_widget_show(MenuItem);

		MenuItem = gtk_menu_item_new_with_label("Request ping");
		gtk_menu_append(GTK_MENU(PlayerPopupMenu), MenuItem);
		gtk_object_set_data(GTK_OBJECT(MenuItem), "action", "ping");
		gtk_signal_connect(GTK_OBJECT(MenuItem), "activate", (GtkSignalFunc)CallBack_PopupMenuPlayer, NULL);
		gtk_widget_show(MenuItem);

		/* token player in playerlist */
		AlignementTokenPlayer = gtk_alignment_new(1.0, 1.0, 0.0, 0.0);
		gtk_box_pack_start(GTK_BOX(PlayerHorizontalBox), AlignementTokenPlayer, TRUE, TRUE, 0);
		global->player[i].playerlist_token_gdkrgb = gtk_drawing_area_new();
		gtk_drawing_area_size( GTK_DRAWING_AREA (global->player[i].playerlist_token_gdkrgb), data->playerlist_token_width,  data->playerlist_token_height );
		gtk_container_add(GTK_CONTAINER(AlignementTokenPlayer), global->player[i].playerlist_token_gdkrgb);
		gtk_signal_connect (GTK_OBJECT (global->player[i].playerlist_token_gdkrgb), "expose_event", GTK_SIGNAL_FUNC (on_playertoken_expose), NULL);

		text = g_strdup_printf("%d", i);
		gtk_object_set_data_full(GTK_OBJECT(global->player[i].playerlist_token_gdkrgb), "player", text, g_free);

		/* name, money, cards owned by player */
		PlayerTable = gtk_table_new(2, 2, FALSE);
		gtk_table_set_row_spacings(GTK_TABLE(PlayerTable), 0);
		gtk_table_set_col_spacings(GTK_TABLE(PlayerTable), 0);
		gtk_box_pack_start(GTK_BOX(PlayerHorizontalBox), PlayerTable, FALSE, FALSE, 0);

		/* cards */
		global->player[i].playerlist_cards_gdkrgb = gtk_drawing_area_new();
		gtk_drawing_area_size( GTK_DRAWING_AREA (global->player[i].playerlist_cards_gdkrgb), data->playerlist_cards_width,  data->playerlist_cards_height );
		gtk_table_attach_defaults(GTK_TABLE(PlayerTable),  global->player[i].playerlist_cards_gdkrgb,  0,  2,  1,  2);
		gtk_signal_connect (GTK_OBJECT (global->player[i].playerlist_cards_gdkrgb), "expose_event", GTK_SIGNAL_FUNC (on_playercards_expose), NULL);

		text = g_strdup_printf("%d", i);
		gtk_object_set_data_full(GTK_OBJECT(global->player[i].playerlist_cards_gdkrgb), "player", text, g_free);

		/* name */
		global->player[i].playerlist_AlignementNamePlayer = gtk_alignment_new(0.0, 0.0, 0.0, 0.0);
		gtk_table_attach_defaults(GTK_TABLE(PlayerTable),  global->player[i].playerlist_AlignementNamePlayer,  0,  1,  0,  1);
		global->player[i].playerlist_LabelNamePlayer = gtk_label_new(global->player[i].name);
		gtk_object_set_data(GTK_OBJECT(global->player[i].playerlist_AlignementNamePlayer), "namelabel", global->player[i].playerlist_LabelNamePlayer);
		gtk_container_add(GTK_CONTAINER(global->player[i].playerlist_AlignementNamePlayer), global->player[i].playerlist_LabelNamePlayer);

		if(global->player[i].hasturn)
			gtk_widget_set_style(global->player[i].playerlist_LabelNamePlayer, global->style_player_turn);
		else
			gtk_widget_set_style(global->player[i].playerlist_LabelNamePlayer, global->style_player_normal);

		/* money */
		global->player[i].playerlist_AlignementMoneyPlayer = gtk_alignment_new(1.0, 0.0, 0.0, 0.0);
		gtk_table_attach_defaults(GTK_TABLE(PlayerTable),  global->player[i].playerlist_AlignementMoneyPlayer,  1,  2,  0,  1);
		text = g_strdup_printf("%d", global->player[i].money);
		global->player[i].playerlist_LabelMoneyPlayer = gtk_label_new(text);
		g_free(text);
		gtk_object_set_data(GTK_OBJECT(global->player[i].playerlist_AlignementMoneyPlayer), "moneylabel", global->player[i].playerlist_LabelMoneyPlayer);
		gtk_container_add(GTK_CONTAINER(global->player[i].playerlist_AlignementMoneyPlayer), global->player[i].playerlist_LabelMoneyPlayer);

		if(global->player[i].hasturn)
			gtk_widget_set_style(global->player[i].playerlist_LabelMoneyPlayer, global->style_player_turn);
		else
			gtk_widget_set_style(global->player[i].playerlist_LabelMoneyPlayer, global->style_player_normal);

		/* playerlist token frame */
		frame = global->player[i].playerlist_token_frame = frame_create();
		frame_set_width(frame, data->playerlist_token_width);
		frame_set_height(frame, data->playerlist_token_height);
		if(data->playerlist_token_bgcolor < 0)
			frame_set_bgcolor(frame, bg_color);
		else
			frame_set_bgcolor(frame, data->playerlist_token_bgcolor);

		/* playerlist token alpha */
		pic = global->player[i].playerlist_token_alpha = pic_create(frame);
		pic_is_alphamask(frame, pic);
		pic_set_width(frame, pic, data->pngfile_token_width[token]);
		pic_set_height(frame, pic, data->pngfile_token_height[token]);
		pic_buff(frame, pic, data->pngfile_token_alpha[token]);

		/* playerlist token pic */
		pic = global->player[i].playerlist_token_pic = pic_create(frame);
		pic_set_x(frame, pic, (data->playerlist_token_width - data->pngfile_token_width[token]) / 2);
		pic_set_y(frame, pic, (data->playerlist_token_height - data->pngfile_token_height[token]) / 2);
		pic_set_z(frame, pic, 0);
		pic_set_width(frame, pic, data->pngfile_token_width[token]);
		pic_set_height(frame, pic, data->pngfile_token_height[token]);
		pic_set_alphamask(frame, pic, global->player[i].playerlist_token_alpha);
		pic_buff(frame, pic, data->pngfile_token_image[token]);

		/* engine frame cards */
		frame = global->player[i].playerlist_cards_frame = frame_create();
		frame_set_width(frame, data->playerlist_cards_width);
		frame_set_height(frame, data->playerlist_cards_height);
		if(data->playerlist_cards_bgcolor < 0)
			frame_set_bgcolor(frame, bg_color);
		else
			frame_set_bgcolor(frame, data->playerlist_cards_bgcolor);

		/* cards */
		for(j = 0 ; j < data->number_playerlist_card ; j++)  {

			pic = global->player[i].playerlist_cards_pic[j] = pic_create(frame);
			pic_set_x(frame, pic, data->playerlist_card[j].x);
			pic_set_y(frame, pic, data->playerlist_card[j].y);
			pic_set_z(frame, pic, data->playerlist_card[j].z);
			t = data->playerlist_card[j].buffer_card;
			pic_set_width(frame, pic, data->pngfile_card_width[t]);
			pic_set_height(frame, pic, data->pngfile_card_height[t]);

			if(game->estate[ data->playerlist_card[j].estateid ].owner  ==  global->player[i].playerid)  {

				if(game->estate[ data->playerlist_card[j].estateid ].mortgaged)  {

					pic_set_alpha(frame, pic, data->playerlist_cards_alphamortgage);
					pic_set_bgcolor(frame, pic, data->playerlist_cards_cardbgcolormortgage);
				}
				else  {

					pic_set_alpha(frame, pic, data->playerlist_cards_alphaowned);
					pic_set_bgcolor(frame, pic, data->playerlist_cards_cardbgcolor);
				}
			}
			else  {

				pic_set_alpha(frame, pic, data->playerlist_cards_alphaunowned);
				pic_set_bgcolor(frame, pic, data->playerlist_cards_cardbgcolor);
			}

			pic_buff(frame, pic, data->pngfile_card_image[t]);
		}
	}

	/* last separator */
	PlayerSeparator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(PlayerVerticalBox), PlayerSeparator, FALSE, FALSE, 0);

	/* message and chat box */
	game->BoxMessageAndChat = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(VerticalBoxPlayerlistMessageChat), game->BoxMessageAndChat, TRUE, TRUE, 0);

	nb_players = game_nb_players();
	if(nb_players <= 5)  {

		game->message_float = 0;
		game->chat_float = 0;
	}
	else if(nb_players <= 7)  {

		game->message_float = 0;
		game->chat_float = 1;
	}
	else  {

		game->message_float = 1;
		game->chat_float = 1;
	}
	interface_message_and_chat_float_unfloat();


	/* vertical box for board / left space */
	VerticalBoxBoard = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(MainHorizontalBox), VerticalBoxBoard, FALSE, FALSE, 0);


	/* ==== <INFO> about board ====
         *
	 *  |-------------|   |-------------|   |-------------|
         *  |             |   |  | | | | |  |   |  | | | | |  |
         *  |-------------|   |-------------|   |-------------|
         *  |             |   |  |       |  |   |--|       |--|
         *  |             |   |  |       |  |   |--|       |--|
         *  |             |   |  |       |  |   |--|       |--|
         *  |             |   |  |       |  |   |--|       |--|
         *  |-------------|   |-------------|   |-------------|
         *  |             |   |  | | | | |  |   |  | | | | |  |
         *  |-------------|   |-------------|   |-------------|
         *
         *  First, build a    Second, build     Third, build
         *  vbox.             three hbox.       two vbox.
         */

	/* first */
	vbox_board = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox_board), BORDER);
	gtk_box_pack_start(GTK_BOX(VerticalBoxBoard), vbox_board, FALSE, FALSE, 0);

	/* second - top */
	hbox_board = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_board), hbox_board, FALSE, FALSE, 0);

	for(i = 20 ; i <= 30 ; i++)  {

		EventBox = gtk_event_box_new();
		gtk_box_pack_start(GTK_BOX(hbox_board), EventBox, FALSE, FALSE, 0);

		text = g_strdup_printf("game_estate_%d", i);
		gtk_object_set_data(GTK_OBJECT(global->MainBox), text, EventBox);
		g_free(text);
	}

	/* second - bottom */
	hbox_board = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_end(GTK_BOX(vbox_board), hbox_board, FALSE, FALSE, 0);

	for(i = 0 ; i <= 10 ; i++)  {

		EventBox = gtk_event_box_new();
		gtk_box_pack_end(GTK_BOX(hbox_board), EventBox, FALSE, FALSE, 0);

		text = g_strdup_printf("game_estate_%d", i);
		gtk_object_set_data(GTK_OBJECT(global->MainBox), text, EventBox);
		g_free(text);
	}

	/* second - center */
	hbox_board = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_board), hbox_board, FALSE, FALSE, 0);

	/* third - left */
	vbox_board = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_board), vbox_board, FALSE, FALSE, 0);

	for(i = 11 ; i < 20 ; i++)  {

		EventBox = gtk_event_box_new();
		gtk_box_pack_end(GTK_BOX(vbox_board), EventBox, FALSE, FALSE, 0);

		text = g_strdup_printf("game_estate_%d", i);
		gtk_object_set_data(GTK_OBJECT(global->MainBox), text, EventBox);
		g_free(text);
	}

	/* third - right */
	vbox_board = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_end(GTK_BOX(hbox_board), vbox_board, FALSE, FALSE, 0);

	for(i = 31 ; i < 40 ; i++)  {

		EventBox = gtk_event_box_new();
		gtk_box_pack_start(GTK_BOX(vbox_board), EventBox, FALSE, FALSE, 0);

		text = g_strdup_printf("game_estate_%d", i);
		gtk_object_set_data(GTK_OBJECT(global->MainBox), text, EventBox);
		g_free(text);
	}

	/* third - center */
	game->BoardCenter = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(hbox_board), game->BoardCenter);

	/* tool tips, display name of estate when mouse was on estate */
	ToolTips = gtk_tooltips_new();


	/* board estates - drawing area */
	for(i = 0 ; i < data->number_estates ; i++)  {

		j = data->estate[i].buffer_board;

		text = g_strdup_printf("game_estate_%d", i);
		EventBox = gtk_object_get_data(GTK_OBJECT(global->MainBox), text);
		g_free(text);

		game->estate[i].gdkrgb = gtk_drawing_area_new();
		gtk_drawing_area_size( GTK_DRAWING_AREA (game->estate[i].gdkrgb), data->pngfile_board_width[j],  data->pngfile_board_height[j] );

		gtk_widget_set_events(GTK_WIDGET(game->estate[i].gdkrgb), GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK | GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK);

		text = g_strdup_printf("%d", i);
		gtk_object_set_data_full(GTK_OBJECT(game->estate[i].gdkrgb), "estateid", text, g_free);

		gtk_signal_connect_after (GTK_OBJECT (game->estate[i].gdkrgb), "enter_notify_event", GTK_SIGNAL_FUNC (Callback_EnterAnEstate), NULL);
		gtk_signal_connect (GTK_OBJECT (game->estate[i].gdkrgb), "leave_notify_event", GTK_SIGNAL_FUNC (Callback_LeaveAnEstate), NULL);
		gtk_signal_connect (GTK_OBJECT (game->estate[i].gdkrgb), "button_press_event", GTK_SIGNAL_FUNC (Callback_ClicOnEstate), NULL);
		gtk_signal_connect (GTK_OBJECT (game->estate[i].gdkrgb), "expose_event", GTK_SIGNAL_FUNC (on_board_expose), NULL);

		gtk_container_add(GTK_CONTAINER(EventBox),  game->estate[i].gdkrgb);

		/* set ToolTips */
		text = g_strdup_printf("%s", game->estate[i].name);

		if(game->estate[i].group >= 0)  {
			tmp1 = text;
			tmp2 = g_strdup_printf(" (%s)", game->group[ game->estate[i].group ].name);
			text = g_strconcat(tmp1, tmp2, NULL);
			g_free(tmp1);
			g_free(tmp2);
		}

		if(game->estate[i].price > 0)  {
			tmp1 = text;
			tmp2 = g_strdup_printf("\nPrice: %d", game->estate[i].price);
			text = g_strconcat(tmp1, tmp2, NULL);
			g_free(tmp1);
			g_free(tmp2);
		}

		if(game->estate[i].rent[5] > 0)  {
			tmp1 = text;
			tmp2 = g_strdup_printf(
				"\nNo house: %d, One: %d, Two: %d, Three: %d, Four: %d, Hotel: %d"
				"\nHouse price: %d",
				game->estate[i].rent[0], game->estate[i].rent[1], game->estate[i].rent[2], game->estate[i].rent[3], game->estate[i].rent[4], game->estate[i].rent[5],
				game->estate[i].houseprice   );
			text = g_strconcat(tmp1, tmp2, NULL);
			g_free(tmp1);
			g_free(tmp2);
		}

		if(game->estate[i].mortgageprice > 0)  {
			tmp1 = text;
			tmp2 = g_strdup_printf("\nMortgage value: %d", game->estate[i].mortgageprice);
			text = g_strconcat(tmp1, tmp2, NULL);
			g_free(tmp1);
			g_free(tmp2);
		}

		gtk_tooltips_set_tip(ToolTips, EventBox, text, NULL);
		g_free(text);
	}


	/* command box */
	game->CommandsBox = gtk_hbox_new(FALSE, 10);
	gtk_container_set_border_width(GTK_CONTAINER(game->CommandsBox), BORDER);
	gtk_box_pack_start(GTK_BOX(VerticalBoxBoard), game->CommandsBox, FALSE, TRUE, 0);

	/* roll button */
	CmdButton = gtk_button_new_with_label("Roll");
	gtk_object_set_data(GTK_OBJECT(game->CommandsBox), "roll_button", CmdButton);
	gtk_widget_set_usize(CmdButton, 60, 0);
	gtk_object_set_data(GTK_OBJECT(CmdButton), "command", ".r\n");
	gtk_box_pack_start(GTK_BOX(game->CommandsBox), CmdButton, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(CmdButton), "clicked", (GtkSignalFunc)CallBack_button_command_pressed, NULL);

	/* how to play in center */
	display_init();
	display_title("How to Play");

	/* how to play in message server box */
	text = g_strdup("Buy house: Press left button on estate");
	text_insert_message(text, strlen(text));
	display_text(text);
	g_free(text);
	text = g_strdup("Sell house: Press right button on estate.");
	text_insert_message(text, strlen(text));
	display_text(text);
	g_free(text);
	text = g_strdup("Mortgage: Press middle button on estate to toggle.");
	text_insert_message(text, strlen(text));
	display_text(text);
	g_free(text);
	display_text("");
	text = g_strdup("Trade: press right button on the player who want to trade with, and select \"Initiate a trade\"");
	text_insert_message(text, strlen(text));
	display_text(text);
	g_free(text);

	display_text("\nPlease read help for more informations");

	/* timeout animate token */
	game->timeout_token = gtk_timeout_add(config->game_token_animation_speed, game_move_tokens, NULL);


	/* ==== GRAPHIC ENGINE IMAGES ==== */

	/* board frame */
	frame = game->board_frame = frame_create();
	frame_set_width(frame, data->board_width);
	frame_set_height(frame, data->board_height);

	/* pic for estates / stars / houses */
	for(i = 0 ; i < data->number_estates ; i++)  {

		j = data->estate[i].buffer_board;


		/* estate */
		pic = game->estate[i].pic = pic_create(frame);
		pic_set_x(frame, pic, data->estate[i].x);
		pic_set_y(frame, pic, data->estate[i].y);
		pic_set_z(frame, pic, 0);
		pic_set_width(frame, pic, data->pngfile_board_width[j]);
		pic_set_height(frame, pic, data->pngfile_board_height[j]);
		pic_buff(frame, pic, data->pngfile_board_image[j]);

		/* star alpha */
		pic = game->estate[i].star_alpha = pic_create(frame);
		pic_is_alphamask(frame, pic);

		/* star */
		pic = game->estate[i].star_pic = pic_create(frame);
		pic_set_x(frame, pic, data->estate[i].xstar);
		pic_set_y(frame, pic, data->estate[i].ystar);
		pic_set_z(frame, pic, 1);
		pic_set_alphamask(frame, pic, game->estate[i].star_alpha);

		/* if estate owned  &&  not mortgaged */
		if(game->estate[i].owner > 0  &&  !game->estate[i].mortgaged)  {

			star = global->player[ get_player_slot_with_playerid( game->estate[i].owner ) ].buffer_star;

			pic = game->estate[i].star_alpha;
			pic_set_width(frame, pic, data->pngfile_star_width[star]);
			pic_set_height(frame, pic, data->pngfile_star_height[star]);
			pic_buff(frame, pic, data->pngfile_star_alpha[star]);

			pic = game->estate[i].star_pic;
			pic_set_width(frame, pic, data->pngfile_star_width[star]);
			pic_set_height(frame, pic, data->pngfile_star_height[star]);
			pic_buff(frame, pic, data->pngfile_star_image[star]);
			pic_show(frame, pic);
		}

		/* if estate owned  &&  mortgaged */
		else  if(game->estate[i].owner > 0  &&  game->estate[i].mortgaged)  {

			star = global->player[ get_player_slot_with_playerid( game->estate[i].owner ) ].buffer_star;

			pic = game->estate[i].star_alpha;
			pic_set_width(frame, pic, data->pngfile_star_m_width[star]);
			pic_set_height(frame, pic, data->pngfile_star_m_height[star]);
			pic_buff(frame, pic, data->pngfile_star_m_alpha[star]);

			pic = game->estate[i].star_pic;
			pic_set_width(frame, pic, data->pngfile_star_m_width[star]);
			pic_set_height(frame, pic, data->pngfile_star_m_height[star]);
			pic_buff(frame, pic, data->pngfile_star_m_image[star]);
			pic_show(frame, pic);
		}

		/* if estate unowned */
		else  /* if( game->estate[i].owner <= 0 ) */ {

			pic = game->estate[i].star_pic;
			pic_unshow(frame, pic);
		}

		/* house alpha */
		pic = game->estate[i].house_alpha = pic_create(frame);
		pic_is_alphamask(frame, pic);

		/* house image */
		pic = game->estate[i].house_pic = pic_create(frame);
		pic_set_x(frame, pic, data->estate[i].xhouse);
		pic_set_y(frame, pic, data->estate[i].yhouse);
		pic_set_z(frame, pic, 1);
		pic_set_alphamask(frame, pic, game->estate[i].house_alpha);

		houses = game->estate[i].houses;

		if(houses <= 0)   {

			pic = game->estate[i].house_pic;
			pic_unshow(frame, pic);
		}
		else  if(houses > 0  &&  data->estate[i].type_house == TYPE_HOUSE_HORIZONTAL)  {

			pic = game->estate[i].house_alpha;
			pic_set_width(frame, pic, data->pngfile_horiz_house_width[ houses ]);
			pic_set_height(frame, pic, data->pngfile_horiz_house_height[ houses ]);
			pic_set_buff(frame, pic, data->pngfile_horiz_house_alpha[ houses ]);

			pic = game->estate[i].house_pic;
			pic_set_width(frame, pic, data->pngfile_horiz_house_width[ houses ]);
			pic_set_height(frame, pic, data->pngfile_horiz_house_height[ houses ]);
			pic_set_buff(frame, pic, data->pngfile_horiz_house_image[ houses ]);
			pic_show(frame, pic);
		}
		else  if(houses > 0  &&  data->estate[i].type_house == TYPE_HOUSE_VERTICAL)  {

			pic = game->estate[i].house_alpha;
			pic_set_width(frame, pic, data->pngfile_vert_house_width[ houses ]);
			pic_set_height(frame, pic, data->pngfile_vert_house_height[ houses ]);
			pic_set_buff(frame, pic, data->pngfile_vert_house_alpha[ houses ]);

			pic = game->estate[i].house_pic;
			pic_set_width(frame, pic, data->pngfile_vert_house_width[ houses ]);
			pic_set_height(frame, pic, data->pngfile_vert_house_height[ houses ]);
			pic_set_buff(frame, pic, data->pngfile_vert_house_image[ houses ]);
			pic_show(frame, pic);
		}
	}


	/* pic for tokens */
	for(i = 0 ; i < MAX_PLAYERS ; i++)  {

		if(! global->player[i].playerid) continue;
		if(global->player[i].game != game->gameid)  continue;

		token = global->player[i].buffer_token;

		/* token alpha */
		pic = global->player[i].token_alpha = pic_create(frame);
		pic_is_alphamask(frame, pic);
		pic_set_width(frame, pic, data->pngfile_token_width[token]);
		pic_set_height(frame, pic, data->pngfile_token_height[token]);
		pic_buff(frame, pic, data->pngfile_token_alpha[token]);

		/* token */
		pic = global->player[i].token_pic = pic_create(frame);
		pic_set_z(frame, pic, 1);
		pic_set_width(frame, pic, data->pngfile_token_width[token]);
		pic_set_height(frame, pic, data->pngfile_token_height[token]);
		pic_set_alphamask(frame, pic, global->player[i].token_alpha);
		pic_buff(frame, pic, data->pngfile_token_image[token]);
		if(global->player[i].bankrupt)
			pic_unshow(frame, pic);

		game_update_tokens();
	}


	gtk_widget_show_all(global->MainVerticalBox);

	if(global->player[ get_player_slot_with_playerid(game->my_playerid) ].can_roll)
		gtk_widget_show(CmdButton);
	else
		gtk_widget_hide(CmdButton);
}


/* create message box, chat box fixed or floating */
void interface_message_and_chat_float_unfloat()  {

	//game->BoxMessageAndChat
		//global->MessageFrame
		//global->MessageWindow
			//global->MessageBox
		//global->ChatFrame
		//global->ChatWindow
			//game->ChatBox

	/* message is fixed and not created */
	if(!game->message_float  &&  !global->MessageFrame) {

		/* if message window is created */
		if(global->MessageWindow)  {

			interface_unparent_message();
			gtk_widget_destroy(global->MessageWindow);
			global->MessageWindow = 0;
		}
		global->MessageFrame = gtk_frame_new("Server Messages");
		gtk_container_set_border_width(GTK_CONTAINER(global->MessageFrame), BORDER);
		gtk_widget_set_usize(global->MessageFrame, 0, 100);
		gtk_box_pack_start(GTK_BOX(game->BoxMessageAndChat), global->MessageFrame, FALSE, TRUE, 0);

		interface_create_message(global->MessageFrame);
		gtk_widget_show_all(global->MessageFrame);
	}

	/* message is float and not created */
	if(game->message_float  &&  !global->MessageWindow)  {

		/* if message fixed is created */
		if(global->MessageFrame)  {

			interface_unparent_message();
			gtk_widget_destroy(global->MessageFrame);
			global->MessageFrame = 0;
			while(gtk_events_pending()) gtk_main_iteration();
		}
		global->MessageWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(global->MessageWindow), "GtkAtlantic: Server Messages");
		gtk_window_set_policy(GTK_WINDOW(global->MessageWindow), TRUE, TRUE, FALSE);
		gtk_widget_set_usize(global->MessageWindow, 300, 230);
		gtk_widget_realize(global->MessageWindow);
		gdk_window_set_icon(global->MessageWindow->window, NULL, global->icon_pixmap, global->icon_mask);
		gtk_signal_connect(GTK_OBJECT(global->MessageWindow), "delete_event", (GtkSignalFunc)CallBack_delete_window_message, NULL);
		gtk_signal_connect(GTK_OBJECT(global->MessageWindow), "destroy", (GtkSignalFunc)CallBack_destroy_window_message, NULL);

		interface_create_message(global->MessageWindow);
		gtk_widget_show_all(global->MessageWindow);
	}


	/* chat is fixed and not created */
	if(!game->chat_float  &&  !game->ChatFrame) {

		/* if chat window is created */
		if(game->ChatWindow)  {

			interface_unparent_chat();
			gtk_widget_destroy(game->ChatWindow);
			game->ChatWindow = 0;
		}
		game->ChatFrame = gtk_frame_new("Chat");
		gtk_container_set_border_width(GTK_CONTAINER(game->ChatFrame), BORDER);
		gtk_box_pack_end(GTK_BOX(game->BoxMessageAndChat), game->ChatFrame, TRUE, TRUE, 0);

		interface_create_chat(game->ChatFrame);
		gtk_widget_show_all(game->ChatFrame);
	}

	/* chat is float and not created */
	if(game->chat_float  &&  !game->ChatWindow)  {

		/* if chat fixed is created */
		if(game->ChatFrame)  {

			interface_unparent_chat();
			gtk_widget_destroy(game->ChatFrame);
			game->ChatFrame = 0;
			while(gtk_events_pending()) gtk_main_iteration();
		}
		game->ChatWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title(GTK_WINDOW(game->ChatWindow), "GtkAtlantic: Chat");
		gtk_window_set_policy(GTK_WINDOW(game->ChatWindow), TRUE, TRUE, FALSE);
		gtk_widget_set_usize(game->ChatWindow, 300, 230);
		gtk_widget_realize(game->ChatWindow);
		gdk_window_set_icon(game->ChatWindow->window, NULL, global->icon_pixmap, global->icon_mask);
		gtk_signal_connect(GTK_OBJECT(game->ChatWindow), "delete_event", (GtkSignalFunc)CallBack_delete_window_chat, NULL);
		gtk_signal_connect(GTK_OBJECT(game->ChatWindow), "destroy", (GtkSignalFunc)CallBack_destroy_window_chat, NULL);

		interface_create_chat(game->ChatWindow);
		gtk_widget_show_all(game->ChatWindow);
	}
}


void interface_create_message(GtkWidget *container)  {

	//global->MessageBox;
		//global->Message
		//GtkWidget* MessageVerticalScrollbar;

	GtkTextBuffer *textbuff;
	GtkTextIter textiter;

	/* also created, just reparent */
	if(global->MessageBox)  {

		gtk_widget_reparent(GTK_WIDGET(global->MessageBox), container);
		return;
	}

	global->MessageBox = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(global->MessageBox),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(container), global->MessageBox);

	/* Create the text view */
	global->Message = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(global->Message), FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(global->Message), GTK_WRAP_CHAR);
	textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(global->Message));
	gtk_text_buffer_get_end_iter(textbuff, &textiter);
	gtk_text_buffer_create_mark(textbuff, "endmark", &textiter, FALSE);

	global->message_nb_lines = 0;

	gtk_container_add(GTK_CONTAINER(global->MessageBox), global->Message);
}


void interface_unparent_message()  {

	if(!global->MessageBox) return;

	gtk_widget_hide( GTK_WIDGET(global->MessageBox) );
	gtk_widget_reparent(GTK_WIDGET(global->MessageBox), global->Trick);
}


void interface_destroy_message()  {

	if(!global->MessageBox) return;

	if(global->MessageFrame)
		gtk_widget_destroy( GTK_WIDGET(global->MessageFrame) );

	if(global->MessageWindow)
		gtk_widget_destroy( GTK_WIDGET(global->MessageWindow) );

	global->MessageWindow = 0;
	global->MessageFrame = 0;
	global->MessageBox = 0;
	global->Message = 0;
}


void interface_create_chat(GtkWidget *container)  {

	//game->ChatBox
		GtkWidget *ChatScrolledWindow;
			//game->Chat
		GtkWidget *SendEntry;

	GtkTextBuffer *textbuff;
	GtkTextIter textiter;

	if(! game) return;

	/* also created, just reparent */
	if(game->ChatBox)  {

		gtk_widget_reparent(GTK_WIDGET(game->ChatBox), container);
		return;
	}

	game->ChatBox = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(container), game->ChatBox);

//	ChatFrameHorizontalBox = gtk_hbox_new(FALSE, 0);
//	gtk_container_add(GTK_CONTAINER(game->ChatBox), ChatFrameHorizontalBox);

	game->Chat = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(game->Chat), FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(game->Chat), GTK_WRAP_CHAR);
	textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(game->Chat));
	gtk_text_buffer_get_end_iter(textbuff, &textiter);
	gtk_text_buffer_create_mark(textbuff, "endmark", &textiter, FALSE);
	game->chat_nb_lines = 0;

	/* Create a scrolled window and put the textview in it */
	ChatScrolledWindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ChatScrolledWindow),
			GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(ChatScrolledWindow), game->Chat);
	gtk_box_pack_start(GTK_BOX(game->ChatBox), ChatScrolledWindow, TRUE, TRUE, 0);

	/* send entry */
	SendEntry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(game->ChatBox), SendEntry, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(SendEntry), "activate", (GtkSignalFunc)Callback_SendButton, (gpointer)SendEntry);
}


void interface_unparent_chat()  {

	if(! game) return;
	if(! game->ChatBox) return;

	gtk_widget_hide( GTK_WIDGET(game->ChatBox) );
	gtk_widget_reparent(GTK_WIDGET(game->ChatBox), global->Trick);
}


void interface_destroy_chat()  {

	if(! game) return;
	if(! game->ChatBox) return;

	if(game->ChatFrame)
		gtk_widget_destroy( GTK_WIDGET(game->ChatFrame) );

	if(game->ChatWindow)
		gtk_widget_destroy( GTK_WIDGET(game->ChatWindow) );

	game->ChatWindow = 0;
	game->ChatFrame = 0;
	game->ChatBox = 0;
	game->Chat = 0;
}


void interface_create_auctionbox()  {

	GtkWidget *vbox;
		GtkWidget *scrolledwindow;
			GtkWidget *text;
				GtkTextBuffer *textbuff;
				GtkTextIter textiter;
		GtkWidget *hbox_entry;
			GtkWidget *entry;
			GtkWidget *Alignment;
				GtkWidget *hbox_buttons;
					GtkWidget *button;

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 15);
	gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "auctionbox", vbox);
	gtk_box_pack_start(GTK_BOX(game->BoardCenter), vbox, TRUE, TRUE, 0);

//	hbox_text = gtk_hbox_new(FALSE, 0);
//	gtk_box_pack_start(GTK_BOX(vbox), hbox_text, TRUE, TRUE, 0);

	hbox_entry = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox_entry, FALSE, TRUE, 0);

	/* text box */
	scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
			GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	text = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(text), FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(text), GTK_WRAP_WORD);

        textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
        gtk_text_buffer_get_end_iter(textbuff, &textiter);
        gtk_text_buffer_create_mark(textbuff, "endmark", &textiter, FALSE);

	gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "auction_text", text);
	gtk_container_add(GTK_CONTAINER(scrolledwindow), text);
	gtk_box_pack_start(GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);

	/* send entry */
	entry = gtk_entry_new();
	gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "auction_entry", entry);
	gtk_box_pack_start(GTK_BOX(hbox_entry), entry,  FALSE, FALSE, 0);
	gtk_widget_set_usize(entry, 60, 0);
	gtk_signal_connect(GTK_OBJECT(entry), "activate", (GtkSignalFunc)Callback_AuctionButton_Absolute, (gpointer)entry);

	button = gtk_button_new_with_label("Bid");
	gtk_widget_set_usize(button, 40, 0);
	gtk_box_pack_start(GTK_BOX(hbox_entry), button, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", (GtkSignalFunc)Callback_AuctionButton_Absolute, (gpointer)entry);

	/* buttons entry */
	Alignment = gtk_alignment_new(1.0, 0.5, 0.0, 1.0);
	gtk_box_pack_start(GTK_BOX(hbox_entry), Alignment, TRUE, TRUE, 0);
	hbox_buttons = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(Alignment), hbox_buttons);

	button = gtk_button_new_with_label("+1");
	gtk_widget_set_usize(button, 40, 0);
	gtk_object_set_data(GTK_OBJECT(button), "auction_entry", entry);
	gtk_object_set_data(GTK_OBJECT(button), "value_add", GINT_TO_POINTER(1));
	gtk_box_pack_start(GTK_BOX(hbox_buttons), button, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", (GtkSignalFunc)Callback_AuctionButton_Relative, NULL);

	button = gtk_button_new_with_label("+10");
	gtk_widget_set_usize(button, 40, 0);
	gtk_object_set_data(GTK_OBJECT(button), "auction_entry", entry);
	gtk_object_set_data(GTK_OBJECT(button), "value_add", GINT_TO_POINTER(10));
	gtk_box_pack_start(GTK_BOX(hbox_buttons), button, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", (GtkSignalFunc)Callback_AuctionButton_Relative, NULL);

	button = gtk_button_new_with_label("+50");
	gtk_widget_set_usize(button, 40, 0);
	gtk_object_set_data(GTK_OBJECT(button), "auction_entry", entry);
	gtk_object_set_data(GTK_OBJECT(button), "value_add", GINT_TO_POINTER(50));
	gtk_box_pack_start(GTK_BOX(hbox_buttons), button, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", (GtkSignalFunc)Callback_AuctionButton_Relative, NULL);

	button = gtk_button_new_with_label("+100");
	gtk_widget_set_usize(button, 40, 0);
	gtk_object_set_data(GTK_OBJECT(button), "auction_entry", entry);
	gtk_object_set_data(GTK_OBJECT(button), "value_add", GINT_TO_POINTER(100));
	gtk_box_pack_start(GTK_BOX(hbox_buttons), button, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button), "clicked", (GtkSignalFunc)Callback_AuctionButton_Relative, NULL);

	gtk_widget_show_all(vbox);
}


/* create about window */
void interface_create_aboutwin()
{
	GtkWidget *AboutDlg;
	GtkWidget *Label;
	GtkWidget *VBox;

	gchar *text;

	AboutDlg = gtk_dialog_new_with_buttons("About gtkAtlantic", NULL,
			GTK_DIALOG_MODAL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
			NULL);
	gtk_window_set_default_size(GTK_WINDOW(AboutDlg), 200, 400);
	gtk_window_set_resizable(GTK_WINDOW(AboutDlg), FALSE);
//	gdk_window_set_icon(AboutDlg->window, NULL, global->icon_pixmap,
//			global->icon_mask);
	g_signal_connect_swapped(G_OBJECT(AboutDlg), "response",
			G_CALLBACK(gtk_widget_destroy), G_OBJECT(AboutDlg));

	/* Create a VBox with a border */
	VBox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(VBox), 10);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(AboutDlg)->vbox), VBox);

	/* name */
	text = g_strdup_printf("<span size=\"xx-large\"><b>GtkAtlantic %s</b></span>", VERSION);

	Label = gtk_label_new(text);
	gtk_label_set_use_markup(GTK_LABEL(Label), TRUE);
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE,
			FALSE, 5);

	g_free(text);

	/* web site */
	Label = gtk_label_new("http://gtkatlantic.sourceforge.net");
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE,	FALSE, 5);

	/* license */
	Label = gtk_label_new("This software is distributed under the GPL Version 2 or any later version");
	gtk_label_set_line_wrap(GTK_LABEL(Label), TRUE);
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE,	FALSE, 10);

	/* author */
	Label = gtk_label_new("<b>Authors:</b>");
	gtk_label_set_use_markup(GTK_LABEL(Label), TRUE);
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE, FALSE, 0);

	Label = gtk_label_new("Sylvain Rochet (gradator@gradator.net)");
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE, FALSE, 0);
	Label = gtk_label_new("Xavier Amado (xavier@blackbloodstudios.com)");
        gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE, FALSE, 0);

	/* IRC */
	Label = gtk_label_new("irc.freenode.net #gtkatlantic");
	gtk_box_pack_start(GTK_BOX(VBox), Label, FALSE, FALSE, 10);

	gtk_widget_show_all(AboutDlg);
}


/* create config panel */
void interface_create_config_panel()  {

	//global->ConfigWin;
		GtkWidget *vbox;
			GtkWidget *hbox;
				GtkWidget *Frame;
					GtkWidget *hboxFrame;
						GtkWidget *vboxFrame;
							GtkWidget *Label;
							GtkWidget *CButton;
							GtkWidget *Entry;
							GtkWidget *Combo;
							GtkObject *Adjust;
								GtkWidget *Scale;
		GtkWidget *Button;

	GList *list;
	gchar *text;

	if(global->ConfigWin)  return;

	global->ConfigWin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(global->ConfigWin), "GtkAtlantic: Configuration");
	gtk_window_set_policy(GTK_WINDOW(global->ConfigWin), FALSE, TRUE, TRUE);
	gtk_widget_realize(global->ConfigWin);
	gdk_window_set_icon(global->ConfigWin->window, NULL, global->icon_pixmap, global->icon_mask);
	gtk_signal_connect(GTK_OBJECT(global->ConfigWin), "delete_event", (GtkSignalFunc)gtk_widget_destroy, NULL);
	gtk_signal_connect(GTK_OBJECT(global->ConfigWin), "destroy", (GtkSignalFunc)CallBack_configwindow_destroyed, NULL);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), BORDER);
	gtk_container_add(GTK_CONTAINER(global->ConfigWin), vbox);


	/* PLAYER CONFIG (such has nickname) */
	Frame = gtk_frame_new("Player");
	gtk_container_set_border_width(GTK_CONTAINER(Frame), BORDER);
	gtk_box_pack_start(GTK_BOX(vbox), Frame, FALSE, FALSE, 0);

	vboxFrame = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxFrame), BORDER);
	gtk_container_add(GTK_CONTAINER(Frame), vboxFrame);

	hboxFrame = gtk_hbox_new(FALSE, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, FALSE, 0);

	Label = gtk_label_new("Nickname");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, FALSE, FALSE, 0);
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_player_nickname", Entry);
	gtk_entry_set_text(GTK_ENTRY(Entry), config->nickname);

	/* horizontal box for metaserver & another server */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);


	/* METASERVER */
	Frame = gtk_frame_new("Meta Server");
	gtk_container_set_border_width(GTK_CONTAINER(Frame), BORDER);
	gtk_box_pack_start(GTK_BOX(hbox), Frame, TRUE, TRUE, 0);

	vboxFrame = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxFrame), BORDER);
	gtk_container_add(GTK_CONTAINER(Frame), vboxFrame);

	hboxFrame = gtk_hbox_new(FALSE, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, TRUE, 0);

	Label = gtk_label_new("host/port");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Entry = gtk_entry_new();
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_metaserver_host", Entry);
	gtk_entry_set_text(GTK_ENTRY(Entry), config->metaserver_host);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, TRUE, TRUE, 0);

	Entry = gtk_entry_new();
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_metaserver_port", Entry);
	text = g_strdup_printf("%d", config->metaserver_port);
	gtk_entry_set_text(GTK_ENTRY(Entry), text);
	g_free(text);
	gtk_widget_set_usize(Entry, 45, 0);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, FALSE, FALSE, 0);

	CButton = gtk_check_button_new_with_label("Check new releases of GtkAtlantic");
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_metaserver_sendclientversion", CButton);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CButton), config->metaserver_sendclientversion);
	gtk_box_pack_start(GTK_BOX(vboxFrame), CButton, FALSE, FALSE, 0);

	CButton = gtk_check_button_new_with_label("Get servers list automatically");
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_metaserver_autogetlist", CButton);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CButton), config->metaserver_autogetlist);
	gtk_box_pack_start(GTK_BOX(vboxFrame), CButton, FALSE, FALSE, 0);

	CButton = gtk_check_button_new_with_label("Get games list automatically");
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_metaserver_autogetgames", CButton);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CButton), config->metaserver_autogetgames);
	gtk_box_pack_start(GTK_BOX(vboxFrame), CButton, FALSE, FALSE, 0);


	/* DEFAULT ANOTHER SERVER */
	Frame = gtk_frame_new("Default Another Server");
	gtk_container_set_border_width(GTK_CONTAINER(Frame), BORDER);
	gtk_box_pack_start(GTK_BOX(hbox), Frame, TRUE, TRUE, 0);

	vboxFrame = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxFrame), BORDER);
	gtk_container_add(GTK_CONTAINER(Frame), vboxFrame);

	hboxFrame = gtk_hbox_new(FALSE, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, TRUE, 0);

	Label = gtk_label_new("host/port");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Entry = gtk_entry_new();
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_anotherserver_host", Entry);
	gtk_entry_set_text(GTK_ENTRY(Entry), config->getgames_host);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, TRUE, TRUE, 0);

	Entry = gtk_entry_new();
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_anotherserver_port", Entry);
	text = g_strdup_printf("%d", config->getgames_port);
	gtk_entry_set_text(GTK_ENTRY(Entry), text);
	g_free(text);
	gtk_widget_set_usize(Entry, 45, 0);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, FALSE, FALSE, 0);

	CButton = gtk_check_button_new_with_label("Get games list automatically");
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_anotherserver_autogetgames", CButton);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CButton), config->getgames_autogetgames);
	gtk_box_pack_start(GTK_BOX(vboxFrame), CButton, FALSE, FALSE, 0);


	/* SERVER MESSAGE BUFFER SIZE */
	Frame = gtk_frame_new("Buffer Sizes");
	gtk_container_set_border_width(GTK_CONTAINER(Frame), BORDER);
	gtk_box_pack_start(GTK_BOX(vbox), Frame, FALSE, TRUE, 0);

	vboxFrame = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxFrame), BORDER);
	gtk_container_add(GTK_CONTAINER(Frame), vboxFrame);

	hboxFrame = gtk_hbox_new(FALSE, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, FALSE, 0);

	Label = gtk_label_new("Server Messages : ");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Entry = gtk_entry_new();
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_buffersize_servermessages", Entry);
	text = g_strdup_printf("%d", config->message_max_lines);
	gtk_entry_set_text(GTK_ENTRY(Entry), text);
	g_free(text);
	gtk_widget_set_usize(Entry, 45, 0);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, FALSE, FALSE, 0);

	Label = gtk_label_new("lines (0=Unlimited)");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	hboxFrame = gtk_hbox_new(FALSE, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, FALSE, 0);

	Label = gtk_label_new("Chat : ");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Entry = gtk_entry_new();
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_buffersize_chat", Entry);
	text = g_strdup_printf("%d", config->chat_max_lines);
	gtk_entry_set_text(GTK_ENTRY(Entry), text);
	g_free(text);
	gtk_widget_set_usize(Entry, 45, 0);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Entry, FALSE, FALSE, 0);

	Label = gtk_label_new("lines (0=Unlimited)");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);


	/* INTERFACE GAME CONFIG */
	Frame = gtk_frame_new("Game Interface");
	gtk_container_set_border_width(GTK_CONTAINER(Frame), BORDER);
	gtk_box_pack_start(GTK_BOX(vbox), Frame, FALSE, FALSE, 0);

	vboxFrame = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vboxFrame), BORDER);
	gtk_container_add(GTK_CONTAINER(Frame), vboxFrame);

	hboxFrame = gtk_hbox_new(FALSE, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, FALSE, 0);

	Label = gtk_label_new("Display player list at ");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Combo = gtk_combo_new();
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_gameinterface_playerlistposition", GTK_COMBO(Combo)->entry );
	gtk_widget_set_usize(Combo, 60, 0);
	gtk_editable_set_editable( GTK_EDITABLE(GTK_COMBO(Combo)->entry), FALSE);
	gtk_box_pack_start(GTK_BOX(hboxFrame), Combo, FALSE, FALSE, 0);

	list = NULL;
	list = g_list_append(list, "left");
	list = g_list_append(list, "right");
	gtk_combo_set_popdown_strings(GTK_COMBO(Combo), list);
	gtk_combo_set_use_arrows_always(GTK_COMBO(Combo), TRUE);
	g_list_free(list);

	if(config->game_playerlist_position == GAME_PLAYERLIST_POS_LEFT)
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(Combo)->entry), "left");
	else
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(Combo)->entry), "right");


	hboxFrame = gtk_hbox_new(FALSE, BORDER);
	gtk_box_pack_start(GTK_BOX(vboxFrame), hboxFrame, FALSE, FALSE, 0);

	Label = gtk_label_new("Token speed (in ms per estate) : ");
	gtk_box_pack_start(GTK_BOX(hboxFrame), Label, FALSE, FALSE, 0);

	Adjust = gtk_adjustment_new (config->game_token_animation_speed, 25, 500, 25, 25, 0);
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_gameinterface_tokenanimatespeed", Adjust);
	Scale = gtk_hscale_new (GTK_ADJUSTMENT(Adjust));
	gtk_widget_set_usize(Scale, 200, 0);
	gtk_scale_set_value_pos (GTK_SCALE (Scale), GTK_POS_TOP);
	gtk_scale_set_digits (GTK_SCALE (Scale), 0);
	gtk_box_pack_start (GTK_BOX (hboxFrame), Scale, FALSE, FALSE, 0);

	CButton = gtk_check_button_new_with_label("Show in transparency the tokens of players who are not moving now");
	gtk_object_set_data(GTK_OBJECT(global->ConfigWin), "config_gameinterface_tokentransparency", CButton);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(CButton), config->game_token_transparency);
	gtk_box_pack_start(GTK_BOX(vboxFrame), CButton, FALSE, FALSE, 0);

	/* CANCEL/OK BUTTON */
	/* horizontal box buttons */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, TRUE, 0);

	Button = gtk_button_new_with_label("CANCEL");
	gtk_widget_set_usize(Button, 130, 45);
	gtk_container_set_border_width(GTK_CONTAINER(Button), 10);
	gtk_box_pack_start(GTK_BOX(hbox), Button, TRUE, FALSE, 0);
	gtk_signal_connect_object(GTK_OBJECT(Button), "clicked", (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(global->ConfigWin) );

	Button = gtk_button_new_with_label("OK");
	gtk_widget_set_usize(Button, 130, 45);
	gtk_container_set_border_width(GTK_CONTAINER(Button), 10);
	gtk_box_pack_start(GTK_BOX(hbox), Button, TRUE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(Button), "clicked", (GtkSignalFunc)CallBack_ok_button_configwindow, NULL);

	gtk_widget_show_all(global->ConfigWin);
}


/* create the little window change nickname */
void interface_create_nicknamewin()  {

	GtkWidget *NicknameWin;
		GtkWidget *HBox;
			GtkWidget *Entry;
			GtkWidget *Label;

	NicknameWin = gtk_dialog_new_with_buttons("GtkAtlantic: Nickname",
			GTK_WINDOW(global->MainWin), GTK_DIALOG_MODAL,
			GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);

//	gtk_window_set_policy(GTK_WINDOW(NicknameWin), FALSE, FALSE, TRUE);
//	gtk_widget_realize(NicknameWin);
//	gdk_window_set_icon(NicknameWin->window, NULL, global->icon_pixmap, global->icon_mask);
//	gtk_signal_connect(GTK_OBJECT(NicknameWin), "delete_event", (GtkSignalFunc)gtk_widget_destroy, NULL);

	HBox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(HBox), 10);
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(NicknameWin)->vbox), HBox);

	Label = gtk_label_new("Nickname:");
	gtk_box_pack_start(GTK_BOX(HBox), Label, FALSE, FALSE, 5);

	Entry = gtk_entry_new();
	gtk_widget_set_usize(Entry, 150, 0);
	gtk_object_set_data(GTK_OBJECT(NicknameWin), "nickname", Entry);
	gtk_entry_set_text(GTK_ENTRY(Entry), global->player[ get_player_slot_with_playerid(game->my_playerid) ].name);
	gtk_box_pack_start(GTK_BOX(HBox), Entry, TRUE, TRUE, 0);

	gtk_signal_connect(GTK_OBJECT(NicknameWin), "response", G_CALLBACK(CallBack_response_changenick_window), NicknameWin);

	gtk_widget_show_all(NicknameWin);
}


/* create estates tree */
void interface_create_estates_tree()  {

	GtkWidget *EstateWin;
		GtkWidget *HBox;
			GtkWidget *ScrollWin;
				GtkWidget *EstateTree;
			GtkWidget *VBox;
				GtkWidget *Alignment;
					GtkWidget *Label;

	GtkCTreeNode *GroupNodes[MAX_GROUPS];
	GtkCTreeNode *OtherNode;
	guint32 i;
	gchar *tmp[10];

	if(game->WinEstateTree)  return;

	for(i = 0 ; i < MAX_GROUPS ; i++)
		GroupNodes[i] = 0;

	game->WinEstateTree = EstateWin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(EstateWin, 450, 400);
	gtk_window_set_title(GTK_WINDOW(EstateWin), "GtkAtlantic: Estates Tree");
	gtk_window_set_policy(GTK_WINDOW(EstateWin), TRUE, TRUE, TRUE);
	gtk_widget_realize(game->WinEstateTree);
	gdk_window_set_icon(game->WinEstateTree->window, NULL, global->icon_pixmap, global->icon_mask);
	gtk_signal_connect(GTK_OBJECT(EstateWin), "delete_event", (GtkSignalFunc)gtk_widget_destroy, NULL);
	gtk_signal_connect(GTK_OBJECT(EstateWin), "destroy", (GtkSignalFunc)CallBack_EstateTree_Destroyed, NULL);

	HBox = gtk_hbox_new(FALSE, 0);
	gtk_object_set_data(GTK_OBJECT(game->WinEstateTree), "parent_box", HBox);
//	gtk_container_set_border_width(GTK_CONTAINER(HBox), 10);
	gtk_container_add(GTK_CONTAINER(EstateWin), HBox);

	/* ScrollWin win */
	ScrollWin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollWin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(ScrollWin, 250, 0);
	gtk_box_pack_start(GTK_BOX(HBox), ScrollWin, FALSE, TRUE, 0);

	/* estate tree */
	EstateTree = gtk_ctree_new(1, 0);
	gtk_signal_connect(GTK_OBJECT(EstateTree), "tree_select_row", (GtkSignalFunc)CallBack_EstateTree_SelectRow, NULL);
	gtk_signal_connect(GTK_OBJECT(EstateTree), "tree_unselect_row", (GtkSignalFunc)CallBack_EstateTree_UnSelectRow,NULL);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ScrollWin), EstateTree);

	/* create groups node */
	for(i = 0 ; i < MAX_GROUPS ; i++)  {

		if(! game->group[i].name)  continue;

		tmp[0] = g_strdup_printf("%s", game->group[i].name);
		GroupNodes[i] = gtk_ctree_insert_node(GTK_CTREE(EstateTree), NULL, NULL, tmp, 0, NULL, NULL, NULL, NULL, FALSE, TRUE);
		gtk_ctree_node_set_selectable(GTK_CTREE(EstateTree), GroupNodes[i], FALSE);
		g_free(tmp[0]);
	}

	tmp[0] = g_strdup_printf("other");
	OtherNode = gtk_ctree_insert_node(GTK_CTREE(EstateTree), NULL, NULL, tmp, 0, NULL, NULL, NULL, NULL, FALSE, FALSE);
	gtk_ctree_node_set_selectable(GTK_CTREE(EstateTree), OtherNode, FALSE);
	g_free(tmp[0]);


	/* create estates node */
	for(i = 0 ; i < data->number_estates ; i++)  {

		gint32 group;
		GtkCTreeNode *node;
		gchar *data;

		group = game->estate[i].group;

		/* create group node if was not created */
		if(group >= 0  &&  ! GroupNodes[group])  {

			tmp[0] = g_strdup_printf("%s", game->group[group].name);
			GroupNodes[group] = gtk_ctree_insert_node(GTK_CTREE(EstateTree), NULL, NULL, tmp, 0, NULL, NULL, NULL, NULL, FALSE, TRUE);
			gtk_ctree_node_set_selectable(GTK_CTREE(EstateTree), GroupNodes[group], FALSE);
			g_free(tmp[0]);
		}

		tmp[0] = g_strdup_printf("%s", game->estate[i].name);
		if(group >= 0)
			node = gtk_ctree_insert_node(GTK_CTREE(EstateTree), GroupNodes[group], NULL, tmp, 0, NULL, NULL, NULL, NULL, FALSE, TRUE);
		else
			node = gtk_ctree_insert_node(GTK_CTREE(EstateTree), OtherNode, NULL, tmp, 0, NULL, NULL, NULL, NULL, FALSE, TRUE);
		g_free(tmp[0]);

		data = g_strdup_printf("%d", i);
		gtk_ctree_node_set_row_data_full(GTK_CTREE(EstateTree), node, (gpointer)data, g_free);
	}


	/* info box */
	VBox = gtk_vbox_new(FALSE, 0);
	gtk_object_set_data(GTK_OBJECT(game->WinEstateTree), "info_box", VBox);
	gtk_container_set_border_width(GTK_CONTAINER(VBox), 10);
	gtk_box_pack_start(GTK_BOX(HBox), VBox, TRUE, TRUE, 0);

	/* default text */
	Alignment = gtk_alignment_new(0.0, 0.0, 0.0, 0.0);
	gtk_box_pack_start(GTK_BOX(VBox), Alignment, FALSE, TRUE, 0);
	Label = gtk_label_new("Select an estate...");
	gtk_container_add(GTK_CONTAINER(Alignment), Label);


	gtk_widget_show_all(EstateWin);
}


/* create help window */
void interface_create_helpwin()  {

	GtkWidget *HelpWin;
		GtkWidget *Scrolled;
			GtkWidget *text;
				GtkTextBuffer *textbuff;
				GtkTextIter textiter;

	FILE *file;
	gchar *filename, *data, *complete, *tmp;
	gint32 len;

	if(global->HelpWin)  return;

	/* open help file */
	filename = g_strconcat(PACKAGE_DATA_DIR, "/help.index", NULL);
	file = fopen(filename, "rt");
	g_free(filename);

	if(!file)  return;


	global->HelpWin = HelpWin = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(HelpWin, 500, 400);
	gtk_window_set_title(GTK_WINDOW(HelpWin), "GtkAtlantic: Help");
	gtk_window_set_policy(GTK_WINDOW(HelpWin), TRUE, TRUE, TRUE);
	gtk_widget_realize(global->HelpWin);
	gdk_window_set_icon(global->HelpWin->window, NULL, global->icon_pixmap, global->icon_mask);
	gtk_signal_connect(GTK_OBJECT(HelpWin), "delete_event", (GtkSignalFunc)gtk_widget_destroy, NULL);
	gtk_signal_connect(GTK_OBJECT(HelpWin), "destroy", (GtkSignalFunc)CallBack_HelpWin_Destroyed, NULL);

	Scrolled = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(Scrolled), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(global->HelpWin), Scrolled);

	/* Create the text view */
	text = gtk_text_view_new();
	gtk_text_view_set_editable(GTK_TEXT_VIEW(text), FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(text), GTK_WRAP_CHAR);
	gtk_container_add(GTK_CONTAINER(Scrolled), text);

	/* put help file */
	data = g_malloc0(1024);
	complete = g_strdup("");

	while( (len = fread(data, 1, 1000, file)) > 0)  {

		data[len] = '\0';

		tmp = complete;
		complete = g_strconcat(complete, data, NULL);
		g_free(tmp);
	}

	fclose(file);
	g_free(data);

	textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	gtk_text_buffer_get_end_iter(textbuff, &textiter);
	gtk_text_buffer_insert(textbuff, &textiter, complete, strlen(complete));

	g_free(complete);

	gtk_widget_show_all(HelpWin);
}


/* put gameclist in correct mode for display games */
void gameclist_title_showgames()  {

	/* fields show are:
		[0] "host"
		[1] "version"
		[2] "game"
		[3] "description"
		[4] "players"
 	   fields hide are:
		[5] "port"
		[6] "gametype"
		[7] "gameid"
	*/

	if(global->mode_gameclist != GAMECLIST_MODE_GAMELIST)  {

		gtk_clist_clear(GTK_CLIST(global->GameCList));

		gtk_clist_set_column_title(GTK_CLIST(global->GameCList), 0, "Host");
		gtk_clist_set_column_title(GTK_CLIST(global->GameCList), 1, "Version");
		gtk_clist_set_column_title(GTK_CLIST(global->GameCList), 2, "Game");
		gtk_clist_set_column_title(GTK_CLIST(global->GameCList), 3, "Description");
		gtk_clist_set_column_title(GTK_CLIST(global->GameCList), 4, "Players");

		gtk_clist_set_column_visibility(GTK_CLIST(global->GameCList), 4, TRUE);

		global->mode_gameclist = GAMECLIST_MODE_GAMELIST;

		gtk_clist_column_titles_passive(GTK_CLIST(global->GameCList));
	}
}


/* put gameclist in correct mode for display servers */
void gameclist_title_showservers()  {

	if(global->mode_gameclist != GAMECLIST_MODE_SERVERLIST)  {

		gtk_clist_clear(GTK_CLIST(global->GameCList));

		gtk_clist_set_column_title(GTK_CLIST(global->GameCList), 0, "Host");
		gtk_clist_set_column_title(GTK_CLIST(global->GameCList), 1, "Port");
		gtk_clist_set_column_title(GTK_CLIST(global->GameCList), 2, "Version");
		gtk_clist_set_column_title(GTK_CLIST(global->GameCList), 3, "Users");

		gtk_clist_set_column_visibility(GTK_CLIST(global->GameCList), 4, FALSE);

		global->mode_gameclist = GAMECLIST_MODE_SERVERLIST;

		gtk_clist_column_titles_passive(GTK_CLIST(global->GameCList));
	}
}


/* generic window with a label into */
void interface_create_messagewin(gchar *msg)  {

/*	GtkWidget *MessageWin;
		GtkWidget *VBox;
			GtkWidget *Alignment;
				GtkWidget *Label;
				GtkWidget *Button;


	MessageWin = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(MessageWin), "GtkAtlantic: Message");
	gtk_window_set_policy(GTK_WINDOW(MessageWin), FALSE, FALSE, TRUE);
	gtk_window_set_position(GTK_WINDOW(MessageWin), GTK_WIN_POS_CENTER);
	gtk_window_set_transient_for(GTK_WINDOW(MessageWin), GTK_WINDOW(global->MainWin));
	gtk_window_set_modal(GTK_WINDOW(MessageWin), TRUE);
	gtk_widget_set_usize(MessageWin, 0, 0);
	gtk_signal_connect(GTK_OBJECT(MessageWin), "delete_event", (GtkSignalFunc)gtk_widget_destroy, NULL);

	VBox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(VBox), 10);
	gtk_container_add(GTK_CONTAINER(MessageWin), VBox);
*/
	/* text  */
/*	Label = gtk_label_new(msg);
	gtk_label_set_line_wrap(GTK_LABEL(Label), TRUE);
	gtk_box_pack_start(GTK_BOX(VBox), Label, TRUE, TRUE, 0);
*/
	/* ok button */
/*	Alignment = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
	gtk_widget_set_usize(Alignment, 0, 50);
	gtk_box_pack_start(GTK_BOX(VBox), Alignment, FALSE, FALSE, 0);

	Button = gtk_button_new_with_label("OK");
	gtk_widget_set_usize(Button, 70, 0);
	gtk_container_add(GTK_CONTAINER(Alignment), Button);

	gtk_signal_connect_object(GTK_OBJECT(Button), "clicked", (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT(MessageWin) );

	gtk_widget_show_all(MessageWin);
*/
}



/* when receive event: redraw an estate */
void on_board_expose (GtkWidget *widget, GdkEventExpose *event)   {

	gchar *ptr = gtk_object_get_data(GTK_OBJECT(widget), "estateid");

	game->estate[ atoi(ptr) ].redraw = TRUE;
}

/* when receive event: redraw player token */
void on_playertoken_expose (GtkWidget *widget, GdkEventExpose *event)   {

	gchar *ptr = gtk_object_get_data(GTK_OBJECT(widget), "player");

	global->player[ atoi(ptr) ].playerlist_token_redraw = TRUE;
}

/* when receive event: redraw player cards */
void on_playercards_expose (GtkWidget *widget, GdkEventExpose *event)   {

	gchar *ptr = gtk_object_get_data(GTK_OBJECT(widget), "player");

	global->player[ atoi(ptr) ].playerlist_cards_redraw = TRUE;
}


/* when receive event: redraw logo */
void on_logo_expose (GtkWidget *widget, GdkEventExpose *event)   {

	global->logo_redraw = TRUE;
}


/* when receive event: redraw theme preview */
void on_theme_preview_expose (GtkWidget *widget, GdkEventExpose *event)   {

	global->theme_redraw = TRUE;
}


/* update display */
gboolean update_display() {

//	test_frequency();

	update_display_theme_preview();

	if(global->phase == PHASE_LOGO)  update_display_logo();
	if(global->phase == PHASE_GAMEPLAY)  update_display_game();

	return(TRUE);
}


/* update display of the theme page */
void update_display_theme_preview()  {

	gchar *ptr;
	GtkWidget *Preview;
	guint32 width, height;

	if(! global->ThemeWin) return;

	if(global->theme_redraw)  {

		ptr = gtk_object_get_data(GTK_OBJECT(global->ThemeWin), "theme_preview_image");
		Preview = gtk_object_get_data(GTK_OBJECT(global->ThemeWin), "theme_preview_data");
		width = atoi( gtk_object_get_data(GTK_OBJECT(global->ThemeWin), "theme_preview_width") );
		height = atoi( gtk_object_get_data(GTK_OBJECT(global->ThemeWin), "theme_preview_height") );

		gdk_draw_rgb_image (Preview->window, Preview->style->fg_gc[GTK_STATE_NORMAL], 0, 0, width, height, GDK_RGB_DITHER_MAX, (guchar*)ptr, width * 3);
		global->theme_redraw = FALSE;
	}
}


/* update display of the logo page */
void update_display_logo()  {

	guint32 frameid;
	gpointer draw_ptr;


	if(global->phase != PHASE_LOGO) return;


	/* draw logo */
	frameid = global->logo_frame;
	eng_create_frame(frameid);

	if(global->logo_redraw  ||  eng_zone_is_modified(frameid, 0, 0, data->logo_width -1, data->logo_height -1) )  {

		draw_ptr = eng_get_zone(frameid, 0, 0, data->logo_width -1, data->logo_height -1);
		gdk_draw_rgb_image (global->gdkrgb_logo->window,  global->gdkrgb_logo->style->fg_gc[GTK_STATE_NORMAL],  10,  10,  data->logo_width,  data->logo_height,  GDK_RGB_DITHER_MAX,  draw_ptr,  data->logo_width * 3);

		global->logo_redraw = FALSE;
	}
}


/* update display of the game page */
void update_display_game()   {

	guint32 i, j, frameid;
	guint16 draw_x1, draw_y1, draw_x2, draw_y2, draw_width, draw_height;
	gpointer draw_ptr;


	if(global->phase != PHASE_GAMEPLAY) return;


	/* draw the board */
	frameid = game->board_frame;
	eng_create_frame(frameid);

	for(i = 0 ; i < data->number_estates ; i++)  {

		if(! game->estate[i].gdkrgb) continue;
		if(! frameid) continue;

		j = data->estate[i].buffer_board;

		draw_x1 = data->estate[i].x;
		draw_y1 = data->estate[i].y;
		draw_width = data->pngfile_board_width[j];
		draw_height = data->pngfile_board_height[j];
		draw_x2 = draw_x1 + draw_width -1;
		draw_y2 = draw_y1 + draw_height -1;

		if(game->estate[i].redraw  ||  eng_zone_is_modified(frameid, draw_x1, draw_y1, draw_x2, draw_y2) )  {

			draw_ptr = eng_get_zone(frameid, draw_x1, draw_y1, draw_x2, draw_y2);
			gdk_draw_rgb_image (game->estate[i].gdkrgb->window,  game->estate[i].gdkrgb->style->fg_gc[GTK_STATE_NORMAL],  0,  0,  draw_width,  draw_height,  GDK_RGB_DITHER_MAX,  draw_ptr,  draw_width * 3);

			game->estate[i].redraw = FALSE;
		}
	}


	/* draw playerlist */
	for(i = 0 ; i < MAX_PLAYERS ; i++)  {

		if(! global->player[i].playerid) continue;
		if(global->player[i].game != game->gameid)  continue;
		if(! global->player[i].playerlist_cards_gdkrgb) continue;

		/* playerlist cards */
		frameid = global->player[i].playerlist_cards_frame;
		if(! frameid) continue;
		eng_create_frame(frameid);

		if(global->player[i].playerlist_cards_redraw  ||  eng_zone_is_modified(frameid, 0, 0, data->playerlist_cards_width -1, data->playerlist_cards_height -1) )  {

			draw_ptr = eng_get_zone(frameid, 0, 0, data->playerlist_cards_width -1, data->playerlist_cards_height -1);
			gdk_draw_rgb_image (global->player[i].playerlist_cards_gdkrgb->window,  global->player[i].playerlist_cards_gdkrgb->style->fg_gc[GTK_STATE_NORMAL],  0,  0,  data->playerlist_cards_width,  data->playerlist_cards_height,  GDK_RGB_DITHER_MAX,  draw_ptr,  data->playerlist_cards_width * 3);

			global->player[i].playerlist_cards_redraw = FALSE;
		}


		/* playerlist token */
		frameid = global->player[i].playerlist_token_frame;
		eng_create_frame(frameid);

		if(global->player[i].playerlist_token_redraw  ||  eng_zone_is_modified(frameid, 0, 0, data->playerlist_token_width -1, data->playerlist_token_height -1) )  {

			draw_ptr = eng_get_zone(frameid, 0, 0, data->playerlist_token_width -1, data->playerlist_token_height -1);
			gdk_draw_rgb_image (global->player[i].playerlist_token_gdkrgb->window,  global->player[i].playerlist_token_gdkrgb->style->fg_gc[GTK_STATE_NORMAL],  0,  0,  data->playerlist_token_width,  data->playerlist_token_height,  GDK_RGB_DITHER_MAX,  draw_ptr,  data->playerlist_token_width * 3);

			global->player[i].playerlist_token_redraw = FALSE;
		}
	}
}
