/*
 *     gtkatlantic - the gtk+ monopd client, enjoy network monopoly games
 *
 *
 *  Copyright (C) 2002-2010 Rochet Sylvain
 *
 *  gtkatlantic is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include <gtk/gtk.h>

#include "global.h"

#include "display.h"
#include "callback.h"


void display_hide()  {

	GtkWidget *vbox;

	vbox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter");
	if(vbox)  gtk_widget_hide(vbox);
}


void display_unhide()  {

	GtkWidget *vbox;

	vbox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter");
	if(vbox)  gtk_widget_show_all(vbox);
}


void display_clear_all()  {

	GtkWidget *vbox;

	display_clear_title();
	display_clear_text();
	gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "boardcenter_text", 0);
	display_clear_buttons();

	vbox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter");
	if(vbox)  gtk_widget_destroy(vbox);
	gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "boardcenter", 0);
}


void display_clear_title() {

	GtkWidget *titlebox;

	titlebox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter_title");
	if(titlebox)  gtk_widget_destroy(titlebox);
	gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "boardcenter_title", 0);
}


void display_clear_text() {

	GtkWidget *text;

	text = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter_text");
	if(text)  {
		GtkTextBuffer *textbuff;
		GtkTextIter startiter, enditer;
		
		textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
//		gtk_text_buffer_get_start_iter(txtbuff, &startiter);
//		gtk_text_buffer_get_end_iter(txtbuff, &enditer);
		gtk_text_buffer_get_bounds(textbuff, &startiter, &enditer);

		gtk_text_buffer_delete(textbuff, &startiter, &enditer);
	}
}


void display_clear_buttons()  {

	GtkWidget *buttonsbox;

	buttonsbox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter_buttons");
	if(buttonsbox)  gtk_widget_destroy(buttonsbox);
	gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "boardcenter_buttons", 0);
}


void display_init()  {

	GtkWidget *vbox;

	vbox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter");
	if(!vbox)  {
		vbox = gtk_vbox_new(FALSE, 15);
		gtk_container_set_border_width(GTK_CONTAINER(vbox), 15);
		gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "boardcenter", vbox);
		gtk_box_pack_start(GTK_BOX(game->BoardCenter), vbox, TRUE, TRUE, 0);

		gtk_widget_show_all(vbox);
	}
}


void display_estate(gint32 estateid)  {

	GtkWidget *titlebox;
	gchar *estate = 0;
	gchar *text;

	titlebox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter_title");
	if(titlebox) estate = gtk_object_get_data(GTK_OBJECT(titlebox), "boardcenter_estate_displayed");

	if(titlebox  &&  estate  &&  atoi(estate) == estateid)
		return;

	if(estate  &&  atoi(estate) != estateid)
		display_clear_title();


	/* create estate title */
	display_title(game->estate[estateid].name);

	titlebox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter_title");
	text = g_strdup_printf("%d", estateid);
	gtk_object_set_data_full(GTK_OBJECT(titlebox), "boardcenter_estate_displayed", text, g_free);
}


void display_title(gchar *title) {

	GtkWidget *Alignement;
		GtkWidget *Label;

	GtkWidget *vbox;
	GtkWidget *titlebox;
	gchar *text2, *text3;
	gint32 i, len;

	titlebox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter_title");
	vbox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter");

	if(titlebox)  display_clear_title();


	/* create estate title */
	titlebox = gtk_vbox_new(FALSE, 0);
	gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "boardcenter_title", titlebox);
	gtk_box_pack_start(GTK_BOX(vbox), titlebox, FALSE, TRUE, 0);
	gtk_box_reorder_child(GTK_BOX(vbox), titlebox, 0);

	for(text2 = title ; (len = strlen(text2) ) > 0 ; )   {

		/* search lenght of string (word wrapping) */
		if(len > MAX_ROW_LENGTH_TITLE_ESTATE)
			for(i = MAX_ROW_LENGTH_TITLE_ESTATE ; i >= 0 ; i--)  {

				if(!i) {
					i = MAX_ROW_LENGTH_TITLE_ESTATE;
					break;
				}

				if(text2[i] == ' ')  break;
			}
		else i = len;

		Alignement = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
		gtk_box_pack_start(GTK_BOX(titlebox), Alignement, FALSE, FALSE, 0);

		text3 = g_strndup(text2, i);
		Label = gtk_label_new(text3);
		g_free(text3);
		gtk_label_set_line_wrap(GTK_LABEL(Label), TRUE);
		gtk_container_add(GTK_CONTAINER(Alignement), Label);
		if(global->style_estate_title)
			gtk_widget_set_style(Label, global->style_estate_title);

		text2 += i;
	}

	gtk_widget_show_all(titlebox);
}


void display_text(gchar *message) {

	GtkWidget *vbox;
	GtkWidget *text;
	GtkTextBuffer *textbuff;
	GtkTextIter textiter;
	GtkWidget *scrolledwin;

	guint32 i, len;
	gchar *data, *msg, *tmp, *chr;

	vbox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter");

	text = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter_text");

	/* build text entry */
	if(!text)  {
		text = gtk_text_view_new();
		gtk_text_view_set_editable(GTK_TEXT_VIEW(text), FALSE);
		gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(text), GTK_WRAP_WORD);
		textbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
		gtk_text_buffer_get_end_iter(textbuff, &textiter);
		gtk_text_buffer_create_mark(textbuff, "endmark", &textiter, FALSE);	
		gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "boardcenter_text", text);

		scrolledwin = gtk_scrolled_window_new(NULL,NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwin), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

		gtk_box_pack_start(GTK_BOX(vbox), scrolledwin, TRUE, TRUE, 0);
		gtk_container_add(GTK_CONTAINER(scrolledwin), text);

		gtk_widget_show_all(text);
	}

	/* convert special chr */
	data = g_strdup_printf("%s\n", message);
	msg = g_strdup("");

	for(len = strlen(data), i = 0 ; i < len ; i++)  {

		chr = g_strndup(data +i, 1);

		if(! strncmp(data +i, "&amp;", 5) ) {

			chr[0] = '&';
			i += 4;
		}

		tmp = msg;
		msg = g_strconcat(msg, chr, NULL);
		g_free(chr);
		g_free(tmp);
	}
	g_free(data);

	/* fill with text */
	GtkTextBuffer *txtbuff;
	GtkTextIter txtiter;
	
	txtbuff = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
	gtk_text_buffer_get_end_iter(txtbuff, &txtiter);

	gtk_text_buffer_insert(txtbuff, &txtiter, msg, strlen(msg));

	g_free(msg);
}


void display_button(gchar *caption, gchar *command, gboolean enabled) {

	GtkWidget *vbox;
	GtkWidget *buttonsbox;
		GtkWidget *Button;

	gchar *text;

	vbox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter");
	buttonsbox = gtk_object_get_data(GTK_OBJECT(game->BoardCenter), "boardcenter_buttons");

	/* build button box if not created */
	if(!buttonsbox)   {

		buttonsbox = gtk_hbox_new(FALSE, 15);
		gtk_object_set_data(GTK_OBJECT(game->BoardCenter), "boardcenter_buttons", buttonsbox);
		gtk_box_pack_end(GTK_BOX(vbox), buttonsbox, FALSE, TRUE, 0);

		gtk_widget_show_all(buttonsbox);
	}

	/* build button */
	Button = gtk_button_new_with_label( caption );
	gtk_box_pack_start(GTK_BOX(buttonsbox), Button, TRUE, TRUE, 0);

	text = g_strdup_printf("%s\n", command );
	gtk_object_set_data_full(GTK_OBJECT(Button), "command", text, g_free);
	gtk_signal_connect(GTK_OBJECT(Button), "clicked", (GtkSignalFunc)CallBack_button_command_pressed, NULL);

	if(! enabled)  gtk_widget_set_sensitive(Button, FALSE);

	gtk_widget_show_all(Button);
}

