/******************************************************************************/
/* smooth_gtk1_rc.h - RC Declarations for GTK1 Engine                         */
/******************************************************************************/
/* Smooth Theme Engine                                                        */
/* Copyright (C) 2002-2004 Andrew Johnson                                     */
/*                                                                            */
/* This library is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU Lesser General Public                 */
/* License as published by the Free Software Foundation; either               */
/* version 2.1 of the License, or (at your option) any later version.         */
/*                                                                            */
/* This library is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          */
/* Lesser General Public License for more details.                            */
/*                                                                            */
/* You should have received a copy of the GNU Lesser General Public           */
/* License along with this library; if not, write to the Free Software        */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  */
/*                                                                            */
/* Author(s): Andrew Johnson <ajgenius@ajgenius.us>                           */
/******************************************************************************/
/* Portions Based on the EnGradient Engine                                    */
/*   Andrew Cattau                                                            */
/*                                                                            */
/* Portions Based on the Xenophilia Engine                                    */
/*   Johan Hanson <misagon@bahnhof.se>                                        */
/******************************************************************************/
#ifndef SMOOTH_GTK1_RC_H
#define SMOOTH_GTK1_RC_H

#include <engines/shared/gtk/smooth_gtk_rc.h>

#define PANED_HANDLE_SIZE(style)(THEME_DATA(style)->paned_handle_size)
#define FOCUS_INTERIOR(style)(THEME_DATA(style)->focus.interior)
#define FOCUS_WIDTH(style)(THEME_DATA(style)->focus.width)
#define FOCUS_PAD(style)(THEME_DATA(style)->focus.pad)

#define RANGE_SLIDER_WIDTH(style)(THEME_DATA(style)->range.slider_width)
#define RANGE_TROUGH_BORDER(style)(THEME_DATA(style)->range.trough_border)
#define RANGE_STEPPER_SIZE(style)(THEME_DATA(style)->range.stepper_size)
#define RANGE_STEPPER_SPACING(style)(THEME_DATA(style)->range.stepper_spacing)
  
#define SCALE_SLIDER_LENGTH(style)(THEME_DATA(style)->scale.slider_length)

#define SCROLLBAR_MIN_SLIDER_LENGTH(style)(THEME_DATA(style)->scrollbar.min_slider_length)

struct _smooth_focus_style{
  gboolean interior;
  gint width;
  gint pad;

  gboolean use_foreground[5];/* SmoothWidgetState */
  SmoothColor foreground[5];/* SmoothWidgetState */

  gchar * pattern[5];/* GtkStateType */

  gboolean use_line_width[5];/* GtkStateType */
  gint line_width[5];/* GtkStateType */
};

typedef struct
{
  gint			  refcount;
  
  gboolean buffered_fill;

  gboolean		  real_sliders;
  gboolean		  resize_grip;
  
  SmoothColorCube         colors;
  SmoothFillPart	  fill;
  SmoothLinePart	  line;
  smooth_edge_style	  edge;

  smooth_focus_style	  focus;

  smooth_bg_style	  background;
  smooth_fg_style	  foreground;

  smooth_trough_style     trough;
  SmoothStepperStyle      stepper;

  smooth_part_style       progress;

  smooth_grip_style	  grip;
  smooth_check_style	  check;
  smooth_check_style	  option;
  SmoothArrowPart	  arrow;
  smooth_button_style	  button;
  smooth_tab_style	  tabs;

  struct {
    gint slider_width;
    gint trough_border;
    gint stepper_size;
    gint stepper_spacing;
  } range;

  struct {
    gint slider_length;
  } scale;

  struct {
    gint min_slider_length;
  } scrollbar;

  gint			  xthickness;
  gint			  ythickness;

  guint16		  paned_handle_size;

} SmoothRcStyle;

extern ThemeSymbols gtk1_theme_symbols[];
extern guint n_gtk1_theme_symbols;

void smooth_rc_style_init (SmoothRcStyle *style);

void
smooth_gtkrc_style_merge (SmoothRcStyle *dest_data,
                          SmoothRcStyle *src_data);

guint
smooth_gtkrc_parse(GScanner   *Scanner,
			SmoothRcStyle *Style,
			guint Token);

typedef struct
{
  gchar * class_name;
  gchar * property_name;
  GtkArg value;
} SmoothRcProperty;

#define is_enum(str, value)  (g_strncasecmp(str, value, strlen(value)) == 0)

guint 
theme_parse_pixmap(GScanner *scanner, 
                   GTokenType wanted_token, 
                   gchar *default_value,
                   GString **retval);
                   
#endif /*SMOOTH_GTK1_RC*/
