/******************************************************************************/
/* smooth_gtk1_misc.h - Misc Functions for GTK1 Engine                        */
/******************************************************************************/
/* Smooth Theme Engine                                                        */
/* Copyright (C) 2002-2004 Andrew Johnson                                     */
/*                                                                            */
/* This library is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU Lesser General Public                 */
/* License as published by the Free Software Foundation; either               */
/* version 2.1 of the License, or (at your option) any later version.         */
/*                                                                            */
/* This library is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          */
/* Lesser General Public License for more details.                            */
/*                                                                            */
/* You should have received a copy of the GNU Lesser General Public           */
/* License along with this library; if not, write to the Free Software        */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  */
/*                                                                            */
/* Author(s): Andrew Johnson <ajgenius@ajgenius.us>                           */
/******************************************************************************/
/* Portions Based on GTK+                                                     */
/*   Peter Mattis <petm@xcf.berkeley.edu>                                     */
/*   Spencer Kimball <spencer@xcf.berkeley.edu>                               */
/*   Josh MacDonald <jmacd@xcf.berkeley.edu>                                  */
/*                                                                            */
/* Portions Based on the EnGradient Engine                                    */
/*   Andrew Cattau                                                            */
/*                                                                            */
/* Portions Based on the XFCE Engine                                          */
/*   Olivier Fourdan <fourdan@xfce.org>                                       */
/*                                                                            */
/* Portions Based on the Xenophilia Engine                                    */
/*   Johan Hanson <misagon@bahnhof.se>                                        */
/******************************************************************************/
#ifndef SMOOTH_GTK1_MISC_H
#define SMOOTH_GTK1_MISC_H

#include <engines/shared/gtk/smooth_gtk_misc.h>

#ifndef max
#define max(x,y) ((x)>=(y)?(x):(y))
#endif
#ifndef min
#define min(x,y) ((x)<=(y)?(x):(y))
#endif

#ifndef M_PI
  #define M_PI    3.14159265358979323846
#endif

#ifndef M_PI_4
  #define M_PI_4  0.78539816339744830962
#endif

#define gtk_range_get_value(range) gtk_range_get_adjustment(range)->value
#define gtk_range_get_inverted(range) FALSE

#define gtk_widget_get_parent(widget) (((widget) && (widget->parent))?widget->parent:NULL)

/* Widget Type Lookups/Macros */
#define IS_HANDLE_BOX_ITEM(object) ((widget) && (widget->parent) && GTK_IS_HANDLE_BOX(widget->parent))
#define IS_BONOBO_DOCK_ITEM(object) ((widget) && widget_is_a (widget, "BonoboDockItem"))
#define IS_BONOBO_TOOLBAR(object) ((widget) && widget_is_a (widget, "BonoboUIToolbar"))
#define IS_EGG_TOOLBAR(object) ((widget) && widget_is_a (widget, "Toolbar"))
#define IS_PANEL_WIDGET(object) ((widget) && widget_is_a (widget, "PanelWidget"))
#define IS_COMBO(object) ((widget) && widget_is_a (widget, "GtkCombo"))
#define IS_SPIN_BUTTON(object) ((widget) && widget_is_a (widget, "GtkSpinButton"))
#define IS_OPTION_MENU(object) ((widget) && widget_is_a (widget, "GtkOptionMenu"))

gboolean widget_is_a (GtkWidget * widget, gchar * type_name);
gboolean is_toolbar_item (GtkWidget * widget);
gboolean is_panel_widget_item (GtkWidget * widget);
gboolean is_combo (GtkWidget * widget);
gboolean is_in_combo_box (GtkWidget * widget);

/* Misc Functions/Macros */
#define xthickness(style) (((GtkStyle *)style)->klass->xthickness)
#define ythickness(style) (((GtkStyle *)style)->klass->ythickness)

#define CHECK_DETAIL(detail, value) ((detail) && (!strcmp(value, detail)))
#define FUZZY_COMPARE(i, j, fudge) ((i>j)?(i - j <= fudge):(j - i <= fudge))

GdkBitmap * arc_clip_mask(gint width, gint height);
#define clip_mask_unref gdk_pixmap_unref

gboolean sanitize_parameters(GtkStyle * style, GdkWindow * window, gint * width, gint * height);

/* Notebook Tab Info */
GtkWidget * get_notebook_page(GtkWidget * widget);
GtkWidget * get_tab_label(GtkWidget *page, GtkWidget * widget);

gboolean widget_is_tab_label(GtkWidget *page, GtkWidget * widget);
gboolean tab_label_is_current_page(GtkWidget *page, GtkWidget * widget);

/* Arrow Sizing Workarounds */
void reverse_engineer_arrow_box(GtkWidget *widget, const gchar * detail, GtkArrowType arrow_type, gint *x, gint *y, gint *width, gint *height);

#endif /* SMOOTH_GTK1_MISC_H */
