// GtkSharp.Generation.EnumGen.cs - The Enumeration Generatable.
//
// Author: Mike Kestner <mkestner@speakeasy.net>
//
// Copyright (c) 2001 Mike Kestner
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the GNU General Public
// License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.


namespace GtkSharp.Generation {

	using System;
	using System.Collections;
	using System.IO;
	using System.Xml;

	public class EnumGen : GenBase {
		
		string enum_type = String.Empty;
		ArrayList members = new ArrayList ();

		public EnumGen (XmlElement ns, XmlElement elem) : base (ns, elem) 
		{
			foreach (XmlElement member in elem.ChildNodes) {
				if (member.Name != "member")
					continue;

				string result = "\t\t" + member.GetAttribute("name");
				if (member.HasAttribute("value")) {
					string value = member.GetAttribute("value");
					if (value.EndsWith("U")) {
						enum_type = " : uint";
						value = value.TrimEnd('U');
					}
					result += " = " + value;
				}
				members.Add (result + ",");
			}
		}

		
		public override string MarshalType {
			get {
				return "int";
			}
		}

		public override string CallByName (string var_name)
		{
			return "(int) " + var_name;
		}
		
		public override string FromNative(string var)
		{
			return "(" + QualifiedName + ") " + var;
		}
		
		public override void Generate (GenerationInfo gen_info)
		{
			StreamWriter sw = gen_info.OpenStream (Name);

			sw.WriteLine ("namespace " + NS + " {");
			sw.WriteLine ();
			sw.WriteLine ("\tusing System;");
			sw.WriteLine ();

			if (Elem.GetAttribute("type") == "flags") {
				sw.WriteLine ();
				sw.WriteLine ("\t[Flags]");
			}

			sw.WriteLine ("#region Autogenerated code");
					
			sw.WriteLine ("\tpublic enum " + Name + enum_type + " {");
			sw.WriteLine ();
				
			foreach (string member in members)
				sw.WriteLine (member);

			sw.WriteLine ("\t}");
			sw.WriteLine ("#endregion");
			sw.WriteLine ("}");
			sw.Close ();
			Statistics.EnumCount++;
		}
		
	}
}

