# maps_page.py
#
# Copyright 2024 Christopher Talbot
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from gi.repository import Adw
from gi.repository import Gtk
from gi.repository import Shumate

import gtk_meshtastic_client.maps_marker as maps_marker

@Gtk.Template(resource_path='/org/kop316/meshtastic/ui/maps_page.ui')
class MapsPageBin(Adw.Bin):
    __gtype_name__ = 'MapsPageBin'

    simple_map = Gtk.Template.Child()
    first_load = False
    longitude_avg = 0
    longitude_num = 0
    longitude_sum = 0
    latitude_avg = 0
    latitude_num = 0
    latitude_sum = 0

    def longitude_running_avg(self, longitude):
        self.longitude_sum += longitude
        self.longitude_num += 1
        self.longitude_avg = self.longitude_sum/self.longitude_num

    def latitude_running_avg(self, latitude):
        self.latitude_sum += latitude
        self.latitude_num += 1
        self.latitude_avg = self.latitude_sum/self.latitude_num

    def reset_map(self):
        self.marker_layer.remove_all()
        self.longitude_avg = 0
        self.longitude_num = 0
        self.longitude_sum = 0
        self.latitude_avg = 0
        self.latitude_num = 0
        self.latitude_sum = 0
        self.first_load = False

    def goto_map(self, lat, lng, zoom):
        goto_map = self.simple_map.get_map()
        goto_map.go_to_full(lat, lng, zoom)

    def goto_map_first_load(self, lat, lng):
        if not self.first_load:
            self.first_load = True
            self.goto_map(lat, lng, 12)

    def goto_map_avg_first_load(self):
        """
        Don't bother trying to update lat and long if there's no entries
        """
        if not self.first_load and self.latitude_avg != 0 and self.longitude_avg != 0:
            self.first_load = True
            self.goto_map(self.latitude_avg, self.longitude_avg, 10)

    def add_marker_to_map(self, marker):
        self.marker_layer.add_marker (marker)

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        app = Gtk.Application.get_default()
        self.logger = app.logger

        self.registry = Shumate.MapSourceRegistry.new_with_defaults()
        map_source = self.registry.get_by_id(Shumate.MAP_SOURCE_OSM_MAPNIK)
        self.simple_map.set_map_source(map_source)

        viewport = self.simple_map.get_viewport()

        self.marker_layer = Shumate.MarkerLayer.new(viewport)
        self.simple_map.add_overlay_layer(self.marker_layer)
