# Gtk Meshtastic Client

An unofficial client for Meshtastic devices in GTK4/Libadwaita.

<div align="center">
  <img src="https://gitlab.com/kop316/gtk-meshtastic-client/-/raw/main/data/screenshot/dark_mode.png?inline=false" width="300" >
  <img src="https://gitlab.com/kop316/gtk-meshtastic-client/-/raw/main/data/screenshot/map.png?inline=false" width="300" >
</div>

Built on APIs from the official [python API](https://github.com/meshtastic/python),
some [examples](https://github.com/pdxlocations/Meshtastic-Python-Examples).

Generating new [key pairs](https://github.com/mate71pl/meshtastic-info/blob/master/security_key.py).

Some information on it from [postmarketOS](https://wiki.postmarketos.org/wiki/Meshtastic)

## License
Unless otherwise specified, all code is licensed under the
[GPL Version 3 or later](https://www.gnu.org/licenses/gpl-3.0.en.html), and all
other images/data is licensed under  Creative Commons
Attribution-ShareAlike 4.0 International [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).

Meshtastic is a Trademark of [Meshtastic LLC](https://meshtastic.org/docs/legal/licensing-and-trademark/),
and they do not endorse or sponsor this project.

Logo from alaraajavamma and is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/).

Map Marker Logo from [libshumate](https://gitlab.gnome.org/GNOME/libshumate/) and is licensed under LGPL 2.1+.

### Install dependencies

On a Debian based system run

``` bash
    sudo apt-get -y install build-essential
    sudo apt-get -y build-dep .
```

For an explicit list of dependencies check the Build-Depends entry in the
[debian/control](https://gitlab.com/kop316/gtk-meshtastic-client/-/blob/main/debian/control)
file.

## Compiling
To prepare/configure the project for compilation:

    # meson setup _build

However, if you want to install it, run

    # meson setup _build -Dprefix=/usr --sysconfdir=/etc

`--sysconfdir=/etc` will install the autostart file in the correct place, and
`-Dprefix=/usr` installs `vvmplayer` in `/usr/bin/` rather than `/usr/local/bin`

To build the project:

    # meson compile -C _build

## Running

If you wish to run the project without installing, you can run the following
command after compiling in the project root directory:

    # ./_build/gtk_meshtastic_client/local-meshtastic-client

## Command Line Options

`-v`: show version and exit
`-d`: enable debug output


## Installing

Install:

    # meson install -C _build

    (Install may require sudo or root privileges).

Uninstall:

    # ninja uninstall -C _build/

    (Uninstall may require sudo or root privileges).
