/*  Gtalk basic configuration
 *
 *  Copyright (C) 1994, 1995, 1996, 1997, 1998 Free Software Foundation
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, you can either send email to this
 *  program's author (see below) or write to:
 * 
 *               The Free Software Foundation, Inc.
 *               675 Mass Ave.
 *               Cambridge, MA 02139, USA. 
 * 
 *  Please send bug reports, etc. to zappo@gnu.org.
 * 
 * $Not Id: config.h,v 1.2 1994/08/29 23:14:46 zappo Exp zappo $ config.h
 *
 * config.h was moved to acconfig.h for use with autoheader
 *
 * $Id: acconfig.h,v 1.19 1998/10/17 01:46:28 zappo Exp $
 *
 * Configuration variables to for setting up gtalk to be compiled
 */
#ifndef CONFIG_H
#define CONFIG_H

/* Here are a couple useful things
 */
#define True 1
#define False 0

/* Load in the current version of this distribution
 */
#undef VERSION
#undef PACKAGE

/* Put this in hear to shutup autoheader
 */
#undef EIEIO_VERSION

/* The following lists of sizes are defined as a checkup.  The headers
 * otalk.h, talk.h, and gtalk.h must declair the messages to be these
 * sizes, or conflicts will occur, and the binary will not initialize.
 *
 * DO NOT OVERRIDE!!  These are static on all systems.
 */
#define OTALK_CM_SIZE 76
#define OTALK_CMR_SIZE 24
#define NTALK_CM_SIZE 84
#define NTALK_CMR_SIZE 24
#define GTALK_CM_SIZE 84
#define GTALK_CMR_SIZE 36

/*
 * Define PROTOTYPES if your system can handle C prototypes of the form
 * type functioname(int parameter);  I provide this to enable
 * debugging from compilers which can handle it.
 */
#undef PROTOTYPES

/* 
 * Define DEBUG_2 if you want tons o debug messages.
#define DEBUG_2
 */

@TOP@

/*
 * Define the options (Otalk only, etc)
 */
#undef OTALK_ONLY
#undef TALKDTEST
#undef GTALK_SERVICE

/*
 * Define this if we have a toolkit
 */
#define athena "athena"
#define lesstif "lesstif"
#define gtk "gtk"
#define gnome "gnome"
/*#define openlook "open-look"*/
#undef X_TOOLKIT
/*
 * Define this if we use curses
 */
#define curses "curses"
#define ncurses "ncurses"
#undef USE_CURSES
#undef CURSES_TAG

/*
 * Some curses define maxx in a WINDOW, not _maxx.  Hmmm.
 */
#undef CURSES_MAXX
#if CURSES_MAXX == maxx
#define _maxx maxx
#define _maxy maxy
#define _curx curx
#define _cury cury
#endif
/*
 * And define this if the above two don't exist!
 */
#ifndef X_TOOLKIT
#ifndef USE_CURSES
#define NO_IFACE
#endif
#endif

/*
 * Define options for struct utmp.  Set this to ut_user, or ut_name
 * depending on how you access a username in /etc/utmp.
 * Next, if UTMP file is not defined by the system, then define it
 * ourselves to point to /etc/utmp.  (Where it usually is)
 */
#undef UT_USER_OR_NAME
#undef UTMP_FILE

/*
 * Define the number of parameters needed by openlog.  Linux and
 * others have 3, but others like ultrix only have 2
 */
#undef NUM_OPENLOG_PARAMETERS

/* PW_FULL_NAME
 * This defines how to determine a users full name from the password
 * structure.  It should be pw_gecos on most systems, but if that is
 * absent, then substitude pw_name instead.  If your system uses
 * something else, let me know and I'll update my configure script.
 */
#undef PW_FULL_NAME

/* 
 * Now define all HAVE_ macros for use by autoconf.
 */

@BOTTOM@

#include "headers.h"

#endif /* CONFIG_H */
