
/* autogenerated from gstvideoconvertorc.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union
{
  orc_int16 i;
  orc_int8 x2[2];
} orc_union16;
typedef union
{
  orc_int32 i;
  float f;
  orc_int16 x2[2];
  orc_int8 x4[4];
} orc_union32;
typedef union
{
  orc_int64 i;
  double f;
  orc_int32 x2[2];
  float x2f[2];
  orc_int16 x4[4];
} orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void cogorc_memcpy_2d (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_I420_UYVY (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n);
void cogorc_convert_I420_YUY2 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n);
void cogorc_convert_I420_AYUV (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n);
void cogorc_convert_YUY2_I420 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3,
    guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n);
void cogorc_convert_UYVY_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_planar_chroma_420_422 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m);
void cogorc_planar_chroma_420_444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m);
void cogorc_planar_chroma_422_444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_planar_chroma_444_422 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_planar_chroma_444_420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void cogorc_planar_chroma_422_420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void cogorc_convert_YUY2_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_UYVY_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_YUY2_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_UYVY_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_YUY2_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_UYVY_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_UYVY_I420 (guint8 * ORC_RESTRICT d1,
    guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3,
    guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n);
void cogorc_convert_AYUV_I420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, guint8 * ORC_RESTRICT d4, int d4_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void cogorc_convert_AYUV_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_AYUV_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_AYUV_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_AYUV_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_Y42B_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void cogorc_convert_Y42B_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void cogorc_convert_Y42B_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void cogorc_convert_Y444_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void cogorc_convert_Y444_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void cogorc_convert_Y444_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void cogorc_convert_AYUV_ARGB (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_AYUV_BGRA (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_AYUV_ABGR (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_AYUV_RGBA (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void cogorc_convert_I420_BGRA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n);
void cogorc_convert_I420_BGRA_avg (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, int n);
void cogorc_getline_I420 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n);
void cogorc_getline_YUV9 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n);
void cogorc_getline_YUY2 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_getline_UYVY (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_getline_YVYU (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_getline_Y42B (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n);
void cogorc_getline_Y444 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n);
void cogorc_getline_Y800 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_getline_Y16 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_getline_BGRA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_getline_ABGR (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_getline_RGBA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_getline_NV12 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void cogorc_getline_NV21 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void cogorc_getline_A420 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n);
void cogorc_putline_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_YUY2 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_YVYU (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_UYVY (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_Y42B (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_Y444 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_Y800 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_Y16 (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_BGRA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_ABGR (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_RGBA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_NV12 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_NV21 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n);
void cogorc_putline_A420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4,
    const guint8 * ORC_RESTRICT s1, int n);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* cogorc_memcpy_2d */
#ifdef DISABLE_ORC
void
cogorc_memcpy_2d (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_cogorc_memcpy_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
    }
  }

}

void
cogorc_memcpy_2d (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_memcpy_2d");
      orc_program_set_backup_function (p, _backup_cogorc_memcpy_2d);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_I420_UYVY */
#ifdef DISABLE_ORC
void
cogorc_convert_I420_UYVY (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *) d1;
  ptr1 = (orc_union32 *) d2;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[0];
      _dest.x2[1] = var35.x2[0];
      var36.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[1];
      _dest.x2[1] = var35.x2[1];
      var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[0];
      _dest.x2[1] = var37.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[1];
      _dest.x2[1] = var37.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

#else
static void
_backup_cogorc_convert_I420_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr1 = (orc_union32 *) ex->arrays[1];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[0];
      _dest.x2[1] = var35.x2[0];
      var36.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[1];
      _dest.x2[1] = var35.x2[1];
      var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[0];
      _dest.x2[1] = var37.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var39.x2[1];
      _dest.x2[1] = var37.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

void
cogorc_convert_I420_UYVY (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_convert_I420_UYVY");
      orc_program_set_backup_function (p, _backup_cogorc_convert_I420_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_S2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_I420_YUY2 */
#ifdef DISABLE_ORC
void
cogorc_convert_I420_YUY2 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *) d1;
  ptr1 = (orc_union32 *) d2;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var35.x2[0];
      _dest.x2[1] = var39.x2[0];
      var36.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var35.x2[1];
      _dest.x2[1] = var39.x2[1];
      var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var39.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var39.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

#else
static void
_backup_cogorc_convert_I420_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr1 = (orc_union32 *) ex->arrays[1];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var35.x2[0];
      _dest.x2[1] = var39.x2[0];
      var36.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var35.x2[1];
      _dest.x2[1] = var39.x2[1];
      var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var39.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var39.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

void
cogorc_convert_I420_YUY2 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_convert_I420_YUY2");
      orc_program_set_backup_function (p, _backup_cogorc_convert_I420_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D2, ORC_VAR_S2, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_I420_AYUV */
#ifdef DISABLE_ORC
void
cogorc_convert_I420_AYUV (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union32 var41;
  orc_int8 var42;
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  ptr0 = (orc_union32 *) d1;
  ptr1 = (orc_union32 *) d2;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 8: loadpb */
  var39 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var42 = ptr6[i >> 1];
    /* 1: loadupdb */
    var43 = ptr7[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var42;
      _dest.x2[1] = var43;
      var44.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var45.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var45.i;
      _dest.x2[1] = var44.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
    /* 9: loadb */
    var40 = ptr5[i];
    /* 10: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var46.i = _dest.i;
    }
    /* 11: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var46.i;
      _dest.x2[1] = var44.i;
      var41.i = _dest.i;
    }
    /* 12: storel */
    ptr1[i] = var41;
  }

}

#else
static void
_backup_cogorc_convert_I420_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  orc_union32 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union32 var41;
  orc_int8 var42;
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr1 = (orc_union32 *) ex->arrays[1];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 8: loadpb */
  var39 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var42 = ptr6[i >> 1];
    /* 1: loadupdb */
    var43 = ptr7[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var42;
      _dest.x2[1] = var43;
      var44.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var45.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var45.i;
      _dest.x2[1] = var44.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
    /* 9: loadb */
    var40 = ptr5[i];
    /* 10: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var46.i = _dest.i;
    }
    /* 11: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var46.i;
      _dest.x2[1] = var44.i;
      var41.i = _dest.i;
    }
    /* 12: storel */
    ptr1[i] = var41;
  }

}

void
cogorc_convert_I420_AYUV (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_convert_I420_AYUV");
      orc_program_set_backup_function (p, _backup_cogorc_convert_I420_AYUV);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T3, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_YUY2_I420 */
#ifdef DISABLE_ORC
void
cogorc_convert_YUY2_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union32 *ORC_RESTRICT ptr4;
  const orc_union32 *ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr3 = (orc_int8 *) d4;
  ptr4 = (orc_union32 *) s1;
  ptr5 = (orc_union32 *) s2;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var35.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var35.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var40;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var41.x2[0] = _src.x2[1];
      var42.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var41.x2[1] = _src.x2[1];
      var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var42;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var41.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var41.x2[1] + 1) >> 1;
    /* 7: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var37 = _src.x2[1];
      var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

#else
static void
_backup_cogorc_convert_YUY2_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union32 *ORC_RESTRICT ptr4;
  const orc_union32 *ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr3 = (orc_int8 *) ex->arrays[3];
  ptr4 = (orc_union32 *) ex->arrays[4];
  ptr5 = (orc_union32 *) ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var35.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var35.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var40;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var41.x2[0] = _src.x2[1];
      var42.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var41.x2[1] = _src.x2[1];
      var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var42;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8) var39.x2[0] + (orc_uint8) var41.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var39.x2[1] + (orc_uint8) var41.x2[1] + 1) >> 1;
    /* 7: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var37 = _src.x2[1];
      var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

void
cogorc_convert_YUY2_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_convert_YUY2_I420");
      orc_program_set_backup_function (p, _backup_cogorc_convert_YUY2_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 1, "d4");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D4, ORC_VAR_D3, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_UYVY_YUY2 */
#ifdef DISABLE_ORC
void
cogorc_convert_UYVY_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var32 = ptr4[i];
      /* 1: swapw */
      var33.x2[0] = ORC_SWAP_W (var32.x2[0]);
      var33.x2[1] = ORC_SWAP_W (var32.x2[1]);
      /* 2: storel */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_cogorc_convert_UYVY_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var32 = ptr4[i];
      /* 1: swapw */
      var33.x2[0] = ORC_SWAP_W (var32.x2[0]);
      var33.x2[1] = ORC_SWAP_W (var32.x2[1]);
      /* 2: storel */
      ptr0[i] = var33;
    }
  }

}

void
cogorc_convert_UYVY_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_UYVY_YUY2");
      orc_program_set_backup_function (p, _backup_cogorc_convert_UYVY_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_planar_chroma_420_422 */
#ifdef DISABLE_ORC
void
cogorc_planar_chroma_420_422 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
      /* 3: loadb */
      var34 = ptr4[i];
      /* 4: copyb */
      var35 = var34;
      /* 5: storeb */
      ptr1[i] = var35;
    }
  }

}

#else
static void
_backup_cogorc_planar_chroma_420_422 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
      /* 3: loadb */
      var34 = ptr4[i];
      /* 4: copyb */
      var35 = var34;
      /* 5: storeb */
      ptr1[i] = var35;
    }
  }

}

void
cogorc_planar_chroma_420_422 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_planar_chroma_420_422");
      orc_program_set_backup_function (p, _backup_cogorc_planar_chroma_420_422);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D2, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_planar_chroma_420_444 */
#ifdef DISABLE_ORC
void
cogorc_planar_chroma_420_444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33 & 0xff) << 8) | (var33 & 0xff);
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: storew */
      ptr1[i] = var34;
    }
  }

}

#else
static void
_backup_cogorc_planar_chroma_420_444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33 & 0xff) << 8) | (var33 & 0xff);
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: storew */
      ptr1[i] = var34;
    }
  }

}

void
cogorc_planar_chroma_420_444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1,
    int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_planar_chroma_420_444");
      orc_program_set_backup_function (p, _backup_cogorc_planar_chroma_420_444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_planar_chroma_422_444 */
#ifdef DISABLE_ORC
void
cogorc_planar_chroma_422_444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33 & 0xff) << 8) | (var33 & 0xff);
      /* 2: storew */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_cogorc_planar_chroma_422_444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33 & 0xff) << 8) | (var33 & 0xff);
      /* 2: storew */
      ptr0[i] = var34;
    }
  }

}

void
cogorc_planar_chroma_422_444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_planar_chroma_422_444");
      orc_program_set_backup_function (p, _backup_cogorc_planar_chroma_422_444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_planar_chroma_444_422 */
#ifdef DISABLE_ORC
void
cogorc_planar_chroma_444_422 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var34.i;
        var36 = _src.x2[1];
        var37 = _src.x2[0];
      }
      /* 2: avgub */
      var35 = ((orc_uint8) var36 + (orc_uint8) var37 + 1) >> 1;
      /* 3: storeb */
      ptr0[i] = var35;
    }
  }

}

#else
static void
_backup_cogorc_planar_chroma_444_422 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var34.i;
        var36 = _src.x2[1];
        var37 = _src.x2[0];
      }
      /* 2: avgub */
      var35 = ((orc_uint8) var36 + (orc_uint8) var37 + 1) >> 1;
      /* 3: storeb */
      ptr0[i] = var35;
    }
  }

}

void
cogorc_planar_chroma_444_422 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_planar_chroma_444_422");
      orc_program_set_backup_function (p, _backup_cogorc_planar_chroma_444_422);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");

      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_planar_chroma_444_420 */
#ifdef DISABLE_ORC
void
cogorc_planar_chroma_444_420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var35;
  orc_union16 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_int8 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var35 = ptr4[i];
      /* 1: loadw */
      var36 = ptr5[i];
      /* 2: avgub */
      var38.x2[0] =
          ((orc_uint8) var35.x2[0] + (orc_uint8) var36.x2[0] + 1) >> 1;
      var38.x2[1] =
          ((orc_uint8) var35.x2[1] + (orc_uint8) var36.x2[1] + 1) >> 1;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var38.i;
        var39 = _src.x2[1];
        var40 = _src.x2[0];
      }
      /* 4: avgub */
      var37 = ((orc_uint8) var39 + (orc_uint8) var40 + 1) >> 1;
      /* 5: storeb */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_cogorc_planar_chroma_444_420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var35;
  orc_union16 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_int8 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var35 = ptr4[i];
      /* 1: loadw */
      var36 = ptr5[i];
      /* 2: avgub */
      var38.x2[0] =
          ((orc_uint8) var35.x2[0] + (orc_uint8) var36.x2[0] + 1) >> 1;
      var38.x2[1] =
          ((orc_uint8) var35.x2[1] + (orc_uint8) var36.x2[1] + 1) >> 1;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var38.i;
        var39 = _src.x2[1];
        var40 = _src.x2[0];
      }
      /* 4: avgub */
      var37 = ((orc_uint8) var39 + (orc_uint8) var40 + 1) >> 1;
      /* 5: storeb */
      ptr0[i] = var37;
    }
  }

}

void
cogorc_planar_chroma_444_420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_planar_chroma_444_420");
      orc_program_set_backup_function (p, _backup_cogorc_planar_chroma_444_420);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_planar_chroma_422_420 */
#ifdef DISABLE_ORC
void
cogorc_planar_chroma_422_420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8) var32 + (orc_uint8) var33 + 1) >> 1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_cogorc_planar_chroma_422_420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8) var32 + (orc_uint8) var33 + 1) >> 1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

void
cogorc_planar_chroma_422_420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_planar_chroma_422_420");
      orc_program_set_backup_function (p, _backup_cogorc_planar_chroma_422_420);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_YUY2_AYUV */
#ifdef DISABLE_ORC
void
cogorc_convert_YUY2_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 2: loadpb */
    var37.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var37.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var36.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var36.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 3: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var40.x2[0];
        var41.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var40.x2[1];
        var41.x2[1] = _dest.i;
      }
      /* 4: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var39.i;
        _dest.x2[1] = var39.i;
        var42.i = _dest.i;
      }
      /* 5: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[0];
        _dest.x2[1] = var42.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[1];
        _dest.x2[1] = var42.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_cogorc_convert_YUY2_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 2: loadpb */
    var37.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var37.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var36.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var36.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 3: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var40.x2[0];
        var41.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var40.x2[1];
        var41.x2[1] = _dest.i;
      }
      /* 4: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var39.i;
        _dest.x2[1] = var39.i;
        var42.i = _dest.i;
      }
      /* 5: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[0];
        _dest.x2[1] = var42.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[1];
        _dest.x2[1] = var42.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

void
cogorc_convert_YUY2_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_YUY2_AYUV");
      orc_program_set_backup_function (p, _backup_cogorc_convert_YUY2_AYUV);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_UYVY_AYUV */
#ifdef DISABLE_ORC
void
cogorc_convert_UYVY_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 2: loadpb */
    var37.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var37.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var36.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var36.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 3: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var39.x2[0];
        var41.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var39.x2[1];
        var41.x2[1] = _dest.i;
      }
      /* 4: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var40.i;
        _dest.x2[1] = var40.i;
        var42.i = _dest.i;
      }
      /* 5: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[0];
        _dest.x2[1] = var42.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[1];
        _dest.x2[1] = var42.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_cogorc_convert_UYVY_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 2: loadpb */
    var37.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var37.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var36.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var36.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 3: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var39.x2[0];
        var41.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var39.x2[1];
        var41.x2[1] = _dest.i;
      }
      /* 4: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var40.i;
        _dest.x2[1] = var40.i;
        var42.i = _dest.i;
      }
      /* 5: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[0];
        _dest.x2[1] = var42.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.x2[1];
        _dest.x2[1] = var42.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

void
cogorc_convert_UYVY_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_UYVY_AYUV");
      orc_program_set_backup_function (p, _backup_cogorc_convert_UYVY_AYUV);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_YUY2_Y42B */
#ifdef DISABLE_ORC
void
cogorc_convert_YUY2_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var33.x2[0];
        var37.x2[0] = _src.x2[1];
        var34.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var33.x2[1];
        var37.x2[1] = _src.x2[1];
        var34.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var37.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

#else
static void
_backup_cogorc_convert_YUY2_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var33.x2[0];
        var37.x2[0] = _src.x2[1];
        var34.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var33.x2[1];
        var37.x2[1] = _src.x2[1];
        var34.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var37.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

void
cogorc_convert_YUY2_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_YUY2_Y42B");
      orc_program_set_backup_function (p, _backup_cogorc_convert_YUY2_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_UYVY_Y42B */
#ifdef DISABLE_ORC
void
cogorc_convert_UYVY_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var33.x2[0];
        var34.x2[0] = _src.x2[1];
        var37.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var33.x2[1];
        var34.x2[1] = _src.x2[1];
        var37.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var37.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

#else
static void
_backup_cogorc_convert_UYVY_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var33.x2[0];
        var34.x2[0] = _src.x2[1];
        var37.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var33.x2[1];
        var34.x2[1] = _src.x2[1];
        var37.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var37.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

void
cogorc_convert_UYVY_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_UYVY_Y42B");
      orc_program_set_backup_function (p, _backup_cogorc_convert_UYVY_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_YUY2_Y444 */
#ifdef DISABLE_ORC
void
cogorc_convert_YUY2_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_union16 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var35.x2[0];
        var39.x2[0] = _src.x2[1];
        var36.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var35.x2[1];
        var39.x2[1] = _src.x2[1];
        var36.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var40 = _src.x2[1];
        var41 = _src.x2[0];
      }
      /* 4: splatbw */
      var37.i = ((var41 & 0xff) << 8) | (var41 & 0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40 & 0xff) << 8) | (var40 & 0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

#else
static void
_backup_cogorc_convert_YUY2_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_union16 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var35.x2[0];
        var39.x2[0] = _src.x2[1];
        var36.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var35.x2[1];
        var39.x2[1] = _src.x2[1];
        var36.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var40 = _src.x2[1];
        var41 = _src.x2[0];
      }
      /* 4: splatbw */
      var37.i = ((var41 & 0xff) << 8) | (var41 & 0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40 & 0xff) << 8) | (var40 & 0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

void
cogorc_convert_YUY2_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_YUY2_Y444");
      orc_program_set_backup_function (p, _backup_cogorc_convert_YUY2_Y444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 2, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D3, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_UYVY_Y444 */
#ifdef DISABLE_ORC
void
cogorc_convert_UYVY_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_union16 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var35.x2[0];
        var36.x2[0] = _src.x2[1];
        var39.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var35.x2[1];
        var36.x2[1] = _src.x2[1];
        var39.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var40 = _src.x2[1];
        var41 = _src.x2[0];
      }
      /* 4: splatbw */
      var37.i = ((var41 & 0xff) << 8) | (var41 & 0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40 & 0xff) << 8) | (var40 & 0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

#else
static void
_backup_cogorc_convert_UYVY_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_union16 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
        orc_union16 _src;
        _src.i = var35.x2[0];
        var36.x2[0] = _src.x2[1];
        var39.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var35.x2[1];
        var36.x2[1] = _src.x2[1];
        var39.x2[1] = _src.x2[0];
      }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var40 = _src.x2[1];
        var41 = _src.x2[0];
      }
      /* 4: splatbw */
      var37.i = ((var41 & 0xff) << 8) | (var41 & 0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40 & 0xff) << 8) | (var40 & 0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

void
cogorc_convert_UYVY_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_UYVY_Y444");
      orc_program_set_backup_function (p, _backup_cogorc_convert_UYVY_Y444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 2, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D3, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_UYVY_I420 */
#ifdef DISABLE_ORC
void
cogorc_convert_UYVY_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union32 *ORC_RESTRICT ptr4;
  const orc_union32 *ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr3 = (orc_int8 *) d4;
  ptr4 = (orc_union32 *) s1;
  ptr5 = (orc_union32 *) s2;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var35.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var35.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var39;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var41.x2[0] = _src.x2[1];
      var42.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var41.x2[1] = _src.x2[1];
      var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var41;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8) var40.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var40.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 7: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var37 = _src.x2[1];
      var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

#else
static void
_backup_cogorc_convert_UYVY_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union32 *ORC_RESTRICT ptr4;
  const orc_union32 *ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr3 = (orc_int8 *) ex->arrays[3];
  ptr4 = (orc_union32 *) ex->arrays[4];
  ptr5 = (orc_union32 *) ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var35.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var35.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var39;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var41.x2[0] = _src.x2[1];
      var42.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var41.x2[1] = _src.x2[1];
      var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var41;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8) var40.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var40.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 7: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var37 = _src.x2[1];
      var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

void
cogorc_convert_UYVY_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_convert_UYVY_I420");
      orc_program_set_backup_function (p, _backup_cogorc_convert_UYVY_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 1, "d4");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D4, ORC_VAR_D3, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_AYUV_I420 */
#ifdef DISABLE_ORC
void
cogorc_convert_AYUV_I420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, guint8 * ORC_RESTRICT d4, int d4_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union64 *ORC_RESTRICT ptr4;
  const orc_union64 *ORC_RESTRICT ptr5;
  orc_union64 var40;
  orc_union16 var41;
  orc_union64 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_int8 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_int8 var56;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr3 = ORC_PTR_OFFSET (d4, d4_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var40 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.x2[0];
        var46.x2[0] = _src.x2[1];
        var47.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var40.x2[1];
        var46.x2[1] = _src.x2[1];
        var47.x2[1] = _src.x2[0];
      }
      /* 2: select1wb */
      {
        orc_union16 _src;
        _src.i = var47.x2[0];
        var41.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var47.x2[1];
        var41.x2[1] = _src.x2[1];
      }
      /* 3: storew */
      ptr0[i] = var41;
      /* 4: loadq */
      var42 = ptr5[i];
      /* 5: splitlw */
      {
        orc_union32 _src;
        _src.i = var42.x2[0];
        var48.x2[0] = _src.x2[1];
        var49.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var42.x2[1];
        var48.x2[1] = _src.x2[1];
        var49.x2[1] = _src.x2[0];
      }
      /* 6: select1wb */
      {
        orc_union16 _src;
        _src.i = var49.x2[0];
        var43.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var49.x2[1];
        var43.x2[1] = _src.x2[1];
      }
      /* 7: storew */
      ptr1[i] = var43;
      /* 8: avgub */
      var50.x4[0] =
          ((orc_uint8) var46.x4[0] + (orc_uint8) var48.x4[0] + 1) >> 1;
      var50.x4[1] =
          ((orc_uint8) var46.x4[1] + (orc_uint8) var48.x4[1] + 1) >> 1;
      var50.x4[2] =
          ((orc_uint8) var46.x4[2] + (orc_uint8) var48.x4[2] + 1) >> 1;
      var50.x4[3] =
          ((orc_uint8) var46.x4[3] + (orc_uint8) var48.x4[3] + 1) >> 1;
      /* 9: splitwb */
      {
        orc_union16 _src;
        _src.i = var50.x2[0];
        var51.x2[0] = _src.x2[1];
        var52.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var50.x2[1];
        var51.x2[1] = _src.x2[1];
        var52.x2[1] = _src.x2[0];
      }
      /* 10: splitwb */
      {
        orc_union16 _src;
        _src.i = var52.i;
        var53 = _src.x2[1];
        var54 = _src.x2[0];
      }
      /* 11: avgub */
      var44 = ((orc_uint8) var53 + (orc_uint8) var54 + 1) >> 1;
      /* 12: storeb */
      ptr2[i] = var44;
      /* 13: splitwb */
      {
        orc_union16 _src;
        _src.i = var51.i;
        var55 = _src.x2[1];
        var56 = _src.x2[0];
      }
      /* 14: avgub */
      var45 = ((orc_uint8) var55 + (orc_uint8) var56 + 1) >> 1;
      /* 15: storeb */
      ptr3[i] = var45;
    }
  }

}

#else
static void
_backup_cogorc_convert_AYUV_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_int8 *ORC_RESTRICT ptr3;
  const orc_union64 *ORC_RESTRICT ptr4;
  const orc_union64 *ORC_RESTRICT ptr5;
  orc_union64 var40;
  orc_union16 var41;
  orc_union64 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_int8 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_int8 var56;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr3 = ORC_PTR_OFFSET (ex->arrays[3], ex->params[3] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var40 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.x2[0];
        var46.x2[0] = _src.x2[1];
        var47.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var40.x2[1];
        var46.x2[1] = _src.x2[1];
        var47.x2[1] = _src.x2[0];
      }
      /* 2: select1wb */
      {
        orc_union16 _src;
        _src.i = var47.x2[0];
        var41.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var47.x2[1];
        var41.x2[1] = _src.x2[1];
      }
      /* 3: storew */
      ptr0[i] = var41;
      /* 4: loadq */
      var42 = ptr5[i];
      /* 5: splitlw */
      {
        orc_union32 _src;
        _src.i = var42.x2[0];
        var48.x2[0] = _src.x2[1];
        var49.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var42.x2[1];
        var48.x2[1] = _src.x2[1];
        var49.x2[1] = _src.x2[0];
      }
      /* 6: select1wb */
      {
        orc_union16 _src;
        _src.i = var49.x2[0];
        var43.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var49.x2[1];
        var43.x2[1] = _src.x2[1];
      }
      /* 7: storew */
      ptr1[i] = var43;
      /* 8: avgub */
      var50.x4[0] =
          ((orc_uint8) var46.x4[0] + (orc_uint8) var48.x4[0] + 1) >> 1;
      var50.x4[1] =
          ((orc_uint8) var46.x4[1] + (orc_uint8) var48.x4[1] + 1) >> 1;
      var50.x4[2] =
          ((orc_uint8) var46.x4[2] + (orc_uint8) var48.x4[2] + 1) >> 1;
      var50.x4[3] =
          ((orc_uint8) var46.x4[3] + (orc_uint8) var48.x4[3] + 1) >> 1;
      /* 9: splitwb */
      {
        orc_union16 _src;
        _src.i = var50.x2[0];
        var51.x2[0] = _src.x2[1];
        var52.x2[0] = _src.x2[0];
      }
      {
        orc_union16 _src;
        _src.i = var50.x2[1];
        var51.x2[1] = _src.x2[1];
        var52.x2[1] = _src.x2[0];
      }
      /* 10: splitwb */
      {
        orc_union16 _src;
        _src.i = var52.i;
        var53 = _src.x2[1];
        var54 = _src.x2[0];
      }
      /* 11: avgub */
      var44 = ((orc_uint8) var53 + (orc_uint8) var54 + 1) >> 1;
      /* 12: storeb */
      ptr2[i] = var44;
      /* 13: splitwb */
      {
        orc_union16 _src;
        _src.i = var51.i;
        var55 = _src.x2[1];
        var56 = _src.x2[0];
      }
      /* 14: avgub */
      var45 = ((orc_uint8) var55 + (orc_uint8) var56 + 1) >> 1;
      /* 15: storeb */
      ptr3[i] = var45;
    }
  }

}

void
cogorc_convert_AYUV_I420 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, guint8 * ORC_RESTRICT d4, int d4_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_AYUV_I420");
      orc_program_set_backup_function (p, _backup_cogorc_convert_AYUV_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 1, "d4");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_source (p, 8, "s2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 1, "t7");
      orc_program_add_temporary (p, 1, "t8");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 2, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T6, ORC_VAR_T5, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D3, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D4, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->params[ORC_VAR_D4] = d4_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_AYUV_YUY2 */
#ifdef DISABLE_ORC
void
cogorc_convert_AYUV_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var37.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var37.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var39.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 3: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 4: select1wb */
      {
        orc_union16 _src;
        _src.i = var40.x2[0];
        var44.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var40.x2[1];
        var44.x2[1] = _src.x2[1];
      }
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var44.x2[0];
        _dest.x2[1] = var43.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var44.x2[1];
        _dest.x2[1] = var43.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_cogorc_convert_AYUV_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var37.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var37.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var39.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 3: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 4: select1wb */
      {
        orc_union16 _src;
        _src.i = var40.x2[0];
        var44.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var40.x2[1];
        var44.x2[1] = _src.x2[1];
      }
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var44.x2[0];
        _dest.x2[1] = var43.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var44.x2[1];
        _dest.x2[1] = var43.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

void
cogorc_convert_AYUV_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_AYUV_YUY2");
      orc_program_set_backup_function (p, _backup_cogorc_convert_AYUV_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_AYUV_UYVY */
#ifdef DISABLE_ORC
void
cogorc_convert_AYUV_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var37.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var37.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var39.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 3: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 4: select1wb */
      {
        orc_union16 _src;
        _src.i = var40.x2[0];
        var44.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var40.x2[1];
        var44.x2[1] = _src.x2[1];
      }
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[0];
        _dest.x2[1] = var44.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[1];
        _dest.x2[1] = var44.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_cogorc_convert_AYUV_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var37.x2[0];
        var39.x2[0] = _src.x2[1];
        var40.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var37.x2[1];
        var39.x2[1] = _src.x2[1];
        var40.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var39.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 3: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 4: select1wb */
      {
        orc_union16 _src;
        _src.i = var40.x2[0];
        var44.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var40.x2[1];
        var44.x2[1] = _src.x2[1];
      }
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[0];
        _dest.x2[1] = var44.x2[0];
        var38.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[1];
        _dest.x2[1] = var44.x2[1];
        var38.x2[1] = _dest.i;
      }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

void
cogorc_convert_AYUV_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_AYUV_UYVY");
      orc_program_set_backup_function (p, _backup_cogorc_convert_AYUV_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_AYUV_Y42B */
#ifdef DISABLE_ORC
void
cogorc_convert_AYUV_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var36 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var36.x2[0];
        var40.x2[0] = _src.x2[1];
        var41.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var36.x2[1];
        var40.x2[1] = _src.x2[1];
        var41.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var42.i = _src.x2[1];
        var43.i = _src.x2[0];
      }
      /* 3: avgub */
      var44.x2[0] =
          ((orc_uint8) var42.x2[0] + (orc_uint8) var43.x2[0] + 1) >> 1;
      var44.x2[1] =
          ((orc_uint8) var42.x2[1] + (orc_uint8) var43.x2[1] + 1) >> 1;
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var44.i;
        var37 = _src.x2[1];
        var38 = _src.x2[0];
      }
      /* 5: storeb */
      ptr2[i] = var37;
      /* 6: storeb */
      ptr1[i] = var38;
      /* 7: select1wb */
      {
        orc_union16 _src;
        _src.i = var41.x2[0];
        var39.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var41.x2[1];
        var39.x2[1] = _src.x2[1];
      }
      /* 8: storew */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_cogorc_convert_AYUV_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var36 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var36.x2[0];
        var40.x2[0] = _src.x2[1];
        var41.x2[0] = _src.x2[0];
      }
      {
        orc_union32 _src;
        _src.i = var36.x2[1];
        var40.x2[1] = _src.x2[1];
        var41.x2[1] = _src.x2[0];
      }
      /* 2: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var42.i = _src.x2[1];
        var43.i = _src.x2[0];
      }
      /* 3: avgub */
      var44.x2[0] =
          ((orc_uint8) var42.x2[0] + (orc_uint8) var43.x2[0] + 1) >> 1;
      var44.x2[1] =
          ((orc_uint8) var42.x2[1] + (orc_uint8) var43.x2[1] + 1) >> 1;
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var44.i;
        var37 = _src.x2[1];
        var38 = _src.x2[0];
      }
      /* 5: storeb */
      ptr2[i] = var37;
      /* 6: storeb */
      ptr1[i] = var38;
      /* 7: select1wb */
      {
        orc_union16 _src;
        _src.i = var41.x2[0];
        var39.x2[0] = _src.x2[1];
      }
      {
        orc_union16 _src;
        _src.i = var41.x2[1];
        var39.x2[1] = _src.x2[1];
      }
      /* 8: storew */
      ptr0[i] = var39;
    }
  }

}

void
cogorc_convert_AYUV_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_AYUV_Y42B");
      orc_program_set_backup_function (p, _backup_cogorc_convert_AYUV_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_AYUV_Y444 */
#ifdef DISABLE_ORC
void
cogorc_convert_AYUV_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET (d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET (d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var34 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var34.i;
        var38.i = _src.x2[1];
        var39.i = _src.x2[0];
      }
      /* 2: splitwb */
      {
        orc_union16 _src;
        _src.i = var38.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 3: storeb */
      ptr2[i] = var35;
      /* 4: storeb */
      ptr1[i] = var36;
      /* 5: select1wb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var37 = _src.x2[1];
      }
      /* 6: storeb */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_cogorc_convert_AYUV_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET (ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET (ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var34 = ptr4[i];
      /* 1: splitlw */
      {
        orc_union32 _src;
        _src.i = var34.i;
        var38.i = _src.x2[1];
        var39.i = _src.x2[0];
      }
      /* 2: splitwb */
      {
        orc_union16 _src;
        _src.i = var38.i;
        var35 = _src.x2[1];
        var36 = _src.x2[0];
      }
      /* 3: storeb */
      ptr2[i] = var35;
      /* 4: storeb */
      ptr1[i] = var36;
      /* 5: select1wb */
      {
        orc_union16 _src;
        _src.i = var39.i;
        var37 = _src.x2[1];
      }
      /* 6: storeb */
      ptr0[i] = var37;
    }
  }

}

void
cogorc_convert_AYUV_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride,
    guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3,
    int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_AYUV_Y444");
      orc_program_set_backup_function (p, _backup_cogorc_convert_AYUV_Y444);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_Y42B_YUY2 */
#ifdef DISABLE_ORC
void
cogorc_convert_Y42B_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var33;
        _dest.x2[1] = var34;
        var37.i = _dest.i;
      }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var35.x2[0];
        _dest.x2[1] = var37.x2[0];
        var36.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var35.x2[1];
        _dest.x2[1] = var37.x2[1];
        var36.x2[1] = _dest.i;
      }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

#else
static void
_backup_cogorc_convert_Y42B_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var33;
        _dest.x2[1] = var34;
        var37.i = _dest.i;
      }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var35.x2[0];
        _dest.x2[1] = var37.x2[0];
        var36.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var35.x2[1];
        _dest.x2[1] = var37.x2[1];
        var36.x2[1] = _dest.i;
      }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

void
cogorc_convert_Y42B_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_Y42B_YUY2");
      orc_program_set_backup_function (p, _backup_cogorc_convert_Y42B_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_Y42B_UYVY */
#ifdef DISABLE_ORC
void
cogorc_convert_Y42B_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var33;
        _dest.x2[1] = var34;
        var37.i = _dest.i;
      }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var35.x2[0];
        var36.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var35.x2[1];
        var36.x2[1] = _dest.i;
      }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

#else
static void
_backup_cogorc_convert_Y42B_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var33;
        _dest.x2[1] = var34;
        var37.i = _dest.i;
      }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[0];
        _dest.x2[1] = var35.x2[0];
        var36.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var37.x2[1];
        _dest.x2[1] = var35.x2[1];
        var36.x2[1] = _dest.i;
      }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

void
cogorc_convert_Y42B_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_Y42B_UYVY");
      orc_program_set_backup_function (p, _backup_cogorc_convert_Y42B_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_Y42B_AYUV */
#ifdef DISABLE_ORC
void
cogorc_convert_Y42B_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);

    /* 3: loadpb */
    var38.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var38.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var36 = ptr5[i];
      /* 1: loadb */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36;
        _dest.x2[1] = var37;
        var41.i = _dest.i;
      }
      /* 4: loadw */
      var39 = ptr4[i];
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[0];
        _dest.x2[1] = var39.x2[0];
        var42.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[1];
        _dest.x2[1] = var39.x2[1];
        var42.x2[1] = _dest.i;
      }
      /* 6: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.i;
        _dest.x2[1] = var41.i;
        var43.i = _dest.i;
      }
      /* 7: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var42.x2[0];
        _dest.x2[1] = var43.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var42.x2[1];
        _dest.x2[1] = var43.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 8: storeq */
      ptr0[i] = var40;
    }
  }

}

#else
static void
_backup_cogorc_convert_Y42B_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);

    /* 3: loadpb */
    var38.x2[0] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
    var38.x2[1] = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var36 = ptr5[i];
      /* 1: loadb */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36;
        _dest.x2[1] = var37;
        var41.i = _dest.i;
      }
      /* 4: loadw */
      var39 = ptr4[i];
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[0];
        _dest.x2[1] = var39.x2[0];
        var42.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[1];
        _dest.x2[1] = var39.x2[1];
        var42.x2[1] = _dest.i;
      }
      /* 6: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var41.i;
        _dest.x2[1] = var41.i;
        var43.i = _dest.i;
      }
      /* 7: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var42.x2[0];
        _dest.x2[1] = var43.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union32 _dest;
        _dest.x2[0] = var42.x2[1];
        _dest.x2[1] = var43.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 8: storeq */
      ptr0[i] = var40;
    }
  }

}

void
cogorc_convert_Y42B_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_Y42B_AYUV");
      orc_program_set_backup_function (p, _backup_cogorc_convert_Y42B_AYUV);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T4, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_T3,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_Y444_YUY2 */
#ifdef DISABLE_ORC
void
cogorc_convert_Y444_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[0];
        _dest.x2[1] = var37.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[1];
        _dest.x2[1] = var37.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 4: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[0];
        _dest.x2[1] = var43.x2[0];
        var39.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[1];
        _dest.x2[1] = var43.x2[1];
        var39.x2[1] = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_cogorc_convert_Y444_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[0];
        _dest.x2[1] = var37.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[1];
        _dest.x2[1] = var37.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 4: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[0];
        _dest.x2[1] = var43.x2[0];
        var39.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var38.x2[1];
        _dest.x2[1] = var43.x2[1];
        var39.x2[1] = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

void
cogorc_convert_Y444_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_Y444_YUY2");
      orc_program_set_backup_function (p, _backup_cogorc_convert_Y444_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_Y444_UYVY */
#ifdef DISABLE_ORC
void
cogorc_convert_Y444_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[0];
        _dest.x2[1] = var37.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[1];
        _dest.x2[1] = var37.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 4: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[0];
        _dest.x2[1] = var38.x2[0];
        var39.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[1];
        _dest.x2[1] = var38.x2[1];
        var39.x2[1] = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_cogorc_convert_Y444_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  const orc_union16 *ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[0];
        _dest.x2[1] = var37.x2[0];
        var40.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var36.x2[1];
        _dest.x2[1] = var37.x2[1];
        var40.x2[1] = _dest.i;
      }
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var40.i;
        var41.i = _src.x2[1];
        var42.i = _src.x2[0];
      }
      /* 4: avgub */
      var43.x2[0] =
          ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
      var43.x2[1] =
          ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[0];
        _dest.x2[1] = var38.x2[0];
        var39.x2[0] = _dest.i;
      }
      {
        orc_union16 _dest;
        _dest.x2[0] = var43.x2[1];
        _dest.x2[1] = var38.x2[1];
        var39.x2[1] = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

void
cogorc_convert_Y444_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_Y444_UYVY");
      orc_program_set_backup_function (p, _backup_cogorc_convert_Y444_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_Y444_AYUV */
#ifdef DISABLE_ORC
void
cogorc_convert_Y444_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET (s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET (s3, s3_stride * j);

    /* 3: loadpb */
    var36 = (int) 0x000000ff;   /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr5[i];
      /* 1: loadb */
      var35 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var34;
        _dest.x2[1] = var35;
        var39.i = _dest.i;
      }
      /* 4: loadb */
      var37 = ptr4[i];
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36;
        _dest.x2[1] = var37;
        var40.i = _dest.i;
      }
      /* 6: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var40.i;
        _dest.x2[1] = var39.i;
        var38.i = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_cogorc_convert_Y444_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET (ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET (ex->arrays[6], ex->params[6] * j);

    /* 3: loadpb */
    var36 = (int) 0x000000ff;   /* 255 or 1.25987e-321f */

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr5[i];
      /* 1: loadb */
      var35 = ptr6[i];
      /* 2: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var34;
        _dest.x2[1] = var35;
        var39.i = _dest.i;
      }
      /* 4: loadb */
      var37 = ptr4[i];
      /* 5: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var36;
        _dest.x2[1] = var37;
        var40.i = _dest.i;
      }
      /* 6: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var40.i;
        _dest.x2[1] = var39.i;
        var38.i = _dest.i;
      }
      /* 7: storel */
      ptr0[i] = var38;
    }
  }

}

void
cogorc_convert_Y444_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride,
    const guint8 * ORC_RESTRICT s2, int s2_stride,
    const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_Y444_AYUV");
      orc_program_set_backup_function (p, _backup_cogorc_convert_Y444_AYUV);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_AYUV_ARGB */
#ifdef DISABLE_ORC
void
cogorc_convert_AYUV_ARGB (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var48;
  orc_union32 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union16 var58;
  orc_union16 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_union16 var85;
  orc_union16 var86;
  orc_int8 var87;
  orc_int8 var88;
  orc_int8 var89;
  orc_union16 var90;
  orc_union16 var91;
  orc_union32 var92;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 1: loadpb */
    var49.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var50.i = (int) 0x0000002a; /* 42 or 2.07508e-322f */
    /* 14: loadpw */
    var51.i = (int) 0x00000067; /* 103 or 5.08888e-322f */
    /* 21: loadpw */
    var52.i = (int) 0x00000004; /* 4 or 1.97626e-323f */
    /* 25: loadpw */
    var53.i = (int) 0x00000064; /* 100 or 4.94066e-322f */
    /* 29: loadpw */
    var54.i = (int) 0x00000068; /* 104 or 5.13828e-322f */
    /* 40: loadpb */
    var55.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var48 = ptr4[i];
      /* 2: subb */
      var57.x4[0] = var48.x4[0] - var49.x4[0];
      var57.x4[1] = var48.x4[1] - var49.x4[1];
      var57.x4[2] = var48.x4[2] - var49.x4[2];
      var57.x4[3] = var48.x4[3] - var49.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var57.i;
        var58.i = _src.x2[1];
        var59.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var59.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var58.i;
        var62 = _src.x2[1];
        var63 = _src.x2[0];
      }
      /* 6: convsbw */
      var64.i = var60;
      /* 7: convsbw */
      var65.i = var63;
      /* 8: convsbw */
      var66.i = var62;
      /* 10: mullw */
      var67.i = (var64.i * var50.i) & 0xffff;
      /* 11: shrsw */
      var68.i = var67.i >> 8;
      /* 12: addssw */
      var69.i = ORC_CLAMP_SW (var64.i + var68.i);
      /* 13: addssw */
      var70.i = ORC_CLAMP_SW (var69.i + var66.i);
      /* 15: mullw */
      var71.i = (var66.i * var51.i) & 0xffff;
      /* 16: shrsw */
      var72.i = var71.i >> 8;
      /* 17: subssw */
      var73.i = ORC_CLAMP_SW (var70.i - var72.i);
      /* 18: addssw */
      var74.i = ORC_CLAMP_SW (var73.i + var66.i);
      /* 19: addssw */
      var75.i = ORC_CLAMP_SW (var69.i + var65.i);
      /* 20: addssw */
      var76.i = ORC_CLAMP_SW (var75.i + var65.i);
      /* 22: mullw */
      var77.i = (var65.i * var52.i) & 0xffff;
      /* 23: shrsw */
      var78.i = var77.i >> 8;
      /* 24: addssw */
      var79.i = ORC_CLAMP_SW (var76.i + var78.i);
      /* 26: mullw */
      var80.i = (var65.i * var53.i) & 0xffff;
      /* 27: shrsw */
      var81.i = var80.i >> 8;
      /* 28: subssw */
      var82.i = ORC_CLAMP_SW (var69.i - var81.i);
      /* 30: mullw */
      var83.i = (var66.i * var54.i) & 0xffff;
      /* 31: shrsw */
      var84.i = var83.i >> 8;
      /* 32: subssw */
      var85.i = ORC_CLAMP_SW (var82.i - var84.i);
      /* 33: subssw */
      var86.i = ORC_CLAMP_SW (var85.i - var84.i);
      /* 34: convssswb */
      var87 = ORC_CLAMP_SB (var74.i);
      /* 35: convssswb */
      var88 = ORC_CLAMP_SB (var86.i);
      /* 36: convssswb */
      var89 = ORC_CLAMP_SB (var79.i);
      /* 37: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var61;
        _dest.x2[1] = var87;
        var90.i = _dest.i;
      }
      /* 38: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var88;
        _dest.x2[1] = var89;
        var91.i = _dest.i;
      }
      /* 39: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var90.i;
        _dest.x2[1] = var91.i;
        var92.i = _dest.i;
      }
      /* 41: addb */
      var56.x4[0] = var92.x4[0] + var55.x4[0];
      var56.x4[1] = var92.x4[1] + var55.x4[1];
      var56.x4[2] = var92.x4[2] + var55.x4[2];
      var56.x4[3] = var92.x4[3] + var55.x4[3];
      /* 42: storel */
      ptr0[i] = var56;
    }
  }

}

#else
static void
_backup_cogorc_convert_AYUV_ARGB (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var48;
  orc_union32 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union16 var58;
  orc_union16 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_union16 var85;
  orc_union16 var86;
  orc_int8 var87;
  orc_int8 var88;
  orc_int8 var89;
  orc_union16 var90;
  orc_union16 var91;
  orc_union32 var92;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 1: loadpb */
    var49.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var50.i = (int) 0x0000002a; /* 42 or 2.07508e-322f */
    /* 14: loadpw */
    var51.i = (int) 0x00000067; /* 103 or 5.08888e-322f */
    /* 21: loadpw */
    var52.i = (int) 0x00000004; /* 4 or 1.97626e-323f */
    /* 25: loadpw */
    var53.i = (int) 0x00000064; /* 100 or 4.94066e-322f */
    /* 29: loadpw */
    var54.i = (int) 0x00000068; /* 104 or 5.13828e-322f */
    /* 40: loadpb */
    var55.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var48 = ptr4[i];
      /* 2: subb */
      var57.x4[0] = var48.x4[0] - var49.x4[0];
      var57.x4[1] = var48.x4[1] - var49.x4[1];
      var57.x4[2] = var48.x4[2] - var49.x4[2];
      var57.x4[3] = var48.x4[3] - var49.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var57.i;
        var58.i = _src.x2[1];
        var59.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var59.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var58.i;
        var62 = _src.x2[1];
        var63 = _src.x2[0];
      }
      /* 6: convsbw */
      var64.i = var60;
      /* 7: convsbw */
      var65.i = var63;
      /* 8: convsbw */
      var66.i = var62;
      /* 10: mullw */
      var67.i = (var64.i * var50.i) & 0xffff;
      /* 11: shrsw */
      var68.i = var67.i >> 8;
      /* 12: addssw */
      var69.i = ORC_CLAMP_SW (var64.i + var68.i);
      /* 13: addssw */
      var70.i = ORC_CLAMP_SW (var69.i + var66.i);
      /* 15: mullw */
      var71.i = (var66.i * var51.i) & 0xffff;
      /* 16: shrsw */
      var72.i = var71.i >> 8;
      /* 17: subssw */
      var73.i = ORC_CLAMP_SW (var70.i - var72.i);
      /* 18: addssw */
      var74.i = ORC_CLAMP_SW (var73.i + var66.i);
      /* 19: addssw */
      var75.i = ORC_CLAMP_SW (var69.i + var65.i);
      /* 20: addssw */
      var76.i = ORC_CLAMP_SW (var75.i + var65.i);
      /* 22: mullw */
      var77.i = (var65.i * var52.i) & 0xffff;
      /* 23: shrsw */
      var78.i = var77.i >> 8;
      /* 24: addssw */
      var79.i = ORC_CLAMP_SW (var76.i + var78.i);
      /* 26: mullw */
      var80.i = (var65.i * var53.i) & 0xffff;
      /* 27: shrsw */
      var81.i = var80.i >> 8;
      /* 28: subssw */
      var82.i = ORC_CLAMP_SW (var69.i - var81.i);
      /* 30: mullw */
      var83.i = (var66.i * var54.i) & 0xffff;
      /* 31: shrsw */
      var84.i = var83.i >> 8;
      /* 32: subssw */
      var85.i = ORC_CLAMP_SW (var82.i - var84.i);
      /* 33: subssw */
      var86.i = ORC_CLAMP_SW (var85.i - var84.i);
      /* 34: convssswb */
      var87 = ORC_CLAMP_SB (var74.i);
      /* 35: convssswb */
      var88 = ORC_CLAMP_SB (var86.i);
      /* 36: convssswb */
      var89 = ORC_CLAMP_SB (var79.i);
      /* 37: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var61;
        _dest.x2[1] = var87;
        var90.i = _dest.i;
      }
      /* 38: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var88;
        _dest.x2[1] = var89;
        var91.i = _dest.i;
      }
      /* 39: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var90.i;
        _dest.x2[1] = var91.i;
        var92.i = _dest.i;
      }
      /* 41: addb */
      var56.x4[0] = var92.x4[0] + var55.x4[0];
      var56.x4[1] = var92.x4[1] + var55.x4[1];
      var56.x4[2] = var92.x4[2] + var55.x4[2];
      var56.x4[3] = var92.x4[3] + var55.x4[3];
      /* 42: storel */
      ptr0[i] = var56;
    }
  }

}

void
cogorc_convert_AYUV_ARGB (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_AYUV_ARGB");
      orc_program_set_backup_function (p, _backup_cogorc_convert_AYUV_ARGB);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x00000080, "c2");
      orc_program_add_constant (p, 4, 0x0000002a, "c3");
      orc_program_add_constant (p, 4, 0x00000067, "c4");
      orc_program_add_constant (p, 4, 0x00000004, "c5");
      orc_program_add_constant (p, 4, 0x00000064, "c6");
      orc_program_add_constant (p, 4, 0x00000068, "c7");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 1, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 2, "t11");
      orc_program_add_temporary (p, 2, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 1, "t14");
      orc_program_add_temporary (p, 1, "t15");
      orc_program_add_temporary (p, 4, "t16");

      orc_program_append_2 (p, "subb", 2, 47, ORC_VAR_S1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T1, ORC_VAR_T2, 47,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T6, ORC_VAR_T5, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T7, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T7, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T9, ORC_VAR_C4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T12,
          ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T8, ORC_VAR_C5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T12,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T8, ORC_VAR_C6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T7, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T9, ORC_VAR_C7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T11,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T11,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T14, ORC_VAR_T11,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T15, ORC_VAR_T12,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3,
          ORC_VAR_T13, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_T14,
          ORC_VAR_T15, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, 47, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, 47, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_AYUV_BGRA */
#ifdef DISABLE_ORC
void
cogorc_convert_AYUV_BGRA (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var48;
  orc_union32 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union16 var58;
  orc_union16 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_union16 var85;
  orc_union16 var86;
  orc_int8 var87;
  orc_int8 var88;
  orc_int8 var89;
  orc_union16 var90;
  orc_union16 var91;
  orc_union32 var92;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 1: loadpb */
    var49.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var50.i = (int) 0x0000002a; /* 42 or 2.07508e-322f */
    /* 14: loadpw */
    var51.i = (int) 0x00000067; /* 103 or 5.08888e-322f */
    /* 21: loadpw */
    var52.i = (int) 0x00000004; /* 4 or 1.97626e-323f */
    /* 25: loadpw */
    var53.i = (int) 0x00000064; /* 100 or 4.94066e-322f */
    /* 29: loadpw */
    var54.i = (int) 0x00000068; /* 104 or 5.13828e-322f */
    /* 40: loadpb */
    var55.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var48 = ptr4[i];
      /* 2: subb */
      var57.x4[0] = var48.x4[0] - var49.x4[0];
      var57.x4[1] = var48.x4[1] - var49.x4[1];
      var57.x4[2] = var48.x4[2] - var49.x4[2];
      var57.x4[3] = var48.x4[3] - var49.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var57.i;
        var58.i = _src.x2[1];
        var59.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var59.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var58.i;
        var62 = _src.x2[1];
        var63 = _src.x2[0];
      }
      /* 6: convsbw */
      var64.i = var60;
      /* 7: convsbw */
      var65.i = var63;
      /* 8: convsbw */
      var66.i = var62;
      /* 10: mullw */
      var67.i = (var64.i * var50.i) & 0xffff;
      /* 11: shrsw */
      var68.i = var67.i >> 8;
      /* 12: addssw */
      var69.i = ORC_CLAMP_SW (var64.i + var68.i);
      /* 13: addssw */
      var70.i = ORC_CLAMP_SW (var69.i + var66.i);
      /* 15: mullw */
      var71.i = (var66.i * var51.i) & 0xffff;
      /* 16: shrsw */
      var72.i = var71.i >> 8;
      /* 17: subssw */
      var73.i = ORC_CLAMP_SW (var70.i - var72.i);
      /* 18: addssw */
      var74.i = ORC_CLAMP_SW (var73.i + var66.i);
      /* 19: addssw */
      var75.i = ORC_CLAMP_SW (var69.i + var65.i);
      /* 20: addssw */
      var76.i = ORC_CLAMP_SW (var75.i + var65.i);
      /* 22: mullw */
      var77.i = (var65.i * var52.i) & 0xffff;
      /* 23: shrsw */
      var78.i = var77.i >> 8;
      /* 24: addssw */
      var79.i = ORC_CLAMP_SW (var76.i + var78.i);
      /* 26: mullw */
      var80.i = (var65.i * var53.i) & 0xffff;
      /* 27: shrsw */
      var81.i = var80.i >> 8;
      /* 28: subssw */
      var82.i = ORC_CLAMP_SW (var69.i - var81.i);
      /* 30: mullw */
      var83.i = (var66.i * var54.i) & 0xffff;
      /* 31: shrsw */
      var84.i = var83.i >> 8;
      /* 32: subssw */
      var85.i = ORC_CLAMP_SW (var82.i - var84.i);
      /* 33: subssw */
      var86.i = ORC_CLAMP_SW (var85.i - var84.i);
      /* 34: convssswb */
      var87 = ORC_CLAMP_SB (var74.i);
      /* 35: convssswb */
      var88 = ORC_CLAMP_SB (var86.i);
      /* 36: convssswb */
      var89 = ORC_CLAMP_SB (var79.i);
      /* 37: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var89;
        _dest.x2[1] = var88;
        var90.i = _dest.i;
      }
      /* 38: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var87;
        _dest.x2[1] = var61;
        var91.i = _dest.i;
      }
      /* 39: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var90.i;
        _dest.x2[1] = var91.i;
        var92.i = _dest.i;
      }
      /* 41: addb */
      var56.x4[0] = var92.x4[0] + var55.x4[0];
      var56.x4[1] = var92.x4[1] + var55.x4[1];
      var56.x4[2] = var92.x4[2] + var55.x4[2];
      var56.x4[3] = var92.x4[3] + var55.x4[3];
      /* 42: storel */
      ptr0[i] = var56;
    }
  }

}

#else
static void
_backup_cogorc_convert_AYUV_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var48;
  orc_union32 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union16 var58;
  orc_union16 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_union16 var85;
  orc_union16 var86;
  orc_int8 var87;
  orc_int8 var88;
  orc_int8 var89;
  orc_union16 var90;
  orc_union16 var91;
  orc_union32 var92;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 1: loadpb */
    var49.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var50.i = (int) 0x0000002a; /* 42 or 2.07508e-322f */
    /* 14: loadpw */
    var51.i = (int) 0x00000067; /* 103 or 5.08888e-322f */
    /* 21: loadpw */
    var52.i = (int) 0x00000004; /* 4 or 1.97626e-323f */
    /* 25: loadpw */
    var53.i = (int) 0x00000064; /* 100 or 4.94066e-322f */
    /* 29: loadpw */
    var54.i = (int) 0x00000068; /* 104 or 5.13828e-322f */
    /* 40: loadpb */
    var55.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var48 = ptr4[i];
      /* 2: subb */
      var57.x4[0] = var48.x4[0] - var49.x4[0];
      var57.x4[1] = var48.x4[1] - var49.x4[1];
      var57.x4[2] = var48.x4[2] - var49.x4[2];
      var57.x4[3] = var48.x4[3] - var49.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var57.i;
        var58.i = _src.x2[1];
        var59.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var59.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var58.i;
        var62 = _src.x2[1];
        var63 = _src.x2[0];
      }
      /* 6: convsbw */
      var64.i = var60;
      /* 7: convsbw */
      var65.i = var63;
      /* 8: convsbw */
      var66.i = var62;
      /* 10: mullw */
      var67.i = (var64.i * var50.i) & 0xffff;
      /* 11: shrsw */
      var68.i = var67.i >> 8;
      /* 12: addssw */
      var69.i = ORC_CLAMP_SW (var64.i + var68.i);
      /* 13: addssw */
      var70.i = ORC_CLAMP_SW (var69.i + var66.i);
      /* 15: mullw */
      var71.i = (var66.i * var51.i) & 0xffff;
      /* 16: shrsw */
      var72.i = var71.i >> 8;
      /* 17: subssw */
      var73.i = ORC_CLAMP_SW (var70.i - var72.i);
      /* 18: addssw */
      var74.i = ORC_CLAMP_SW (var73.i + var66.i);
      /* 19: addssw */
      var75.i = ORC_CLAMP_SW (var69.i + var65.i);
      /* 20: addssw */
      var76.i = ORC_CLAMP_SW (var75.i + var65.i);
      /* 22: mullw */
      var77.i = (var65.i * var52.i) & 0xffff;
      /* 23: shrsw */
      var78.i = var77.i >> 8;
      /* 24: addssw */
      var79.i = ORC_CLAMP_SW (var76.i + var78.i);
      /* 26: mullw */
      var80.i = (var65.i * var53.i) & 0xffff;
      /* 27: shrsw */
      var81.i = var80.i >> 8;
      /* 28: subssw */
      var82.i = ORC_CLAMP_SW (var69.i - var81.i);
      /* 30: mullw */
      var83.i = (var66.i * var54.i) & 0xffff;
      /* 31: shrsw */
      var84.i = var83.i >> 8;
      /* 32: subssw */
      var85.i = ORC_CLAMP_SW (var82.i - var84.i);
      /* 33: subssw */
      var86.i = ORC_CLAMP_SW (var85.i - var84.i);
      /* 34: convssswb */
      var87 = ORC_CLAMP_SB (var74.i);
      /* 35: convssswb */
      var88 = ORC_CLAMP_SB (var86.i);
      /* 36: convssswb */
      var89 = ORC_CLAMP_SB (var79.i);
      /* 37: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var89;
        _dest.x2[1] = var88;
        var90.i = _dest.i;
      }
      /* 38: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var87;
        _dest.x2[1] = var61;
        var91.i = _dest.i;
      }
      /* 39: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var90.i;
        _dest.x2[1] = var91.i;
        var92.i = _dest.i;
      }
      /* 41: addb */
      var56.x4[0] = var92.x4[0] + var55.x4[0];
      var56.x4[1] = var92.x4[1] + var55.x4[1];
      var56.x4[2] = var92.x4[2] + var55.x4[2];
      var56.x4[3] = var92.x4[3] + var55.x4[3];
      /* 42: storel */
      ptr0[i] = var56;
    }
  }

}

void
cogorc_convert_AYUV_BGRA (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_AYUV_BGRA");
      orc_program_set_backup_function (p, _backup_cogorc_convert_AYUV_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x00000080, "c2");
      orc_program_add_constant (p, 4, 0x0000002a, "c3");
      orc_program_add_constant (p, 4, 0x00000067, "c4");
      orc_program_add_constant (p, 4, 0x00000004, "c5");
      orc_program_add_constant (p, 4, 0x00000064, "c6");
      orc_program_add_constant (p, 4, 0x00000068, "c7");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 1, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 2, "t11");
      orc_program_add_temporary (p, 2, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 1, "t14");
      orc_program_add_temporary (p, 1, "t15");
      orc_program_add_temporary (p, 4, "t16");

      orc_program_append_2 (p, "subb", 2, 47, ORC_VAR_S1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T1, ORC_VAR_T2, 47,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T6, ORC_VAR_T5, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T7, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T7, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T9, ORC_VAR_C4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T12,
          ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T8, ORC_VAR_C5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T12,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T8, ORC_VAR_C6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T7, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T9, ORC_VAR_C7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T11,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T11,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T14, ORC_VAR_T11,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T15, ORC_VAR_T12,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T15,
          ORC_VAR_T14, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_T13,
          ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, 47, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, 47, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_AYUV_ABGR */
#ifdef DISABLE_ORC
void
cogorc_convert_AYUV_ABGR (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var48;
  orc_union32 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union16 var58;
  orc_union16 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_union16 var85;
  orc_union16 var86;
  orc_int8 var87;
  orc_int8 var88;
  orc_int8 var89;
  orc_union16 var90;
  orc_union16 var91;
  orc_union32 var92;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 1: loadpb */
    var49.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var50.i = (int) 0x0000002a; /* 42 or 2.07508e-322f */
    /* 14: loadpw */
    var51.i = (int) 0x00000067; /* 103 or 5.08888e-322f */
    /* 21: loadpw */
    var52.i = (int) 0x00000004; /* 4 or 1.97626e-323f */
    /* 25: loadpw */
    var53.i = (int) 0x00000064; /* 100 or 4.94066e-322f */
    /* 29: loadpw */
    var54.i = (int) 0x00000068; /* 104 or 5.13828e-322f */
    /* 40: loadpb */
    var55.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var48 = ptr4[i];
      /* 2: subb */
      var57.x4[0] = var48.x4[0] - var49.x4[0];
      var57.x4[1] = var48.x4[1] - var49.x4[1];
      var57.x4[2] = var48.x4[2] - var49.x4[2];
      var57.x4[3] = var48.x4[3] - var49.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var57.i;
        var58.i = _src.x2[1];
        var59.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var59.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var58.i;
        var62 = _src.x2[1];
        var63 = _src.x2[0];
      }
      /* 6: convsbw */
      var64.i = var60;
      /* 7: convsbw */
      var65.i = var63;
      /* 8: convsbw */
      var66.i = var62;
      /* 10: mullw */
      var67.i = (var64.i * var50.i) & 0xffff;
      /* 11: shrsw */
      var68.i = var67.i >> 8;
      /* 12: addssw */
      var69.i = ORC_CLAMP_SW (var64.i + var68.i);
      /* 13: addssw */
      var70.i = ORC_CLAMP_SW (var69.i + var66.i);
      /* 15: mullw */
      var71.i = (var66.i * var51.i) & 0xffff;
      /* 16: shrsw */
      var72.i = var71.i >> 8;
      /* 17: subssw */
      var73.i = ORC_CLAMP_SW (var70.i - var72.i);
      /* 18: addssw */
      var74.i = ORC_CLAMP_SW (var73.i + var66.i);
      /* 19: addssw */
      var75.i = ORC_CLAMP_SW (var69.i + var65.i);
      /* 20: addssw */
      var76.i = ORC_CLAMP_SW (var75.i + var65.i);
      /* 22: mullw */
      var77.i = (var65.i * var52.i) & 0xffff;
      /* 23: shrsw */
      var78.i = var77.i >> 8;
      /* 24: addssw */
      var79.i = ORC_CLAMP_SW (var76.i + var78.i);
      /* 26: mullw */
      var80.i = (var65.i * var53.i) & 0xffff;
      /* 27: shrsw */
      var81.i = var80.i >> 8;
      /* 28: subssw */
      var82.i = ORC_CLAMP_SW (var69.i - var81.i);
      /* 30: mullw */
      var83.i = (var66.i * var54.i) & 0xffff;
      /* 31: shrsw */
      var84.i = var83.i >> 8;
      /* 32: subssw */
      var85.i = ORC_CLAMP_SW (var82.i - var84.i);
      /* 33: subssw */
      var86.i = ORC_CLAMP_SW (var85.i - var84.i);
      /* 34: convssswb */
      var87 = ORC_CLAMP_SB (var74.i);
      /* 35: convssswb */
      var88 = ORC_CLAMP_SB (var86.i);
      /* 36: convssswb */
      var89 = ORC_CLAMP_SB (var79.i);
      /* 37: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var61;
        _dest.x2[1] = var89;
        var90.i = _dest.i;
      }
      /* 38: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var88;
        _dest.x2[1] = var87;
        var91.i = _dest.i;
      }
      /* 39: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var90.i;
        _dest.x2[1] = var91.i;
        var92.i = _dest.i;
      }
      /* 41: addb */
      var56.x4[0] = var92.x4[0] + var55.x4[0];
      var56.x4[1] = var92.x4[1] + var55.x4[1];
      var56.x4[2] = var92.x4[2] + var55.x4[2];
      var56.x4[3] = var92.x4[3] + var55.x4[3];
      /* 42: storel */
      ptr0[i] = var56;
    }
  }

}

#else
static void
_backup_cogorc_convert_AYUV_ABGR (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var48;
  orc_union32 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union16 var58;
  orc_union16 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_union16 var85;
  orc_union16 var86;
  orc_int8 var87;
  orc_int8 var88;
  orc_int8 var89;
  orc_union16 var90;
  orc_union16 var91;
  orc_union32 var92;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 1: loadpb */
    var49.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var50.i = (int) 0x0000002a; /* 42 or 2.07508e-322f */
    /* 14: loadpw */
    var51.i = (int) 0x00000067; /* 103 or 5.08888e-322f */
    /* 21: loadpw */
    var52.i = (int) 0x00000004; /* 4 or 1.97626e-323f */
    /* 25: loadpw */
    var53.i = (int) 0x00000064; /* 100 or 4.94066e-322f */
    /* 29: loadpw */
    var54.i = (int) 0x00000068; /* 104 or 5.13828e-322f */
    /* 40: loadpb */
    var55.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var48 = ptr4[i];
      /* 2: subb */
      var57.x4[0] = var48.x4[0] - var49.x4[0];
      var57.x4[1] = var48.x4[1] - var49.x4[1];
      var57.x4[2] = var48.x4[2] - var49.x4[2];
      var57.x4[3] = var48.x4[3] - var49.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var57.i;
        var58.i = _src.x2[1];
        var59.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var59.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var58.i;
        var62 = _src.x2[1];
        var63 = _src.x2[0];
      }
      /* 6: convsbw */
      var64.i = var60;
      /* 7: convsbw */
      var65.i = var63;
      /* 8: convsbw */
      var66.i = var62;
      /* 10: mullw */
      var67.i = (var64.i * var50.i) & 0xffff;
      /* 11: shrsw */
      var68.i = var67.i >> 8;
      /* 12: addssw */
      var69.i = ORC_CLAMP_SW (var64.i + var68.i);
      /* 13: addssw */
      var70.i = ORC_CLAMP_SW (var69.i + var66.i);
      /* 15: mullw */
      var71.i = (var66.i * var51.i) & 0xffff;
      /* 16: shrsw */
      var72.i = var71.i >> 8;
      /* 17: subssw */
      var73.i = ORC_CLAMP_SW (var70.i - var72.i);
      /* 18: addssw */
      var74.i = ORC_CLAMP_SW (var73.i + var66.i);
      /* 19: addssw */
      var75.i = ORC_CLAMP_SW (var69.i + var65.i);
      /* 20: addssw */
      var76.i = ORC_CLAMP_SW (var75.i + var65.i);
      /* 22: mullw */
      var77.i = (var65.i * var52.i) & 0xffff;
      /* 23: shrsw */
      var78.i = var77.i >> 8;
      /* 24: addssw */
      var79.i = ORC_CLAMP_SW (var76.i + var78.i);
      /* 26: mullw */
      var80.i = (var65.i * var53.i) & 0xffff;
      /* 27: shrsw */
      var81.i = var80.i >> 8;
      /* 28: subssw */
      var82.i = ORC_CLAMP_SW (var69.i - var81.i);
      /* 30: mullw */
      var83.i = (var66.i * var54.i) & 0xffff;
      /* 31: shrsw */
      var84.i = var83.i >> 8;
      /* 32: subssw */
      var85.i = ORC_CLAMP_SW (var82.i - var84.i);
      /* 33: subssw */
      var86.i = ORC_CLAMP_SW (var85.i - var84.i);
      /* 34: convssswb */
      var87 = ORC_CLAMP_SB (var74.i);
      /* 35: convssswb */
      var88 = ORC_CLAMP_SB (var86.i);
      /* 36: convssswb */
      var89 = ORC_CLAMP_SB (var79.i);
      /* 37: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var61;
        _dest.x2[1] = var89;
        var90.i = _dest.i;
      }
      /* 38: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var88;
        _dest.x2[1] = var87;
        var91.i = _dest.i;
      }
      /* 39: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var90.i;
        _dest.x2[1] = var91.i;
        var92.i = _dest.i;
      }
      /* 41: addb */
      var56.x4[0] = var92.x4[0] + var55.x4[0];
      var56.x4[1] = var92.x4[1] + var55.x4[1];
      var56.x4[2] = var92.x4[2] + var55.x4[2];
      var56.x4[3] = var92.x4[3] + var55.x4[3];
      /* 42: storel */
      ptr0[i] = var56;
    }
  }

}

void
cogorc_convert_AYUV_ABGR (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_AYUV_ABGR");
      orc_program_set_backup_function (p, _backup_cogorc_convert_AYUV_ABGR);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x00000080, "c2");
      orc_program_add_constant (p, 4, 0x0000002a, "c3");
      orc_program_add_constant (p, 4, 0x00000067, "c4");
      orc_program_add_constant (p, 4, 0x00000004, "c5");
      orc_program_add_constant (p, 4, 0x00000064, "c6");
      orc_program_add_constant (p, 4, 0x00000068, "c7");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 1, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 2, "t11");
      orc_program_add_temporary (p, 2, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 1, "t14");
      orc_program_add_temporary (p, 1, "t15");
      orc_program_add_temporary (p, 4, "t16");

      orc_program_append_2 (p, "subb", 2, 47, ORC_VAR_S1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T1, ORC_VAR_T2, 47,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T6, ORC_VAR_T5, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T7, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T7, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T9, ORC_VAR_C4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T12,
          ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T8, ORC_VAR_C5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T12,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T8, ORC_VAR_C6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T7, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T9, ORC_VAR_C7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T11,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T11,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T14, ORC_VAR_T11,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T15, ORC_VAR_T12,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3,
          ORC_VAR_T15, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_T14,
          ORC_VAR_T13, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, 47, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, 47, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_AYUV_RGBA */
#ifdef DISABLE_ORC
void
cogorc_convert_AYUV_RGBA (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  int i;
  int j;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var48;
  orc_union32 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union16 var58;
  orc_union16 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_union16 var85;
  orc_union16 var86;
  orc_int8 var87;
  orc_int8 var88;
  orc_int8 var89;
  orc_union16 var90;
  orc_union16 var91;
  orc_union32 var92;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET (s1, s1_stride * j);

    /* 1: loadpb */
    var49.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var50.i = (int) 0x0000002a; /* 42 or 2.07508e-322f */
    /* 14: loadpw */
    var51.i = (int) 0x00000067; /* 103 or 5.08888e-322f */
    /* 21: loadpw */
    var52.i = (int) 0x00000004; /* 4 or 1.97626e-323f */
    /* 25: loadpw */
    var53.i = (int) 0x00000064; /* 100 or 4.94066e-322f */
    /* 29: loadpw */
    var54.i = (int) 0x00000068; /* 104 or 5.13828e-322f */
    /* 40: loadpb */
    var55.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var48 = ptr4[i];
      /* 2: subb */
      var57.x4[0] = var48.x4[0] - var49.x4[0];
      var57.x4[1] = var48.x4[1] - var49.x4[1];
      var57.x4[2] = var48.x4[2] - var49.x4[2];
      var57.x4[3] = var48.x4[3] - var49.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var57.i;
        var58.i = _src.x2[1];
        var59.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var59.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var58.i;
        var62 = _src.x2[1];
        var63 = _src.x2[0];
      }
      /* 6: convsbw */
      var64.i = var60;
      /* 7: convsbw */
      var65.i = var63;
      /* 8: convsbw */
      var66.i = var62;
      /* 10: mullw */
      var67.i = (var64.i * var50.i) & 0xffff;
      /* 11: shrsw */
      var68.i = var67.i >> 8;
      /* 12: addssw */
      var69.i = ORC_CLAMP_SW (var64.i + var68.i);
      /* 13: addssw */
      var70.i = ORC_CLAMP_SW (var69.i + var66.i);
      /* 15: mullw */
      var71.i = (var66.i * var51.i) & 0xffff;
      /* 16: shrsw */
      var72.i = var71.i >> 8;
      /* 17: subssw */
      var73.i = ORC_CLAMP_SW (var70.i - var72.i);
      /* 18: addssw */
      var74.i = ORC_CLAMP_SW (var73.i + var66.i);
      /* 19: addssw */
      var75.i = ORC_CLAMP_SW (var69.i + var65.i);
      /* 20: addssw */
      var76.i = ORC_CLAMP_SW (var75.i + var65.i);
      /* 22: mullw */
      var77.i = (var65.i * var52.i) & 0xffff;
      /* 23: shrsw */
      var78.i = var77.i >> 8;
      /* 24: addssw */
      var79.i = ORC_CLAMP_SW (var76.i + var78.i);
      /* 26: mullw */
      var80.i = (var65.i * var53.i) & 0xffff;
      /* 27: shrsw */
      var81.i = var80.i >> 8;
      /* 28: subssw */
      var82.i = ORC_CLAMP_SW (var69.i - var81.i);
      /* 30: mullw */
      var83.i = (var66.i * var54.i) & 0xffff;
      /* 31: shrsw */
      var84.i = var83.i >> 8;
      /* 32: subssw */
      var85.i = ORC_CLAMP_SW (var82.i - var84.i);
      /* 33: subssw */
      var86.i = ORC_CLAMP_SW (var85.i - var84.i);
      /* 34: convssswb */
      var87 = ORC_CLAMP_SB (var74.i);
      /* 35: convssswb */
      var88 = ORC_CLAMP_SB (var86.i);
      /* 36: convssswb */
      var89 = ORC_CLAMP_SB (var79.i);
      /* 37: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var87;
        _dest.x2[1] = var88;
        var90.i = _dest.i;
      }
      /* 38: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var89;
        _dest.x2[1] = var61;
        var91.i = _dest.i;
      }
      /* 39: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var90.i;
        _dest.x2[1] = var91.i;
        var92.i = _dest.i;
      }
      /* 41: addb */
      var56.x4[0] = var92.x4[0] + var55.x4[0];
      var56.x4[1] = var92.x4[1] + var55.x4[1];
      var56.x4[2] = var92.x4[2] + var55.x4[2];
      var56.x4[3] = var92.x4[3] + var55.x4[3];
      /* 42: storel */
      ptr0[i] = var56;
    }
  }

}

#else
static void
_backup_cogorc_convert_AYUV_RGBA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var48;
  orc_union32 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union16 var58;
  orc_union16 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_union16 var85;
  orc_union16 var86;
  orc_int8 var87;
  orc_int8 var88;
  orc_int8 var89;
  orc_union16 var90;
  orc_union16 var91;
  orc_union32 var92;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET (ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET (ex->arrays[4], ex->params[4] * j);

    /* 1: loadpb */
    var49.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var49.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    /* 9: loadpw */
    var50.i = (int) 0x0000002a; /* 42 or 2.07508e-322f */
    /* 14: loadpw */
    var51.i = (int) 0x00000067; /* 103 or 5.08888e-322f */
    /* 21: loadpw */
    var52.i = (int) 0x00000004; /* 4 or 1.97626e-323f */
    /* 25: loadpw */
    var53.i = (int) 0x00000064; /* 100 or 4.94066e-322f */
    /* 29: loadpw */
    var54.i = (int) 0x00000068; /* 104 or 5.13828e-322f */
    /* 40: loadpb */
    var55.x4[0] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[1] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[2] = (int) 0x00000080;     /* 128 or 6.32404e-322f */
    var55.x4[3] = (int) 0x00000080;     /* 128 or 6.32404e-322f */

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var48 = ptr4[i];
      /* 2: subb */
      var57.x4[0] = var48.x4[0] - var49.x4[0];
      var57.x4[1] = var48.x4[1] - var49.x4[1];
      var57.x4[2] = var48.x4[2] - var49.x4[2];
      var57.x4[3] = var48.x4[3] - var49.x4[3];
      /* 3: splitlw */
      {
        orc_union32 _src;
        _src.i = var57.i;
        var58.i = _src.x2[1];
        var59.i = _src.x2[0];
      }
      /* 4: splitwb */
      {
        orc_union16 _src;
        _src.i = var59.i;
        var60 = _src.x2[1];
        var61 = _src.x2[0];
      }
      /* 5: splitwb */
      {
        orc_union16 _src;
        _src.i = var58.i;
        var62 = _src.x2[1];
        var63 = _src.x2[0];
      }
      /* 6: convsbw */
      var64.i = var60;
      /* 7: convsbw */
      var65.i = var63;
      /* 8: convsbw */
      var66.i = var62;
      /* 10: mullw */
      var67.i = (var64.i * var50.i) & 0xffff;
      /* 11: shrsw */
      var68.i = var67.i >> 8;
      /* 12: addssw */
      var69.i = ORC_CLAMP_SW (var64.i + var68.i);
      /* 13: addssw */
      var70.i = ORC_CLAMP_SW (var69.i + var66.i);
      /* 15: mullw */
      var71.i = (var66.i * var51.i) & 0xffff;
      /* 16: shrsw */
      var72.i = var71.i >> 8;
      /* 17: subssw */
      var73.i = ORC_CLAMP_SW (var70.i - var72.i);
      /* 18: addssw */
      var74.i = ORC_CLAMP_SW (var73.i + var66.i);
      /* 19: addssw */
      var75.i = ORC_CLAMP_SW (var69.i + var65.i);
      /* 20: addssw */
      var76.i = ORC_CLAMP_SW (var75.i + var65.i);
      /* 22: mullw */
      var77.i = (var65.i * var52.i) & 0xffff;
      /* 23: shrsw */
      var78.i = var77.i >> 8;
      /* 24: addssw */
      var79.i = ORC_CLAMP_SW (var76.i + var78.i);
      /* 26: mullw */
      var80.i = (var65.i * var53.i) & 0xffff;
      /* 27: shrsw */
      var81.i = var80.i >> 8;
      /* 28: subssw */
      var82.i = ORC_CLAMP_SW (var69.i - var81.i);
      /* 30: mullw */
      var83.i = (var66.i * var54.i) & 0xffff;
      /* 31: shrsw */
      var84.i = var83.i >> 8;
      /* 32: subssw */
      var85.i = ORC_CLAMP_SW (var82.i - var84.i);
      /* 33: subssw */
      var86.i = ORC_CLAMP_SW (var85.i - var84.i);
      /* 34: convssswb */
      var87 = ORC_CLAMP_SB (var74.i);
      /* 35: convssswb */
      var88 = ORC_CLAMP_SB (var86.i);
      /* 36: convssswb */
      var89 = ORC_CLAMP_SB (var79.i);
      /* 37: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var87;
        _dest.x2[1] = var88;
        var90.i = _dest.i;
      }
      /* 38: mergebw */
      {
        orc_union16 _dest;
        _dest.x2[0] = var89;
        _dest.x2[1] = var61;
        var91.i = _dest.i;
      }
      /* 39: mergewl */
      {
        orc_union32 _dest;
        _dest.x2[0] = var90.i;
        _dest.x2[1] = var91.i;
        var92.i = _dest.i;
      }
      /* 41: addb */
      var56.x4[0] = var92.x4[0] + var55.x4[0];
      var56.x4[1] = var92.x4[1] + var55.x4[1];
      var56.x4[2] = var92.x4[2] + var55.x4[2];
      var56.x4[3] = var92.x4[3] + var55.x4[3];
      /* 42: storel */
      ptr0[i] = var56;
    }
  }

}

void
cogorc_convert_AYUV_RGBA (guint8 * ORC_RESTRICT d1, int d1_stride,
    const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "cogorc_convert_AYUV_RGBA");
      orc_program_set_backup_function (p, _backup_cogorc_convert_AYUV_RGBA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x00000080, "c2");
      orc_program_add_constant (p, 4, 0x0000002a, "c3");
      orc_program_add_constant (p, 4, 0x00000067, "c4");
      orc_program_add_constant (p, 4, 0x00000004, "c5");
      orc_program_add_constant (p, 4, 0x00000064, "c6");
      orc_program_add_constant (p, 4, 0x00000068, "c7");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 1, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 2, "t11");
      orc_program_add_temporary (p, 2, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 1, "t14");
      orc_program_add_temporary (p, 1, "t15");
      orc_program_add_temporary (p, 4, "t16");

      orc_program_append_2 (p, "subb", 2, 47, ORC_VAR_S1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T1, ORC_VAR_T2, 47,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T6, ORC_VAR_T5, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T7, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T7, ORC_VAR_T9,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T9, ORC_VAR_C4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T12,
          ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T8, ORC_VAR_C5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T12, ORC_VAR_T12,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T8, ORC_VAR_C6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T7, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T9, ORC_VAR_C7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T11,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T11, ORC_VAR_T11,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T14, ORC_VAR_T11,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T15, ORC_VAR_T12,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T13,
          ORC_VAR_T14, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_T15,
          ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, 47, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, 47, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ORC_EXECUTOR_M (ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_I420_BGRA */
#ifdef DISABLE_ORC
void
cogorc_convert_I420_BGRA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_int8 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_int8 var57;
  orc_union16 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_int8 var85;
  orc_int8 var86;
  orc_int8 var87;
  orc_union16 var88;
  orc_union16 var89;
  orc_union32 var90;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 1: loadpb */
  var46 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 5: loadpb */
  var47 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 9: loadpb */
  var48 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 12: loadpw */
  var49.i = (int) 0x0000002a;   /* 42 or 2.07508e-322f */
  /* 17: loadpw */
  var50.i = (int) 0x00000067;   /* 103 or 5.08888e-322f */
  /* 24: loadpw */
  var51.i = (int) 0x00000004;   /* 4 or 1.97626e-323f */
  /* 28: loadpw */
  var52.i = (int) 0x00000064;   /* 100 or 4.94066e-322f */
  /* 32: loadpw */
  var53.i = (int) 0x00000068;   /* 104 or 5.13828e-322f */
  /* 41: loadpb */
  var54 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 44: loadpb */
  var55.x4[0] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var55.x4[1] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var55.x4[2] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var55.x4[3] = (int) 0x00000080;       /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var45 = ptr4[i];
    /* 2: subb */
    var57 = var45 - var46;
    /* 3: convsbw */
    var58.i = var57;
    /* 4: loadupib */
    var59 =
        (i & 1) ? ((orc_uint8) ptr5[i >> 1] + (orc_uint8) ptr5[(i >> 1) + 1] +
        1) >> 1 : ptr5[i >> 1];
    /* 6: subb */
    var60 = var59 - var47;
    /* 7: convsbw */
    var61.i = var60;
    /* 8: loadupib */
    var62 =
        (i & 1) ? ((orc_uint8) ptr6[i >> 1] + (orc_uint8) ptr6[(i >> 1) + 1] +
        1) >> 1 : ptr6[i >> 1];
    /* 10: subb */
    var63 = var62 - var48;
    /* 11: convsbw */
    var64.i = var63;
    /* 13: mullw */
    var65.i = (var58.i * var49.i) & 0xffff;
    /* 14: shrsw */
    var66.i = var65.i >> 8;
    /* 15: addssw */
    var67.i = ORC_CLAMP_SW (var58.i + var66.i);
    /* 16: addssw */
    var68.i = ORC_CLAMP_SW (var67.i + var64.i);
    /* 18: mullw */
    var69.i = (var64.i * var50.i) & 0xffff;
    /* 19: shrsw */
    var70.i = var69.i >> 8;
    /* 20: subssw */
    var71.i = ORC_CLAMP_SW (var68.i - var70.i);
    /* 21: addssw */
    var72.i = ORC_CLAMP_SW (var71.i + var64.i);
    /* 22: addssw */
    var73.i = ORC_CLAMP_SW (var67.i + var61.i);
    /* 23: addssw */
    var74.i = ORC_CLAMP_SW (var73.i + var61.i);
    /* 25: mullw */
    var75.i = (var61.i * var51.i) & 0xffff;
    /* 26: shrsw */
    var76.i = var75.i >> 8;
    /* 27: addssw */
    var77.i = ORC_CLAMP_SW (var74.i + var76.i);
    /* 29: mullw */
    var78.i = (var61.i * var52.i) & 0xffff;
    /* 30: shrsw */
    var79.i = var78.i >> 8;
    /* 31: subssw */
    var80.i = ORC_CLAMP_SW (var67.i - var79.i);
    /* 33: mullw */
    var81.i = (var64.i * var53.i) & 0xffff;
    /* 34: shrsw */
    var82.i = var81.i >> 8;
    /* 35: subssw */
    var83.i = ORC_CLAMP_SW (var80.i - var82.i);
    /* 36: subssw */
    var84.i = ORC_CLAMP_SW (var83.i - var82.i);
    /* 37: convssswb */
    var85 = ORC_CLAMP_SB (var72.i);
    /* 38: convssswb */
    var86 = ORC_CLAMP_SB (var84.i);
    /* 39: convssswb */
    var87 = ORC_CLAMP_SB (var77.i);
    /* 40: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var87;
      _dest.x2[1] = var86;
      var88.i = _dest.i;
    }
    /* 42: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var85;
      _dest.x2[1] = var54;
      var89.i = _dest.i;
    }
    /* 43: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var88.i;
      _dest.x2[1] = var89.i;
      var90.i = _dest.i;
    }
    /* 45: addb */
    var56.x4[0] = var90.x4[0] + var55.x4[0];
    var56.x4[1] = var90.x4[1] + var55.x4[1];
    var56.x4[2] = var90.x4[2] + var55.x4[2];
    var56.x4[3] = var90.x4[3] + var55.x4[3];
    /* 46: storel */
    ptr0[i] = var56;
  }

}

#else
static void
_backup_cogorc_convert_I420_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_int8 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_int8 var57;
  orc_union16 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_union16 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_int8 var85;
  orc_int8 var86;
  orc_int8 var87;
  orc_union16 var88;
  orc_union16 var89;
  orc_union32 var90;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 1: loadpb */
  var46 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 5: loadpb */
  var47 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 9: loadpb */
  var48 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 12: loadpw */
  var49.i = (int) 0x0000002a;   /* 42 or 2.07508e-322f */
  /* 17: loadpw */
  var50.i = (int) 0x00000067;   /* 103 or 5.08888e-322f */
  /* 24: loadpw */
  var51.i = (int) 0x00000004;   /* 4 or 1.97626e-323f */
  /* 28: loadpw */
  var52.i = (int) 0x00000064;   /* 100 or 4.94066e-322f */
  /* 32: loadpw */
  var53.i = (int) 0x00000068;   /* 104 or 5.13828e-322f */
  /* 41: loadpb */
  var54 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 44: loadpb */
  var55.x4[0] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var55.x4[1] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var55.x4[2] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var55.x4[3] = (int) 0x00000080;       /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var45 = ptr4[i];
    /* 2: subb */
    var57 = var45 - var46;
    /* 3: convsbw */
    var58.i = var57;
    /* 4: loadupib */
    var59 =
        (i & 1) ? ((orc_uint8) ptr5[i >> 1] + (orc_uint8) ptr5[(i >> 1) + 1] +
        1) >> 1 : ptr5[i >> 1];
    /* 6: subb */
    var60 = var59 - var47;
    /* 7: convsbw */
    var61.i = var60;
    /* 8: loadupib */
    var62 =
        (i & 1) ? ((orc_uint8) ptr6[i >> 1] + (orc_uint8) ptr6[(i >> 1) + 1] +
        1) >> 1 : ptr6[i >> 1];
    /* 10: subb */
    var63 = var62 - var48;
    /* 11: convsbw */
    var64.i = var63;
    /* 13: mullw */
    var65.i = (var58.i * var49.i) & 0xffff;
    /* 14: shrsw */
    var66.i = var65.i >> 8;
    /* 15: addssw */
    var67.i = ORC_CLAMP_SW (var58.i + var66.i);
    /* 16: addssw */
    var68.i = ORC_CLAMP_SW (var67.i + var64.i);
    /* 18: mullw */
    var69.i = (var64.i * var50.i) & 0xffff;
    /* 19: shrsw */
    var70.i = var69.i >> 8;
    /* 20: subssw */
    var71.i = ORC_CLAMP_SW (var68.i - var70.i);
    /* 21: addssw */
    var72.i = ORC_CLAMP_SW (var71.i + var64.i);
    /* 22: addssw */
    var73.i = ORC_CLAMP_SW (var67.i + var61.i);
    /* 23: addssw */
    var74.i = ORC_CLAMP_SW (var73.i + var61.i);
    /* 25: mullw */
    var75.i = (var61.i * var51.i) & 0xffff;
    /* 26: shrsw */
    var76.i = var75.i >> 8;
    /* 27: addssw */
    var77.i = ORC_CLAMP_SW (var74.i + var76.i);
    /* 29: mullw */
    var78.i = (var61.i * var52.i) & 0xffff;
    /* 30: shrsw */
    var79.i = var78.i >> 8;
    /* 31: subssw */
    var80.i = ORC_CLAMP_SW (var67.i - var79.i);
    /* 33: mullw */
    var81.i = (var64.i * var53.i) & 0xffff;
    /* 34: shrsw */
    var82.i = var81.i >> 8;
    /* 35: subssw */
    var83.i = ORC_CLAMP_SW (var80.i - var82.i);
    /* 36: subssw */
    var84.i = ORC_CLAMP_SW (var83.i - var82.i);
    /* 37: convssswb */
    var85 = ORC_CLAMP_SB (var72.i);
    /* 38: convssswb */
    var86 = ORC_CLAMP_SB (var84.i);
    /* 39: convssswb */
    var87 = ORC_CLAMP_SB (var77.i);
    /* 40: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var87;
      _dest.x2[1] = var86;
      var88.i = _dest.i;
    }
    /* 42: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var85;
      _dest.x2[1] = var54;
      var89.i = _dest.i;
    }
    /* 43: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var88.i;
      _dest.x2[1] = var89.i;
      var90.i = _dest.i;
    }
    /* 45: addb */
    var56.x4[0] = var90.x4[0] + var55.x4[0];
    var56.x4[1] = var90.x4[1] + var55.x4[1];
    var56.x4[2] = var90.x4[2] + var55.x4[2];
    var56.x4[3] = var90.x4[3] + var55.x4[3];
    /* 46: storel */
    ptr0[i] = var56;
  }

}

void
cogorc_convert_I420_BGRA (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_convert_I420_BGRA");
      orc_program_set_backup_function (p, _backup_cogorc_convert_I420_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x00000008, "c1");
      orc_program_add_constant (p, 1, 0x00000080, "c2");
      orc_program_add_constant (p, 4, 0x0000002a, "c3");
      orc_program_add_constant (p, 4, 0x00000067, "c4");
      orc_program_add_constant (p, 4, 0x00000004, "c5");
      orc_program_add_constant (p, 4, 0x00000064, "c6");
      orc_program_add_constant (p, 4, 0x00000068, "c7");
      orc_program_add_constant (p, 4, 0x000000ff, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 1, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");
      orc_program_add_temporary (p, 4, "t13");

      orc_program_append_2 (p, "subb", 0, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadupib", 0, ORC_VAR_T3, ORC_VAR_S2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadupib", 0, ORC_VAR_T3, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T6, ORC_VAR_C4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_C5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_C6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T8, ORC_VAR_T4, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T6, ORC_VAR_C7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T8, ORC_VAR_T8, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T8, ORC_VAR_T8, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T10, ORC_VAR_T7,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T11, ORC_VAR_T8,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T12, ORC_VAR_T9,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T12,
          ORC_VAR_T11, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_T10,
          ORC_VAR_C8, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T13, ORC_VAR_T1,
          ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T13, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_convert_I420_BGRA_avg */
#ifdef DISABLE_ORC
void
cogorc_convert_I420_BGRA_avg (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  const orc_int8 *ORC_RESTRICT ptr8;
  orc_int8 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_int8 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_int8 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_int8 var58;
  orc_union16 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_int8 var65;
  orc_int8 var66;
  orc_int8 var67;
  orc_int8 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_union16 var85;
  orc_union16 var86;
  orc_union16 var87;
  orc_union16 var88;
  orc_union16 var89;
  orc_int8 var90;
  orc_int8 var91;
  orc_int8 var92;
  orc_union16 var93;
  orc_union16 var94;
  orc_union32 var95;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;
  ptr8 = (orc_int8 *) s5;

  /* 1: loadpb */
  var47 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 7: loadpb */
  var48 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 13: loadpb */
  var49 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 16: loadpw */
  var50.i = (int) 0x0000002a;   /* 42 or 2.07508e-322f */
  /* 21: loadpw */
  var51.i = (int) 0x00000067;   /* 103 or 5.08888e-322f */
  /* 28: loadpw */
  var52.i = (int) 0x00000004;   /* 4 or 1.97626e-323f */
  /* 32: loadpw */
  var53.i = (int) 0x00000064;   /* 100 or 4.94066e-322f */
  /* 36: loadpw */
  var54.i = (int) 0x00000068;   /* 104 or 5.13828e-322f */
  /* 45: loadpb */
  var55 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 48: loadpb */
  var56.x4[0] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var56.x4[1] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var56.x4[2] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var56.x4[3] = (int) 0x00000080;       /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var46 = ptr4[i];
    /* 2: subb */
    var58 = var46 - var47;
    /* 3: convsbw */
    var59.i = var58;
    /* 4: loadupib */
    var60 =
        (i & 1) ? ((orc_uint8) ptr5[i >> 1] + (orc_uint8) ptr5[(i >> 1) + 1] +
        1) >> 1 : ptr5[i >> 1];
    /* 5: loadupib */
    var61 =
        (i & 1) ? ((orc_uint8) ptr6[i >> 1] + (orc_uint8) ptr6[(i >> 1) + 1] +
        1) >> 1 : ptr6[i >> 1];
    /* 6: avgub */
    var62 = ((orc_uint8) var60 + (orc_uint8) var61 + 1) >> 1;
    /* 8: subb */
    var63 = var62 - var48;
    /* 9: convsbw */
    var64.i = var63;
    /* 10: loadupib */
    var65 =
        (i & 1) ? ((orc_uint8) ptr7[i >> 1] + (orc_uint8) ptr7[(i >> 1) + 1] +
        1) >> 1 : ptr7[i >> 1];
    /* 11: loadupib */
    var66 =
        (i & 1) ? ((orc_uint8) ptr8[i >> 1] + (orc_uint8) ptr8[(i >> 1) + 1] +
        1) >> 1 : ptr8[i >> 1];
    /* 12: avgub */
    var67 = ((orc_uint8) var65 + (orc_uint8) var66 + 1) >> 1;
    /* 14: subb */
    var68 = var67 - var49;
    /* 15: convsbw */
    var69.i = var68;
    /* 17: mullw */
    var70.i = (var59.i * var50.i) & 0xffff;
    /* 18: shrsw */
    var71.i = var70.i >> 8;
    /* 19: addssw */
    var72.i = ORC_CLAMP_SW (var59.i + var71.i);
    /* 20: addssw */
    var73.i = ORC_CLAMP_SW (var72.i + var69.i);
    /* 22: mullw */
    var74.i = (var69.i * var51.i) & 0xffff;
    /* 23: shrsw */
    var75.i = var74.i >> 8;
    /* 24: subssw */
    var76.i = ORC_CLAMP_SW (var73.i - var75.i);
    /* 25: addssw */
    var77.i = ORC_CLAMP_SW (var76.i + var69.i);
    /* 26: addssw */
    var78.i = ORC_CLAMP_SW (var72.i + var64.i);
    /* 27: addssw */
    var79.i = ORC_CLAMP_SW (var78.i + var64.i);
    /* 29: mullw */
    var80.i = (var64.i * var52.i) & 0xffff;
    /* 30: shrsw */
    var81.i = var80.i >> 8;
    /* 31: addssw */
    var82.i = ORC_CLAMP_SW (var79.i + var81.i);
    /* 33: mullw */
    var83.i = (var64.i * var53.i) & 0xffff;
    /* 34: shrsw */
    var84.i = var83.i >> 8;
    /* 35: subssw */
    var85.i = ORC_CLAMP_SW (var72.i - var84.i);
    /* 37: mullw */
    var86.i = (var69.i * var54.i) & 0xffff;
    /* 38: shrsw */
    var87.i = var86.i >> 8;
    /* 39: subssw */
    var88.i = ORC_CLAMP_SW (var85.i - var87.i);
    /* 40: subssw */
    var89.i = ORC_CLAMP_SW (var88.i - var87.i);
    /* 41: convssswb */
    var90 = ORC_CLAMP_SB (var77.i);
    /* 42: convssswb */
    var91 = ORC_CLAMP_SB (var89.i);
    /* 43: convssswb */
    var92 = ORC_CLAMP_SB (var82.i);
    /* 44: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var92;
      _dest.x2[1] = var91;
      var93.i = _dest.i;
    }
    /* 46: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var90;
      _dest.x2[1] = var55;
      var94.i = _dest.i;
    }
    /* 47: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var93.i;
      _dest.x2[1] = var94.i;
      var95.i = _dest.i;
    }
    /* 49: addb */
    var57.x4[0] = var95.x4[0] + var56.x4[0];
    var57.x4[1] = var95.x4[1] + var56.x4[1];
    var57.x4[2] = var95.x4[2] + var56.x4[2];
    var57.x4[3] = var95.x4[3] + var56.x4[3];
    /* 50: storel */
    ptr0[i] = var57;
  }

}

#else
static void
_backup_cogorc_convert_I420_BGRA_avg (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  const orc_int8 *ORC_RESTRICT ptr8;
  orc_int8 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_int8 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_int8 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_int8 var58;
  orc_union16 var59;
  orc_int8 var60;
  orc_int8 var61;
  orc_int8 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_int8 var65;
  orc_int8 var66;
  orc_int8 var67;
  orc_int8 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_union16 var76;
  orc_union16 var77;
  orc_union16 var78;
  orc_union16 var79;
  orc_union16 var80;
  orc_union16 var81;
  orc_union16 var82;
  orc_union16 var83;
  orc_union16 var84;
  orc_union16 var85;
  orc_union16 var86;
  orc_union16 var87;
  orc_union16 var88;
  orc_union16 var89;
  orc_int8 var90;
  orc_int8 var91;
  orc_int8 var92;
  orc_union16 var93;
  orc_union16 var94;
  orc_union32 var95;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];
  ptr8 = (orc_int8 *) ex->arrays[8];

  /* 1: loadpb */
  var47 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 7: loadpb */
  var48 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 13: loadpb */
  var49 = (int) 0x00000080;     /* 128 or 6.32404e-322f */
  /* 16: loadpw */
  var50.i = (int) 0x0000002a;   /* 42 or 2.07508e-322f */
  /* 21: loadpw */
  var51.i = (int) 0x00000067;   /* 103 or 5.08888e-322f */
  /* 28: loadpw */
  var52.i = (int) 0x00000004;   /* 4 or 1.97626e-323f */
  /* 32: loadpw */
  var53.i = (int) 0x00000064;   /* 100 or 4.94066e-322f */
  /* 36: loadpw */
  var54.i = (int) 0x00000068;   /* 104 or 5.13828e-322f */
  /* 45: loadpb */
  var55 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 48: loadpb */
  var56.x4[0] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var56.x4[1] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var56.x4[2] = (int) 0x00000080;       /* 128 or 6.32404e-322f */
  var56.x4[3] = (int) 0x00000080;       /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var46 = ptr4[i];
    /* 2: subb */
    var58 = var46 - var47;
    /* 3: convsbw */
    var59.i = var58;
    /* 4: loadupib */
    var60 =
        (i & 1) ? ((orc_uint8) ptr5[i >> 1] + (orc_uint8) ptr5[(i >> 1) + 1] +
        1) >> 1 : ptr5[i >> 1];
    /* 5: loadupib */
    var61 =
        (i & 1) ? ((orc_uint8) ptr6[i >> 1] + (orc_uint8) ptr6[(i >> 1) + 1] +
        1) >> 1 : ptr6[i >> 1];
    /* 6: avgub */
    var62 = ((orc_uint8) var60 + (orc_uint8) var61 + 1) >> 1;
    /* 8: subb */
    var63 = var62 - var48;
    /* 9: convsbw */
    var64.i = var63;
    /* 10: loadupib */
    var65 =
        (i & 1) ? ((orc_uint8) ptr7[i >> 1] + (orc_uint8) ptr7[(i >> 1) + 1] +
        1) >> 1 : ptr7[i >> 1];
    /* 11: loadupib */
    var66 =
        (i & 1) ? ((orc_uint8) ptr8[i >> 1] + (orc_uint8) ptr8[(i >> 1) + 1] +
        1) >> 1 : ptr8[i >> 1];
    /* 12: avgub */
    var67 = ((orc_uint8) var65 + (orc_uint8) var66 + 1) >> 1;
    /* 14: subb */
    var68 = var67 - var49;
    /* 15: convsbw */
    var69.i = var68;
    /* 17: mullw */
    var70.i = (var59.i * var50.i) & 0xffff;
    /* 18: shrsw */
    var71.i = var70.i >> 8;
    /* 19: addssw */
    var72.i = ORC_CLAMP_SW (var59.i + var71.i);
    /* 20: addssw */
    var73.i = ORC_CLAMP_SW (var72.i + var69.i);
    /* 22: mullw */
    var74.i = (var69.i * var51.i) & 0xffff;
    /* 23: shrsw */
    var75.i = var74.i >> 8;
    /* 24: subssw */
    var76.i = ORC_CLAMP_SW (var73.i - var75.i);
    /* 25: addssw */
    var77.i = ORC_CLAMP_SW (var76.i + var69.i);
    /* 26: addssw */
    var78.i = ORC_CLAMP_SW (var72.i + var64.i);
    /* 27: addssw */
    var79.i = ORC_CLAMP_SW (var78.i + var64.i);
    /* 29: mullw */
    var80.i = (var64.i * var52.i) & 0xffff;
    /* 30: shrsw */
    var81.i = var80.i >> 8;
    /* 31: addssw */
    var82.i = ORC_CLAMP_SW (var79.i + var81.i);
    /* 33: mullw */
    var83.i = (var64.i * var53.i) & 0xffff;
    /* 34: shrsw */
    var84.i = var83.i >> 8;
    /* 35: subssw */
    var85.i = ORC_CLAMP_SW (var72.i - var84.i);
    /* 37: mullw */
    var86.i = (var69.i * var54.i) & 0xffff;
    /* 38: shrsw */
    var87.i = var86.i >> 8;
    /* 39: subssw */
    var88.i = ORC_CLAMP_SW (var85.i - var87.i);
    /* 40: subssw */
    var89.i = ORC_CLAMP_SW (var88.i - var87.i);
    /* 41: convssswb */
    var90 = ORC_CLAMP_SB (var77.i);
    /* 42: convssswb */
    var91 = ORC_CLAMP_SB (var89.i);
    /* 43: convssswb */
    var92 = ORC_CLAMP_SB (var82.i);
    /* 44: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var92;
      _dest.x2[1] = var91;
      var93.i = _dest.i;
    }
    /* 46: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var90;
      _dest.x2[1] = var55;
      var94.i = _dest.i;
    }
    /* 47: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var93.i;
      _dest.x2[1] = var94.i;
      var95.i = _dest.i;
    }
    /* 49: addb */
    var57.x4[0] = var95.x4[0] + var56.x4[0];
    var57.x4[1] = var95.x4[1] + var56.x4[1];
    var57.x4[2] = var95.x4[2] + var56.x4[2];
    var57.x4[3] = var95.x4[3] + var56.x4[3];
    /* 50: storel */
    ptr0[i] = var57;
  }

}

void
cogorc_convert_I420_BGRA_avg (guint8 * ORC_RESTRICT d1,
    const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2,
    const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4,
    const guint8 * ORC_RESTRICT s5, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_convert_I420_BGRA_avg");
      orc_program_set_backup_function (p, _backup_cogorc_convert_I420_BGRA_avg);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_source (p, 1, "s5");
      orc_program_add_constant (p, 1, 0x00000008, "c1");
      orc_program_add_constant (p, 1, 0x00000080, "c2");
      orc_program_add_constant (p, 4, 0x0000002a, "c3");
      orc_program_add_constant (p, 4, 0x00000067, "c4");
      orc_program_add_constant (p, 4, 0x00000004, "c5");
      orc_program_add_constant (p, 4, 0x00000064, "c6");
      orc_program_add_constant (p, 4, 0x00000068, "c7");
      orc_program_add_constant (p, 4, 0x000000ff, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 4, "t14");

      orc_program_append_2 (p, "subb", 0, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadupib", 0, ORC_VAR_T3, ORC_VAR_S2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupib", 0, ORC_VAR_T4, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "loadupib", 0, ORC_VAR_T3, ORC_VAR_S4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupib", 0, ORC_VAR_T4, ORC_VAR_S5,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convsbw", 0, ORC_VAR_T7, ORC_VAR_T3, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_C3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T7, ORC_VAR_C4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T8, ORC_VAR_T8, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T8, ORC_VAR_T8, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T5, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T6, ORC_VAR_C5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "addssw", 0, ORC_VAR_T10, ORC_VAR_T10,
          ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T6, ORC_VAR_C6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T7, ORC_VAR_C7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "subssw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T11, ORC_VAR_T8,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T12, ORC_VAR_T9,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T13,
          ORC_VAR_T12, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_T11,
          ORC_VAR_C8, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T14, ORC_VAR_T1,
          ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T14, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;
  ex->arrays[ORC_VAR_S5] = (void *) s5;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_I420 */
#ifdef DISABLE_ORC
void
cogorc_getline_I420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i >> 1];
    /* 1: loadupdb */
    var40 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var41.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var41.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_getline_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i >> 1];
    /* 1: loadupdb */
    var40 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var41.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var41.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

void
cogorc_getline_I420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_I420");
      orc_program_set_backup_function (p, _backup_cogorc_getline_I420);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T3, ORC_VAR_S2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_YUV9 */
#ifdef DISABLE_ORC
void
cogorc_getline_YUV9 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_union16 var37;
  orc_union16 var38;
  orc_union64 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union32 var43;
  orc_union32 var44;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 4: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var40 = ptr5[i >> 1];
    /* 1: loadupdb */
    var41 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var40;
      _dest.x2[1] = var41;
      var42.i = _dest.i;
    }
    /* 3: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var42.i;
      var43.i = _dest.i;
    }
    /* 5: loadw */
    var38 = ptr4[i];
    /* 6: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var38.x2[0];
      var44.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var38.x2[1];
      var44.x2[1] = _dest.i;
    }
    /* 7: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var43.x2[0];
      var39.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var43.x2[1];
      var39.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_cogorc_getline_YUV9 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_union16 var37;
  orc_union16 var38;
  orc_union64 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union32 var43;
  orc_union32 var44;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 4: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var40 = ptr5[i >> 1];
    /* 1: loadupdb */
    var41 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var40;
      _dest.x2[1] = var41;
      var42.i = _dest.i;
    }
    /* 3: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var42.i;
      var43.i = _dest.i;
    }
    /* 5: loadw */
    var38 = ptr4[i];
    /* 6: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var38.x2[0];
      var44.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var38.x2[1];
      var44.x2[1] = _dest.i;
    }
    /* 7: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var43.x2[0];
      var39.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var43.x2[1];
      var39.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var39;
  }

}

void
cogorc_getline_YUV9 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_YUV9");
      orc_program_set_backup_function (p, _backup_cogorc_getline_YUV9);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T5, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_YUY2 */
#ifdef DISABLE_ORC
void
cogorc_getline_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 2: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var40.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var40.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var39.i;
      _dest.x2[1] = var39.i;
      var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var42.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var42.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_getline_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 2: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var40.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var40.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var39.i;
      _dest.x2[1] = var39.i;
      var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var42.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var42.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

void
cogorc_getline_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_YUY2");
      orc_program_set_backup_function (p, _backup_cogorc_getline_YUY2);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_UYVY */
#ifdef DISABLE_ORC
void
cogorc_getline_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 2: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var39.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var39.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.i;
      _dest.x2[1] = var40.i;
      var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var42.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var42.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_getline_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 2: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var39.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var39.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.i;
      _dest.x2[1] = var40.i;
      var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var42.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var42.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

void
cogorc_getline_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_UYVY");
      orc_program_set_backup_function (p, _backup_cogorc_getline_UYVY);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_YVYU */
#ifdef DISABLE_ORC
void
cogorc_getline_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union32 *) s1;

  /* 3: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: swapw */
    var41.i = ORC_SWAP_W (var39.i);
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var40.x2[0];
      var42.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var40.x2[1];
      var42.x2[1] = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.i;
      _dest.x2[1] = var41.i;
      var43.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[0];
      _dest.x2[1] = var43.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[1];
      _dest.x2[1] = var43.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_getline_YVYU (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];

  /* 3: loadpb */
  var37.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var37.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
      orc_union16 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: swapw */
    var41.i = ORC_SWAP_W (var39.i);
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[0];
      _dest.x2[1] = var40.x2[0];
      var42.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var37.x2[1];
      _dest.x2[1] = var40.x2[1];
      var42.x2[1] = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.i;
      _dest.x2[1] = var41.i;
      var43.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[0];
      _dest.x2[1] = var43.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[1];
      _dest.x2[1] = var43.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

void
cogorc_getline_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_YVYU");
      orc_program_set_backup_function (p, _backup_cogorc_getline_YVYU);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_Y42B */
#ifdef DISABLE_ORC
void
cogorc_getline_Y42B (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 3: loadpb */
  var38.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var38.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var36 = ptr5[i];
    /* 1: loadb */
    var37 = ptr6[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var41.i = _dest.i;
    }
    /* 4: loadw */
    var39 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var38.x2[0];
      _dest.x2[1] = var39.x2[0];
      var42.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var38.x2[1];
      _dest.x2[1] = var39.x2[1];
      var42.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.i;
      _dest.x2[1] = var41.i;
      var43.i = _dest.i;
    }
    /* 7: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[0];
      _dest.x2[1] = var43.x2[0];
      var40.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[1];
      _dest.x2[1] = var43.x2[1];
      var40.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_cogorc_getline_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 3: loadpb */
  var38.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var38.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var36 = ptr5[i];
    /* 1: loadb */
    var37 = ptr6[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var41.i = _dest.i;
    }
    /* 4: loadw */
    var39 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var38.x2[0];
      _dest.x2[1] = var39.x2[0];
      var42.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var38.x2[1];
      _dest.x2[1] = var39.x2[1];
      var42.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.i;
      _dest.x2[1] = var41.i;
      var43.i = _dest.i;
    }
    /* 7: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[0];
      _dest.x2[1] = var43.x2[0];
      var40.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.x2[1];
      _dest.x2[1] = var43.x2[1];
      var40.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var40;
  }

}

void
cogorc_getline_Y42B (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_Y42B");
      orc_program_set_backup_function (p, _backup_cogorc_getline_Y42B);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T4, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_T3,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_Y444 */
#ifdef DISABLE_ORC
void
cogorc_getline_Y444 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr5[i];
    /* 1: loadb */
    var35 = ptr6[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var34;
      _dest.x2[1] = var35;
      var39.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var40.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.i;
      _dest.x2[1] = var39.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_getline_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];

  /* 3: loadpb */
  var36 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr5[i];
    /* 1: loadb */
    var35 = ptr6[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var34;
      _dest.x2[1] = var35;
      var39.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var40.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.i;
      _dest.x2[1] = var39.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

void
cogorc_getline_Y444 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_Y444");
      orc_program_set_backup_function (p, _backup_cogorc_getline_Y444);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_Y800 */
#ifdef DISABLE_ORC
void
cogorc_getline_Y800 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;

  /* 0: loadpb */
  var33 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 3: loadpw */
  var35.i = (int) 0x00008080;   /* 32896 or 1.62528e-319f */

  for (i = 0; i < n; i++) {
    /* 1: loadb */
    var34 = ptr4[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var37.i = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var37.i;
      _dest.x2[1] = var35.i;
      var36.i = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_cogorc_getline_Y800 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];

  /* 0: loadpb */
  var33 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 3: loadpw */
  var35.i = (int) 0x00008080;   /* 32896 or 1.62528e-319f */

  for (i = 0; i < n; i++) {
    /* 1: loadb */
    var34 = ptr4[i];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var33;
      _dest.x2[1] = var34;
      var37.i = _dest.i;
    }
    /* 4: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var37.i;
      _dest.x2[1] = var35.i;
      var36.i = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
cogorc_getline_Y800 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_Y800");
      orc_program_set_backup_function (p, _backup_cogorc_getline_Y800);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_constant (p, 2, 0x00008080, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_Y16 */
#ifdef DISABLE_ORC
void
cogorc_getline_Y16 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_int8 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union16 *) s1;

  /* 2: loadpb */
  var35 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 4: loadpw */
  var36.i = (int) 0x00008080;   /* 32896 or 1.62528e-319f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: convhwb */
    var38 = ((orc_uint16) var34.i) >> 8;
    /* 3: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var35;
      _dest.x2[1] = var38;
      var39.i = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var39.i;
      _dest.x2[1] = var36.i;
      var37.i = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_cogorc_getline_Y16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_int8 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_int8 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];

  /* 2: loadpb */
  var35 = (int) 0x000000ff;     /* 255 or 1.25987e-321f */
  /* 4: loadpw */
  var36.i = (int) 0x00008080;   /* 32896 or 1.62528e-319f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: convhwb */
    var38 = ((orc_uint16) var34.i) >> 8;
    /* 3: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var35;
      _dest.x2[1] = var38;
      var39.i = _dest.i;
    }
    /* 5: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var39.i;
      _dest.x2[1] = var36.i;
      var37.i = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var37;
  }

}

void
cogorc_getline_Y16 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_Y16");
      orc_program_set_backup_function (p, _backup_cogorc_getline_Y16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_constant (p, 2, 0x00008080, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");

      orc_program_append_2 (p, "convhwb", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_BGRA */
#ifdef DISABLE_ORC
void
cogorc_getline_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_cogorc_getline_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
cogorc_getline_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_BGRA");
      orc_program_set_backup_function (p, _backup_cogorc_getline_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_ABGR */
#ifdef DISABLE_ORC
void
cogorc_getline_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47;
      _dest.x2[1] = var44;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var45;
      _dest.x2[1] = var46;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_cogorc_getline_ABGR (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47;
      _dest.x2[1] = var44;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var45;
      _dest.x2[1] = var46;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

void
cogorc_getline_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_ABGR");
      orc_program_set_backup_function (p, _backup_cogorc_getline_ABGR);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T7, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_RGBA */
#ifdef DISABLE_ORC
void
cogorc_getline_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var46;
      _dest.x2[1] = var45;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44;
      _dest.x2[1] = var47;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_cogorc_getline_RGBA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var46;
      _dest.x2[1] = var45;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44;
      _dest.x2[1] = var47;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

void
cogorc_getline_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_RGBA");
      orc_program_set_backup_function (p, _backup_cogorc_getline_RGBA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T6, ORC_VAR_T5, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T7, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T7, ORC_VAR_T8,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_NV12 */
#ifdef DISABLE_ORC
void
cogorc_getline_NV12 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;

  /* 3: loadpb */
  var36.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var36.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: loadw */
    var35 = ptr5[i];
    /* 2: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var34.i;
      _dest.x2[1] = var35.i;
      var39.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[0];
      _dest.x2[1] = var37.x2[0];
      var40.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[1];
      _dest.x2[1] = var37.x2[1];
      var40.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.x2[0];
      _dest.x2[1] = var39.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.x2[1];
      _dest.x2[1] = var39.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_getline_NV12 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];

  /* 3: loadpb */
  var36.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var36.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: loadw */
    var35 = ptr5[i];
    /* 2: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var34.i;
      _dest.x2[1] = var35.i;
      var39.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[0];
      _dest.x2[1] = var37.x2[0];
      var40.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[1];
      _dest.x2[1] = var37.x2[1];
      var40.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.x2[0];
      _dest.x2[1] = var39.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var40.x2[1];
      _dest.x2[1] = var39.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

void
cogorc_getline_NV12 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_NV12");
      orc_program_set_backup_function (p, _backup_cogorc_getline_NV12);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_NV21 */
#ifdef DISABLE_ORC
void
cogorc_getline_NV21 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  int i;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union64 *) d1;
  ptr4 = (orc_union16 *) s1;
  ptr5 = (orc_union16 *) s2;

  /* 3: loadpb */
  var36.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var36.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr5[i];
    /* 1: swapw */
    var39.i = ORC_SWAP_W (var35.i);
    /* 2: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var39.i;
      _dest.x2[1] = var39.i;
      var40.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[0];
      _dest.x2[1] = var37.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[1];
      _dest.x2[1] = var37.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var40.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var40.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_getline_NV21 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 *ORC_RESTRICT ptr0;
  const orc_union16 *ORC_RESTRICT ptr4;
  const orc_union16 *ORC_RESTRICT ptr5;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union64 *) ex->arrays[0];
  ptr4 = (orc_union16 *) ex->arrays[4];
  ptr5 = (orc_union16 *) ex->arrays[5];

  /* 3: loadpb */
  var36.x2[0] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */
  var36.x2[1] = (int) 0x000000ff;       /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr5[i];
    /* 1: swapw */
    var39.i = ORC_SWAP_W (var35.i);
    /* 2: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var39.i;
      _dest.x2[1] = var39.i;
      var40.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[0];
      _dest.x2[1] = var37.x2[0];
      var41.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var36.x2[1];
      _dest.x2[1] = var37.x2[1];
      var41.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[0];
      _dest.x2[1] = var40.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union32 _dest;
      _dest.x2[0] = var41.x2[1];
      _dest.x2[1] = var40.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

void
cogorc_getline_NV21 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_NV21");
      orc_program_set_backup_function (p, _backup_cogorc_getline_NV21);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_getline_A420 */
#ifdef DISABLE_ORC
void
cogorc_getline_A420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_int8 *) s1;
  ptr5 = (orc_int8 *) s2;
  ptr6 = (orc_int8 *) s3;
  ptr7 = (orc_int8 *) s4;


  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i >> 1];
    /* 1: loadupdb */
    var40 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var41.i = _dest.i;
    }
    /* 3: loadb */
    var36 = ptr7[i];
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var41.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_getline_A420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_int8 *ORC_RESTRICT ptr4;
  const orc_int8 *ORC_RESTRICT ptr5;
  const orc_int8 *ORC_RESTRICT ptr6;
  const orc_int8 *ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_int8 *) ex->arrays[4];
  ptr5 = (orc_int8 *) ex->arrays[5];
  ptr6 = (orc_int8 *) ex->arrays[6];
  ptr7 = (orc_int8 *) ex->arrays[7];


  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i >> 1];
    /* 1: loadupdb */
    var40 = ptr6[i >> 1];
    /* 2: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var39;
      _dest.x2[1] = var40;
      var41.i = _dest.i;
    }
    /* 3: loadb */
    var36 = ptr7[i];
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var36;
      _dest.x2[1] = var37;
      var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var42.i;
      _dest.x2[1] = var41.i;
      var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

void
cogorc_getline_A420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3,
    const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_getline_A420");
      orc_program_set_backup_function (p, _backup_cogorc_getline_A420);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T3, ORC_VAR_S2,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S3,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;
  ex->arrays[ORC_VAR_S2] = (void *) s2;
  ex->arrays[ORC_VAR_S3] = (void *) s3;
  ex->arrays[ORC_VAR_S4] = (void *) s4;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_I420 */
#ifdef DISABLE_ORC
void
cogorc_putline_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_int8 var49;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_int8 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var38 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var38.x2[0];
      var42.x2[0] = _src.x2[1];
      var43.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var38.x2[1];
      var42.x2[1] = _src.x2[1];
      var43.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var43.x2[0];
      var39.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var43.x2[1];
      var39.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var39;
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.x2[0];
      var44.x2[0] = _src.x2[1];
      var45.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var42.x2[1];
      var44.x2[1] = _src.x2[1];
      var45.x2[1] = _src.x2[0];
    }
    /* 5: splitwb */
    {
      orc_union16 _src;
      _src.i = var45.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 6: avgub */
    var40 = ((orc_uint8) var46 + (orc_uint8) var47 + 1) >> 1;
    /* 7: storeb */
    ptr1[i] = var40;
    /* 8: splitwb */
    {
      orc_union16 _src;
      _src.i = var44.i;
      var48 = _src.x2[1];
      var49 = _src.x2[0];
    }
    /* 9: avgub */
    var41 = ((orc_uint8) var48 + (orc_uint8) var49 + 1) >> 1;
    /* 10: storeb */
    ptr2[i] = var41;
  }

}

#else
static void
_backup_cogorc_putline_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_int8 var49;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_int8 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var38 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var38.x2[0];
      var42.x2[0] = _src.x2[1];
      var43.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var38.x2[1];
      var42.x2[1] = _src.x2[1];
      var43.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var43.x2[0];
      var39.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var43.x2[1];
      var39.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var39;
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.x2[0];
      var44.x2[0] = _src.x2[1];
      var45.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var42.x2[1];
      var44.x2[1] = _src.x2[1];
      var45.x2[1] = _src.x2[0];
    }
    /* 5: splitwb */
    {
      orc_union16 _src;
      _src.i = var45.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 6: avgub */
    var40 = ((orc_uint8) var46 + (orc_uint8) var47 + 1) >> 1;
    /* 7: storeb */
    ptr1[i] = var40;
    /* 8: splitwb */
    {
      orc_union16 _src;
      _src.i = var44.i;
      var48 = _src.x2[1];
      var49 = _src.x2[0];
    }
    /* 9: avgub */
    var41 = ((orc_uint8) var48 + (orc_uint8) var49 + 1) >> 1;
    /* 10: storeb */
    ptr2[i] = var41;
  }

}

void
cogorc_putline_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_I420");
      orc_program_set_backup_function (p, _backup_cogorc_putline_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 1, "t6");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D2, ORC_VAR_T5, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D3, ORC_VAR_T5, ORC_VAR_T6,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_YUY2 */
#ifdef DISABLE_ORC
void
cogorc_putline_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var37.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var37.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: splitlw */
    {
      orc_union32 _src;
      _src.i = var39.i;
      var41.i = _src.x2[1];
      var42.i = _src.x2[0];
    }
    /* 3: avgub */
    var43.x2[0] = ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 4: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.x2[0];
      var44.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var40.x2[1];
      var44.x2[1] = _src.x2[1];
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var43.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var43.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_putline_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var37.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var37.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: splitlw */
    {
      orc_union32 _src;
      _src.i = var39.i;
      var41.i = _src.x2[1];
      var42.i = _src.x2[0];
    }
    /* 3: avgub */
    var43.x2[0] = ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 4: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.x2[0];
      var44.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var40.x2[1];
      var44.x2[1] = _src.x2[1];
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var43.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var43.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var38;
  }

}

void
cogorc_putline_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_YUY2");
      orc_program_set_backup_function (p, _backup_cogorc_putline_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_YVYU */
#ifdef DISABLE_ORC
void
cogorc_putline_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var37.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var37.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: splitlw */
    {
      orc_union32 _src;
      _src.i = var39.i;
      var41.i = _src.x2[1];
      var42.i = _src.x2[0];
    }
    /* 3: avgub */
    var43.x2[0] = ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 4: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.x2[0];
      var44.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var40.x2[1];
      var44.x2[1] = _src.x2[1];
    }
    /* 5: swapw */
    var45.i = ORC_SWAP_W (var43.i);
    /* 6: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var45.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var45.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_putline_YVYU (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var37.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var37.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: splitlw */
    {
      orc_union32 _src;
      _src.i = var39.i;
      var41.i = _src.x2[1];
      var42.i = _src.x2[0];
    }
    /* 3: avgub */
    var43.x2[0] = ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 4: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.x2[0];
      var44.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var40.x2[1];
      var44.x2[1] = _src.x2[1];
    }
    /* 5: swapw */
    var45.i = ORC_SWAP_W (var43.i);
    /* 6: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[0];
      _dest.x2[1] = var45.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var44.x2[1];
      _dest.x2[1] = var45.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

void
cogorc_putline_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_YVYU");
      orc_program_set_backup_function (p, _backup_cogorc_putline_YVYU);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_UYVY */
#ifdef DISABLE_ORC
void
cogorc_putline_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var37.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var37.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: splitlw */
    {
      orc_union32 _src;
      _src.i = var39.i;
      var41.i = _src.x2[1];
      var42.i = _src.x2[0];
    }
    /* 3: avgub */
    var43.x2[0] = ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 4: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.x2[0];
      var44.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var40.x2[1];
      var44.x2[1] = _src.x2[1];
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var43.x2[0];
      _dest.x2[1] = var44.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var43.x2[1];
      _dest.x2[1] = var44.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_cogorc_putline_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var37.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var37.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: splitlw */
    {
      orc_union32 _src;
      _src.i = var39.i;
      var41.i = _src.x2[1];
      var42.i = _src.x2[0];
    }
    /* 3: avgub */
    var43.x2[0] = ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var43.x2[1] = ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 4: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.x2[0];
      var44.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var40.x2[1];
      var44.x2[1] = _src.x2[1];
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var43.x2[0];
      _dest.x2[1] = var44.x2[0];
      var38.x2[0] = _dest.i;
    }
    {
      orc_union16 _dest;
      _dest.x2[0] = var43.x2[1];
      _dest.x2[1] = var44.x2[1];
      var38.x2[1] = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var38;
  }

}

void
cogorc_putline_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_UYVY");
      orc_program_set_backup_function (p, _backup_cogorc_putline_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T4,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_Y42B */
#ifdef DISABLE_ORC
void
cogorc_putline_Y42B (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_int8 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var40.x2[0] = _src.x2[1];
      var41.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var40.x2[1] = _src.x2[1];
      var41.x2[1] = _src.x2[0];
    }
    /* 2: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 3: avgub */
    var44.x2[0] = ((orc_uint8) var42.x2[0] + (orc_uint8) var43.x2[0] + 1) >> 1;
    var44.x2[1] = ((orc_uint8) var42.x2[1] + (orc_uint8) var43.x2[1] + 1) >> 1;
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var44.i;
      var37 = _src.x2[1];
      var38 = _src.x2[0];
    }
    /* 5: storeb */
    ptr2[i] = var37;
    /* 6: storeb */
    ptr1[i] = var38;
    /* 7: select1wb */
    {
      orc_union16 _src;
      _src.i = var41.x2[0];
      var39.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var41.x2[1];
      var39.x2[1] = _src.x2[1];
    }
    /* 8: storew */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_cogorc_putline_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_int8 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var40.x2[0] = _src.x2[1];
      var41.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var40.x2[1] = _src.x2[1];
      var41.x2[1] = _src.x2[0];
    }
    /* 2: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 3: avgub */
    var44.x2[0] = ((orc_uint8) var42.x2[0] + (orc_uint8) var43.x2[0] + 1) >> 1;
    var44.x2[1] = ((orc_uint8) var42.x2[1] + (orc_uint8) var43.x2[1] + 1) >> 1;
    /* 4: splitwb */
    {
      orc_union16 _src;
      _src.i = var44.i;
      var37 = _src.x2[1];
      var38 = _src.x2[0];
    }
    /* 5: storeb */
    ptr2[i] = var37;
    /* 6: storeb */
    ptr1[i] = var38;
    /* 7: select1wb */
    {
      orc_union16 _src;
      _src.i = var41.x2[0];
      var39.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var41.x2[1];
      var39.x2[1] = _src.x2[1];
    }
    /* 8: storew */
    ptr0[i] = var39;
  }

}

void
cogorc_putline_Y42B (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_Y42B");
      orc_program_set_backup_function (p, _backup_cogorc_putline_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_Y444 */
#ifdef DISABLE_ORC
void
cogorc_putline_Y444 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  ptr0 = (orc_int8 *) d1;
  ptr1 = (orc_int8 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var34.i;
      var38.i = _src.x2[1];
      var39.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var38.i;
      var35 = _src.x2[1];
      var36 = _src.x2[0];
    }
    /* 3: storeb */
    ptr2[i] = var35;
    /* 4: storeb */
    ptr1[i] = var36;
    /* 5: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.i;
      var37 = _src.x2[1];
    }
    /* 6: storeb */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_cogorc_putline_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr1 = (orc_int8 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var34.i;
      var38.i = _src.x2[1];
      var39.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var38.i;
      var35 = _src.x2[1];
      var36 = _src.x2[0];
    }
    /* 3: storeb */
    ptr2[i] = var35;
    /* 4: storeb */
    ptr1[i] = var36;
    /* 5: select1wb */
    {
      orc_union16 _src;
      _src.i = var39.i;
      var37 = _src.x2[1];
    }
    /* 6: storeb */
    ptr0[i] = var37;
  }

}

void
cogorc_putline_Y444 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_Y444");
      orc_program_set_backup_function (p, _backup_cogorc_putline_Y444);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_Y800 */
#ifdef DISABLE_ORC
void
cogorc_putline_Y800 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
      orc_union32 _src;
      _src.i = var33.i;
      var35.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var35.i;
      var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_cogorc_putline_Y800 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
      orc_union32 _src;
      _src.i = var33.i;
      var35.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var35.i;
      var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
cogorc_putline_Y800 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_Y800");
      orc_program_set_backup_function (p, _backup_cogorc_putline_Y800);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_Y16 */
#ifdef DISABLE_ORC
void
cogorc_putline_Y16 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_int8 var37;
  orc_union16 var38;

  ptr0 = (orc_union16 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: select0lw */
    {
      orc_union32 _src;
      _src.i = var34.i;
      var36.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var36.i;
      var37 = _src.x2[1];
    }
    /* 3: convubw */
    var38.i = (orc_uint8) var37;
    /* 4: shlw */
    var35.i = var38.i << 8;
    /* 5: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_cogorc_putline_Y16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_int8 var37;
  orc_union16 var38;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: select0lw */
    {
      orc_union32 _src;
      _src.i = var34.i;
      var36.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var36.i;
      var37 = _src.x2[1];
    }
    /* 3: convubw */
    var38.i = (orc_uint8) var37;
    /* 4: shlw */
    var35.i = var38.i << 8;
    /* 5: storew */
    ptr0[i] = var35;
  }

}

void
cogorc_putline_Y16 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_Y16");
      orc_program_set_backup_function (p, _backup_cogorc_putline_Y16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");

      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_T2, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_BGRA */
#ifdef DISABLE_ORC
void
cogorc_putline_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_cogorc_putline_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L (var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
cogorc_putline_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_BGRA");
      orc_program_set_backup_function (p, _backup_cogorc_putline_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_ABGR */
#ifdef DISABLE_ORC
void
cogorc_putline_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47;
      _dest.x2[1] = var44;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var45;
      _dest.x2[1] = var46;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_cogorc_putline_ABGR (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var47;
      _dest.x2[1] = var44;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var45;
      _dest.x2[1] = var46;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var48.i;
      _dest.x2[1] = var49.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

void
cogorc_putline_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_ABGR");
      orc_program_set_backup_function (p, _backup_cogorc_putline_ABGR);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T6, ORC_VAR_T5,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_RGBA */
#ifdef DISABLE_ORC
void
cogorc_putline_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  int i;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) d1;
  ptr4 = (orc_union32 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44;
      _dest.x2[1] = var47;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var46;
      _dest.x2[1] = var45;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var49.i;
      _dest.x2[1] = var48.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_cogorc_putline_RGBA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 *ORC_RESTRICT ptr0;
  const orc_union32 *ORC_RESTRICT ptr4;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_int8 var46;
  orc_int8 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union32 *) ex->arrays[0];
  ptr4 = (orc_union32 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
      orc_union16 _src;
      _src.i = var42.i;
      var44 = _src.x2[1];
      var45 = _src.x2[0];
    }
    /* 3: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.i;
      var46 = _src.x2[1];
      var47 = _src.x2[0];
    }
    /* 4: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var44;
      _dest.x2[1] = var47;
      var48.i = _dest.i;
    }
    /* 5: mergebw */
    {
      orc_union16 _dest;
      _dest.x2[0] = var46;
      _dest.x2[1] = var45;
      var49.i = _dest.i;
    }
    /* 6: mergewl */
    {
      orc_union32 _dest;
      _dest.x2[0] = var49.i;
      _dest.x2[1] = var48.i;
      var41.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var41;
  }

}

void
cogorc_putline_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1,
    int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_RGBA");
      orc_program_set_backup_function (p, _backup_cogorc_putline_RGBA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T8,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T7,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T6, ORC_VAR_T4, ORC_VAR_T1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_T6,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_NV12 */
#ifdef DISABLE_ORC
void
cogorc_putline_NV12 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.x2[0];
      var37.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var40.x2[1];
      var37.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var37;
    /* 4: splitlw */
    {
      orc_union32 _src;
      _src.i = var39.i;
      var41.i = _src.x2[1];
      var42.i = _src.x2[0];
    }
    /* 5: avgub */
    var38.x2[0] = ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var38.x2[1] = ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 6: storew */
    ptr1[i] = var38;
  }

}

#else
static void
_backup_cogorc_putline_NV12 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var36.x2[0];
      var39.x2[0] = _src.x2[1];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var36.x2[1];
      var39.x2[1] = _src.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var40.x2[0];
      var37.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var40.x2[1];
      var37.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var37;
    /* 4: splitlw */
    {
      orc_union32 _src;
      _src.i = var39.i;
      var41.i = _src.x2[1];
      var42.i = _src.x2[0];
    }
    /* 5: avgub */
    var38.x2[0] = ((orc_uint8) var41.x2[0] + (orc_uint8) var42.x2[0] + 1) >> 1;
    var38.x2[1] = ((orc_uint8) var41.x2[1] + (orc_uint8) var42.x2[1] + 1) >> 1;
    /* 6: storew */
    ptr1[i] = var38;
  }

}

void
cogorc_putline_NV12 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_NV12");
      orc_program_set_backup_function (p, _backup_cogorc_putline_NV12);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_NV21 */
#ifdef DISABLE_ORC
void
cogorc_putline_NV21 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_union16 *) d2;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var37.x2[0];
      var40.x2[0] = _src.x2[1];
      var41.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var37.x2[1];
      var40.x2[1] = _src.x2[1];
      var41.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var41.x2[0];
      var38.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var41.x2[1];
      var38.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var38;
    /* 4: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 5: avgub */
    var44.x2[0] = ((orc_uint8) var42.x2[0] + (orc_uint8) var43.x2[0] + 1) >> 1;
    var44.x2[1] = ((orc_uint8) var42.x2[1] + (orc_uint8) var43.x2[1] + 1) >> 1;
    /* 6: swapw */
    var39.i = ORC_SWAP_W (var44.i);
    /* 7: storew */
    ptr1[i] = var39;
  }

}

#else
static void
_backup_cogorc_putline_NV21 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_union16 *ORC_RESTRICT ptr1;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_union16 *) ex->arrays[1];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var37.x2[0];
      var40.x2[0] = _src.x2[1];
      var41.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var37.x2[1];
      var40.x2[1] = _src.x2[1];
      var41.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var41.x2[0];
      var38.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var41.x2[1];
      var38.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var38;
    /* 4: splitlw */
    {
      orc_union32 _src;
      _src.i = var40.i;
      var42.i = _src.x2[1];
      var43.i = _src.x2[0];
    }
    /* 5: avgub */
    var44.x2[0] = ((orc_uint8) var42.x2[0] + (orc_uint8) var43.x2[0] + 1) >> 1;
    var44.x2[1] = ((orc_uint8) var42.x2[1] + (orc_uint8) var43.x2[1] + 1) >> 1;
    /* 6: swapw */
    var39.i = ORC_SWAP_W (var44.i);
    /* 7: storew */
    ptr1[i] = var39;
  }

}

void
cogorc_putline_NV21 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_NV21");
      orc_program_set_backup_function (p, _backup_cogorc_putline_NV21);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_D2, ORC_VAR_T5, ORC_VAR_D1,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif


/* cogorc_putline_A420 */
#ifdef DISABLE_ORC
void
cogorc_putline_A420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4,
    const guint8 * ORC_RESTRICT s1, int n)
{
  int i;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_union16 *ORC_RESTRICT ptr3;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_int8 var41;
  orc_int8 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_int8 var49;
  orc_int8 var50;

  ptr0 = (orc_union16 *) d1;
  ptr1 = (orc_int8 *) d2;
  ptr2 = (orc_int8 *) d3;
  ptr3 = (orc_union16 *) d4;
  ptr4 = (orc_union64 *) s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var38 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var38.x2[0];
      var43.x2[0] = _src.x2[1];
      var44.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var38.x2[1];
      var43.x2[1] = _src.x2[1];
      var44.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var44.x2[0];
      var39.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var44.x2[1];
      var39.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var39;
    /* 4: select0wb */
    {
      orc_union16 _src;
      _src.i = var44.x2[0];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var44.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr3[i] = var40;
    /* 6: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.x2[0];
      var45.x2[0] = _src.x2[1];
      var46.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var43.x2[1];
      var45.x2[1] = _src.x2[1];
      var46.x2[1] = _src.x2[0];
    }
    /* 7: splitwb */
    {
      orc_union16 _src;
      _src.i = var46.i;
      var47 = _src.x2[1];
      var48 = _src.x2[0];
    }
    /* 8: avgub */
    var41 = ((orc_uint8) var47 + (orc_uint8) var48 + 1) >> 1;
    /* 9: storeb */
    ptr1[i] = var41;
    /* 10: splitwb */
    {
      orc_union16 _src;
      _src.i = var45.i;
      var49 = _src.x2[1];
      var50 = _src.x2[0];
    }
    /* 11: avgub */
    var42 = ((orc_uint8) var49 + (orc_uint8) var50 + 1) >> 1;
    /* 12: storeb */
    ptr2[i] = var42;
  }

}

#else
static void
_backup_cogorc_putline_A420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 *ORC_RESTRICT ptr0;
  orc_int8 *ORC_RESTRICT ptr1;
  orc_int8 *ORC_RESTRICT ptr2;
  orc_union16 *ORC_RESTRICT ptr3;
  const orc_union64 *ORC_RESTRICT ptr4;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_int8 var41;
  orc_int8 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_int8 var47;
  orc_int8 var48;
  orc_int8 var49;
  orc_int8 var50;

  ptr0 = (orc_union16 *) ex->arrays[0];
  ptr1 = (orc_int8 *) ex->arrays[1];
  ptr2 = (orc_int8 *) ex->arrays[2];
  ptr3 = (orc_union16 *) ex->arrays[3];
  ptr4 = (orc_union64 *) ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var38 = ptr4[i];
    /* 1: splitlw */
    {
      orc_union32 _src;
      _src.i = var38.x2[0];
      var43.x2[0] = _src.x2[1];
      var44.x2[0] = _src.x2[0];
    }
    {
      orc_union32 _src;
      _src.i = var38.x2[1];
      var43.x2[1] = _src.x2[1];
      var44.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
      orc_union16 _src;
      _src.i = var44.x2[0];
      var39.x2[0] = _src.x2[1];
    }
    {
      orc_union16 _src;
      _src.i = var44.x2[1];
      var39.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var39;
    /* 4: select0wb */
    {
      orc_union16 _src;
      _src.i = var44.x2[0];
      var40.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var44.x2[1];
      var40.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr3[i] = var40;
    /* 6: splitwb */
    {
      orc_union16 _src;
      _src.i = var43.x2[0];
      var45.x2[0] = _src.x2[1];
      var46.x2[0] = _src.x2[0];
    }
    {
      orc_union16 _src;
      _src.i = var43.x2[1];
      var45.x2[1] = _src.x2[1];
      var46.x2[1] = _src.x2[0];
    }
    /* 7: splitwb */
    {
      orc_union16 _src;
      _src.i = var46.i;
      var47 = _src.x2[1];
      var48 = _src.x2[0];
    }
    /* 8: avgub */
    var41 = ((orc_uint8) var47 + (orc_uint8) var48 + 1) >> 1;
    /* 9: storeb */
    ptr1[i] = var41;
    /* 10: splitwb */
    {
      orc_union16 _src;
      _src.i = var45.i;
      var49 = _src.x2[1];
      var50 = _src.x2[0];
    }
    /* 11: avgub */
    var42 = ((orc_uint8) var49 + (orc_uint8) var50 + 1) >> 1;
    /* 12: storeb */
    ptr2[i] = var42;
  }

}

void
cogorc_putline_A420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2,
    guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4,
    const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcProgram *p = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {

      p = orc_program_new ();
      orc_program_set_name (p, "cogorc_putline_A420");
      orc_program_set_backup_function (p, _backup_cogorc_putline_A420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 2, "d4");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 1, "t6");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1,
          ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 1, ORC_VAR_D4, ORC_VAR_T1,
          ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T2,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_T3,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D2, ORC_VAR_T5, ORC_VAR_T6,
          ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_T4,
          ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D3, ORC_VAR_T5, ORC_VAR_T6,
          ORC_VAR_D1);

      orc_program_compile (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->program = p;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->arrays[ORC_VAR_S1] = (void *) s1;

  func = p->code_exec;
  func (ex);
}
#endif
