/* GStreamer
 * Copyright (C) 2017 Matthew Waters <matthew@centricular.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __GST_WEBRTC_RTP_RECEIVER_H__
#define __GST_WEBRTC_RTP_RECEIVER_H__

#include <gst/gst.h>
#include <gst/webrtc/webrtc_fwd.h>
#include <gst/webrtc/dtlstransport.h>

G_BEGIN_DECLS

GST_EXPORT
GType gst_webrtc_rtp_receiver_get_type(void);
#define GST_TYPE_WEBRTC_RTP_RECEIVER            (gst_webrtc_rtp_receiver_get_type())
#define GST_WEBRTC_RTP_RECEIVER(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),GST_TYPE_WEBRTC_RTP_RECEIVER,GstWebRTCRTPReceiver))
#define GST_IS_WEBRTC_RTP_RECEIVER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),GST_TYPE_WEBRTC_RTP_RECEIVER))
#define GST_WEBRTC_RTP_RECEIVER_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass) ,GST_TYPE_WEBRTC_RTP_RECEIVER,GstWebRTCRTPReceiverClass))
#define GST_IS_WEBRTC_RTP_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass) ,GST_TYPE_WEBRTC_RTP_RECEIVER))
#define GST_WEBRTC_RTP_RECEIVER_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj) ,GST_TYPE_WEBRTC_RTP_RECEIVER,GstWebRTCRTPReceiverClass))

typedef struct _GstWebRTCRTPReceiver GstWebRTCRTPReceiver;
typedef struct _GstWebRTCRTPReceiverClass GstWebRTCRTPReceiverClass;

struct _GstWebRTCRTPReceiver
{
  GstObject                          parent;

  /* The MediStreamTrack is represented by the stream and is output into @transport/@rtcp_transport as necessary */
  GstWebRTCDTLSTransport            *transport;
  GstWebRTCDTLSTransport            *rtcp_transport;

  gpointer                          _padding[GST_PADDING];
};

struct _GstWebRTCRTPReceiverClass
{
  GstObjectClass            parent_class;

  gpointer                  _padding[GST_PADDING];
};

GST_EXPORT
GstWebRTCRTPReceiver *      gst_webrtc_rtp_receiver_new                 (void);
GST_EXPORT
GstStructure *              gst_webrtc_rtp_receiver_get_parameters      (GstWebRTCRTPReceiver * receiver, gchar * kind);
/* FIXME: promise? */
GST_EXPORT
gboolean                    gst_webrtc_rtp_receiver_set_parameters      (GstWebRTCRTPReceiver * receiver,
                                                                         GstStructure * parameters);
GST_EXPORT
void                        gst_webrtc_rtp_receiver_set_transport       (GstWebRTCRTPReceiver * receiver,
                                                                         GstWebRTCDTLSTransport * transport);
GST_EXPORT
void                        gst_webrtc_rtp_receiver_set_rtcp_transport  (GstWebRTCRTPReceiver * receiver,
                                                                         GstWebRTCDTLSTransport * transport);

G_END_DECLS

#endif /* __GST_WEBRTC_RTP_RECEIVER_H__ */
