/*
  Gnome applet for Searching the web in a Practical, Outlined and Tidy way
  Copyright (C) 2005 Norberto M. Lopes shelika@mail.telepac.pt, and GeCC gecc@mfa.kicks-ass.org
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   
  
  @author: Norberto M. Lopes shelika@mail.telepac.pt
*/
#include "gspot_engines.h"
#include "gspot_callbacks.h"

static void open_selection(char *complete_url){
  _GSPOT_SPECIAL_CLIPBOARD = gtk_clipboard_get( GDK_SELECTION_PRIMARY );

  gtk_clipboard_request_text( _GSPOT_SPECIAL_CLIPBOARD, (GtkClipboardTextReceivedFunc)got_selection, complete_url );

  /* THIS SHOULD NOT BE DONE THIS WAY!!! */
  /* DOCUMENTATION SAYS NOT TO DO IT THIS WAY */
  gtk_clipboard_clear(_GSPOT_SPECIAL_CLIPBOARD);
}
void menu_urban_dictionary_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("www.urbandictionary.com/define.php?term=");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );

  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

void menu_wikipedia_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("wikipedia.org/wiki/");
  char *lang = N_("en");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url) + strlen(lang))*sizeof(char))+1 );

  sprintf( complete_url, N_("%s%s.%s"), header, lang, url );
  open_selection(complete_url);
}

void menu_google_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("www.google.com/search?");
  char *lang = N_("en");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url) + strlen(lang) + strlen("hl=&q="))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%shl=%s&q="), header, url, lang );
  open_selection(complete_url);
}

/* Modify the parameters in the end... do not forget that... things like www.imdb.com/find?q=Melanie;s=all should be supported */
void menu_imdb_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("www.imdb.com/find?q=");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

void menu_distrowatch_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("distrowatch.com/table.php?distribution=");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

/* Watch out for thesaurus and enciclopedia */
void menu_dictionary_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("dictionary.reference.com/search?q=");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

void menu_ebay_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("search.ebay.com/");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

/* AskJeeves */
void menu_ask_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("web.ask.com/web?q=");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

/* freedb: REMOVED CDDB because of their stupid licensing! */
void menu_freedb_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("www.freedb.org/freedb_search.php?words=");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

/* Merriam-Webster Online */
void menu_webster_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("www.webster.com/cgi-bin/dictionary?va=");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

/* MathWorld from Wolfram Research */
void menu_mathworld_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("mathworld.wolfram.com/search/index.cgi?q=");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

/* Answers.com */
void menu_answers_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("www.answers.com/");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

/* bugs.debian.org */
void menu_bugs_debian_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("bugs.debian.org/cgi-bin/pkgreport.cgi?which=pkg&data=");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

/* packages.debian.org */
void menu_packages_debian_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("packages.debian.org/cgi-bin/search_packages.pl?searchon=names&subword=1&version=all&release=all&keywords=");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}

/* packages.qa.debian.org */
void menu_packages_qa_debian_cb(GtkMenuItem *menu_item, gspotData *gspot) {
  char *header = N_("http://");
  char *url = N_("packages.qa.debian.org/");
  char *complete_url = (char *) malloc(((strlen(header) + strlen(url))*sizeof(char))+1 );
  
  sprintf( complete_url, N_("%s%s"), header, url );
  open_selection(complete_url);
}
