//*****************************************************************************
//                              DlgGcpCfgOPT.hpp                              *
//                             ------------------                             *
//  Description : This dialogue is used to enter values associated with the   *
//                GNU-Cap OPTIONS command.                                    *
//  Started     : 14/09/2006                                                  *
//  Last Update : 16/04/2010                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef DLGGCPCFGOPT_HPP
#define DLGGCPCFGOPT_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "utility/PnlValue.hpp"
#include "gnucap/commands/CmdGnuCapOPT.hpp"

// Local Constant Declarations


//*****************************************************************************

class DlgGcpCfgOPT : public wxDialog
{
  private :

    // Value panel controls
    PnlValue      m_oPnlABSTOL;   // Absolute current error tolerance
    PnlValue      m_oPnlCHGTOL;   // Charge tolerance
    PnlValue      m_oPnlDAMPMAX;  // Normal Newton damping factor (when all is well)
    PnlValue      m_oPnlDAMPMIN;  // Newton damping factor when there's a problem
    PnlValue      m_oPnlDAMPST;   // Damping strategy
    PnlValue      m_oPnlDEFAD;    // MOS drain diffusion area
    PnlValue      m_oPnlDEFAS;    // MOS source diffusion area
    PnlValue      m_oPnlDEFL;     // MOS channel length
    PnlValue      m_oPnlDEFW;     // MOS channel width
    PnlValue      m_oPnlDTMIN;    // Minimum time step
    PnlValue      m_oPnlDTRATIO;  // The ratio between minimum and maximum time step
    PnlValue      m_oPnlFLOOR;    // Effective zero value
    PnlValue      m_oPnlGMIN;     // Minimum allowable conductance
    PnlValue      m_oPnlHARMS;    // Harmonics in Fourier analysis
    PnlValue      m_oPnlITL1;     // DC iteration limit
    PnlValue      m_oPnlITL2;     // DC transfer curve iteration limit
    PnlValue      m_oPnlITL4;     // TR analysis timepoint iteration limit
    PnlValue      m_oPnlITL7;     // Worst case analysis iteration limit
    PnlValue      m_oPnlITL8;     // Convergence diagnostic iteration threshold
    PnlValue      m_oPnlLIMIT;    // Internal differential branch voltage limit
    PnlValue      m_oPnlNUMDGT;   // No. of digits to print for analysis results
    PnlValue      m_oPnlRELTOL;   // Relative error tolerance
    PnlValue      m_oPnlSEED;     // Seed used by the random number generator
    PnlValue      m_oPnlSHORT;    // Resistance of voltage source or short
    PnlValue      m_oPnlTEMPAMB;  // Ambient temp. of circuit
    PnlValue      m_oPnlTNOM;     // Nominal temp. at which device parameters measured
    PnlValue      m_oPnlTRANSITS; // Mixed mode transition count
    PnlValue      m_oPnlTRREJECT; // Transient error rejection threshold
    PnlValue      m_oPnlTRSTEPG;  // Maximum internal step size growth in transient analysis
    PnlValue      m_oPnlTRSTEPS;  // Amount to decrease the transient step size by when convergence fails
    PnlValue      m_oPnlTRTOL;    // TR error tolerance
    PnlValue      m_oPnlVFLOOR;   // Effective zero value for voltage probes
    PnlValue      m_oPnlVMAX;     // Positive node voltage limit
    PnlValue      m_oPnlVMIN;     // Negative node voltage limit
    PnlValue      m_oPnlVNTOL;    // Abs. voltage error tolerance
    PnlValue      m_oPnlWCZERO;   // Worst case zero window

    wxChoice      m_oChoMETHOD;   // Numerical integration method
    wxLabel       m_oLblMETHOD;
    wxChoice      m_oChoMODE;     // Simulation mode selection
    wxLabel       m_oLblMODE;
    wxChoice      m_oChoORDER;    // Equation ordering
    wxLabel       m_oLblORDER;

    wxCheckBox    m_oCbxBYPASS;   // Bypass model evaluation if appropriate
    wxCheckBox    m_oCbxCSTRAY;   // Include capacitance in device models
    wxCheckBox    m_oCbxINCMODE;  // Incrementally update the matrix
    wxCheckBox    m_oCbxLUBYPASS; // Bypass parts of LU decomposition if appropriate
    wxCheckBox    m_oCbxRSTRAY;   // Include series resistance in device models
    wxCheckBox    m_oCbxTRACEL;   // Use a queue to only load changed elements to the matrix
    wxCheckBox    m_oCbxVBYPASS;  // Check only voltage to bypass model evaluation

    // Button controls
    wxButton      m_oBtnOk;
    wxButton      m_oBtnCancel;
    wxButton      m_oBtnDefaults;

    // OPTIONS command object
    CmdGnuCapOPT  m_oCmdOPT;

    // Object initialization functions
    void  Initialize( void );
    void  Create    ( void );
    void  ToolTips  ( void );
    void  DoLayout  ( void );

    PnlValue * poGetPanel( int iPnlID );

    void  SetValues( CmdGnuCapOPT & roCmdOPT );
    void  GetValues( CmdGnuCapOPT & roCmdOPT );

  public :

    DlgGcpCfgOPT( wxWindow * poWin );
   ~DlgGcpCfgOPT( );

    bool  bClear( void );

    bool  bSetValues( CmdGnuCapOPT & roCmdOPT );
    bool  bGetValues( CmdGnuCapOPT & roCmdOPT );

          bool         bSetValue( int iPnlID, const wxString & rosValue );
    const wxString & rosGetValue( int iPnlID );

    // Event handlers
    void  OnBtnOk      ( wxCommandEvent & roEvtCmd );
    void  OnBtnDefaults( wxCommandEvent & roEvtCmd );
    void  OnBtnCancel  ( wxCommandEvent & roEvtCmd );

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum eDlgItemID
    {
      ID_PNL_ABSTOL = 0,
      ID_PNL_CHGTOL,
      ID_PNL_DAMPMAX,
      ID_PNL_DAMPMIN,
      ID_PNL_DAMPST,
      ID_PNL_DEFAD,
      ID_PNL_DEFAS,
      ID_PNL_DEFL,
      ID_PNL_DEFW,
      ID_PNL_DTMIN,
      ID_PNL_DTRATIO,
      ID_PNL_FLOOR,
      ID_PNL_GMIN,
      ID_PNL_HARMS,
      ID_PNL_ITL1,
      ID_PNL_ITL2,
      ID_PNL_ITL4,
      ID_PNL_ITL7,
      ID_PNL_ITL8,
      ID_PNL_LIMIT,
      ID_PNL_NUMDGT,
      ID_PNL_RELTOL,
      ID_PNL_SEED,
      ID_PNL_SHORT,
      ID_PNL_TEMPAMB,
      ID_PNL_TNOM,
      ID_PNL_TRANSITS,
      ID_PNL_TRREJECT,
      ID_PNL_TRSTEPG,
      ID_PNL_TRSTEPS,
      ID_PNL_TRTOL,
      ID_PNL_VFLOOR,
      ID_PNL_VMAX,
      ID_PNL_VMIN,
      ID_PNL_VNTOL,
      ID_PNL_WCZERO,

      ID_CBX_BYPASS,
      ID_CBX_CSTRAY,
      ID_CBX_INCMODE,
      ID_CBX_LUBYPASS,
      ID_CBX_RSTRAY,
      ID_CBX_TRACEL,
      ID_CBX_VBYPASS,

      ID_CHO_METHOD,
      ID_CHO_MODE,
      ID_CHO_ORDER,

      ID_BTN_OK,
      ID_BTN_DEFAULTS,
      ID_BTN_CANCEL,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_FST = ID_PNL_ABSTOL,
      ID_LST = ID_BTN_CANCEL
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // DLGGCPCFGOPT_HPP
