//*****************************************************************************
//                                CmdLinePcr.hpp                              *
//                               ----------------                             *
//  Description : This class does the command line processing.                *
//  Started     : 22/02/2005                                                  *
//  Last Update : 25/03/2010                                                  *
//  Copyright   : (C) 2005 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDLINEPCR_HPP
#define CMDLINEPCR_HPP

// System includes

#include <iostream>

// wxWindows includes

#include <wx/wx.h>
#include <wx/config.h>
#include <wx/cmdline.h>
#include <wx/filename.h>

// Application includes

#include "Version.hpp"
#include "process/PrcGNetList.hpp"

// Local constant declarations

#define CLP_NGSPICE  wxT("NG-Spice")
#define CLP_GNUCAP   wxT("GNU-Cap")

#define CLP_GWAVE    wxT("gWave")
#define CLP_GAW      wxT("Gaw")

//*****************************************************************************

class CmdLinePcr : wxCmdLineParser
{
  private :

    int            m_iArgC;
    wxChar **      m_ppsArgV;

    wxString       m_osSimrType;
    wxString       m_osAnaType;
    wxString       m_osGuileProc;
    wxString       m_osViewer;
    wxString       m_osConfigFile;
    wxString       m_osNetLstFile;
    wxArrayString  m_osaSchemFiles;
    bool           m_bCleanCfgFile;

    bool  bProcOption_a( int * piArg );  // Analysis page specifier
    bool  bProcOption_c( int * piArg );  // Rebuild/clean configuration file
    bool  bProcOption_g( int * piArg );  // Specify Guile procedure for import
    bool  bProcOption_h( int * piArg );  // Display usage and exit
    bool  bProcOption_r( int * piArg );  // Specify a configuration file
    bool  bProcOption_s( int * piArg );  // Simulator engine specifier
    bool  bProcOption_v( int * piArg );  // Display app. version and exit
    bool  bProcOption_w( int * piArg );  // Specify the waveform viewer to use

    bool  bCheckFiles  ( int * piArg );  // Check that file names are correct
    bool  bProcSchems  ( int * piArg );  // Schematic file name/s
    bool  bProcNetList ( int * piArg );  // Netlist file name

    void  Usage( void );
    void  Version( void );

    void  SetConfig( void );
    void  CleanCfgFile( void );


  public :

    CmdLinePcr( void );
   ~CmdLinePcr( );

    bool  bClear( void );
    bool  bSetCmdLine( int iArgC, wxChar ** ppsArgV );
    bool  bProcArgs( void );

    const wxString & rosGetConfigFile ( void ) { return( m_osConfigFile  ); }

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDLINEPCR_HPP
