//*****************************************************************************
//                                NetList.hpp                                 *
//                               -------------                                *
// Description : This class provides an interface to the circuit description  *
//               (netlist) file. The raw netlist data is loaded from file     *
//               into memory and stored as a string array. The individual     *
//               netlist types (component definitions, models, etc.) are      *
//               extracted and stored as object attributes.                   *
// Started     : 01/09/2003                                                   *
// Last Update : 11/08/2009                                                   *
// Copyright   : (C) 2003 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef NETLIST_HPP
#define NETLIST_HPP

// System Includes

using  namespace  std;

#include <iostream>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/textfile.h>
#include <wx/tokenzr.h>

// Application Includes

#include "Version.hpp"
#include "TypeDefs.hpp"
#include "utility/iStrCmp.h"
#include "netlist/Component.hpp"

// Local Constant Declarations


//*****************************************************************************

struct NetList
{
  protected :

    // File names
    static  wxFileName     m_ofnLoadFile;
    static  wxFileName     m_ofnSaveFile;
    static  ArrayFileName  m_ofnaSchemFiles;

  public :

    // String array containing the netlist data
    static  wxArrayString   m_osaNetLst;

    // String arrays containing data extracted from the netlist
    static  wxArrayString   m_osaTitle;
    static  wxArrayString   m_osaIncludes;
    static  ArrayComponent  m_oaCpnts;
    static  wxArrayString   m_osaModels;
    static  wxArrayString   m_osaSubCcts;

    // String arrays containing labels only
    static  wxArrayString   m_osaNodeLbls;

  private :

    static  bool  m_bIsValid;

    // Functions to extract information from the circuit description
    bool  bExtract          ( void );
    bool  bExtractTitle     ( void );
    bool  bExtractIncludes  ( void );
    bool  bExtractCpnts     ( void );
    bool  bExtractModels    ( void );
    bool  bExtractSubCcts   ( void );
    bool  bExtractNodeLbls  ( void );
    bool  bExtractSchemFiles( void );
    bool  bIsSubCkt( wxString & roLine );

  public :

    NetList( void );
   ~NetList( );

    bool  bClear   ( void );
    bool  bIsEmpty ( void ) { return( m_osaNetLst.IsEmpty( ) ); }
    bool  bValidate( void );
    bool  bIsValid ( void ) { return( m_bIsValid ); }

    bool  bLoadFile( const wxString & rosFName=wxT("") );
    bool  bSaveFile( const wxString & rosFName=wxT("") );

    bool  bSetLoadFile  ( const wxString      &  rosFName  );
    bool  bSetSaveFile  ( const wxString      &  rosFName  );
    bool  bSetSchemFiles( const wxArrayString & rosaFNames );
    bool  bSetSchemFiles( const wxString      &  rosFNames );

    static  const  wxFileName    &  rofnGetLoadFile( void )
                                                { return( m_ofnLoadFile  ); }
    static  const  wxFileName    &  rofnGetSaveFile( void )
                                                { return( m_ofnSaveFile  ); }
    static  const  ArrayFileName & rofnaGetSchemFiles( void )
                                                { return( m_ofnaSchemFiles ); }
            const  wxString      &  rosGetSchemFiles( void );
            const  Component     &   roGetCpnt( const wxString & rosName );

    void  Print( const wxString & rosPrefix=wxT("  ") );

    friend  class  PrcGnuCap;
    friend  class  PrcNgSpice;
};

//*****************************************************************************

#endif // NETLIST_HPP
