//*****************************************************************************
//                                NbkTxtCtls.hpp                              *
//                               ----------------                             *
//  Description : This class extends wxNotebook, it contains all text control *
//                objects which appear at the bottom of the GUI.              *
//  Started     : 14/06/2005                                                  *
//  Last Update : 28/10/2008                                                  *
//  Copyright   : (C) 2005 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef NBKTXTCTLS_HPP
#define NBKTXTCTLS_HPP

// wxWindows Includes

#include <wx/wx.h>
#include <wx/notebook.h>

// System Includes


// Application Includes

#include "utility/TextCtrl.hpp"

// Local Constant Declarations


//*****************************************************************************

class NbkTxtCtls : public wxNotebook
{
  public :

    // The various page identifiers
    enum ePageType
    {
      ePAGE_CONSOLE = 0,
      ePAGE_NETLIST,
      ePAGE_SIMULTN,
      ePAGE_GNUCAP,
      ePAGE_NGSPICE,

      ePAGE_ALL,
      ePAGE_NONE,
      ePAGE_CURRENT,

      ePAGE_FST = ePAGE_CONSOLE,
      ePAGE_LST = ePAGE_NGSPICE
    };

    NbkTxtCtls( void );
   ~NbkTxtCtls( );

    bool  bCreate( wxWindow * poWin, wxWindowID oWinID );
    bool  bIsCreated( void ) { return( GetParent( )!=NULL ? TRUE : FALSE ); }

    bool  bClear     ( ePageType ePage=ePAGE_ALL );
    bool  bInitialize( ePageType ePage=ePAGE_ALL );
    bool  bIsEmpty   ( ePageType ePage=ePAGE_ALL );

    bool  bSetPage( ePageType ePage );
    bool  bSetPosn( long liPosn );

    ePageType   eGetPage( void );
    TextCtrl * poGetPage( ePageType ePage=ePAGE_CURRENT );

    bool  bSetLinesMax( int iLines ) { return( TextCtrl::bSetLinesMax( iLines ) ); }
    bool  bSetLinesDsp( int iLines ) { return( TextCtrl::bSetLinesDsp( iLines ) ); }
};

//*****************************************************************************

#endif // NBKTXTCTLS_HPP
