//*****************************************************************************
//                                NbkSimrBase.cpp                             *
//                               -----------------                            *
//  Started     : 05/05/2004                                                  *
//  Last Update : 19/08/2009                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "base/NbkSimrBase.hpp"

//*****************************************************************************
// Constructor.
//
// Arguments:
//   poParent - The parent window
//   oWinID   - The display object ID
//   roPosn   - The notebook position
//   roSize   - The notebook size

NbkSimrBase::NbkSimrBase( wxWindow * poParent, wxWindowID oWinID )
                        : wxNotebook( poParent, oWinID )
{
  // Set the simulator engine type specifier
  m_eSimEng = eSIMR_NONE;
}

//*****************************************************************************
// Default constructor.
// (Used for two stage creation ie. must call Create( ) method.

NbkSimrBase::NbkSimrBase( void ) : wxNotebook( )
{
  m_eSimEng = eSIMR_NONE;
}

//*****************************************************************************
// Destructor.

NbkSimrBase::~NbkSimrBase( )
{
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  NbkSimrBase::bClear( void )
{
  m_osErrMsg.Empty( ); // Clear the error string

  return( TRUE );
}

//*****************************************************************************
